/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.jboss.logging.Logger;

public class IndexProcessor {
    private static final Logger log = Logger.getLogger(IndexProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void processIndices(MetaDataDialect metaDataDialect, String defaultSchema, String defaultCatalog, Table table) {
        indexes = new HashMap<String, Index>();
        uniquekeys = new HashMap<String, UniqueKey>();
        uniqueColumns = new HashMap<Column, ArrayList<UniqueKey>>();
        indexIterator = null;
        try {
            indexRs = null;
            indexIterator = metaDataDialect.getIndexInfo(IndexProcessor.getCatalogForDBLookup(table.getCatalog(), defaultCatalog), IndexProcessor.getSchemaForDBLookup(table.getSchema(), defaultSchema), table.getName());
            while (indexIterator.hasNext()) {
                indexRs = (Map)indexIterator.next();
                indexName = (String)indexRs.get("INDEX_NAME");
                columnName = (String)indexRs.get("COLUMN_NAME");
                v0 = unique = (Boolean)indexRs.get("NON_UNIQUE") == false;
                if (columnName != null || indexName != null) {
                    if (unique) {
                        key = (UniqueKey)uniquekeys.get(indexName);
                        if (key == null) {
                            key = new UniqueKey();
                            key.setName(indexName);
                            key.setTable(table);
                            table.addUniqueKey(key);
                            uniquekeys.put(indexName, key);
                        }
                        if (indexes.containsKey(indexName)) {
                            throw new JDBCBinderException("UniqueKey exists also as Index! ");
                        }
                        column = IndexProcessor.getColumn(metaDataDialect, table, columnName);
                        key.addColumn(column);
                        if (!unique || key.getColumnSpan() != 1) continue;
                        l = (ArrayList<UniqueKey>)uniqueColumns.get(column);
                        if (l == null) {
                            l = new ArrayList<UniqueKey>();
                            uniqueColumns.put(column, l);
                        }
                        l.add(key);
                        continue;
                    }
                    index = (Index)indexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                        table.addIndex(index);
                        indexes.put(indexName, index);
                    }
                    if (uniquekeys.containsKey(indexName)) {
                        throw new JDBCBinderException("Index exists also as Unique! ");
                    }
                    column = IndexProcessor.getColumn(metaDataDialect, table, columnName);
                    index.addColumn(column);
                    continue;
                }
                if (0 == (Short)indexRs.get("TYPE")) continue;
                IndexProcessor.log.warn((Object)("Index was not statistical, but no column name was found in " + indexName));
            }
            ** if (indexIterator == null) goto lbl-1000
        }
        catch (JDBCException t) {
            try {
                IndexProcessor.log.warn((Object)("Exception while trying to get indexinfo on " + Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) + "=" + t.getMessage()));
                ** if (indexIterator == null) goto lbl-1000
            }
            catch (Throwable var15_19) {
                if (indexIterator != null) {
                    try {
                        metaDataDialect.close(indexIterator);
                    }
                    catch (JDBCException se) {
                        IndexProcessor.log.warn((Object)"Exception while trying to close resultset for index meta data", (Throwable)se);
                    }
                }
                throw var15_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    metaDataDialect.close(indexIterator);
                }
                catch (JDBCException se) {
                    IndexProcessor.log.warn((Object)"Exception while trying to close resultset for index meta data", (Throwable)se);
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                metaDataDialect.close(indexIterator);
            }
            catch (JDBCException se) {
                IndexProcessor.log.warn((Object)"Exception while trying to close resultset for index meta data", (Throwable)se);
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        for (Map.Entry<K, V> entry : uniqueColumns.entrySet()) {
            col = (Column)entry.getKey();
            for (UniqueKey key : (List)entry.getValue()) {
                if (key.getColumnSpan() != 1) continue;
                col.setUnique(true);
            }
        }
        iterator = uniquekeys.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private static String getCatalogForDBLookup(String catalog, String defaultCatalog) {
        return catalog == null ? defaultCatalog : catalog;
    }

    private static String getSchemaForDBLookup(String schema, String defaultSchema) {
        return schema == null ? defaultSchema : schema;
    }

    private static Column getColumn(MetaDataDialect metaDataDialect, Table table, String columnName) {
        Column column = new Column();
        column.setName(IndexProcessor.quote(columnName, metaDataDialect));
        Column existing = table.getColumn(column);
        if (existing != null) {
            column = existing;
        }
        return column;
    }

    private static String quote(String columnName, MetaDataDialect metaDataDialect) {
        if (columnName == null) {
            return columnName;
        }
        if (metaDataDialect.needQuote(columnName)) {
            if (columnName.length() > 1 && columnName.charAt(0) == '`' && columnName.charAt(columnName.length() - 1) == '`') {
                return columnName;
            }
            return "`" + columnName + "`";
        }
        return columnName;
    }
}

