/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.MultiValuedMap;
import org.dom4j.Document;
import org.hibernate.MappingException;
import org.hibernate.cfg.reveng.AssociationInfo;
import org.hibernate.cfg.reveng.DelegatingReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.MetaAttributeBinder;
import org.hibernate.cfg.reveng.OverrideBinder;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.SimpleMetaAttribute;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.xml.ErrorLogger;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.Table;
import org.hibernate.tool.xml.XMLHelper;
import org.jboss.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class OverrideRepository {
    private static final Logger log = Logger.getLogger(OverrideRepository.class);
    private final Map typeMappings = new HashMap();
    private final List tableFilters = new ArrayList();
    private final List tables = new ArrayList();
    private final Map foreignKeys = new HashMap();
    private final Map typeForColumn = new HashMap();
    private final Map propertyNameForColumn = new HashMap();
    private final Map identifierStrategyForTable = new HashMap();
    private final Map identifierPropertiesForTable = new HashMap();
    private final Map primaryKeyColumnsForTable = new HashMap();
    private final Set excludedColumns;
    private final Map tableToClassName;
    private final List<SchemaSelection> schemaSelections;
    private final Map propertyNameForPrimaryKey = new HashMap();
    private final Map compositeIdNameForTable;
    private final Map foreignKeyToOneName;
    private final Map foreignKeyToInverseName;
    private final Map foreignKeyInverseExclude;
    private final Map foreignKeyToOneExclude;
    private final Map foreignKeyToEntityInfo;
    private final Map foreignKeyToInverseEntityInfo;
    private final Map<TableIdentifier, MultiValuedMap<String, SimpleMetaAttribute>> tableMetaAttributes;
    private final Map<TableColumnKey, MultiValuedMap<String, SimpleMetaAttribute>> columnMetaAttributes;

    public OverrideRepository() {
        this.tableToClassName = new HashMap();
        this.excludedColumns = new HashSet();
        this.schemaSelections = new ArrayList<SchemaSelection>();
        this.compositeIdNameForTable = new HashMap();
        this.foreignKeyToOneName = new HashMap();
        this.foreignKeyToInverseName = new HashMap();
        this.foreignKeyInverseExclude = new HashMap();
        this.foreignKeyToOneExclude = new HashMap();
        this.tableMetaAttributes = new HashMap<TableIdentifier, MultiValuedMap<String, SimpleMetaAttribute>>();
        this.columnMetaAttributes = new HashMap<TableColumnKey, MultiValuedMap<String, SimpleMetaAttribute>>();
        this.foreignKeyToEntityInfo = new HashMap();
        this.foreignKeyToInverseEntityInfo = new HashMap();
    }

    public OverrideRepository addFile(File xmlFile) {
        log.info((Object)("Override file: " + xmlFile.getPath()));
        try {
            this.addInputStream(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("Could not configure overrides from file: " + xmlFile.getPath()), (Throwable)e);
            throw new MappingException("Could not configure overrides from file: " + xmlFile.getPath(), (Throwable)e);
        }
        return this;
    }

    public OverrideRepository addResource(String path) throws MappingException {
        log.info((Object)("Mapping resource: " + path));
        InputStream rsrc = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (rsrc == null) {
            rsrc = OverrideRepository.class.getClassLoader().getResourceAsStream(path);
        }
        if (rsrc == null) {
            throw new MappingException("Resource: " + path + " not found");
        }
        try {
            return this.addInputStream(rsrc);
        }
        catch (MappingException me) {
            throw new MappingException("Error reading resource: " + path, (Throwable)me);
        }
    }

    public OverrideRepository addInputStream(InputStream xmlInputStream) throws MappingException {
        try {
            ErrorLogger errorLogger = new ErrorLogger("XML InputStream");
            Document doc = XMLHelper.createSAXReader((ErrorHandler)errorLogger).read(new InputSource(xmlInputStream));
            if (errorLogger.hasErrors()) {
                throw new MappingException("invalid override definition", (Throwable)errorLogger.getErrors().get(0));
            }
            this.add(doc);
            OverrideRepository overrideRepository = this;
            return overrideRepository;
        }
        catch (MappingException me) {
            throw me;
        }
        catch (Exception e) {
            log.error((Object)"Could not configure overrides from input stream", (Throwable)e);
            throw new MappingException((Throwable)e);
        }
        finally {
            try {
                xmlInputStream.close();
            }
            catch (IOException ioe) {
                log.error((Object)"could not close input stream", (Throwable)ioe);
            }
        }
    }

    private OverrideRepository add(Document doc) {
        OverrideBinder.bindRoot(this, doc);
        return this;
    }

    private String getPreferredHibernateType(int sqlType, int length, int precision, int scale, boolean nullable) {
        List l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, length));
        if (l == null) {
            l = (List)this.typeMappings.get(new TypeMappingKey(sqlType, Integer.MAX_VALUE));
        }
        return this.scanForMatch(sqlType, length, precision, scale, nullable, l);
    }

    private String scanForMatch(int sqlType, int length, int precision, int scale, boolean nullable, List l) {
        if (l != null) {
            for (SQLTypeMapping element : l) {
                if (element.getJDBCType() != sqlType) {
                    return null;
                }
                if (!element.match(sqlType, length, precision, scale, nullable)) continue;
                return element.getHibernateType();
            }
        }
        return null;
    }

    public OverrideRepository addTypeMapping(SQLTypeMapping sqltype) {
        TypeMappingKey key = new TypeMappingKey(sqltype);
        ArrayList<SQLTypeMapping> list = (ArrayList<SQLTypeMapping>)this.typeMappings.get(key);
        if (list == null) {
            list = new ArrayList<SQLTypeMapping>();
            this.typeMappings.put(key, list);
        }
        list.add(sqltype);
        return this;
    }

    protected String getPackageName(TableIdentifier identifier) {
        for (TableFilter tf : this.tableFilters) {
            String value = tf.getPackage(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected boolean excludeTable(TableIdentifier identifier) {
        Iterator iterator = this.tableFilters.iterator();
        boolean hasInclude = false;
        while (iterator.hasNext()) {
            TableFilter tf = (TableFilter)iterator.next();
            Boolean value = tf.exclude(identifier);
            if (value != null) {
                return value;
            }
            if (tf.getExclude().booleanValue()) continue;
            hasInclude = true;
        }
        return hasInclude;
    }

    public void addTableFilter(TableFilter filter) {
        this.tableFilters.add(filter);
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy(ReverseEngineeringStrategy delegate) {
        return new DelegatingReverseEngineeringStrategy(delegate){

            @Override
            public boolean excludeTable(TableIdentifier ti) {
                return OverrideRepository.this.excludeTable(ti);
            }

            public Map tableToMetaAttributes(TableIdentifier tableIdentifier) {
                return OverrideRepository.this.tableToMetaAttributes(tableIdentifier);
            }

            public Map columnToMetaAttributes(TableIdentifier tableIdentifier, String column) {
                return OverrideRepository.this.columnToMetaAttributes(tableIdentifier, column);
            }

            @Override
            public boolean excludeColumn(TableIdentifier identifier, String columnName) {
                return OverrideRepository.this.excludedColumns.contains(new TableColumnKey(identifier, columnName));
            }

            @Override
            public String tableToCompositeIdName(TableIdentifier identifier) {
                String result = (String)OverrideRepository.this.compositeIdNameForTable.get(identifier);
                if (result == null) {
                    return super.tableToCompositeIdName(identifier);
                }
                return result;
            }

            @Override
            public List<SchemaSelection> getSchemaSelections() {
                if (OverrideRepository.this.schemaSelections.isEmpty()) {
                    return super.getSchemaSelections();
                }
                return OverrideRepository.this.schemaSelections;
            }

            @Override
            public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale, boolean nullable, boolean generatedIdentifier) {
                String result = null;
                String location = "";
                String info = " t:" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlType) + " l:" + length + " p:" + precision + " s:" + scale + " n:" + nullable + " id:" + generatedIdentifier;
                location = table != null ? Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) + "." + columnName : location + " Column: " + columnName + info;
                if (table != null && columnName != null && (result = (String)OverrideRepository.this.typeForColumn.get(new TableColumnKey(table, columnName))) != null) {
                    log.debug((Object)("explicit column mapping found for [" + location + "] to [" + result + "]"));
                    return result;
                }
                result = OverrideRepository.this.getPreferredHibernateType(sqlType, length, precision, scale, nullable);
                if (result == null) {
                    return super.columnToHibernateTypeName(table, columnName, sqlType, length, precision, scale, nullable, generatedIdentifier);
                }
                log.debug((Object)("<type-mapping> found for [" + location + info + "] to [" + result + "]"));
                return result;
            }

            @Override
            public String tableToClassName(TableIdentifier tableIdentifier) {
                String className = (String)OverrideRepository.this.tableToClassName.get(tableIdentifier);
                if (className != null) {
                    if (className.indexOf(".") >= 0) {
                        return className;
                    }
                    String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                    if (packageName == null) {
                        return className;
                    }
                    return StringHelper.qualify((String)packageName, (String)className);
                }
                String packageName = OverrideRepository.this.getPackageName(tableIdentifier);
                if (packageName == null) {
                    return super.tableToClassName(tableIdentifier);
                }
                String string = super.tableToClassName(tableIdentifier);
                if (string == null) {
                    return null;
                }
                return StringHelper.qualify((String)packageName, (String)StringHelper.unqualify((String)string));
            }

            @Override
            public List<ForeignKey> getForeignKeys(TableIdentifier referencedTable) {
                List list = (List)OverrideRepository.this.foreignKeys.get(referencedTable);
                if (list == null) {
                    return super.getForeignKeys(referencedTable);
                }
                return list;
            }

            @Override
            public String columnToPropertyName(TableIdentifier table, String column) {
                String result = (String)OverrideRepository.this.propertyNameForColumn.get(new TableColumnKey(table, column));
                if (result == null) {
                    return super.columnToPropertyName(table, column);
                }
                return result;
            }

            @Override
            public String tableToIdentifierPropertyName(TableIdentifier tableIdentifier) {
                String result = (String)OverrideRepository.this.propertyNameForPrimaryKey.get(tableIdentifier);
                if (result == null) {
                    return super.tableToIdentifierPropertyName(tableIdentifier);
                }
                return result;
            }

            @Override
            public String getTableIdentifierStrategyName(TableIdentifier tableIdentifier) {
                String result = (String)OverrideRepository.this.identifierStrategyForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierStrategyName(tableIdentifier);
                }
                log.debug((Object)("tableIdentifierStrategy for " + tableIdentifier + " -> '" + result + "'"));
                return result;
            }

            @Override
            public Properties getTableIdentifierProperties(TableIdentifier tableIdentifier) {
                Properties result = (Properties)OverrideRepository.this.identifierPropertiesForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getTableIdentifierProperties(tableIdentifier);
                }
                return result;
            }

            public List getPrimaryKeyColumnNames(TableIdentifier tableIdentifier) {
                List result = (List)OverrideRepository.this.primaryKeyColumnsForTable.get(tableIdentifier);
                if (result == null) {
                    return super.getPrimaryKeyColumnNames(tableIdentifier);
                }
                return result;
            }

            @Override
            public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
                String property = (String)OverrideRepository.this.foreignKeyToOneName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
                }
                return property;
            }

            @Override
            public String foreignKeyToInverseEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
                String property = (String)OverrideRepository.this.foreignKeyToInverseName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToInverseEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
                }
                return property;
            }

            @Override
            public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns, boolean uniqueReference) {
                String property = (String)OverrideRepository.this.foreignKeyToInverseName.get(keyname);
                if (property == null) {
                    return super.foreignKeyToCollectionName(keyname, fromTable, fromColumns, referencedTable, referencedColumns, uniqueReference);
                }
                return property;
            }

            public boolean excludeForeignKeyAsCollection(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns) {
                Boolean bool = (Boolean)OverrideRepository.this.foreignKeyInverseExclude.get(keyname);
                if (bool != null) {
                    return bool;
                }
                return super.excludeForeignKeyAsCollection(keyname, fromTable, fromColumns, referencedTable, referencedColumns);
            }

            @Override
            public boolean excludeForeignKeyAsManytoOne(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns) {
                Boolean bool = (Boolean)OverrideRepository.this.foreignKeyToOneExclude.get(keyname);
                if (bool != null) {
                    return bool;
                }
                return super.excludeForeignKeyAsManytoOne(keyname, fromTable, fromColumns, referencedTable, referencedColumns);
            }

            @Override
            public AssociationInfo foreignKeyToInverseAssociationInfo(ForeignKey foreignKey) {
                AssociationInfo fkei = (AssociationInfo)OverrideRepository.this.foreignKeyToInverseEntityInfo.get(foreignKey.getName());
                if (fkei != null) {
                    return fkei;
                }
                return super.foreignKeyToInverseAssociationInfo(foreignKey);
            }

            @Override
            public AssociationInfo foreignKeyToAssociationInfo(ForeignKey foreignKey) {
                AssociationInfo fkei = (AssociationInfo)OverrideRepository.this.foreignKeyToEntityInfo.get(foreignKey.getName());
                if (fkei != null) {
                    return fkei;
                }
                return super.foreignKeyToAssociationInfo(foreignKey);
            }
        };
    }

    protected Map<String, MetaAttribute> columnToMetaAttributes(TableIdentifier tableIdentifier, String column) {
        MultiValuedMap<String, SimpleMetaAttribute> specific = this.columnMetaAttributes.get(new TableColumnKey(tableIdentifier, column));
        if (specific != null && !specific.isEmpty()) {
            return this.toMetaAttributes(specific);
        }
        return null;
    }

    protected Map<String, MetaAttribute> tableToMetaAttributes(TableIdentifier identifier) {
        MultiValuedMap<String, SimpleMetaAttribute> specific = this.tableMetaAttributes.get(identifier);
        if (specific != null && !specific.isEmpty()) {
            return this.toMetaAttributes(specific);
        }
        MultiValuedMap<String, SimpleMetaAttribute> general = this.findGeneralAttributes(identifier);
        if (general != null && !general.isEmpty()) {
            return this.toMetaAttributes(general);
        }
        return null;
    }

    private MultiValuedMap<String, SimpleMetaAttribute> findGeneralAttributes(TableIdentifier identifier) {
        for (TableFilter tf : this.tableFilters) {
            MultiValuedMap<String, SimpleMetaAttribute> value = tf.getMetaAttributes(identifier);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private Map<String, MetaAttribute> toMetaAttributes(MultiValuedMap<String, SimpleMetaAttribute> mvm) {
        HashMap<String, MetaAttribute> result = new HashMap<String, MetaAttribute>();
        MapIterator iter = mvm.mapIterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Collection values = mvm.get((Object)key);
            result.put(key, MetaAttributeBinder.toRealMetaAttribute(key, values));
        }
        return result;
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.getReverseEngineeringStrategy(null);
    }

    public void addTable(Table table, String wantedClassName) {
        Iterator fkIter = table.getForeignKeyIterator();
        while (fkIter.hasNext()) {
            ForeignKey fk = (ForeignKey)fkIter.next();
            TableIdentifier identifier = TableIdentifier.create(fk.getReferencedTable());
            ArrayList<ForeignKey> existing = (ArrayList<ForeignKey>)this.foreignKeys.get(identifier);
            if (existing == null) {
                existing = new ArrayList<ForeignKey>();
                this.foreignKeys.put(identifier, existing);
            }
            existing.add(fk);
        }
        this.tables.add(table);
        if (StringHelper.isNotEmpty((String)wantedClassName)) {
            this.tableToClassName.put(TableIdentifier.create(table), wantedClassName);
        }
    }

    public void setTypeNameForColumn(TableIdentifier identifier, String columnName, String type) {
        if (StringHelper.isNotEmpty((String)type)) {
            this.typeForColumn.put(new TableColumnKey(identifier, columnName), type);
        }
    }

    public void setExcludedColumn(TableIdentifier tableIdentifier, String columnName) {
        this.excludedColumns.add(new TableColumnKey(tableIdentifier, columnName));
    }

    public void setPropertyNameForColumn(TableIdentifier identifier, String columnName, String property) {
        if (StringHelper.isNotEmpty((String)property)) {
            this.propertyNameForColumn.put(new TableColumnKey(identifier, columnName), property);
        }
    }

    public void addTableIdentifierStrategy(Table table, String identifierClass, Properties params) {
        if (identifierClass != null) {
            TableIdentifier tid = TableIdentifier.create(table);
            this.identifierStrategyForTable.put(tid, identifierClass);
            this.identifierPropertiesForTable.put(tid, params);
        }
    }

    public void addPrimaryKeyNamesForTable(Table table, List boundColumnNames, String propertyName, String compositeIdName) {
        TableIdentifier tableIdentifier = TableIdentifier.create(table);
        if (boundColumnNames != null && !boundColumnNames.isEmpty()) {
            this.primaryKeyColumnsForTable.put(tableIdentifier, boundColumnNames);
        }
        if (StringHelper.isNotEmpty((String)propertyName)) {
            this.propertyNameForPrimaryKey.put(tableIdentifier, propertyName);
        }
        if (StringHelper.isNotEmpty((String)compositeIdName)) {
            this.compositeIdNameForTable.put(tableIdentifier, compositeIdName);
        }
    }

    public void addSchemaSelection(SchemaSelection schemaSelection) {
        this.schemaSelections.add(schemaSelection);
    }

    public void addForeignKeyInfo(String constraintName, String toOneProperty, Boolean excludeToOne, String inverseProperty, Boolean excludeInverse, AssociationInfo associationInfo, AssociationInfo inverseAssociationInfo) {
        if (StringHelper.isNotEmpty((String)toOneProperty)) {
            this.foreignKeyToOneName.put(constraintName, toOneProperty);
        }
        if (StringHelper.isNotEmpty((String)inverseProperty)) {
            this.foreignKeyToInverseName.put(constraintName, inverseProperty);
        }
        if (excludeInverse != null) {
            this.foreignKeyInverseExclude.put(constraintName, excludeInverse);
        }
        if (excludeToOne != null) {
            this.foreignKeyToOneExclude.put(constraintName, excludeToOne);
        }
        if (associationInfo != null) {
            this.foreignKeyToEntityInfo.put(constraintName, associationInfo);
        }
        if (inverseAssociationInfo != null) {
            this.foreignKeyToInverseEntityInfo.put(constraintName, inverseAssociationInfo);
        }
    }

    public void addMetaAttributeInfo(Table table, MultiValuedMap<String, SimpleMetaAttribute> map) {
        if (map != null && !map.isEmpty()) {
            this.tableMetaAttributes.put(TableIdentifier.create(table), map);
        }
    }

    public void addMetaAttributeInfo(TableIdentifier tableIdentifier, String name, MultiValuedMap<String, SimpleMetaAttribute> map) {
        if (map != null && !map.isEmpty()) {
            this.columnMetaAttributes.put(new TableColumnKey(tableIdentifier, name), map);
        }
    }

    static class TableColumnKey {
        private TableIdentifier query;
        private String name;

        TableColumnKey(TableIdentifier query, String name) {
            this.query = query;
            this.name = name;
        }

        public int hashCode() {
            int prime = 29;
            int result = 1;
            result = 29 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 29 * result + (this.query == null ? 0 : this.query.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TableColumnKey other = (TableColumnKey)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.query == null ? other.query != null : !this.query.equals(other.query));
        }
    }

    static class TypeMappingKey {
        int type;
        int length;

        TypeMappingKey(SQLTypeMapping mpa) {
            this.type = mpa.getJDBCType();
            this.length = mpa.getLength();
        }

        public TypeMappingKey(int sqlType, int length) {
            this.type = sqlType;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeMappingKey)) {
                return false;
            }
            TypeMappingKey other = (TypeMappingKey)obj;
            return this.type == other.type && this.length == other.length;
        }

        public int hashCode() {
            return (this.type + this.length) % 17;
        }

        public String toString() {
            return this.getClass() + "(type:" + this.type + ", length:" + this.length + ")";
        }
    }
}

