/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.cfg.reveng.dialect.AbstractMetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.mapping.Table;

public class OracleMetaDataDialect
extends AbstractMetaDataDialect {
    private static final String SQL_TABLE_BASE = "select a.table_name, a.owner, (SELECT b.comments\n   FROM all_tab_comments b\n  WHERE a.owner = b.owner\n        AND a.table_name = b.table_name) AS comments, 'TABLE' from all_tables a ";
    private static final String SQL_TABLE_VIEW = " union all select view_name, owner, NULL, 'VIEW' from all_views ";
    private static final String SQL_TABLE_NONE = "select a.table_name, a.owner, (SELECT b.comments\n   FROM all_tab_comments b\n  WHERE a.owner = b.owner\n        AND a.table_name = b.table_name) AS comments, 'TABLE' from all_tables a  union all select view_name, owner, NULL, 'VIEW' from all_views ";
    private static final String SQL_TABLE_SCHEMA = "select a.table_name, a.owner, (SELECT b.comments\n   FROM all_tab_comments b\n  WHERE a.owner = b.owner\n        AND a.table_name = b.table_name) AS comments, 'TABLE' from all_tables a where a.owner like ?  union all select view_name, owner, NULL, 'VIEW' from all_views  where owner like ?";
    private static final String SQL_TABLE_TABLE = "select a.table_name, a.owner, (SELECT b.comments\n   FROM all_tab_comments b\n  WHERE a.owner = b.owner\n        AND a.table_name = b.table_name) AS comments, 'TABLE' from all_tables a where a.table_name like ? union all select view_name, owner, NULL, 'VIEW' from all_views where view_name like ?";
    private static final String SQL_TABLE_SCHEMA_AND_TABLE = "select a.table_name, a.owner, (SELECT b.comments\n   FROM all_tab_comments b\n  WHERE a.owner = b.owner\n        AND a.table_name = b.table_name) AS comments, 'TABLE' from all_tables a where a.owner like ? and a.table_name like ? union all select view_name, owner, NULL, 'VIEW' from all_views where owner like ? and view_name like ?";
    private PreparedStatement prepTableNone;
    private PreparedStatement prepTableSchema;
    private PreparedStatement prepTableTable;
    private PreparedStatement prepTableSchemaAndTable;
    private static final String SQL_INDEX_BASE = "SELECT a.column_name\n      ,decode((SELECT b.uniqueness\n                FROM all_indexes b\n               WHERE a.table_name = b.table_name\n                     AND a.table_owner = b.table_owner\n                     AND a.index_name = b.index_name\n                     AND b.index_type NOT LIKE 'FUNCTION-BASED%'), 'UNIQUE', 'false', 'true') AS uniqueness\n      ,a.index_owner\n      ,a.index_name\n      ,a.table_name\n  FROM all_ind_columns a\n  WHERE 1 = 1\n ";
    private static final String SQL_INDEX_ORDER = " order by a.table_name, a.column_position";
    private static final String SQL_INDEX_NONE = "SELECT a.column_name\n      ,decode((SELECT b.uniqueness\n                FROM all_indexes b\n               WHERE a.table_name = b.table_name\n                     AND a.table_owner = b.table_owner\n                     AND a.index_name = b.index_name\n                     AND b.index_type NOT LIKE 'FUNCTION-BASED%'), 'UNIQUE', 'false', 'true') AS uniqueness\n      ,a.index_owner\n      ,a.index_name\n      ,a.table_name\n  FROM all_ind_columns a\n  WHERE 1 = 1\n  order by a.table_name, a.column_position";
    private static final String SQL_INDEX_SCHEMA = "SELECT a.column_name\n      ,decode((SELECT b.uniqueness\n                FROM all_indexes b\n               WHERE a.table_name = b.table_name\n                     AND a.table_owner = b.table_owner\n                     AND a.index_name = b.index_name\n                     AND b.index_type NOT LIKE 'FUNCTION-BASED%'), 'UNIQUE', 'false', 'true') AS uniqueness\n      ,a.index_owner\n      ,a.index_name\n      ,a.table_name\n  FROM all_ind_columns a\n  WHERE 1 = 1\n and a.table_owner like ?  order by a.table_name, a.column_position";
    private static final String SQL_INDEX_TABLE = "SELECT a.column_name\n      ,decode((SELECT b.uniqueness\n                FROM all_indexes b\n               WHERE a.table_name = b.table_name\n                     AND a.table_owner = b.table_owner\n                     AND a.index_name = b.index_name\n                     AND b.index_type NOT LIKE 'FUNCTION-BASED%'), 'UNIQUE', 'false', 'true') AS uniqueness\n      ,a.index_owner\n      ,a.index_name\n      ,a.table_name\n  FROM all_ind_columns a\n  WHERE 1 = 1\n and a.table_name like ?  order by a.table_name, a.column_position";
    private static final String SQL_INDEX_SCHEMA_AND_TABLE = "SELECT a.column_name\n      ,decode((SELECT b.uniqueness\n                FROM all_indexes b\n               WHERE a.table_name = b.table_name\n                     AND a.table_owner = b.table_owner\n                     AND a.index_name = b.index_name\n                     AND b.index_type NOT LIKE 'FUNCTION-BASED%'), 'UNIQUE', 'false', 'true') AS uniqueness\n      ,a.index_owner\n      ,a.index_name\n      ,a.table_name\n  FROM all_ind_columns a\n  WHERE 1 = 1\n and a.table_owner like ? and a.table_name like ?  order by a.table_name, a.column_position";
    private PreparedStatement prepIndexNone;
    private PreparedStatement prepIndexSchema;
    private PreparedStatement prepIndexTable;
    private PreparedStatement prepIndexSchemaAndTable;
    private static final String SQL_COLUMN_BASE = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\n";
    private static final String SQL_COLUMN_ORDER = " order by column_id ";
    private static final String SQL_COLUMN_NONE = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\n order by column_id ";
    private static final String SQL_COLUMN_SCHEMA = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.owner like ?  order by column_id ";
    private static final String SQL_COLUMN_TABLE = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.table_name like ?  order by column_id ";
    private static final String SQL_COLUMN_COLUMN = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.column_name like ?  order by column_id ";
    private static final String SQL_COLUMN_SCHEMA_AND_TABLE = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.owner like ? and a.table_name like ?  order by column_id ";
    private static final String SQL_COLUMN_SCHEMA_AND_COLUMN = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.owner like ? and a.column_name like ?  order by column_id ";
    private static final String SQL_COLUMN_TABLE_AND_COLUMN = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.table_name like ? and a.column_name like ?  order by column_id ";
    private static final String SQL_COLUMN_SCHEMA_AND_TABLE_AND_COLUMN = "SELECT a.column_name AS COLUMN_NAME\n      ,a.owner AS TABLE_SCHEM\n      ,decode(a.nullable, 'N', 0, 1) AS NULLABLE\n      ,decode(a.data_type, 'FLOAT', decode(a.data_precision, NULL, a.data_length, a.data_precision), 'NUMBER',\n              decode(a.data_precision, NULL, a.data_length, a.data_precision), 'VARCHAR2', a.char_length, 'VARCHAR',\n              a.char_length, 'NVARCHAR2', a.char_length, 'CHAR', a.char_length, 'NCHAR', a.char_length, a.data_length) AS COLUMN_SIZE\n      ,CASE\n         WHEN a.data_type LIKE 'TIMESTAMP%' THEN\n          93\n         ELSE\n          decode(a.data_type, 'CHAR', 1, 'DATE', 91, 'FLOAT', 6, 'LONG', -1, 'NUMBER', 2, 'VARCHAR2', 12, 'BFILE', -13,\n                 'BLOB', 2004, 'CLOB', 2005, 'MLSLABEL', 1111, 'NCHAR', 1, 'NCLOB', 2005, 'NVARCHAR2', 12, 'RAW', -3,\n                 'ROWID', 1111, 'UROWID', 1111, 'LONG RAW', -4, 'XMLTYPE', 2005, 1111)\n       END AS DATA_TYPE\n      ,a.table_name AS TABLE_NAME\n      ,a.data_type AS TYPE_NAME\n      ,decode(a.data_scale, NULL, 0, a.data_scale) AS DECIMAL_DIGITS\n      ,(SELECT b.comments\n          FROM all_col_comments b\n         WHERE a.owner = b.owner\n               AND a.table_name = b.table_name\n               AND a.column_name = b.column_name) AS COMMENTS\n  FROM all_tab_columns a\nwhere a.owner like ? and a.table_name like ? and a.column_name like ?  order by column_id ";
    private PreparedStatement prepColumnNone;
    private PreparedStatement prepColumnSchema;
    private PreparedStatement prepColumnTable;
    private PreparedStatement prepColumnColumn;
    private PreparedStatement prepColumnSchemaAndTable;
    private PreparedStatement prepColumnSchemaAndColumn;
    private PreparedStatement prepColumnTableAndColumn;
    private PreparedStatement prepColumnSchemaAndTableAndColumn;
    private static final String SQL_PK_BASE = "select c.table_name, c.column_name, c.position,  c.constraint_name, c.owner from all_cons_columns c join all_constraints k on (k.owner = c.owner AND k.table_name = c.table_name AND k.constraint_name = c.constraint_name) where  k.constraint_type = 'P' ";
    private static final String SQL_PK_ORDER = " order by c.table_name, c.constraint_name, c.position desc ";
    private static final String SQL_PK_NONE = "select c.table_name, c.column_name, c.position,  c.constraint_name, c.owner from all_cons_columns c join all_constraints k on (k.owner = c.owner AND k.table_name = c.table_name AND k.constraint_name = c.constraint_name) where  k.constraint_type = 'P'  order by c.table_name, c.constraint_name, c.position desc ";
    private static final String SQL_PK_SCHEMA = "select c.table_name, c.column_name, c.position,  c.constraint_name, c.owner from all_cons_columns c join all_constraints k on (k.owner = c.owner AND k.table_name = c.table_name AND k.constraint_name = c.constraint_name) where  k.constraint_type = 'P'  and c.owner like ?  order by c.table_name, c.constraint_name, c.position desc ";
    private static final String SQL_PK_TABLE = "select c.table_name, c.column_name, c.position,  c.constraint_name, c.owner from all_cons_columns c join all_constraints k on (k.owner = c.owner AND k.table_name = c.table_name AND k.constraint_name = c.constraint_name) where  k.constraint_type = 'P'  and c.table_name like ?  order by c.table_name, c.constraint_name, c.position desc ";
    private static final String SQL_PK_SCHEMA_AND_TABLE = "select c.table_name, c.column_name, c.position,  c.constraint_name, c.owner from all_cons_columns c join all_constraints k on (k.owner = c.owner AND k.table_name = c.table_name AND k.constraint_name = c.constraint_name) where  k.constraint_type = 'P'  and c.owner like ? and c.table_name like ?  order by c.table_name, c.constraint_name, c.position desc ";
    private PreparedStatement prepPkNone;
    private PreparedStatement prepPkSchema;
    private PreparedStatement prepPkTable;
    private PreparedStatement prepPkSchemaAndTable;
    private static final String SQL_FK_BASE = "SELECT p.table_name as p_table_name\n      ,p.owner as p_owner\n      ,f.owner as f_owner\n      ,f.table_name as f_table_name\n      ,(SELECT fc.column_name\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_column_name\n      ,pc.column_name as pc_column_name\n      ,f.constraint_name\n      ,(SELECT fc.position\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_position\n  FROM all_constraints p\n  JOIN all_cons_columns pc\n    ON pc.owner = p.owner\n       AND pc.constraint_name = p.constraint_name\n       AND pc.table_name = p.table_name\n  JOIN all_constraints f\n    ON p.owner = f.r_owner\n       AND p.constraint_name = f.r_constraint_name\n WHERE f.constraint_type = 'R'\n       AND p.constraint_type = 'P'\n";
    private static final String SQL_FK_ORDER = " order by f.table_name, f.constraint_name, position ";
    private static final String SQL_FK_NONE = "SELECT p.table_name as p_table_name\n      ,p.owner as p_owner\n      ,f.owner as f_owner\n      ,f.table_name as f_table_name\n      ,(SELECT fc.column_name\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_column_name\n      ,pc.column_name as pc_column_name\n      ,f.constraint_name\n      ,(SELECT fc.position\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_position\n  FROM all_constraints p\n  JOIN all_cons_columns pc\n    ON pc.owner = p.owner\n       AND pc.constraint_name = p.constraint_name\n       AND pc.table_name = p.table_name\n  JOIN all_constraints f\n    ON p.owner = f.r_owner\n       AND p.constraint_name = f.r_constraint_name\n WHERE f.constraint_type = 'R'\n       AND p.constraint_type = 'P'\n order by f.table_name, f.constraint_name, position ";
    private static final String SQL_FK_SCHEMA = "SELECT p.table_name as p_table_name\n      ,p.owner as p_owner\n      ,f.owner as f_owner\n      ,f.table_name as f_table_name\n      ,(SELECT fc.column_name\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_column_name\n      ,pc.column_name as pc_column_name\n      ,f.constraint_name\n      ,(SELECT fc.position\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_position\n  FROM all_constraints p\n  JOIN all_cons_columns pc\n    ON pc.owner = p.owner\n       AND pc.constraint_name = p.constraint_name\n       AND pc.table_name = p.table_name\n  JOIN all_constraints f\n    ON p.owner = f.r_owner\n       AND p.constraint_name = f.r_constraint_name\n WHERE f.constraint_type = 'R'\n       AND p.constraint_type = 'P'\n and p.owner like ?  order by f.table_name, f.constraint_name, position ";
    private static final String SQL_FK_TABLE = "SELECT p.table_name as p_table_name\n      ,p.owner as p_owner\n      ,f.owner as f_owner\n      ,f.table_name as f_table_name\n      ,(SELECT fc.column_name\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_column_name\n      ,pc.column_name as pc_column_name\n      ,f.constraint_name\n      ,(SELECT fc.position\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_position\n  FROM all_constraints p\n  JOIN all_cons_columns pc\n    ON pc.owner = p.owner\n       AND pc.constraint_name = p.constraint_name\n       AND pc.table_name = p.table_name\n  JOIN all_constraints f\n    ON p.owner = f.r_owner\n       AND p.constraint_name = f.r_constraint_name\n WHERE f.constraint_type = 'R'\n       AND p.constraint_type = 'P'\n and p.table_name like ?  order by f.table_name, f.constraint_name, position ";
    private static final String SQL_FK_SCHEMA_AND_TABLE = "SELECT p.table_name as p_table_name\n      ,p.owner as p_owner\n      ,f.owner as f_owner\n      ,f.table_name as f_table_name\n      ,(SELECT fc.column_name\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_column_name\n      ,pc.column_name as pc_column_name\n      ,f.constraint_name\n      ,(SELECT fc.position\n          FROM all_cons_columns fc\n         WHERE fc.owner = f.owner\n               AND fc.constraint_name = f.constraint_name\n               AND fc.table_name = f.table_name\n               AND fc.position = pc.position) AS fc_position\n  FROM all_constraints p\n  JOIN all_cons_columns pc\n    ON pc.owner = p.owner\n       AND pc.constraint_name = p.constraint_name\n       AND pc.table_name = p.table_name\n  JOIN all_constraints f\n    ON p.owner = f.r_owner\n       AND p.constraint_name = f.r_constraint_name\n WHERE f.constraint_type = 'R'\n       AND p.constraint_type = 'P'\n and p.owner like ? and p.table_name like ?  order by f.table_name, f.constraint_name, position ";
    private PreparedStatement prepFkNone;
    private PreparedStatement prepFkSchema;
    private PreparedStatement prepFkTable;
    private PreparedStatement prepFkSchemaAndTable;

    @Override
    public Iterator<Map<String, Object>> getTables(final String catalog, final String schema, String table) {
        try {
            this.log.debug((Object)("getTables(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getTableResultSet(schema, table);
            return new ResultSetIterator(null, tableRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(stmt, resultset, exceptionConverter);
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet tableResultSet) throws SQLException {
                    this.element.clear();
                    this.element.put("TABLE_NAME", tableResultSet.getString(1));
                    this.element.put("TABLE_SCHEM", tableResultSet.getString(2));
                    this.element.put("TABLE_CAT", null);
                    this.element.put("TABLE_TYPE", tableResultSet.getString(4));
                    this.element.put("REMARKS", tableResultSet.getString(3));
                    OracleMetaDataDialect.this.log.info((Object)this.element.toString());
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    String databaseStructure = OracleMetaDataDialect.this.getDatabaseStructure(catalog, schema);
                    throw this.getSQLExceptionConverter().convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
                }
            };
        }
        catch (SQLException e) {
            String databaseStructure = this.getDatabaseStructure(catalog, schema);
            throw this.getSQLExceptionConverter().convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
        }
    }

    @Override
    public Iterator getIndexInfo(final String catalog, final String schema, final String table) {
        try {
            this.log.debug((Object)("getIndexInfo(" + catalog + "." + schema + "." + table + ")"));
            ResultSet indexRs = this.getIndexInfoResultSet(schema, table);
            return new ResultSetIterator(null, indexRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(stmt, resultset, exceptionConverter);
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    this.element.put("COLUMN_NAME", rs.getString(1));
                    this.element.put("TYPE", new Short(1));
                    this.element.put("NON_UNIQUE", Boolean.valueOf(rs.getString(2)));
                    this.element.put("TABLE_SCHEM", rs.getString(3));
                    this.element.put("INDEX_NAME", rs.getString(4));
                    this.element.put("TABLE_CAT", null);
                    this.element.put("TABLE_NAME", rs.getString(5));
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Exception while getting index info for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Exception while getting index info for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    @Override
    public Iterator getColumns(final String catalog, final String schema, final String table, String column) {
        try {
            this.log.debug((Object)("getColumns(" + catalog + "." + schema + "." + table + "." + column + ")"));
            ResultSet columnRs = this.getColumnsResultSet(schema, table, column);
            return new ResultSetIterator(null, columnRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(stmt, resultset, exceptionConverter);
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    this.element.put("COLUMN_NAME", rs.getString(1));
                    this.element.put("TABLE_SCHEM", rs.getString(2));
                    this.element.put("NULLABLE", new Integer(rs.getInt(3)));
                    this.element.put("COLUMN_SIZE", new Integer(rs.getInt(4)));
                    this.element.put("DATA_TYPE", new Integer(rs.getInt(5)));
                    this.element.put("TABLE_NAME", rs.getString(6));
                    this.element.put("TYPE_NAME", rs.getString(7));
                    this.element.put("DECIMAL_DIGITS", new Integer(rs.getInt(8)));
                    this.element.put("TABLE_CAT", null);
                    this.element.put("REMARKS", rs.getString(9));
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Error while reading column meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Error while reading column meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    @Override
    public Iterator<Map<String, Object>> getPrimaryKeys(final String catalog, final String schema, final String table) {
        try {
            this.log.debug((Object)("getPrimaryKeys(" + catalog + "." + schema + "." + table + ")"));
            ResultSet pkeyRs = this.getPrimaryKeysResultSet(schema, table);
            return new ResultSetIterator(null, pkeyRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(stmt, resultset, exceptionConverter);
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    this.element.put("TABLE_NAME", rs.getString(1));
                    this.element.put("COLUMN_NAME", rs.getString(2));
                    this.element.put("KEY_SEQ", new Short(rs.getShort(3)));
                    this.element.put("PK_NAME", rs.getString(4));
                    this.element.put("TABLE_SCHEM", rs.getString(5));
                    this.element.put("TABLE_CAT", null);
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Error while reading primary key meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Error while reading primary key meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    @Override
    public Iterator<Map<String, Object>> getExportedKeys(final String catalog, final String schema, final String table) {
        try {
            this.log.debug((Object)("getExportedKeys(" + catalog + "." + schema + "." + table + ")"));
            ResultSet pExportRs = this.getExportedKeysResultSet(schema, table);
            return new ResultSetIterator(null, pExportRs, this.getSQLExceptionConverter()){
                Map element;
                {
                    super(stmt, resultset, exceptionConverter);
                    this.element = new HashMap();
                }

                @Override
                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    this.element.put("PKTABLE_NAME", rs.getString(1));
                    this.element.put("PKTABLE_SCHEM", rs.getString(2));
                    this.element.put("PKTABLE_CAT", null);
                    this.element.put("FKTABLE_CAT", null);
                    this.element.put("FKTABLE_SCHEM", rs.getString(3));
                    this.element.put("FKTABLE_NAME", rs.getString(4));
                    this.element.put("FKCOLUMN_NAME", rs.getString(5));
                    this.element.put("PKCOLUMN_NAME", rs.getString(6));
                    this.element.put("FK_NAME", rs.getString(7));
                    this.element.put("KEY_SEQ", new Short(rs.getShort(8)));
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw this.getSQLExceptionConverter().convert(e, "Error while reading exported keys meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Error while reading exported keys meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    @Override
    public void close() {
        try {
            this.prepTableNone = this.close(this.prepTableNone);
            this.prepTableSchema = this.close(this.prepTableSchema);
            this.prepTableTable = this.close(this.prepTableTable);
            this.prepTableSchemaAndTable = this.close(this.prepTableSchemaAndTable);
            this.prepIndexNone = this.close(this.prepIndexNone);
            this.prepIndexSchema = this.close(this.prepIndexSchema);
            this.prepIndexTable = this.close(this.prepIndexTable);
            this.prepIndexSchemaAndTable = this.close(this.prepIndexSchemaAndTable);
            this.prepColumnNone = this.close(this.prepColumnNone);
            this.prepColumnSchema = this.close(this.prepColumnSchema);
            this.prepColumnTable = this.close(this.prepColumnTable);
            this.prepColumnColumn = this.close(this.prepColumnColumn);
            this.prepColumnSchemaAndTable = this.close(this.prepColumnSchemaAndTable);
            this.prepColumnSchemaAndColumn = this.close(this.prepColumnSchemaAndColumn);
            this.prepColumnTableAndColumn = this.close(this.prepColumnTableAndColumn);
            this.prepColumnSchemaAndTableAndColumn = this.close(this.prepColumnSchemaAndTableAndColumn);
            this.prepPkNone = this.close(this.prepPkNone);
            this.prepPkSchema = this.close(this.prepPkSchema);
            this.prepPkTable = this.close(this.prepPkTable);
            this.prepPkSchemaAndTable = this.close(this.prepPkSchemaAndTable);
            this.prepFkNone = this.close(this.prepFkNone);
            this.prepFkSchema = this.close(this.prepFkSchema);
            this.prepFkTable = this.close(this.prepFkTable);
            this.prepFkSchemaAndTable = this.close(this.prepFkSchemaAndTable);
        }
        finally {
            super.close();
        }
    }

    private PreparedStatement close(PreparedStatement ps) {
        if (ps == null) {
            return null;
        }
        try {
            ps.close();
        }
        catch (SQLException e) {
            throw this.getSQLExceptionConverter().convert(e, "Problem while closing prepared statement", null);
        }
        return null;
    }

    private ResultSet getPrimaryKeysResultSet(String schema, String table) throws SQLException {
        ResultSet pkeyRs;
        if (this.prepPkNone == null) {
            this.log.debug((Object)"Preparing primary key queries...");
            Connection con = this.getConnection();
            this.prepPkNone = con.prepareStatement(SQL_PK_NONE);
            this.prepPkSchema = con.prepareStatement(SQL_PK_SCHEMA);
            this.prepPkTable = con.prepareStatement(SQL_PK_TABLE);
            this.prepPkSchemaAndTable = con.prepareStatement(SQL_PK_SCHEMA_AND_TABLE);
            this.log.debug((Object)"  primary key queries prepared!");
        }
        if (schema == null && table == null) {
            pkeyRs = this.prepPkNone.executeQuery();
        } else if (schema != null) {
            if (table == null) {
                this.prepPkSchema.setString(1, schema);
                pkeyRs = this.prepPkSchema.executeQuery();
            } else {
                this.prepPkSchemaAndTable.setString(1, schema);
                this.prepPkSchemaAndTable.setString(2, table);
                pkeyRs = this.prepPkSchemaAndTable.executeQuery();
            }
        } else {
            this.prepPkTable.setString(1, table);
            pkeyRs = this.prepPkTable.executeQuery();
        }
        return pkeyRs;
    }

    private ResultSet getIndexInfoResultSet(String schema, String table) throws SQLException {
        ResultSet indexRs;
        if (this.prepIndexNone == null) {
            this.log.debug((Object)"Preparing index queries...");
            Connection con = this.getConnection();
            this.prepIndexNone = con.prepareStatement(SQL_INDEX_NONE);
            this.prepIndexSchema = con.prepareStatement(SQL_INDEX_SCHEMA);
            this.prepIndexTable = con.prepareStatement(SQL_INDEX_TABLE);
            this.prepIndexSchemaAndTable = con.prepareStatement(SQL_INDEX_SCHEMA_AND_TABLE);
            this.log.debug((Object)"  ...index queries prepared!");
        }
        if (schema == null && table == null) {
            indexRs = this.prepIndexNone.executeQuery();
        } else if (schema != null) {
            if (table == null) {
                this.prepIndexSchema.setString(1, schema);
                indexRs = this.prepIndexSchema.executeQuery();
            } else {
                this.prepIndexSchemaAndTable.setString(1, schema);
                this.prepIndexSchemaAndTable.setString(2, table);
                indexRs = this.prepIndexSchemaAndTable.executeQuery();
            }
        } else {
            this.prepIndexTable.setString(1, table);
            indexRs = this.prepIndexTable.executeQuery();
        }
        return indexRs;
    }

    private ResultSet getExportedKeysResultSet(String schema, String table) throws SQLException {
        ResultSet pExportRs;
        if (this.prepFkNone == null) {
            this.log.debug((Object)"Preparing foreign key queries...");
            Connection con = this.getConnection();
            this.prepFkNone = con.prepareStatement(SQL_FK_NONE);
            this.prepFkSchema = con.prepareStatement(SQL_FK_SCHEMA);
            this.prepFkTable = con.prepareStatement(SQL_FK_TABLE);
            this.prepFkSchemaAndTable = con.prepareStatement(SQL_FK_SCHEMA_AND_TABLE);
            this.log.debug((Object)"  foreign key queries prepared!");
        }
        if (schema == null && table == null) {
            pExportRs = this.prepFkNone.executeQuery();
        } else if (schema != null) {
            if (table == null) {
                this.prepFkSchema.setString(1, schema);
                pExportRs = this.prepFkSchema.executeQuery();
            } else {
                this.prepFkSchemaAndTable.setString(1, schema);
                this.prepFkSchemaAndTable.setString(2, table);
                pExportRs = this.prepFkSchemaAndTable.executeQuery();
            }
        } else {
            this.prepFkTable.setString(1, table);
            pExportRs = this.prepFkTable.executeQuery();
        }
        return pExportRs;
    }

    private ResultSet getColumnsResultSet(String schema, String table, String column) throws SQLException {
        ResultSet columnRs;
        if (this.prepColumnNone == null) {
            this.log.debug((Object)"Preparing column queries...");
            Connection con = this.getConnection();
            this.prepColumnNone = con.prepareStatement(SQL_COLUMN_NONE);
            this.prepColumnSchema = con.prepareStatement(SQL_COLUMN_SCHEMA);
            this.prepColumnTable = con.prepareStatement(SQL_COLUMN_TABLE);
            this.prepColumnColumn = con.prepareStatement(SQL_COLUMN_COLUMN);
            this.prepColumnSchemaAndTable = con.prepareStatement(SQL_COLUMN_SCHEMA_AND_TABLE);
            this.prepColumnSchemaAndColumn = con.prepareStatement(SQL_COLUMN_SCHEMA_AND_COLUMN);
            this.prepColumnTableAndColumn = con.prepareStatement(SQL_COLUMN_TABLE_AND_COLUMN);
            this.prepColumnSchemaAndTableAndColumn = con.prepareStatement(SQL_COLUMN_SCHEMA_AND_TABLE_AND_COLUMN);
            this.log.debug((Object)"  ...column queries prepared!");
        }
        if (schema == null && table == null && column == null) {
            columnRs = this.prepColumnNone.executeQuery();
        } else if (schema != null) {
            if (table == null) {
                if (column == null) {
                    this.prepColumnSchema.setString(1, schema);
                    columnRs = this.prepColumnSchema.executeQuery();
                } else {
                    this.prepColumnSchemaAndColumn.setString(1, schema);
                    this.prepColumnSchemaAndColumn.setString(2, column);
                    columnRs = this.prepColumnSchemaAndColumn.executeQuery();
                }
            } else if (column == null) {
                this.prepColumnSchemaAndTable.setString(1, schema);
                this.prepColumnSchemaAndTable.setString(2, table);
                columnRs = this.prepColumnSchemaAndTable.executeQuery();
            } else {
                this.prepColumnSchemaAndTableAndColumn.setString(1, schema);
                this.prepColumnSchemaAndTableAndColumn.setString(2, table);
                this.prepColumnSchemaAndTableAndColumn.setString(3, column);
                columnRs = this.prepColumnSchemaAndTableAndColumn.executeQuery();
            }
        } else if (table == null) {
            this.prepColumnColumn.setString(1, column);
            columnRs = this.prepColumnColumn.executeQuery();
        } else if (column == null) {
            this.prepColumnTable.setString(1, table);
            columnRs = this.prepColumnTable.executeQuery();
        } else {
            this.prepColumnTableAndColumn.setString(1, table);
            this.prepColumnTableAndColumn.setString(2, column);
            columnRs = this.prepColumnTableAndColumn.executeQuery();
        }
        return columnRs;
    }

    private ResultSet getTableResultSet(String schema, String table) throws SQLException {
        ResultSet tableRs;
        if (this.prepTableNone == null) {
            this.log.debug((Object)"Preparing table queries...");
            Connection connection2 = this.getConnection();
            this.prepTableNone = connection2.prepareStatement(SQL_TABLE_NONE);
            this.prepTableSchema = connection2.prepareStatement(SQL_TABLE_SCHEMA);
            this.prepTableTable = connection2.prepareStatement(SQL_TABLE_TABLE);
            this.prepTableSchemaAndTable = connection2.prepareStatement(SQL_TABLE_SCHEMA_AND_TABLE);
            this.log.debug((Object)"  ...table queries prepared!");
        }
        if (schema == null && table == null) {
            tableRs = this.prepTableNone.executeQuery();
        } else if (schema != null) {
            if (table == null) {
                this.prepTableSchema.setString(1, schema);
                this.prepTableSchema.setString(2, schema);
                tableRs = this.prepTableSchema.executeQuery();
            } else {
                this.prepTableSchemaAndTable.setString(1, schema);
                this.prepTableSchemaAndTable.setString(2, table);
                this.prepTableSchemaAndTable.setString(3, schema);
                this.prepTableSchemaAndTable.setString(4, table);
                tableRs = this.prepTableSchemaAndTable.executeQuery();
            }
        } else {
            this.prepTableTable.setString(1, table);
            this.prepTableTable.setString(2, table);
            tableRs = this.prepTableTable.executeQuery();
        }
        return tableRs;
    }
}

