/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.reveng.DefaulAssociationInfo;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.MetaAttributeBinder;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.SchemaSelection;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;

public final class OverrideBinder {
    private OverrideBinder() {
    }

    public static void bindRoot(OverrideRepository repository, Document doc) {
        Element rootElement = doc.getRootElement();
        List elements = rootElement.elements("schema-selection");
        OverrideBinder.bindSchemaSelection(elements, repository);
        Element element = rootElement.element("type-mapping");
        if (element != null) {
            OverrideBinder.bindTypeMappings(element, repository);
        }
        elements = rootElement.elements("table-filter");
        OverrideBinder.bindTableFilters(elements, repository);
        List tables = rootElement.elements("table");
        OverrideBinder.bindTables(tables, repository);
    }

    static boolean bindManyToOneAndCollection(Element element, String constraintName, OverrideRepository repository) {
        String manyToOneProperty = null;
        Boolean excludeManyToOne = null;
        DefaulAssociationInfo associationInfo = null;
        DefaulAssociationInfo inverseAssociationInfo = null;
        Element manyToOne = element.element("many-to-one");
        if (manyToOne != null) {
            manyToOneProperty = manyToOne.attributeValue("property");
            excludeManyToOne = OverrideBinder.BooleanValue(manyToOne.attributeValue("exclude"));
            associationInfo = OverrideBinder.extractAssociationInfo(manyToOne);
        }
        String collectionProperty = null;
        Boolean excludeCollection = null;
        Element collection = element.element("set");
        if (collection != null) {
            collectionProperty = collection.attributeValue("property");
            excludeCollection = OverrideBinder.BooleanValue(collection.attributeValue("exclude"));
            inverseAssociationInfo = OverrideBinder.extractAssociationInfo(collection);
        }
        if (manyToOne != null || collection != null) {
            repository.addForeignKeyInfo(constraintName, manyToOneProperty, excludeManyToOne, collectionProperty, excludeCollection, associationInfo, inverseAssociationInfo);
            return true;
        }
        return false;
    }

    private static void bindSchemaSelection(List<?> selection, OverrideRepository repository) {
        for (Element element : selection) {
            SchemaSelection schemaSelection = new SchemaSelection();
            schemaSelection.setMatchCatalog(element.attributeValue("match-catalog"));
            schemaSelection.setMatchSchema(element.attributeValue("match-schema"));
            schemaSelection.setMatchTable(element.attributeValue("match-table"));
            repository.addSchemaSelection(schemaSelection);
        }
    }

    private static void bindTables(List<?> tables, OverrideRepository repository) {
        for (Element element : tables) {
            Table table = new Table();
            table.setCatalog(element.attributeValue("catalog"));
            table.setSchema(element.attributeValue("schema"));
            table.setName(element.attributeValue("name"));
            String wantedClassName = element.attributeValue("class");
            Element primaryKey = element.element("primary-key");
            OverrideBinder.bindPrimaryKey(primaryKey, table, repository);
            List columns = element.elements("column");
            OverrideBinder.bindColumns(columns, table, repository);
            List foreignKeys = element.elements("foreign-key");
            OverrideBinder.bindForeignKeys(foreignKeys, table, repository);
            OverrideBinder.bindMetaAttributes(element, table, repository);
            repository.addTable(table, wantedClassName);
        }
    }

    private static void bindMetaAttributes(Element element, Table table, OverrideRepository repository) {
        MultiMap map = MetaAttributeBinder.loadAndMergeMetaMap(element, (MultiMap)new MultiValueMap());
        if (map != null && !map.isEmpty()) {
            repository.addMetaAttributeInfo(table, map);
        }
    }

    private static void bindPrimaryKey(Element identifier, Table table, OverrideRepository repository) {
        if (identifier == null) {
            return;
        }
        String propertyName = identifier.attributeValue("property");
        String compositeIdName = identifier.attributeValue("id-class");
        Element element = identifier.element("generator");
        if (element != null) {
            String identifierClass = element.attributeValue("class");
            Properties params = new Properties();
            Iterator iter = element.elementIterator("param");
            while (iter.hasNext()) {
                Element childNode = (Element)iter.next();
                params.setProperty(childNode.attributeValue("name"), childNode.getText());
            }
            repository.addTableIdentifierStrategy(table, identifierClass, params);
        }
        List<String> boundColumnNames = OverrideBinder.bindColumns(identifier.elements("key-column"), table, repository);
        repository.addPrimaryKeyNamesForTable(table, boundColumnNames, propertyName, compositeIdName);
    }

    private static void bindForeignKeys(List<?> foreignKeys, Table table, OverrideRepository repository) {
        for (Element element : foreignKeys) {
            String constraintName = element.attributeValue("constraint-name");
            String foreignTableName = element.attributeValue("foreign-table");
            if (foreignTableName != null) {
                Table foreignTable = new Table();
                foreignTable.setName(foreignTableName);
                foreignTable.setCatalog(OverrideBinder.getValue(element.attributeValue("foreign-catalog"), table.getCatalog()));
                foreignTable.setSchema(OverrideBinder.getValue(element.attributeValue("foreign-schema"), table.getSchema()));
                ArrayList<Column> localColumns = new ArrayList<Column>();
                ArrayList<Column> foreignColumns = new ArrayList<Column>();
                for (Element columnRef : element.elements("column-ref")) {
                    String localColumnName = columnRef.attributeValue("local-column");
                    String foreignColumnName = columnRef.attributeValue("foreign-column");
                    Column localColumn = new Column(localColumnName);
                    Column foreignColumn = new Column(foreignColumnName);
                    localColumns.add(localColumn);
                    foreignColumns.add(foreignColumn);
                }
                ForeignKey key = table.createForeignKey(constraintName, localColumns, foreignTableName, foreignColumns);
                key.setReferencedTable(foreignTable);
            }
            if (!StringHelper.isNotEmpty((String)constraintName)) continue;
            if (!OverrideBinder.validateFkAssociations(element)) {
                throw new IllegalArgumentException("you can't mix <many-to-one/> or <set/> with <(inverse-)one-to-one/> ");
            }
            if (OverrideBinder.bindManyToOneAndCollection(element, constraintName, repository)) continue;
            OverrideBinder.bindOneToOne(element, constraintName, repository);
        }
    }

    private static void bindOneToOne(Element element, String constraintName, OverrideRepository repository) {
        String oneToOneProperty = null;
        Boolean excludeOneToOne = null;
        Element oneToOne = element.element("one-to-one");
        DefaulAssociationInfo associationInfo = null;
        if (oneToOne != null) {
            oneToOneProperty = oneToOne.attributeValue("property");
            excludeOneToOne = OverrideBinder.BooleanValue(oneToOne.attributeValue("exclude"));
            associationInfo = OverrideBinder.extractAssociationInfo(oneToOne);
        }
        String inverseOneToOneProperty = null;
        Boolean excludeInverseOneToOne = null;
        Element inverseOneToOne = element.element("inverse-one-to-one");
        DefaulAssociationInfo inverseAssociationInfo = null;
        if (inverseOneToOne != null) {
            inverseOneToOneProperty = inverseOneToOne.attributeValue("property");
            excludeInverseOneToOne = OverrideBinder.BooleanValue(inverseOneToOne.attributeValue("exclude"));
            inverseAssociationInfo = OverrideBinder.extractAssociationInfo(inverseOneToOne);
        }
        if (oneToOne != null) {
            repository.addForeignKeyInfo(constraintName, oneToOneProperty, excludeOneToOne, inverseOneToOneProperty, excludeInverseOneToOne, associationInfo, inverseAssociationInfo);
        }
    }

    private static DefaulAssociationInfo extractAssociationInfo(Element manyToOne) {
        String attributeValue = manyToOne.attributeValue("cascade");
        DefaulAssociationInfo associationInfo = null;
        if (attributeValue != null) {
            associationInfo = OverrideBinder.ensureInit(associationInfo);
            associationInfo.setCascade(attributeValue);
        }
        if ((attributeValue = manyToOne.attributeValue("fetch")) != null) {
            associationInfo = OverrideBinder.ensureInit(associationInfo);
            associationInfo.setFetch(attributeValue);
        }
        if ((attributeValue = manyToOne.attributeValue("insert")) != null) {
            associationInfo = OverrideBinder.ensureInit(associationInfo);
            associationInfo.setInsert(new Boolean(attributeValue));
        }
        if ((attributeValue = manyToOne.attributeValue("update")) != null) {
            associationInfo = OverrideBinder.ensureInit(associationInfo);
            associationInfo.setUpdate(new Boolean(attributeValue));
        }
        return associationInfo;
    }

    private static DefaulAssociationInfo ensureInit(DefaulAssociationInfo associationInfo) {
        return associationInfo == null ? new DefaulAssociationInfo() : associationInfo;
    }

    private static boolean validateFkAssociations(Element element) {
        Element manyToOne = element.element("many-to-one");
        Element oneToOne = element.element("one-to-one");
        Element set = element.element("set");
        Element inverseOneToOne = element.element("inverse-one-to-one");
        if (manyToOne != null && (oneToOne != null || inverseOneToOne != null)) {
            return false;
        }
        if (oneToOne != null && set != null) {
            return false;
        }
        return inverseOneToOne == null || set == null;
    }

    private static Boolean BooleanValue(String string) {
        if (string == null) {
            return null;
        }
        return Boolean.valueOf(string);
    }

    private static String getValue(String first, String second) {
        if (first == null) {
            return second;
        }
        return first;
    }

    private static List<String> bindColumns(List<?> columns, Table table, OverrideRepository repository) {
        Iterator<?> iterator = columns.iterator();
        ArrayList<String> columnNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            String foreignTableName;
            Element element = (Element)iterator.next();
            Column column = new Column();
            column.setName(element.attributeValue("name"));
            String attributeValue = element.attributeValue("jdbc-type");
            if (StringHelper.isNotEmpty((String)attributeValue)) {
                column.setSqlTypeCode(new Integer(JDBCToHibernateTypeHelper.getJDBCType(attributeValue)));
            }
            TableIdentifier tableIdentifier = TableIdentifier.create(table);
            if (table.getColumn(column) != null) {
                throw new MappingException("Column " + column.getName() + " already exists in table " + tableIdentifier);
            }
            MultiMap map = MetaAttributeBinder.loadAndMergeMetaMap(element, (MultiMap)new MultiValueMap());
            if (map != null && !map.isEmpty()) {
                repository.addMetaAttributeInfo(tableIdentifier, column.getName(), map);
            }
            table.addColumn(column);
            columnNames.add(column.getName());
            repository.setTypeNameForColumn(tableIdentifier, column.getName(), element.attributeValue("type"));
            repository.setPropertyNameForColumn(tableIdentifier, column.getName(), element.attributeValue("property"));
            boolean excluded = OverrideBinder.booleanValue(element.attributeValue("exclude"));
            if (excluded) {
                repository.setExcludedColumn(tableIdentifier, column.getName());
            }
            if ((foreignTableName = element.attributeValue("foreign-table")) == null) continue;
            ArrayList<Column> localColumns = new ArrayList<Column>();
            localColumns.add(column);
            ArrayList<Column> foreignColumns = new ArrayList<Column>();
            Table foreignTable = new Table();
            foreignTable.setName(foreignTableName);
            foreignTable.setCatalog(OverrideBinder.getValue(element.attributeValue("foreign-catalog"), table.getCatalog()));
            foreignTable.setSchema(OverrideBinder.getValue(element.attributeValue("foreign-schema"), table.getSchema()));
            String foreignColumnName = element.attributeValue("foreign-column");
            if (foreignColumnName == null) {
                throw new MappingException("foreign-column is required when foreign-table is specified on " + column);
            }
            Column foreignColumn = new Column();
            foreignColumn.setName(foreignColumnName);
            foreignColumns.add(foreignColumn);
            ForeignKey key = table.createForeignKey(null, localColumns, foreignTableName, foreignColumns);
            key.setReferencedTable(foreignTable);
        }
        return columnNames;
    }

    private static boolean booleanValue(String value) {
        return Boolean.valueOf(value);
    }

    private static void bindTableFilters(List<?> filters, OverrideRepository respository) {
        for (Element element : filters) {
            TableFilter filter = new TableFilter();
            filter.setMatchCatalog(element.attributeValue("match-catalog"));
            filter.setMatchSchema(element.attributeValue("match-schema"));
            filter.setMatchName(element.attributeValue("match-name"));
            filter.setExclude(Boolean.valueOf(element.attributeValue("exclude")));
            filter.setPackage(element.attributeValue("package"));
            MultiMap map = MetaAttributeBinder.loadAndMergeMetaMap(element, (MultiMap)new MultiValueMap());
            if (map != null && !map.isEmpty()) {
                filter.setMetaAttributes((Map<?, ?>)map);
            } else {
                filter.setMetaAttributes(null);
            }
            respository.addTableFilter(filter);
        }
    }

    private static void bindTypeMappings(Element typeMapping, OverrideRepository repository) {
        for (Element element : typeMapping.elements("sql-type")) {
            int jdbcType = JDBCToHibernateTypeHelper.getJDBCType(element.attributeValue("jdbc-type"));
            SQLTypeMapping mapping = new SQLTypeMapping(jdbcType);
            mapping.setHibernateType(OverrideBinder.getHibernateType(element));
            mapping.setLength(OverrideBinder.getInteger(element.attributeValue("length"), Integer.MAX_VALUE));
            mapping.setPrecision(OverrideBinder.getInteger(element.attributeValue("precision"), Integer.MAX_VALUE));
            mapping.setScale(OverrideBinder.getInteger(element.attributeValue("scale"), Integer.MAX_VALUE));
            String notNull = element.attributeValue("not-null");
            if (notNull == null) {
                mapping.setNullable(null);
            } else {
                boolean nullable = notNull.equals("false");
                mapping.setNullable(nullable);
            }
            if (StringHelper.isEmpty((String)mapping.getHibernateType())) {
                throw new MappingException("No hibernate-type specified for " + element.attributeValue("jdbc-type") + " at " + element.getUniquePath());
            }
            repository.addTypeMapping(mapping);
        }
    }

    private static String getHibernateType(Element element) {
        String attributeValue = element.attributeValue("hibernate-type");
        if (StringHelper.isEmpty((String)attributeValue)) {
            Element child = element.element("hibernate-type");
            if (child == null) {
                return null;
            }
            return child.attributeValue("name");
        }
        return attributeValue;
    }

    private static int getInteger(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }

    String getMatchString(String input) {
        return input.toUpperCase();
    }
}

