/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.internal.InFlightMetadataCollectorImpl;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.BasicTypeRegistration;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;

public class PojoMetaDataConfiguration
extends Configuration {
    private StandardServiceRegistry serviceRegistry = null;
    private InFlightMetadataCollectorImpl metadataCollector;
    private ClassLoaderAccess classLoaderAccess = null;
    private MetadataBuildingOptions metadataBuildingOptions = null;
    private MetadataBuildingContext metadataBuildingContext = null;
    private Metadata metadata = null;

    public void addClass(PersistentClass persistentClass) {
        this.getMetadataCollector().addEntityBinding(persistentClass);
    }

    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = this.getMetadataCollector().buildMetadataInstance(this.getMetadataBuildingContext());
        }
        return this.metadata;
    }

    public MetadataImplementor getMetadataImplementor() {
        return this.getMetadataCollector();
    }

    private ClassLoaderAccess getClassLoaderAccess() {
        if (this.classLoaderAccess == null) {
            MetadataBuildingOptions options = this.getMetadataBuildingOptions();
            ClassLoaderService classLoaderService = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
            this.classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        }
        return this.classLoaderAccess;
    }

    private MetadataBuildingOptions getMetadataBuildingOptions() {
        if (this.metadataBuildingOptions == null) {
            this.metadataBuildingOptions = new MetadataBuilderImpl.MetadataBuildingOptionsImpl(this.getServiceRegistry());
        }
        return this.metadataBuildingOptions;
    }

    private InFlightMetadataCollectorImpl getMetadataCollector() {
        if (this.metadataCollector == null) {
            MetadataBuildingOptions options = this.getMetadataBuildingOptions();
            BasicTypeRegistry basicTypeRegistry = PojoMetaDataConfiguration.handleTypes(options);
            this.metadataCollector = new InFlightMetadataCollectorImpl(options, new TypeResolver(basicTypeRegistry, new TypeFactory()));
        }
        return this.metadataCollector;
    }

    private MetadataBuildingContext getMetadataBuildingContext() {
        if (this.metadataBuildingContext == null) {
            this.metadataBuildingContext = new MetadataBuildingContextRootImpl(this.getMetadataBuildingOptions(), this.getClassLoaderAccess(), (InFlightMetadataCollector)this.getMetadataCollector());
        }
        return this.metadataBuildingContext;
    }

    private StandardServiceRegistry getServiceRegistry() {
        if (this.serviceRegistry == null) {
            this.serviceRegistry = new StandardServiceRegistryBuilder().applySettings((Map)this.getProperties()).build();
        }
        return this.serviceRegistry;
    }

    private static BasicTypeRegistry handleTypes(MetadataBuildingOptions options) {
        ClassLoaderService classLoaderService = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
        final BasicTypeRegistry basicTypeRegistry = new BasicTypeRegistry();
        TypeContributions typeContributions = new TypeContributions(){

            public void contributeType(BasicType type) {
                basicTypeRegistry.register(type);
            }

            public void contributeType(BasicType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }

            public void contributeType(UserType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }

            public void contributeType(CompositeUserType type, String ... keys) {
                basicTypeRegistry.register(type, keys);
            }
        };
        Dialect dialect = ((JdbcServices)options.getServiceRegistry().getService(JdbcServices.class)).getDialect();
        dialect.contributeTypes(typeContributions, (ServiceRegistry)options.getServiceRegistry());
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, (ServiceRegistry)options.getServiceRegistry());
        }
        for (BasicTypeRegistration basicTypeRegistration : options.getBasicTypeRegistrations()) {
            basicTypeRegistry.register(basicTypeRegistration.getBasicType(), basicTypeRegistration.getRegistrationKeys());
        }
        return basicTypeRegistry;
    }
}

