/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2x.doc.DocFile;
import org.hibernate.tool.hbm2x.doc.DocFolder;
import org.hibernate.tool.hbm2x.doc.DocHelper;
import org.hibernate.tool.hbm2x.pojo.POJOClass;

public class DocFileManager {
    private DocFolder rootDocFolder;
    private DocFile mainIndexDocFile;
    private DocFolder assetsDocFolder;
    private DocFile hibernateImageDocFile;
    private DocFile extendsImageDocFile;
    private DocFile cssStylesDocFile;
    private DocFolder rootTablesDocFolder;
    private DocFolder rootEntitiesDocFolder;
    private DocFile classIndexDocFile;
    private DocFile entitySummaryDocFile;
    private DocFile allPackagesDocFile;
    private DocFile allEntitiesDocFile;
    private DocFile tableIndexDocFile;
    private DocFile tableSummaryDocFile;
    private DocFile allSchemasDocFile;
    private DocFile allTablesDocFile;
    private Map<Table, DocFile> tableDocFiles = new HashMap<Table, DocFile>();
    private Map<POJOClass, DocFile> entityDocFiles = new HashMap<POJOClass, DocFile>();
    private Map<String, DocFile> schemaSummaryDocFiles = new HashMap<String, DocFile>();
    private Map<String, DocFile> packageSummaryDocFiles = new HashMap<String, DocFile>();
    private Map<String, DocFile> schemaTableListDocFiles = new HashMap<String, DocFile>();
    private Map<String, DocFile> packageEntityListDocFile = new HashMap<String, DocFile>();

    public DocFolder getRootDocFolder() {
        return this.rootDocFolder;
    }

    public DocFileManager(DocHelper docHelper, File pRootFolder) {
        this.rootDocFolder = new DocFolder(pRootFolder);
        this.mainIndexDocFile = new DocFile("index.html", this.rootDocFolder);
        this.assetsDocFolder = new DocFolder("assets", this.rootDocFolder);
        this.hibernateImageDocFile = new DocFile("hibernate_logo.gif", this.assetsDocFolder);
        this.extendsImageDocFile = new DocFile("inherit.gif", this.assetsDocFolder);
        this.cssStylesDocFile = new DocFile("doc-style.css", this.assetsDocFolder);
        this.rootEntitiesDocFolder = new DocFolder("entities", this.rootDocFolder);
        this.classIndexDocFile = new DocFile("index.html", this.rootEntitiesDocFolder);
        this.entitySummaryDocFile = new DocFile("summary.html", this.rootEntitiesDocFolder);
        this.allPackagesDocFile = new DocFile("allpackages.html", this.rootEntitiesDocFolder);
        this.allEntitiesDocFile = new DocFile("allentities.html", this.rootEntitiesDocFolder);
        this.rootTablesDocFolder = new DocFolder("tables", this.rootDocFolder);
        this.tableIndexDocFile = new DocFile("index.html", this.rootTablesDocFolder);
        this.tableSummaryDocFile = new DocFile("summary.html", this.rootTablesDocFolder);
        this.allSchemasDocFile = new DocFile("allschemas.html", this.rootTablesDocFolder);
        this.allTablesDocFile = new DocFile("alltables.html", this.rootTablesDocFolder);
        HashMap<String, DocFolder> schemaFolders = new HashMap<String, DocFolder>();
        for (String packageName : docHelper.getPackages()) {
            DocFolder packageFolder = null;
            DocFolder theRoot = this.rootEntitiesDocFolder;
            if (!packageName.equals("All Entities")) {
                String[] packagesArr = packageName.split("\\.");
                for (int count = 0; count < packagesArr.length; ++count) {
                    theRoot = packageFolder = new DocFolder(packagesArr[count], theRoot);
                }
                DocFile packageSummaryDocFile = new DocFile("summary.html", packageFolder);
                this.packageSummaryDocFiles.put(packageName, packageSummaryDocFile);
                DocFile classListDocFile = new DocFile("entities.html", packageFolder);
                this.packageEntityListDocFile.put(packageName, classListDocFile);
            } else {
                packageFolder = this.rootEntitiesDocFolder;
            }
            for (POJOClass pc : docHelper.getClasses(packageName)) {
                String classFileName = pc.getDeclarationName();
                classFileName = classFileName + ".html";
                DocFile classDocFile = new DocFile(classFileName, packageFolder);
                this.entityDocFiles.put(pc, classDocFile);
            }
        }
        for (String schemaName : docHelper.getSchemas()) {
            DocFolder schemaFolder = new DocFolder(schemaName, this.rootTablesDocFolder);
            schemaFolders.put(schemaName, schemaFolder);
            DocFile schemaSummaryDocFile = new DocFile("summary.html", schemaFolder);
            this.schemaSummaryDocFiles.put(schemaName, schemaSummaryDocFile);
            DocFile tableListDocFile = new DocFile("tables.html", schemaFolder);
            this.schemaTableListDocFiles.put(schemaName, tableListDocFile);
            for (Table table : docHelper.getTables(schemaName)) {
                if (!table.isPhysicalTable()) continue;
                String tableFileName = table.getName() + ".html";
                DocFile tableDocFile = new DocFile(tableFileName, schemaFolder);
                this.tableDocFiles.put(table, tableDocFile);
            }
        }
    }

    public DocFolder getAssetsDocFolder() {
        return this.assetsDocFolder;
    }

    public DocFile getCssStylesDocFile() {
        return this.cssStylesDocFile;
    }

    public DocFile getHibernateImageDocFile() {
        return this.hibernateImageDocFile;
    }

    public DocFile getExtendsImageDocFile() {
        return this.extendsImageDocFile;
    }

    public DocFile getMainIndexDocFile() {
        return this.mainIndexDocFile;
    }

    public DocFile getTableIndexDocFile() {
        return this.tableIndexDocFile;
    }

    public DocFile getClassIndexDocFile() {
        return this.classIndexDocFile;
    }

    public DocFile getClassSummaryFile() {
        return this.entitySummaryDocFile;
    }

    public DocFile getAllPackagesDocFile() {
        return this.allPackagesDocFile;
    }

    public DocFile getAllEntitiesDocFile() {
        return this.allEntitiesDocFile;
    }

    public DocFile getPackageEntityListDocFile(String packageName) {
        return this.packageEntityListDocFile.get(packageName);
    }

    public DocFile getTableSummaryDocFile() {
        return this.tableSummaryDocFile;
    }

    public DocFile getAllSchemasDocFile() {
        return this.allSchemasDocFile;
    }

    public DocFile getAllTablesDocFile() {
        return this.allTablesDocFile;
    }

    public DocFile getTableDocFile(Table table) {
        return this.tableDocFiles.get(table);
    }

    public DocFile getEntityDocFileByDeclarationName(POJOClass pc) {
        DocFile df = this.getEntityDocFile(pc);
        String pcQualifiedDeclarationName = pc.getQualifiedDeclarationName();
        if (df == null) {
            for (POJOClass pojoClass : this.entityDocFiles.keySet()) {
                String pojoClassQualifiedDeclarationName = pojoClass.getQualifiedDeclarationName();
                if (!pcQualifiedDeclarationName.equals(pojoClassQualifiedDeclarationName)) continue;
                df = this.entityDocFiles.get(pojoClass);
                break;
            }
        }
        return df;
    }

    public DocFile getEntityDocFile(POJOClass pc) {
        return this.entityDocFiles.get(pc);
    }

    public DocFile getSchemaSummaryDocFile(String schemaName) {
        return this.schemaSummaryDocFiles.get(schemaName);
    }

    public DocFile getPackageSummaryDocFile(String packageName) {
        return this.packageSummaryDocFiles.get(packageName);
    }

    public DocFile getSchemaTableListDocFile(String schemaName) {
        return this.schemaTableListDocFiles.get(schemaName);
    }

    public String getRef(DocFile from, DocFile to) {
        if (from == null) {
            throw new IllegalArgumentException("From cannot be null.");
        }
        if (to == null) {
            throw new IllegalArgumentException("To cannot be null.");
        }
        return from.buildRefTo(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(ClassLoader loader, String fileName, File to) throws IOException {
        InputStream is = null;
        FileOutputStream out = null;
        try {
            int value;
            is = loader.getResourceAsStream(fileName);
            if (is == null) {
                throw new IllegalArgumentException("File not found: " + fileName);
            }
            out = new FileOutputStream(to);
            while ((value = is.read()) != -1) {
                out.write(value);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

