/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.tool.hbm2x.Cfg2JavaTool;
import org.hibernate.tool.hbm2x.POJOExporter;
import org.hibernate.tool.hbm2x.pojo.ComponentPOJOClass;
import org.hibernate.tool.hbm2x.pojo.POJOClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationNavigator {
    private static final Logger log = LoggerFactory.getLogger(POJOExporter.class);

    public static void collectComponents(Map<String, Component> components, PersistentClass clazz) {
        Iterator<Property> iter = new Cfg2JavaTool().getPOJOClass(clazz).getAllPropertiesIterator();
        ConfigurationNavigator.collectComponents(components, iter);
    }

    public static void collectComponents(Map<String, Component> components, POJOClass clazz) {
        Iterator<Property> iter = clazz.getAllPropertiesIterator();
        ConfigurationNavigator.collectComponents(components, iter);
    }

    private static void collectComponents(Map<String, Component> components, Iterator<Property> iter) {
        while (iter.hasNext()) {
            Collection collection;
            Property property = iter.next();
            if (!"embedded".equals(property.getPropertyAccessorName()) && property.getValue() instanceof Component) {
                Component comp = (Component)property.getValue();
                ConfigurationNavigator.addComponent(components, comp);
                continue;
            }
            if (!(property.getValue() instanceof Collection) || !((collection = (Collection)property.getValue()).getElement() instanceof Component)) continue;
            Component comp = (Component)collection.getElement();
            ConfigurationNavigator.addComponent(components, comp);
        }
    }

    private static void addComponent(Map<String, Component> components, Component comp) {
        if (!comp.isDynamic()) {
            Component existing = components.put(comp.getComponentClassName(), comp);
            if (existing != null) {
                log.warn("Component " + existing.getComponentClassName() + " found more than once! Will only generate the last found.");
            }
        } else {
            log.debug("dynamic-component found. Ignoring it as a component, but will collect any embedded components.");
        }
        ConfigurationNavigator.collectComponents(components, new ComponentPOJOClass(comp, new Cfg2JavaTool()).getAllPropertiesIterator());
    }
}

