/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.jtype;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.hibernate.validation.jtype.ClassSerializer;
import org.hibernate.validation.jtype.ClassSerializers;
import org.hibernate.validation.jtype.ClassUtils;
import org.hibernate.validation.jtype.DefaultGenericArrayType;
import org.hibernate.validation.jtype.DefaultParameterizedType;
import org.hibernate.validation.jtype.DefaultTypeVariable;
import org.hibernate.validation.jtype.DefaultWildcardType;
import org.hibernate.validation.jtype.Types;
import org.hibernate.validation.jtype.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeUtils {
    private TypeUtils() {
        throw new AssertionError();
    }

    public static boolean isAssignable(Type supertype, Type type) {
        Utils.checkNotNull(supertype, "supertype");
        Utils.checkNotNull(type, "type");
        boolean assignable = supertype.equals(type) ? true : (supertype instanceof Class && type instanceof Class ? ((Class)supertype).isAssignableFrom((Class)type) : (supertype instanceof Class && type instanceof ParameterizedType ? TypeUtils.isAssignable(supertype, ((ParameterizedType)type).getRawType()) : (supertype instanceof ParameterizedType && type instanceof ParameterizedType ? TypeUtils.isAssignable((ParameterizedType)supertype, (ParameterizedType)type) : (supertype instanceof WildcardType ? TypeUtils.isAssignable((WildcardType)supertype, type) : (type instanceof Class ? TypeUtils.isAssignable(supertype, (Class)type) : false)))));
        return assignable;
    }

    public static boolean isInstance(Type type, Object object) {
        return TypeUtils.getRawType(type).isInstance(object);
    }

    public static Type getErasedType(Type type) {
        Type erasedType;
        Utils.checkNotNull(type, "type");
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            erasedType = TypeUtils.getErasedType(rawType);
        } else if (TypeUtils.isArray(type)) {
            Type componentType = TypeUtils.getComponentType(type);
            Type erasedComponentType = TypeUtils.getErasedType(componentType);
            erasedType = TypeUtils.getArrayType(erasedComponentType);
        } else if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            erasedType = TypeUtils.getErasedType(bounds[0]);
        } else {
            erasedType = type;
        }
        return erasedType;
    }

    public static Class<?> getRawType(Type type) {
        Class<?> rawType;
        Utils.checkNotNull(type, "type");
        if (type instanceof Class) {
            rawType = (Class<?>)type;
        } else if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> rawComponentType = TypeUtils.getRawType(componentType);
            rawType = ClassUtils.getArrayType(rawComponentType);
        } else if (type instanceof ParameterizedType) {
            rawType = TypeUtils.getRawType(((ParameterizedType)type).getRawType());
        } else {
            throw new IllegalArgumentException("Cannot obtain raw type from " + type);
        }
        return rawType;
    }

    public static boolean isArray(Type type) {
        Utils.checkNotNull(type, "type");
        boolean array = type instanceof Class ? ((Class)type).isArray() : type instanceof GenericArrayType;
        return array;
    }

    public static Type getComponentType(Type type) {
        Class klass;
        Utils.checkNotNull(type, "type");
        Class<Object> componentType = type instanceof Class ? ((klass = (Class)type).isArray() ? klass.getComponentType() : null) : (type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : null);
        return componentType;
    }

    public static Type getArrayType(Type componentType) {
        Utils.checkNotNull(componentType, "componentType");
        Type arrayType = componentType instanceof Class ? ClassUtils.getArrayType((Class)componentType) : Types.genericArrayType(componentType);
        return arrayType;
    }

    public static boolean isSimpleParameterizedType(Type type, Class<?> rawType) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(rawType, "rawType");
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramType = (ParameterizedType)type;
        Type paramRawType = paramType.getRawType();
        if (!(paramRawType instanceof Class)) {
            return false;
        }
        Class paramRawClass = (Class)paramRawType;
        if (!rawType.isAssignableFrom(paramRawClass)) {
            return false;
        }
        Type[] typeArgs = paramType.getActualTypeArguments();
        return typeArgs.length == 1;
    }

    public static Type getActualTypeArgument(Type type) {
        Utils.checkNotNull(type, "type");
        ParameterizedType paramType = (ParameterizedType)type;
        Type[] typeArgs = paramType.getActualTypeArguments();
        Utils.checkTrue(typeArgs.length == 1, "type must be a ParameterizedType with one actual type argument: ", type);
        return typeArgs[0];
    }

    public static String toString(Type type) {
        return TypeUtils.toString(type, ClassSerializers.QUALIFIED);
    }

    public static String toString(Type type, ClassSerializer serializer) {
        Class klass;
        String value = type instanceof Class ? ((klass = (Class)type).isArray() ? TypeUtils.toString(klass.getComponentType(), serializer) + "[]" : serializer.toString(klass)) : (type instanceof TypeVariable ? DefaultTypeVariable.toString((TypeVariable)type, serializer) : (type instanceof GenericArrayType ? DefaultGenericArrayType.toString((GenericArrayType)type, serializer) : (type instanceof ParameterizedType ? DefaultParameterizedType.toString((ParameterizedType)type, serializer) : (type instanceof WildcardType ? DefaultWildcardType.toString((WildcardType)type, serializer) : String.valueOf(type)))));
        return value;
    }

    public static String toUnqualifiedString(Type type) {
        return TypeUtils.toString(type, ClassSerializers.UNQUALIFIED);
    }

    static StringBuilder appendBounds(StringBuilder builder, Type[] bounds, ClassSerializer serializer) {
        for (int i = 0; i < bounds.length; ++i) {
            if (i > 0) {
                builder.append(" & ");
            }
            builder.append(TypeUtils.toString(bounds[i], serializer));
        }
        return builder;
    }

    private static boolean isAssignable(ParameterizedType supertype, ParameterizedType type) {
        Type[] typeArgs;
        if (!TypeUtils.isAssignable(supertype.getRawType(), type.getRawType())) {
            return false;
        }
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        if (supertypeArgs.length != (typeArgs = type.getActualTypeArguments()).length) {
            return false;
        }
        for (int i = 0; i < supertypeArgs.length; ++i) {
            Type supertypeArg = supertypeArgs[i];
            Type typeArg = typeArgs[i];
            if (supertypeArg.equals(typeArg) || supertypeArg instanceof WildcardType && TypeUtils.isAssignable((WildcardType)supertypeArg, typeArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType supertype, Type type) {
        for (Type upperBound : supertype.getUpperBounds()) {
            if (TypeUtils.isAssignable(upperBound, type)) continue;
            return false;
        }
        for (Type lowerBound : supertype.getLowerBounds()) {
            if (TypeUtils.isAssignable(type, lowerBound)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Type supertype, Class<?> type) {
        Type genericSuperclass = type.getGenericSuperclass();
        if (genericSuperclass != null && TypeUtils.isAssignable(supertype, genericSuperclass)) {
            return true;
        }
        for (Type interphace : type.getGenericInterfaces()) {
            if (!TypeUtils.isAssignable(supertype, interphace)) continue;
            return true;
        }
        return false;
    }
}

