/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.GroupDefinitionException;
import javax.validation.groups.Default;
import org.hibernate.validation.engine.groups.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupChain {
    private List<Group> groupList = new ArrayList<Group>();
    private Map<Class<?>, List<Group>> sequenceMap = new HashMap();

    public Iterator<Group> getGroupIterator() {
        return this.groupList.iterator();
    }

    public Iterator<List<Group>> getSequenceIterator() {
        return this.sequenceMap.values().iterator();
    }

    public Iterator<Group> getAllGroupsUnordered() {
        HashSet<Group> allGroups = new HashSet<Group>();
        allGroups.addAll(this.groupList);
        for (List<Group> sequenceList : this.sequenceMap.values()) {
            allGroups.addAll(sequenceList);
        }
        return allGroups.iterator();
    }

    public boolean containsSequence(Class<?> groupSequence) {
        return this.sequenceMap.containsKey(groupSequence);
    }

    void insertGroup(Group group) {
        if (!this.groupList.contains(group)) {
            this.groupList.add(group);
        }
    }

    void insertSequence(List<Group> groups) {
        if (groups == null || groups.size() == 0) {
            return;
        }
        if (!this.sequenceMap.containsValue(groups)) {
            this.sequenceMap.put(groups.get(0).getSequence(), groups);
        }
    }

    public String toString() {
        return "GroupChain{groupList=" + this.groupList + ", sequenceMap=" + this.sequenceMap + '}';
    }

    public void assertDefaulGroupSequenceIsExpandable(List<Class<?>> defaultGroupSequence) {
        for (Map.Entry<Class<?>, List<Group>> entry : this.sequenceMap.entrySet()) {
            Class<?> sequence = entry.getKey();
            List<Group> groupList = entry.getValue();
            List<Group> defaultGroupList = this.buildTempGroupList(defaultGroupSequence, sequence);
            int defaultGroupIndex = this.containsDefaultGroupAtIndex(sequence, groupList);
            if (defaultGroupIndex == -1) continue;
            this.ensureDefaultGroupSequenceIsExpandable(groupList, defaultGroupList, defaultGroupIndex);
        }
    }

    private void ensureDefaultGroupSequenceIsExpandable(List<Group> groupList, List<Group> defaultGroupList, int defaultGroupIndex) {
        for (int i = 0; i < defaultGroupList.size(); ++i) {
            int index;
            Group group = defaultGroupList.get(i);
            if (group.getGroup().equals(Default.class) || (index = groupList.indexOf(group)) == -1 || i == 0 && index == defaultGroupIndex - 1 || i == defaultGroupList.size() - 1 && index == defaultGroupIndex + 1) continue;
            throw new GroupDefinitionException("Unable to expand default group list" + defaultGroupList + " into sequence " + groupList);
        }
    }

    private int containsDefaultGroupAtIndex(Class<?> sequence, List<Group> groupList) {
        Group defaultGroup = new Group(Default.class, sequence);
        return groupList.indexOf(defaultGroup);
    }

    private List<Group> buildTempGroupList(List<Class<?>> defaultGroupSequence, Class<?> sequence) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (Class<?> clazz : defaultGroupSequence) {
            Group g = new Group(clazz, sequence);
            groupList.add(g);
        }
        return groupList;
    }
}

