/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.constraints.impl;

import java.util.Map;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import javax.validation.constraints.Size;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizeValidatorForMap
implements ConstraintValidator<Size, Map> {
    private int min;
    private int max;

    public void initialize(Size parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.validateParameters();
    }

    public boolean isValid(Map map, ConstraintValidatorContext constraintValidatorContext) {
        if (map == null) {
            return true;
        }
        int size = map.size();
        return size >= this.min && size <= this.max;
    }

    private void validateParameters() {
        if (this.min < 0) {
            throw new ValidationException("The min parameter cannot be negative.");
        }
        if (this.max < 0) {
            throw new ValidationException("The max paramter cannot be negative.");
        }
        if (this.max < this.min) {
            throw new ValidationException("The length cannot be negative.");
        }
    }
}

