/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.engine;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validator.engine.ResourceBundleMessageInterpolator;
import org.hibernate.validator.engine.ValidatorConfiguration;
import org.hibernate.validator.engine.resolver.DefaultTraversableResolver;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.Version;
import org.hibernate.validator.xml.ValidationBootstrapParameters;
import org.hibernate.validator.xml.ValidationXmlParser;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements ValidatorConfiguration,
ConfigurationState {
    private static final Logger log;
    private final MessageInterpolator defaultMessageInterpolator = new ResourceBundleMessageInterpolator();
    private final TraversableResolver defaultTraversableResolver = new DefaultTraversableResolver();
    private final ConstraintValidatorFactory defaultValidatorFactory = new ConstraintValidatorFactoryImpl();
    private final ValidationProviderResolver providerResolver;
    private ValidationBootstrapParameters validationBootstrapParameters;
    private boolean ignoreXmlConfiguration = false;

    public ConfigurationImpl(BootstrapState state) {
        this.providerResolver = state.getValidationProviderResolver() == null ? state.getDefaultValidationProviderResolver() : state.getValidationProviderResolver();
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
    }

    public ConfigurationImpl(ValidationProvider provider) {
        if (provider == null) {
            throw new ValidationException("Assertion error: inconsistent ConfigurationImpl construction");
        }
        this.providerResolver = null;
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        this.validationBootstrapParameters.provider = provider;
    }

    public ValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    public ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        this.validationBootstrapParameters.messageInterpolator = interpolator;
        return this;
    }

    public ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        this.validationBootstrapParameters.traversableResolver = resolver;
        return this;
    }

    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.validationBootstrapParameters.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public ValidatorConfiguration addMapping(InputStream stream) {
        this.validationBootstrapParameters.mappings.add(stream);
        return this;
    }

    public ValidatorConfiguration addProperty(String name, String value) {
        if (value != null) {
            this.validationBootstrapParameters.configProperties.put(name, value);
        }
        return this;
    }

    public ValidatorFactory buildValidatorFactory() {
        this.parseValidationXml();
        ValidatorFactory factory = null;
        if (this.isSpecificProvider()) {
            factory = this.validationBootstrapParameters.provider.buildValidatorFactory((ConfigurationState)this);
        } else {
            Class<ValidationProvider<?>> providerClass = this.validationBootstrapParameters.providerClass;
            if (providerClass != null) {
                for (ValidationProvider provider : this.providerResolver.getValidationProviders()) {
                    if (!providerClass.isAssignableFrom(provider.getClass())) continue;
                    factory = provider.buildValidatorFactory((ConfigurationState)this);
                    break;
                }
                if (factory == null) {
                    throw new ValidationException("Unable to find provider: " + providerClass);
                }
            } else {
                List providers = this.providerResolver.getValidationProviders();
                assert (providers.size() != 0);
                factory = ((ValidationProvider)providers.get(0)).buildValidatorFactory((ConfigurationState)this);
            }
        }
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        return factory;
    }

    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.validationBootstrapParameters.messageInterpolator;
    }

    public Set<InputStream> getMappingStreams() {
        return this.validationBootstrapParameters.mappings;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validationBootstrapParameters.constraintValidatorFactory;
    }

    public TraversableResolver getTraversableResolver() {
        return this.validationBootstrapParameters.traversableResolver;
    }

    public Map<String, String> getProperties() {
        return this.validationBootstrapParameters.configProperties;
    }

    public MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    private boolean isSpecificProvider() {
        return this.validationBootstrapParameters.provider != null;
    }

    private void parseValidationXml() {
        if (this.ignoreXmlConfiguration) {
            log.info("Ignoring XML configuration.");
            if (this.validationBootstrapParameters.messageInterpolator == null) {
                this.validationBootstrapParameters.messageInterpolator = this.defaultMessageInterpolator;
            }
            if (this.validationBootstrapParameters.traversableResolver == null) {
                this.validationBootstrapParameters.traversableResolver = this.defaultTraversableResolver;
            }
            if (this.validationBootstrapParameters.constraintValidatorFactory == null) {
                this.validationBootstrapParameters.constraintValidatorFactory = this.defaultValidatorFactory;
            }
        } else {
            ValidationBootstrapParameters xmlParameters = new ValidationXmlParser().parseValidationXml();
            this.applyXmlSettings(xmlParameters);
        }
    }

    private void applyXmlSettings(ValidationBootstrapParameters xmlParameters) {
        this.validationBootstrapParameters.providerClass = xmlParameters.providerClass;
        if (this.validationBootstrapParameters.messageInterpolator == null) {
            this.validationBootstrapParameters.messageInterpolator = xmlParameters.messageInterpolator != null ? xmlParameters.messageInterpolator : this.defaultMessageInterpolator;
        }
        if (this.validationBootstrapParameters.traversableResolver == null) {
            this.validationBootstrapParameters.traversableResolver = xmlParameters.traversableResolver != null ? xmlParameters.traversableResolver : this.defaultTraversableResolver;
        }
        if (this.validationBootstrapParameters.constraintValidatorFactory == null) {
            this.validationBootstrapParameters.constraintValidatorFactory = xmlParameters.constraintValidatorFactory != null ? xmlParameters.constraintValidatorFactory : this.defaultValidatorFactory;
        }
        this.validationBootstrapParameters.mappings.addAll(xmlParameters.mappings);
        for (Map.Entry<String, String> entry : xmlParameters.configProperties.entrySet()) {
            if (this.validationBootstrapParameters.configProperties.get(entry.getKey()) != null) continue;
            this.validationBootstrapParameters.configProperties.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

