/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.metadata;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.Valid;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.metadata.AnnotationIgnores;
import org.hibernate.validator.metadata.BeanDescriptorImpl;
import org.hibernate.validator.metadata.BeanMetaData;
import org.hibernate.validator.metadata.ConstraintDescriptorImpl;
import org.hibernate.validator.metadata.ConstraintHelper;
import org.hibernate.validator.metadata.MetaConstraint;
import org.hibernate.validator.metadata.PropertyDescriptorImpl;
import org.hibernate.validator.util.GetDeclaredFields;
import org.hibernate.validator.util.GetDeclaredMethods;
import org.hibernate.validator.util.LoggerFactory;
import org.hibernate.validator.util.ReflectionHelper;
import org.hibernate.validator.util.SetAccessibility;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanMetaDataImpl<T>
implements BeanMetaData<T> {
    private static final Logger log = LoggerFactory.make();
    private final Class<T> beanClass;
    private BeanDescriptorImpl<T> beanDescriptor;
    private Map<Class<?>, List<MetaConstraint<T, ? extends Annotation>>> metaConstraints = new HashMap();
    private List<Member> cascadedMembers = new ArrayList<Member>();
    private Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();
    private List<Class<?>> defaultGroupSequence = new ArrayList();
    private final ConstraintHelper constraintHelper;
    private final Set<String> propertyNames = new HashSet<String>(30);

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper) {
        this(beanClass, constraintHelper, new AnnotationIgnores());
    }

    public BeanMetaDataImpl(Class<T> beanClass, ConstraintHelper constraintHelper, AnnotationIgnores annotationIgnores) {
        this.beanClass = beanClass;
        this.constraintHelper = constraintHelper;
        this.createMetaData(annotationIgnores);
    }

    @Override
    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.beanDescriptor;
    }

    @Override
    public List<Member> getCascadedMembers() {
        return Collections.unmodifiableList(this.cascadedMembers);
    }

    @Override
    public Map<Class<?>, List<MetaConstraint<T, ? extends Annotation>>> getMetaConstraintsAsMap() {
        return Collections.unmodifiableMap(this.metaConstraints);
    }

    @Override
    public List<MetaConstraint<T, ? extends Annotation>> getMetaConstraintsAsList() {
        ArrayList<MetaConstraint<T, ? extends Annotation>> constraintList = new ArrayList<MetaConstraint<T, ? extends Annotation>>();
        for (List<MetaConstraint<T, ? extends Annotation>> list : this.metaConstraints.values()) {
            constraintList.addAll(list);
        }
        return Collections.unmodifiableList(constraintList);
    }

    public void addMetaConstraint(Class<?> clazz, MetaConstraint<T, ? extends Annotation> metaConstraint) {
        List<Object> constraintList;
        if (!this.metaConstraints.containsKey(clazz)) {
            constraintList = new ArrayList();
            this.metaConstraints.put(clazz, constraintList);
        } else {
            constraintList = this.metaConstraints.get(clazz);
        }
        constraintList.add(metaConstraint);
        if (metaConstraint.getElementType() == ElementType.TYPE) {
            this.beanDescriptor.addConstraintDescriptor(metaConstraint.getDescriptor());
        } else {
            PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(metaConstraint.getPropertyName());
            if (propertyDescriptor == null) {
                Member member = metaConstraint.getMember();
                propertyDescriptor = this.addPropertyDescriptorForMember(member, this.isValidAnnotationPresent(member));
            }
            propertyDescriptor.addConstraintDescriptor(metaConstraint.getDescriptor());
        }
    }

    public void addCascadedMember(Member member) {
        this.cascadedMembers.add(member);
        this.addPropertyDescriptorForMember(member, true);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String property) {
        return this.propertyDescriptors.get(property);
    }

    @Override
    public boolean isPropertyPresent(String name) {
        return this.propertyNames.contains(name);
    }

    @Override
    public List<Class<?>> getDefaultGroupSequence() {
        return Collections.unmodifiableList(this.defaultGroupSequence);
    }

    @Override
    public boolean defaultGroupSequenceIsRedefined() {
        return this.defaultGroupSequence.size() > 1;
    }

    public void setDefaultGroupSequence(List<Class<?>> groupSequence) {
        this.defaultGroupSequence = new ArrayList();
        boolean groupSequenceContainsDefault = false;
        for (Class<?> group : groupSequence) {
            if (group.getName().equals(this.beanClass.getName())) {
                this.defaultGroupSequence.add(Default.class);
                groupSequenceContainsDefault = true;
                continue;
            }
            if (group.getName().equals(Default.class.getName())) {
                throw new GroupDefinitionException("'Default.class' cannot appear in default group sequence list.");
            }
            this.defaultGroupSequence.add(group);
        }
        if (!groupSequenceContainsDefault) {
            throw new GroupDefinitionException(this.beanClass.getName() + " must be part of the redefined default group sequence.");
        }
        if (log.isTraceEnabled()) {
            log.trace("Members of the default group sequence for bean {} are: {}", (Object)this.beanClass.getName(), this.defaultGroupSequence);
        }
    }

    @Override
    public Set<PropertyDescriptor> getConstrainedProperties() {
        return Collections.unmodifiableSet(new HashSet<PropertyDescriptor>(this.propertyDescriptors.values()));
    }

    private void createMetaData(AnnotationIgnores annotationIgnores) {
        this.beanDescriptor = new BeanDescriptorImpl(this);
        this.initDefaultGroupSequence();
        ArrayList classes = new ArrayList();
        ReflectionHelper.computeClassHierarchy(this.beanClass, classes);
        for (Class clazz : classes) {
            this.initClass(clazz, annotationIgnores);
        }
    }

    private void initClass(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        this.initClassConstraints(clazz, annotationIgnores);
        this.initMethodConstraints(clazz, annotationIgnores);
        this.initFieldConstraints(clazz, annotationIgnores);
    }

    private void initDefaultGroupSequence() {
        ArrayList groupSequence = new ArrayList();
        GroupSequence groupSequenceAnnotation = this.beanClass.getAnnotation(GroupSequence.class);
        if (groupSequenceAnnotation == null) {
            groupSequence.add(this.beanClass);
        } else {
            groupSequence.addAll(Arrays.asList(groupSequenceAnnotation.value()));
        }
        this.setDefaultGroupSequence(groupSequence);
    }

    private void initFieldConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        GetDeclaredFields action = GetDeclaredFields.action(clazz);
        Field[] fields = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers()) || annotationIgnores.isIgnoreAnnotations(field)) continue;
            String name = ReflectionHelper.getPropertyName(field);
            if (name != null) {
                this.propertyNames.add(name);
            }
            List<ConstraintDescriptorImpl<?>> fieldMetadata = this.findConstraints(field);
            for (ConstraintDescriptorImpl<?> constraintDescription : fieldMetadata) {
                this.setAccessibility(field);
                MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(field, constraintDescription);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            if (!field.isAnnotationPresent(Valid.class)) continue;
            this.setAccessibility(field);
            this.addCascadedMember(field);
        }
    }

    private void setAccessibility(Member member) {
        SetAccessibility action = SetAccessibility.action(member);
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
    }

    private void initMethodConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        GetDeclaredMethods action = GetDeclaredMethods.action(clazz);
        Method[] declaredMethods = System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
        for (Method method : declaredMethods) {
            if (Modifier.isStatic(method.getModifiers()) || annotationIgnores.isIgnoreAnnotations(method)) continue;
            String name = ReflectionHelper.getPropertyName(method);
            if (name != null) {
                this.propertyNames.add(name);
            }
            List<ConstraintDescriptorImpl<?>> methodMetadata = this.findConstraints(method);
            for (ConstraintDescriptorImpl<?> constraintDescription : methodMetadata) {
                this.setAccessibility(method);
                MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(method, constraintDescription);
                this.addMetaConstraint(clazz, metaConstraint);
            }
            if (!method.isAnnotationPresent(Valid.class)) continue;
            this.setAccessibility(method);
            this.addCascadedMember(method);
        }
    }

    private PropertyDescriptorImpl addPropertyDescriptorForMember(Member member, boolean isCascaded) {
        String name = ReflectionHelper.getPropertyName(member);
        PropertyDescriptorImpl propertyDescriptor = (PropertyDescriptorImpl)this.propertyDescriptors.get(name);
        if (propertyDescriptor == null) {
            propertyDescriptor = new PropertyDescriptorImpl(ReflectionHelper.getType(member), isCascaded, name);
            this.propertyDescriptors.put(name, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private boolean isValidAnnotationPresent(Member member) {
        return ((AnnotatedElement)((Object)member)).isAnnotationPresent(Valid.class);
    }

    private void initClassConstraints(Class<?> clazz, AnnotationIgnores annotationIgnores) {
        if (annotationIgnores.isIgnoreAnnotations(clazz)) {
            return;
        }
        List<ConstraintDescriptorImpl<?>> classMetadata = this.findClassLevelConstraints(clazz);
        for (ConstraintDescriptorImpl<?> constraintDescription : classMetadata) {
            MetaConstraint<T, ?> metaConstraint = this.createMetaConstraint(constraintDescription);
            this.addMetaConstraint(clazz, metaConstraint);
        }
    }

    private <A extends Annotation> MetaConstraint<T, ?> createMetaConstraint(ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<T, A>(this.beanClass, descriptor);
    }

    private <A extends Annotation> MetaConstraint<T, ?> createMetaConstraint(Member m, ConstraintDescriptorImpl<A> descriptor) {
        return new MetaConstraint<T, A>(m, this.beanClass, descriptor);
    }

    private <A extends Annotation> List<ConstraintDescriptorImpl<?>> findConstraintAnnotations(Class<?> clazz, A annotation) {
        ArrayList constraintDescriptors = new ArrayList();
        ArrayList<Annotation> constraints = new ArrayList<Annotation>();
        if (this.constraintHelper.isConstraintAnnotation(annotation) || this.constraintHelper.isBuiltinConstraint(annotation.annotationType())) {
            constraints.add(annotation);
        }
        constraints.addAll(this.constraintHelper.getMultiValueConstraints(annotation));
        for (Annotation constraint : constraints) {
            ConstraintDescriptorImpl constraintDescriptor = this.buildConstraintDescriptor(clazz, constraint);
            constraintDescriptors.add(constraintDescriptor);
        }
        return constraintDescriptors;
    }

    private <A extends Annotation> ConstraintDescriptorImpl buildConstraintDescriptor(Class<?> clazz, A annotation) {
        ConstraintDescriptorImpl<A> constraintDescriptor = clazz.isInterface() && !clazz.equals(this.beanClass) ? new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper, clazz) : new ConstraintDescriptorImpl<A>(annotation, this.constraintHelper);
        return constraintDescriptor;
    }

    private List<ConstraintDescriptorImpl<?>> findClassLevelConstraints(Class<?> beanClass) {
        ArrayList metadata = new ArrayList();
        for (Annotation annotation : beanClass.getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(beanClass, annotation));
        }
        return metadata;
    }

    private List<ConstraintDescriptorImpl<?>> findConstraints(Member member) {
        assert (member instanceof Field || member instanceof Method);
        ArrayList metadata = new ArrayList();
        for (Annotation annotation : ((AnnotatedElement)((Object)member)).getAnnotations()) {
            metadata.addAll(this.findConstraintAnnotations(member.getDeclaringClass(), annotation));
        }
        return metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BeanMetaDataImpl");
        sb.append("{beanClass=").append(this.beanClass);
        sb.append(", beanDescriptor=").append(this.beanDescriptor);
        sb.append(", metaConstraints=").append(this.metaConstraints);
        sb.append(", cascadedMembers=").append(this.cascadedMembers);
        sb.append(", propertyDescriptors=").append(this.propertyDescriptors);
        sb.append(", defaultGroupSequence=").append(this.defaultGroupSequence);
        sb.append(", constraintHelper=").append(this.constraintHelper);
        sb.append('}');
        return sb.toString();
    }
}

