/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.hibernate.validator.method.MethodConstraintViolation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodConstraintViolationImpl<T>
extends ConstraintViolationImpl<T>
implements MethodConstraintViolation<T> {
    private static final long serialVersionUID = 7907489574577836537L;
    private final Method method;
    private final Integer parameterIndex;
    private final String parameterName;
    private final MethodConstraintViolation.Kind kind;

    public MethodConstraintViolationImpl(String messageTemplate, String interpolatedMessage, Method method, Integer parameterIndex, String parameterName, Class<T> rootBeanClass, T rootBean, Object leafBeanInstance, Object value, Path propertyPath, ConstraintDescriptor<?> constraintDescriptor, ElementType elementType) {
        super(messageTemplate, interpolatedMessage, rootBeanClass, rootBean, leafBeanInstance, value, propertyPath, constraintDescriptor, elementType);
        this.method = method;
        this.parameterIndex = parameterIndex;
        this.parameterName = parameterName;
        this.kind = parameterIndex != null ? MethodConstraintViolation.Kind.PARAMETER : MethodConstraintViolation.Kind.RETURN_VALUE;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Integer getParameterIndex() {
        return this.parameterIndex;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public MethodConstraintViolation.Kind getKind() {
        return this.kind;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.parameterIndex == null ? 0 : this.parameterIndex.hashCode());
        result = 31 * result + (this.parameterName == null ? 0 : this.parameterName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodConstraintViolationImpl other = (MethodConstraintViolationImpl)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.parameterIndex == null ? other.parameterIndex != null : !this.parameterIndex.equals(other.parameterIndex)) {
            return false;
        }
        return !(this.parameterName == null ? other.parameterName != null : !this.parameterName.equals(other.parameterName));
    }

    @Override
    public String toString() {
        return "MethodConstraintViolationImpl [method=" + this.method + ", parameterIndex=" + this.parameterIndex + ", parameterName=" + this.parameterName + ", kind=" + (Object)((Object)this.kind) + ", message=" + this.getMessage() + ", messageTemplate=" + this.getMessageTemplate() + ", rootBean=" + this.getRootBean() + ", rootBeanClass=" + this.getRootBeanClass() + ", leafBean=" + this.getLeafBean() + ", invalidValue=" + this.getInvalidValue() + ", propertyPath=" + this.getPropertyPath() + ", constraintDescriptor=" + this.getConstraintDescriptor() + "]";
    }
}

