/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.groups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.validation.GroupSequence;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.engine.groups.GroupChain;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupChainGenerator {
    private static final Log log = LoggerFactory.make();
    private final ConcurrentMap<Class<?>, List<Group>> resolvedSequences = new ConcurrentHashMap();

    public GroupChain getGroupChainFor(Collection<Class<?>> groups) {
        if (groups == null || groups.size() == 0) {
            throw log.getAtLeastOneGroupHasToBeSpecifiedException();
        }
        for (Class<?> clazz : groups) {
            if (clazz.isInterface()) continue;
            throw log.getGroupHasToBeAnInterfaceException(clazz.getName());
        }
        GroupChain chain = new GroupChain();
        for (Class<?> clazz : groups) {
            if (this.isGroupSequence(clazz)) {
                this.insertSequence(clazz, chain);
                continue;
            }
            Group group = new Group(clazz);
            chain.insertGroup(group);
            this.insertInheritedGroups(clazz, chain);
        }
        return chain;
    }

    private boolean isGroupSequence(Class<?> clazz) {
        return clazz.getAnnotation(GroupSequence.class) != null;
    }

    private void insertInheritedGroups(Class<?> clazz, GroupChain chain) {
        for (Class<?> inheritedGroup : clazz.getInterfaces()) {
            Group group = new Group(inheritedGroup);
            chain.insertGroup(group);
            this.insertInheritedGroups(inheritedGroup, chain);
        }
    }

    private void insertSequence(Class<?> clazz, GroupChain chain) {
        List<Group> sequence = (List<Group>)this.resolvedSequences.get(clazz);
        if (sequence == null) {
            sequence = this.resolveSequence(clazz, new ArrayList());
            List<Group> cachedResolvedSequence = this.resolvedSequences.putIfAbsent(clazz, sequence = this.expandInheritedGroups(sequence));
            if (cachedResolvedSequence != null) {
                sequence = cachedResolvedSequence;
            }
        }
        chain.insertSequence(sequence);
    }

    private List<Group> expandInheritedGroups(List<Group> sequence) {
        ArrayList<Group> expandedGroup = new ArrayList<Group>();
        for (Group group : sequence) {
            expandedGroup.add(group);
            this.addInheritedGroups(group, expandedGroup);
        }
        return expandedGroup;
    }

    private void addInheritedGroups(Group group, List<Group> expandedGroups) {
        for (Class<?> inheritedGroup : group.getGroup().getInterfaces()) {
            if (this.isGroupSequence(inheritedGroup)) {
                throw log.getSequenceDefinitionsNotAllowedException();
            }
            Group g = new Group(inheritedGroup, group.getSequence());
            expandedGroups.add(g);
            this.addInheritedGroups(g, expandedGroups);
        }
    }

    private List<Group> resolveSequence(Class<?> group, List<Class<?>> processedSequences) {
        Class[] sequenceArray;
        if (processedSequences.contains(group)) {
            throw log.getCyclicDependencyInGroupsDefinitionException();
        }
        processedSequences.add(group);
        ArrayList<Group> resolvedGroupSequence = new ArrayList<Group>();
        GroupSequence sequenceAnnotation = group.getAnnotation(GroupSequence.class);
        for (Class clazz : sequenceArray = sequenceAnnotation.value()) {
            if (this.isGroupSequence(clazz)) {
                List<Group> tmpSequence = this.resolveSequence(clazz, processedSequences);
                this.addGroups(resolvedGroupSequence, tmpSequence);
                continue;
            }
            ArrayList<Group> list = new ArrayList<Group>();
            list.add(new Group(clazz, group));
            this.addGroups(resolvedGroupSequence, list);
        }
        return resolvedGroupSequence;
    }

    private void addGroups(List<Group> resolvedGroupSequence, List<Group> groups) {
        for (Group tmpGroup : groups) {
            if (resolvedGroupSequence.contains(tmpGroup) && resolvedGroupSequence.indexOf(tmpGroup) < resolvedGroupSequence.size() - 1) {
                throw log.getUnableToExpandGroupSequenceException();
            }
            resolvedGroupSequence.add(tmpGroup);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GroupChainGenerator");
        sb.append("{resolvedSequences=").append(this.resolvedSequences);
        sb.append('}');
        return sb.toString();
    }
}

