/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.group.DefaultGroupSequenceProvider;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaDataProviderImplBase
implements MetaDataProvider {
    protected static final String DEFAULT_PARAMETER_NAME_PREFIX = "arg";
    protected final Map<Class<?>, BeanConfiguration<?>> configuredBeans;
    protected final ConstraintHelper constraintHelper;

    public MetaDataProviderImplBase(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
        this.configuredBeans = CollectionHelper.newHashMap();
    }

    @Override
    public Set<BeanConfiguration<?>> getAllBeanConfigurations() {
        return new HashSet(this.configuredBeans.values());
    }

    @Override
    public Set<BeanConfiguration<?>> getBeanConfigurationForHierarchy(Class<?> beanClass) {
        HashSet<BeanConfiguration<?>> configurations = CollectionHelper.newHashSet();
        for (Class<?> oneHierarchyClass : ReflectionHelper.computeClassHierarchy(beanClass, true)) {
            BeanConfiguration<?> configuration = this.getBeanConfiguration(oneHierarchyClass);
            if (configuration == null) continue;
            configurations.add(configuration);
        }
        return configurations;
    }

    protected BeanConfiguration<?> getBeanConfiguration(Class<?> beanClass) {
        return this.configuredBeans.get(beanClass);
    }

    protected <T> BeanConfiguration<T> createBeanConfiguration(ConfigurationSource source, Class<T> beanClass, Set<? extends ConstrainedElement> constrainableElements, List<Class<?>> defaultGroupSequence, Class<? extends DefaultGroupSequenceProvider<?>> defaultGroupSequenceProvider) {
        return new BeanConfiguration<T>(source, beanClass, constrainableElements, defaultGroupSequence, defaultGroupSequenceProvider);
    }

    protected CollectionHelper.Partitioner<BeanConstraintLocation, ConfiguredConstraint<?, BeanConstraintLocation>> constraintsByLocation() {
        return new CollectionHelper.Partitioner<BeanConstraintLocation, ConfiguredConstraint<?, BeanConstraintLocation>>(){

            @Override
            public BeanConstraintLocation getPartition(ConfiguredConstraint<?, BeanConstraintLocation> constraint) {
                return constraint.getLocation();
            }
        };
    }
}

