/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.hibernate.validator.internal.cfg.context.ConfiguredConstraint;
import org.hibernate.validator.internal.cfg.context.ConstraintMappingContext;
import org.hibernate.validator.internal.metadata.core.AnnotationIgnores;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProviderImplBase;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgrammaticMappingMetaDataProvider
extends MetaDataProviderImplBase {
    private static final Log log = LoggerFactory.make();

    public ProgrammaticMappingMetaDataProvider(ConstraintHelper constraintHelper, Set<ConstraintMapping> programmaticMappings) {
        super(constraintHelper);
        Contracts.assertNotNull(programmaticMappings);
        ConstraintMappingContext mergedContext = this.createMergedMappingContext(programmaticMappings);
        this.initProgrammaticConfiguration(mergedContext);
    }

    @Override
    public AnnotationIgnores getAnnotationIgnores() {
        return null;
    }

    private void initProgrammaticConfiguration(ConstraintMappingContext context) {
        for (Class<?> clazz : context.getConfiguredClasses()) {
            Set<ConstrainedElement> constrainedElements = this.retrievePropertyMetaData(context.getConstraintConfig().get(clazz), context.getCascadeConfig().get(clazz));
            Set<ConstrainedElement> methodMetaData = this.retrieveMethodMetaData(context.getMethodCascadeConfig().get(clazz), context.getMethodConstraintConfig().get(clazz));
            constrainedElements.addAll(methodMetaData);
            this.configuredBeans.put(clazz, this.createBeanConfiguration(ConfigurationSource.API, clazz, constrainedElements, context.getDefaultSequence(clazz), context.getDefaultGroupSequenceProvider(clazz)));
        }
    }

    private Set<ConstrainedElement> retrievePropertyMetaData(Set<ConfiguredConstraint<?, BeanConstraintLocation>> constraints, Set<BeanConstraintLocation> cascades) {
        Map<BeanConstraintLocation, Set<ConfiguredConstraint<?, BeanConstraintLocation>>> constraintsByLocation = CollectionHelper.partition(constraints, this.constraintsByLocation());
        if (cascades == null) {
            cascades = Collections.emptySet();
        }
        HashSet<BeanConstraintLocation> allConfiguredProperties = new HashSet<BeanConstraintLocation>(cascades);
        allConfiguredProperties.addAll(constraintsByLocation.keySet());
        HashSet<ConstrainedElement> allPropertyMetaData = CollectionHelper.newHashSet();
        for (BeanConstraintLocation oneConfiguredProperty : allConfiguredProperties) {
            if (oneConfiguredProperty.getElementType() == ElementType.FIELD) {
                allPropertyMetaData.add(new ConstrainedField(ConfigurationSource.API, oneConfiguredProperty, this.asMetaConstraints(constraintsByLocation.get(oneConfiguredProperty)), cascades.contains(oneConfiguredProperty)));
                continue;
            }
            allPropertyMetaData.add(new ConstrainedType(ConfigurationSource.API, oneConfiguredProperty, this.asMetaConstraints(constraintsByLocation.get(oneConfiguredProperty))));
        }
        return allPropertyMetaData;
    }

    private Set<ConstrainedElement> retrieveMethodMetaData(Set<MethodConstraintLocation> methodCascades, Set<ConfiguredConstraint<?, MethodConstraintLocation>> methodConstraints) {
        Map<Method, Set<MethodConstraintLocation>> cascadesByMethod = CollectionHelper.partition(methodCascades, this.cascadesByMethod());
        Map<Method, Set<ConfiguredConstraint<?, MethodConstraintLocation>>> constraintsByMethod = CollectionHelper.partition(methodConstraints, this.constraintsByMethod());
        HashSet<Method> allConfiguredMethods = new HashSet<Method>(cascadesByMethod.keySet());
        allConfiguredMethods.addAll(constraintsByMethod.keySet());
        HashSet<ConstrainedElement> allMethodMetaData = CollectionHelper.newHashSet();
        for (Method oneMethod : allConfiguredMethods) {
            Map<Integer, Set<MethodConstraintLocation>> cascadesByParameter = CollectionHelper.partition(cascadesByMethod.get(oneMethod), this.cascadesByParameterIndex());
            Map<Integer, Set<ConfiguredConstraint<?, MethodConstraintLocation>>> constraintsByParameter = CollectionHelper.partition(constraintsByMethod.get(oneMethod), this.constraintsByParameterIndex());
            ArrayList<ConstrainedParameter> parameterMetaDataList = CollectionHelper.newArrayList();
            for (int i = 0; i < oneMethod.getParameterTypes().length; ++i) {
                parameterMetaDataList.add(new ConstrainedParameter(ConfigurationSource.API, new MethodConstraintLocation(oneMethod, i), "arg" + i, this.asMetaConstraints(constraintsByParameter.get(i)), cascadesByParameter.containsKey(i)));
            }
            ConstrainedMethod methodMetaData = new ConstrainedMethod(ConfigurationSource.API, new MethodConstraintLocation(oneMethod), parameterMetaDataList, this.asMetaConstraints(constraintsByParameter.get(null)), cascadesByParameter.containsKey(null));
            allMethodMetaData.add(methodMetaData);
        }
        return allMethodMetaData;
    }

    private Set<MetaConstraint<?>> asMetaConstraints(Set<? extends ConfiguredConstraint<?, ?>> constraints) {
        if (constraints == null) {
            return Collections.emptySet();
        }
        HashSet<MetaConstraint<?>> theValue = CollectionHelper.newHashSet();
        for (ConfiguredConstraint<?, ?> oneConfiguredConstraint : constraints) {
            theValue.add(this.asMetaConstraint(oneConfiguredConstraint));
        }
        return theValue;
    }

    private <A extends Annotation> MetaConstraint<A> asMetaConstraint(ConfiguredConstraint<A, ? extends ConstraintLocation> config) {
        ConstraintDescriptorImpl<A> constraintDescriptor = new ConstraintDescriptorImpl<A>(config.createAnnotationProxy(), this.constraintHelper, config.getLocation().getElementType(), ConstraintOrigin.DEFINED_LOCALLY);
        return new MetaConstraint<A>(constraintDescriptor, config.getLocation());
    }

    private CollectionHelper.Partitioner<Method, MethodConstraintLocation> cascadesByMethod() {
        return new CollectionHelper.Partitioner<Method, MethodConstraintLocation>(){

            @Override
            public Method getPartition(MethodConstraintLocation location) {
                return location.getMember();
            }
        };
    }

    private CollectionHelper.Partitioner<Integer, MethodConstraintLocation> cascadesByParameterIndex() {
        return new CollectionHelper.Partitioner<Integer, MethodConstraintLocation>(){

            @Override
            public Integer getPartition(MethodConstraintLocation location) {
                return location.getParameterIndex();
            }
        };
    }

    private CollectionHelper.Partitioner<Method, ConfiguredConstraint<?, MethodConstraintLocation>> constraintsByMethod() {
        return new CollectionHelper.Partitioner<Method, ConfiguredConstraint<?, MethodConstraintLocation>>(){

            @Override
            public Method getPartition(ConfiguredConstraint<?, MethodConstraintLocation> constraint) {
                return constraint.getLocation().getMember();
            }
        };
    }

    private CollectionHelper.Partitioner<Integer, ConfiguredConstraint<?, MethodConstraintLocation>> constraintsByParameterIndex() {
        return new CollectionHelper.Partitioner<Integer, ConfiguredConstraint<?, MethodConstraintLocation>>(){

            @Override
            public Integer getPartition(ConfiguredConstraint<?, MethodConstraintLocation> v) {
                return v.getLocation().getParameterIndex();
            }
        };
    }

    private ConstraintMappingContext createMergedMappingContext(Set<ConstraintMapping> programmaticMappings) {
        if (programmaticMappings.size() == 1) {
            return ConstraintMappingContext.getFromMapping(programmaticMappings.iterator().next());
        }
        ConstraintMappingContext mergedContext = new ConstraintMappingContext();
        for (ConstraintMapping mapping : programmaticMappings) {
            ConstraintMappingContext context = ConstraintMappingContext.getFromMapping(mapping);
            for (Set<ConfiguredConstraint<?, BeanConstraintLocation>> set : context.getConstraintConfig().values()) {
                for (ConfiguredConstraint<?, BeanConstraintLocation> configuredConstraint : set) {
                    mergedContext.addConstraintConfig(configuredConstraint);
                }
            }
            for (Set<Object> set : context.getCascadeConfig().values()) {
                for (BeanConstraintLocation beanConstraintLocation : set) {
                    mergedContext.addCascadeConfig(beanConstraintLocation);
                }
            }
            for (Set<Object> set : context.getMethodConstraintConfig().values()) {
                for (ConfiguredConstraint configuredConstraint : set) {
                    mergedContext.addMethodConstraintConfig(configuredConstraint);
                }
            }
            for (Set<Object> set : context.getMethodCascadeConfig().values()) {
                for (MethodConstraintLocation methodConstraintLocation : set) {
                    mergedContext.addMethodCascadeConfig(methodConstraintLocation);
                }
            }
            this.mergeGroupSequenceAndGroupSequenceProvider(mergedContext, context);
        }
        return mergedContext;
    }

    private void mergeGroupSequenceAndGroupSequenceProvider(ConstraintMappingContext mergedContext, ConstraintMappingContext context) {
        for (Class<?> clazz : context.getConfiguredClasses()) {
            if (context.getDefaultGroupSequenceProvider(clazz) != null) {
                if (mergedContext.getDefaultGroupSequenceProvider(clazz) != null) {
                    throw log.getMultipleDefinitionOfDefaultGroupSequenceProviderException();
                }
                mergedContext.addDefaultGroupSequenceProvider(clazz, context.getDefaultGroupSequenceProvider(clazz));
            }
            if (context.getDefaultSequence(clazz) == null) continue;
            if (mergedContext.getDefaultSequence(clazz) != null) {
                throw log.getMultipleDefinitionOfDefaultGroupSequenceException();
            }
            mergedContext.addDefaultGroupSequence(clazz, context.getDefaultSequence(clazz));
        }
    }
}

