/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.provider;

import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.AnnotationIgnores;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.provider.MetaDataProviderImplBase;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedMethod;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.xml.XmlMappingParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationMetaDataProvider
extends MetaDataProviderImplBase {
    private final AnnotationIgnores annotationIgnores;

    public XmlConfigurationMetaDataProvider(ConstraintHelper constraintHelper, Set<InputStream> mappingStreams) {
        super(constraintHelper);
        XmlMappingParser mappingParser = new XmlMappingParser(constraintHelper);
        mappingParser.parse(mappingStreams);
        for (Class<?> clazz : mappingParser.getXmlConfiguredClasses()) {
            Map<ConstraintLocation, Set<MetaConstraint<?>>> constraintsByLocation = CollectionHelper.partition(mappingParser.getConstraintsForClass(clazz), this.byLocation());
            Set<BeanConstraintLocation> cascades = this.getCascades(mappingParser, clazz);
            Set<ConstrainedElement> constrainedElements = this.getConstrainedElements(constraintsByLocation, cascades);
            this.configuredBeans.put(clazz, this.createBeanConfiguration(ConfigurationSource.XML, clazz, constrainedElements, mappingParser.getDefaultSequenceForClass(clazz), null));
        }
        this.annotationIgnores = mappingParser.getAnnotationIgnores();
    }

    private Set<ConstrainedElement> getConstrainedElements(Map<ConstraintLocation, Set<MetaConstraint<?>>> constraintsByLocation, Set<BeanConstraintLocation> cascades) {
        HashSet<BeanConstraintLocation> configuredLocations = new HashSet<BeanConstraintLocation>(cascades);
        configuredLocations.addAll(constraintsByLocation.keySet());
        HashSet<ConstrainedElement> propertyMetaData = CollectionHelper.newHashSet();
        for (ConstraintLocation constraintLocation : configuredLocations) {
            if (constraintLocation.getElementType() == ElementType.FIELD) {
                propertyMetaData.add(new ConstrainedField(ConfigurationSource.XML, (BeanConstraintLocation)constraintLocation, constraintsByLocation.get(constraintLocation), cascades.contains(constraintLocation)));
                continue;
            }
            if (constraintLocation.getElementType() == ElementType.METHOD) {
                propertyMetaData.add(new ConstrainedMethod(ConfigurationSource.XML, new MethodConstraintLocation((Method)constraintLocation.getMember()), constraintsByLocation.get(constraintLocation), cascades.contains(constraintLocation)));
                continue;
            }
            if (constraintLocation.getElementType() != ElementType.TYPE) continue;
            propertyMetaData.add(new ConstrainedType(ConfigurationSource.XML, (BeanConstraintLocation)constraintLocation, constraintsByLocation.get(constraintLocation)));
        }
        return propertyMetaData;
    }

    private Set<BeanConstraintLocation> getCascades(XmlMappingParser mappingParser, Class<?> clazz) {
        HashSet<BeanConstraintLocation> theValue = CollectionHelper.newHashSet();
        for (Member member : mappingParser.getCascadedMembersForClass(clazz)) {
            theValue.add(new BeanConstraintLocation(member));
        }
        return theValue;
    }

    @Override
    public AnnotationIgnores getAnnotationIgnores() {
        return this.annotationIgnores;
    }

    protected CollectionHelper.Partitioner<ConstraintLocation, MetaConstraint<?>> byLocation() {
        return new CollectionHelper.Partitioner<ConstraintLocation, MetaConstraint<?>>(){

            @Override
            public ConstraintLocation getPartition(MetaConstraint<?> constraint) {
                return constraint.getLocation();
            }
        };
    }
}

