/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModUtil {
    private ModUtil() {
    }

    public static boolean passesMod11Test(List<Integer> digits, int multiplier) {
        int modResult = ModUtil.mod11(digits, multiplier);
        return modResult == 0;
    }

    public static boolean passesMod10Test(List<Integer> digits, int multiplier) {
        int modResult = ModUtil.mod10(digits, multiplier);
        return modResult == 0;
    }

    private static int mod11(List<Integer> digits, int multiplier) {
        int sum = 0;
        int weight = 1;
        for (int index = digits.size() - 1; index >= 0; --index) {
            sum += digits.get(index) * weight++;
            if (weight <= multiplier) continue;
            weight = 2;
        }
        int mod = 11 - sum % 11;
        return mod > 9 ? 0 : mod;
    }

    private static int mod10(List<Integer> digits, int multiplier) {
        int sum = 0;
        boolean even = false;
        for (int index = digits.size() - 1; index >= 0; --index) {
            int digit = digits.get(index);
            if (even) {
                digit *= multiplier;
            }
            if (digit > 9) {
                digit = digit / 10 + digit % 10;
            }
            sum += digit;
            even = !even;
        }
        return sum % 10;
    }
}

