/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.scriptengine;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.scriptengine.ScriptEvaluator;

public class ScriptEvaluatorFactory {
    private static final Log log = LoggerFactory.make();
    private static Reference<ScriptEvaluatorFactory> INSTANCE = new SoftReference<ScriptEvaluatorFactory>(new ScriptEvaluatorFactory());
    private ConcurrentMap<String, ScriptEvaluator> scriptExecutorCache = new ConcurrentHashMap<String, ScriptEvaluator>();

    private ScriptEvaluatorFactory() {
    }

    public static synchronized ScriptEvaluatorFactory getInstance() {
        ScriptEvaluatorFactory theValue = INSTANCE.get();
        if (theValue == null) {
            theValue = new ScriptEvaluatorFactory();
            INSTANCE = new SoftReference<ScriptEvaluatorFactory>(theValue);
        }
        return theValue;
    }

    public ScriptEvaluator getScriptEvaluatorByLanguageName(String languageName) throws ScriptException {
        if (!this.scriptExecutorCache.containsKey(languageName)) {
            ScriptEvaluator scriptExecutor = this.createNewScriptEvaluator(languageName);
            this.scriptExecutorCache.putIfAbsent(languageName, scriptExecutor);
        }
        return (ScriptEvaluator)this.scriptExecutorCache.get(languageName);
    }

    private ScriptEvaluator createNewScriptEvaluator(String languageName) throws ScriptException {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName(languageName);
        if (engine == null) {
            throw new ScriptException(Messages.MESSAGES.unableToFindScriptEngine(languageName));
        }
        return new ScriptEvaluator(engine);
    }
}

