/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationInvocationHandler
implements InvocationHandler {
    private final Object wrapped;
    private final MethodValidator validator;
    private final Integer parameterIndex;
    private final Class<?>[] groups;

    public ValidationInvocationHandler(Object wrapped, MethodValidator validator, Class<?> ... groups) {
        this(wrapped, validator, (Integer)null, groups);
    }

    public ValidationInvocationHandler(Object wrapped, MethodValidator validator, Integer parameterIndex, Class<?> ... groups) {
        this.wrapped = wrapped;
        this.validator = validator;
        this.parameterIndex = parameterIndex;
        this.groups = groups;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Set constraintViolations = this.parameterIndex != null ? this.validator.validateParameter(this.wrapped, method, args[this.parameterIndex], this.parameterIndex.intValue(), (Class[])this.groups) : this.validator.validateAllParameters(this.wrapped, method, args, (Class[])this.groups);
        if (!constraintViolations.isEmpty()) {
            throw new MethodConstraintViolationException(constraintViolations);
        }
        Object result = method.invoke(this.wrapped, args);
        constraintViolations = this.validator.validateReturnValue(this.wrapped, method, result, (Class[])this.groups);
        if (!constraintViolations.isEmpty()) {
            throw new MethodConstraintViolationException(constraintViolations);
        }
        return result;
    }

    public Object getWrapped() {
        return this.wrapped;
    }
}

