/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.validator.internal.metadata.aggregated.ConstraintMetaData;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.ConstraintOrigin;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaDataBuilder {
    protected final ConstraintHelper constraintHelper;

    protected MetaDataBuilder(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
    }

    public abstract boolean accepts(ConstrainedElement var1);

    public abstract void add(ConstrainedElement var1);

    public abstract ConstraintMetaData build();

    protected Set<MetaConstraint<?>> adaptOriginsAndImplicitGroups(Class<?> beanClass, Set<MetaConstraint<?>> constraints) {
        HashSet<MetaConstraint<?>> adaptedConstraints = CollectionHelper.newHashSet();
        for (MetaConstraint<?> oneConstraint : constraints) {
            adaptedConstraints.add(this.adaptOriginAndImplicitGroup(beanClass, oneConstraint));
        }
        return adaptedConstraints;
    }

    private <A extends Annotation> MetaConstraint<A> adaptOriginAndImplicitGroup(Class<?> beanClass, MetaConstraint<A> constraint) {
        ConstraintOrigin definedIn = this.definedIn(beanClass, constraint.getLocation().getBeanClass());
        if (definedIn == ConstraintOrigin.DEFINED_LOCALLY) {
            return constraint;
        }
        Class<?> constraintClass = constraint.getLocation().getBeanClass();
        ConstraintDescriptorImpl<A> descriptor = new ConstraintDescriptorImpl<A>(constraint.getDescriptor().getAnnotation(), this.constraintHelper, constraintClass.isInterface() ? constraintClass : null, constraint.getElementType(), definedIn);
        return new MetaConstraint<A>(descriptor, constraint.getLocation());
    }

    private ConstraintOrigin definedIn(Class<?> rootClass, Class<?> hierarchyClass) {
        if (hierarchyClass.equals(rootClass)) {
            return ConstraintOrigin.DEFINED_LOCALLY;
        }
        return ConstraintOrigin.DEFINED_IN_HIERARCHY;
    }
}

