/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.hibernate.validator.internal.util.LRUMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftLimitMRUCache<K, V>
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    public static final int DEFAULT_SOFT_REF_COUNT = 2048;
    private final int strongRefCount;
    private final int softRefCount;
    private transient LRUMap<K, V> strongRefCache;
    private transient LRUMap<K, SoftReference<V>> softRefCache;
    private transient ReferenceQueue<V> referenceQueue;

    public SoftLimitMRUCache() {
        this(128, 2048);
    }

    public SoftLimitMRUCache(int strongRefCount, int softRefCount) {
        if (strongRefCount < 1 || softRefCount < 1) {
            throw new IllegalArgumentException("Reference counts must be greater than zero");
        }
        if (strongRefCount > softRefCount) {
            throw new IllegalArgumentException("Strong reference count cannot exceed soft reference count");
        }
        this.strongRefCount = strongRefCount;
        this.softRefCount = softRefCount;
        this.init();
    }

    public synchronized V get(K key) {
        Object refValue;
        if (key == null) {
            throw new IllegalArgumentException("Key to get cannot be null");
        }
        this.clearObsoleteReferences();
        SoftReference ref = (SoftReference)this.softRefCache.get(key);
        if (ref != null && (refValue = ref.get()) != null) {
            this.strongRefCache.put(key, refValue);
            return (V)refValue;
        }
        return null;
    }

    public synchronized V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException(this.getClass().getName() + "does not support null key [" + key + "] or value [" + value + "]");
        }
        this.clearObsoleteReferences();
        this.strongRefCache.put(key, value);
        SoftReference ref = this.softRefCache.put(key, new KeyedSoftReference(key, value, this.referenceQueue));
        return ref != null ? (V)ref.get() : null;
    }

    public synchronized int size() {
        this.clearObsoleteReferences();
        return this.strongRefCache.size();
    }

    public synchronized int softSize() {
        this.clearObsoleteReferences();
        return this.softRefCache.size();
    }

    public synchronized void clear() {
        this.strongRefCache.clear();
        this.softRefCache.clear();
    }

    private void init() {
        this.strongRefCache = new LRUMap(this.strongRefCount);
        this.softRefCache = new LRUMap(this.softRefCount);
        this.referenceQueue = new ReferenceQueue();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private void clearObsoleteReferences() {
        KeyedSoftReference obsoleteRef;
        while ((obsoleteRef = (KeyedSoftReference)this.referenceQueue.poll()) != null) {
            Object key = obsoleteRef.getKey();
            this.softRefCache.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyedSoftReference<K, V>
    extends SoftReference<V> {
        private final K key;

        private KeyedSoftReference(K key, V value, ReferenceQueue<V> q) {
            super(value, q);
            this.key = key;
        }

        private K getKey() {
            return this.key;
        }
    }
}

