/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine;

import java.lang.annotation.ElementType;
import java.lang.reflect.Type;
import javax.validation.groups.Default;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.facets.Validatable;

public class ValueContext<T, V> {
    private final T currentBean;
    private final Class<T> currentBeanType;
    private PathImpl propertyPath;
    private Class<?> currentGroup;
    private V currentValue;
    private final Validatable currentValidatable;
    private ElementType elementType;
    private Type typeOfAnnotatedElement;

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(T value, Validatable validatable, PathImpl propertyPath) {
        Class<?> rootBeanClass = value.getClass();
        return new ValueContext<T, V>(value, rootBeanClass, validatable, propertyPath);
    }

    public static <T, V> ValueContext<T, V> getLocalExecutionContext(Class<T> type, Validatable validatable, PathImpl propertyPath) {
        return new ValueContext<Object, V>(null, type, validatable, propertyPath);
    }

    protected ValueContext(T currentBean, Class<T> currentBeanType, Validatable validatable, PathImpl propertyPath) {
        this.currentBean = currentBean;
        this.currentBeanType = currentBeanType;
        this.currentValidatable = validatable;
        this.propertyPath = propertyPath;
    }

    public final PathImpl getPropertyPath() {
        return this.propertyPath;
    }

    public final Class<?> getCurrentGroup() {
        return this.currentGroup;
    }

    public final T getCurrentBean() {
        return this.currentBean;
    }

    public final Class<T> getCurrentBeanType() {
        return this.currentBeanType;
    }

    public Validatable getCurrentValidatable() {
        return this.currentValidatable;
    }

    public final V getCurrentValidatedValue() {
        return this.currentValue;
    }

    public final void setPropertyPath(PathImpl propertyPath) {
        this.propertyPath = propertyPath;
    }

    public final void appendNode(Cascadable node) {
        this.propertyPath = PathImpl.createCopy(this.propertyPath);
        this.propertyPath.addNode(node.getName(), node.getDescriptor());
    }

    public final void appendNode(BeanMetaData<?> node) {
        this.propertyPath = PathImpl.createCopy(this.propertyPath);
        this.propertyPath.addNode(null, node.getDescriptor());
    }

    public final void markCurrentPropertyAsIterable() {
        this.propertyPath.makeLeafNodeIterable();
    }

    public final void setKey(Object key) {
        this.propertyPath.setLeafNodeMapKey(key);
    }

    public final void setIndex(Integer index) {
        this.propertyPath.setLeafNodeIndex(index);
    }

    public final void setCurrentGroup(Class<?> currentGroup) {
        this.currentGroup = currentGroup;
    }

    public final void setCurrentValidatedValue(V currentValue) {
        this.currentValue = currentValue;
    }

    public final boolean validatingDefault() {
        return this.getCurrentGroup() != null && this.getCurrentGroup().getName().equals(Default.class.getName());
    }

    public final ElementType getElementType() {
        return this.elementType;
    }

    public final void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public final Type getTypeOfAnnotatedElement() {
        return this.typeOfAnnotatedElement;
    }

    public final void setTypeOfAnnotatedElement(Type typeOfAnnotatedElement) {
        this.typeOfAnnotatedElement = typeOfAnnotatedElement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueContext");
        sb.append("{currentBean=").append(this.currentBean);
        sb.append(", currentBeanType=").append(this.currentBeanType);
        sb.append(", propertyPath=").append(this.propertyPath);
        sb.append(", currentGroup=").append(this.currentGroup);
        sb.append(", currentValue=").append(this.currentValue);
        sb.append(", elementType=").append((Object)this.elementType);
        sb.append(", typeOfAnnotatedElement=").append(this.typeOfAnnotatedElement);
        sb.append('}');
        return sb.toString();
    }
}

