/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import com.fasterxml.classmate.Filter;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;

public abstract class ExecutableElement {
    private static TypeResolver typeResolver = new TypeResolver();

    public static ExecutableElement forConstructor(Constructor<?> constructor) {
        return new ConstructorElement(constructor);
    }

    public static List<ExecutableElement> forConstructors(Constructor<?>[] constructors) {
        ArrayList<ExecutableElement> executableElements = CollectionHelper.newArrayList(constructors.length);
        for (Constructor<?> constructor : constructors) {
            executableElements.add(ExecutableElement.forConstructor(constructor));
        }
        return executableElements;
    }

    public static ExecutableElement forMethod(Method method) {
        return new MethodElement(method);
    }

    public static List<ExecutableElement> forMethods(Method[] methods) {
        ArrayList<ExecutableElement> executableElements = CollectionHelper.newArrayList(methods.length);
        for (Method method : methods) {
            executableElements.add(ExecutableElement.forMethod(method));
        }
        return executableElements;
    }

    private ExecutableElement() {
    }

    public abstract String[] getParameterNames(ParameterNameProvider var1);

    public abstract Annotation[][] getParameterAnnotations();

    public abstract Class<?>[] getParameterTypes();

    public abstract Class<?> getReturnType();

    public abstract Type[] getGenericParameterTypes();

    public abstract AccessibleObject getAccessibleObject();

    public abstract Member getMember();

    public abstract ElementType getElementType();

    public abstract String getSimpleName();

    public abstract boolean isGetterMethod();

    public String getIdentifier() {
        return this.getSimpleName() + Arrays.toString(this.getParameterTypes());
    }

    public boolean overrides(ExecutableElement other) {
        Contracts.assertValueNotNull(other, "other");
        if (!this.getMember().getName().equals(other.getMember().getName())) {
            return false;
        }
        if (this.getParameterTypes().length != other.getParameterTypes().length) {
            return false;
        }
        if (!other.getMember().getDeclaringClass().isAssignableFrom(this.getMember().getDeclaringClass())) {
            return false;
        }
        if (this.getMember() instanceof Constructor || other.getMember() instanceof Constructor) {
            return false;
        }
        return this.parametersResolveToSameTypes((Method)this.getMember(), (Method)other.getMember());
    }

    private boolean parametersResolveToSameTypes(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod.getParameterTypes().length == 0) {
            return true;
        }
        ResolvedType resolvedSubType = typeResolver.resolve(subTypeMethod.getDeclaringClass(), new Type[0]);
        MemberResolver memberResolver = new MemberResolver(typeResolver);
        memberResolver.setMethodFilter((Filter)new SimpleMethodFilter(subTypeMethod, superTypeMethod));
        ResolvedTypeWithMembers typeWithMembers = memberResolver.resolve(resolvedSubType, null, null);
        ResolvedMethod[] resolvedMethods = typeWithMembers.getMemberMethods();
        if (resolvedMethods.length == 1) {
            return true;
        }
        for (int i = 0; i < resolvedMethods[0].getArgumentCount(); ++i) {
            if (resolvedMethods[0].getArgumentType(i).equals((Object)resolvedMethods[1].getArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    private static class SimpleMethodFilter
    implements Filter<RawMethod> {
        private final Method method1;
        private final Method method2;

        private SimpleMethodFilter(Method method1, Method method2) {
            this.method1 = method1;
            this.method2 = method2;
        }

        public boolean include(RawMethod element) {
            return element.getRawMember().equals(this.method1) || element.getRawMember().equals(this.method2);
        }
    }

    private static class MethodElement
    extends ExecutableElement {
        private final Method method;

        public MethodElement(Method method) {
            this.method = method;
        }

        @Override
        public String[] getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames(this.method);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.method;
        }

        @Override
        public Member getMember() {
            return this.method;
        }

        @Override
        public ElementType getElementType() {
            return ElementType.METHOD;
        }

        @Override
        public String getSimpleName() {
            return this.method.getName();
        }

        @Override
        public boolean isGetterMethod() {
            return ReflectionHelper.isGetterMethod(this.method);
        }

        public String toString() {
            return this.method.toGenericString();
        }
    }

    private static class ConstructorElement
    extends ExecutableElement {
        private final Constructor<?> constructor;

        private ConstructorElement(Constructor<?> method) {
            this.constructor = method;
        }

        @Override
        public String[] getParameterNames(ParameterNameProvider parameterNameProvider) {
            return parameterNameProvider.getParameterNames(this.constructor);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            int parameterCount;
            Annotation[][] parameterAnnotations = this.constructor.getParameterAnnotations();
            if (parameterAnnotations.length == (parameterCount = this.constructor.getParameterTypes().length)) {
                return parameterAnnotations;
            }
            return this.paddedLeft((T[])parameterAnnotations, (T[])new Annotation[parameterCount][], (Object)new Annotation[0]);
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.constructor.getParameterTypes();
        }

        @Override
        public Class<?> getReturnType() {
            return this.constructor.getDeclaringClass();
        }

        @Override
        public Type[] getGenericParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        public AccessibleObject getAccessibleObject() {
            return this.constructor;
        }

        @Override
        public Member getMember() {
            return this.constructor;
        }

        @Override
        public ElementType getElementType() {
            return ElementType.CONSTRUCTOR;
        }

        @Override
        public String getSimpleName() {
            return this.constructor.getDeclaringClass().getSimpleName();
        }

        @Override
        public boolean isGetterMethod() {
            return false;
        }

        public String toString() {
            return this.constructor.toGenericString();
        }

        private <T> T[] paddedLeft(T[] src, T[] dest, T fillElement) {
            int originalCount = src.length;
            int targetCount = dest.length;
            System.arraycopy(src, 0, dest, targetCount - originalCount, originalCount);
            Arrays.fill(dest, 0, targetCount - originalCount, fillElement);
            return dest;
        }
    }
}

