/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.validation.Constraint;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.validation.constraintvalidation.SupportedValidationTarget;
import javax.validation.constraintvalidation.ValidationTarget;
import org.hibernate.validator.constraints.ConstraintComposition;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ModCheck;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.internal.constraintvalidators.AssertFalseValidator;
import org.hibernate.validator.internal.constraintvalidators.AssertTrueValidator;
import org.hibernate.validator.internal.constraintvalidators.DecimalMaxValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.DecimalMaxValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.DecimalMinValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.DecimalMinValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.DigitsValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.DigitsValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.EmailValidator;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForCalendar;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForDate;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForReadableInstant;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForReadablePartial;
import org.hibernate.validator.internal.constraintvalidators.LengthValidator;
import org.hibernate.validator.internal.constraintvalidators.MaxValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.MaxValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.MinValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.MinValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.ModCheckValidator;
import org.hibernate.validator.internal.constraintvalidators.NotBlankValidator;
import org.hibernate.validator.internal.constraintvalidators.NotNullValidator;
import org.hibernate.validator.internal.constraintvalidators.NullValidator;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForCalendar;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForDate;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForReadableInstant;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForReadablePartial;
import org.hibernate.validator.internal.constraintvalidators.PatternValidator;
import org.hibernate.validator.internal.constraintvalidators.SafeHtmlValidator;
import org.hibernate.validator.internal.constraintvalidators.ScriptAssertValidator;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArray;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfBoolean;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfByte;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfChar;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfDouble;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfFloat;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfInt;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfLong;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForCollection;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForMap;
import org.hibernate.validator.internal.constraintvalidators.URLValidator;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;

public class ConstraintHelper {
    public static final String GROUPS = "groups";
    public static final String PAYLOAD = "payload";
    public static final String MESSAGE = "message";
    public static final String VALIDATION_APPLIES_TO = "validationAppliesTo";
    private static final Log log = LoggerFactory.make();
    private static final String JODA_TIME_CLASS_NAME = "org.joda.time.ReadableInstant";
    private final ConcurrentMap<Class<? extends Annotation>, List<? extends Class<?>>> builtinConstraints = CollectionHelper.newConcurrentHashMap();
    private final ValidatorClassMap validatorClasses = new ValidatorClassMap();

    public ConstraintHelper() {
        ArrayList constraintList = CollectionHelper.newArrayList();
        constraintList.add(AssertFalseValidator.class);
        this.builtinConstraints.put(AssertFalse.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(AssertTrueValidator.class);
        this.builtinConstraints.put(AssertTrue.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(DecimalMaxValidatorForNumber.class);
        constraintList.add(DecimalMaxValidatorForCharSequence.class);
        this.builtinConstraints.put(DecimalMax.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(DecimalMinValidatorForNumber.class);
        constraintList.add(DecimalMinValidatorForCharSequence.class);
        this.builtinConstraints.put(DecimalMin.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(DigitsValidatorForCharSequence.class);
        constraintList.add(DigitsValidatorForNumber.class);
        this.builtinConstraints.put(Digits.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(FutureValidatorForCalendar.class);
        constraintList.add(FutureValidatorForDate.class);
        if (this.isJodaTimeInClasspath()) {
            constraintList.add(FutureValidatorForReadableInstant.class);
            constraintList.add(FutureValidatorForReadablePartial.class);
        }
        this.builtinConstraints.put(Future.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(MaxValidatorForNumber.class);
        constraintList.add(MaxValidatorForCharSequence.class);
        this.builtinConstraints.put(Max.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(MinValidatorForNumber.class);
        constraintList.add(MinValidatorForCharSequence.class);
        this.builtinConstraints.put(Min.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(NotNullValidator.class);
        this.builtinConstraints.put(NotNull.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(NullValidator.class);
        this.builtinConstraints.put(Null.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(PastValidatorForCalendar.class);
        constraintList.add(PastValidatorForDate.class);
        if (this.isJodaTimeInClasspath()) {
            constraintList.add(PastValidatorForReadableInstant.class);
            constraintList.add(PastValidatorForReadablePartial.class);
        }
        this.builtinConstraints.put(Past.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(PatternValidator.class);
        this.builtinConstraints.put(Pattern.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(SizeValidatorForCharSequence.class);
        constraintList.add(SizeValidatorForCollection.class);
        constraintList.add(SizeValidatorForArray.class);
        constraintList.add(SizeValidatorForMap.class);
        constraintList.add(SizeValidatorForArraysOfBoolean.class);
        constraintList.add(SizeValidatorForArraysOfByte.class);
        constraintList.add(SizeValidatorForArraysOfChar.class);
        constraintList.add(SizeValidatorForArraysOfDouble.class);
        constraintList.add(SizeValidatorForArraysOfFloat.class);
        constraintList.add(SizeValidatorForArraysOfInt.class);
        constraintList.add(SizeValidatorForArraysOfLong.class);
        this.builtinConstraints.put(Size.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(EmailValidator.class);
        this.builtinConstraints.put(Email.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(LengthValidator.class);
        this.builtinConstraints.put(Length.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(ModCheckValidator.class);
        this.builtinConstraints.put(ModCheck.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(NotBlankValidator.class);
        this.builtinConstraints.put(NotBlank.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(SafeHtmlValidator.class);
        this.builtinConstraints.put(SafeHtml.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(ScriptAssertValidator.class);
        this.builtinConstraints.put(ScriptAssert.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(URLValidator.class);
        this.builtinConstraints.put(URL.class, constraintList);
    }

    private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> getBuiltInConstraints(Class<A> annotationClass) {
        List builtInList = (List)this.builtinConstraints.get(annotationClass);
        if (builtInList == null || builtInList.size() == 0) {
            throw log.getUnableToFindAnnotationConstraintsException(annotationClass);
        }
        return builtInList;
    }

    private boolean isBuiltinConstraint(Class<? extends Annotation> annotationType) {
        return this.builtinConstraints.containsKey(annotationType);
    }

    public <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> getAllValidatorClasses(Class<A> annotationType) {
        List cachedValidatorClasses;
        Contracts.assertNotNull(annotationType, Messages.MESSAGES.classCannotBeNull());
        List classes = this.validatorClasses.get(annotationType);
        if (classes == null && (cachedValidatorClasses = this.validatorClasses.putIfAbsent(annotationType, classes = this.getDefaultValidatorClasses(annotationType))) != null) {
            classes = cachedValidatorClasses;
        }
        return Collections.unmodifiableList(classes);
    }

    public <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> findValidatorClasses(Class<A> annotationType, ValidationTarget validationTarget) {
        List<Class<ConstraintValidator<A, ?>>> validatorClasses = this.getAllValidatorClasses(annotationType);
        ArrayList<Class<ConstraintValidator<A, ?>>> matchingValidatorClasses = CollectionHelper.newArrayList();
        for (Class<ConstraintValidator<A, ?>> validatorClass : validatorClasses) {
            if (!this.supportsValidationTarget(validatorClass, validationTarget)) continue;
            matchingValidatorClasses.add(validatorClass);
        }
        return matchingValidatorClasses;
    }

    private boolean supportsValidationTarget(Class<? extends ConstraintValidator<?, ?>> validatorClass, ValidationTarget target) {
        SupportedValidationTarget supportedTargetAnnotation = validatorClass.getAnnotation(SupportedValidationTarget.class);
        if (supportedTargetAnnotation == null) {
            return target == ValidationTarget.ANNOTATED_ELEMENT;
        }
        return Arrays.asList(supportedTargetAnnotation.value()).contains(target);
    }

    public <A extends Annotation> void putValidatorClasses(Class<A> annotationType, List<Class<? extends ConstraintValidator<A, ?>>> definitionClasses, boolean keepDefaultClasses) {
        if (keepDefaultClasses) {
            definitionClasses.addAll(this.getDefaultValidatorClasses(annotationType));
        }
        this.validatorClasses.put(annotationType, definitionClasses);
    }

    public boolean isMultiValueConstraint(Class<? extends Annotation> annotationType) {
        Class<?> returnType;
        boolean isMultiValueConstraint = false;
        Method method = ReflectionHelper.getMethod(annotationType, "value");
        if (method != null && (returnType = method.getReturnType()).isArray() && returnType.getComponentType().isAnnotation()) {
            Class<?> componentType = returnType.getComponentType();
            isMultiValueConstraint = this.isConstraintAnnotation(componentType) || this.isBuiltinConstraint(componentType);
        }
        return isMultiValueConstraint;
    }

    public <A extends Annotation> List<Annotation> getMultiValueConstraints(A annotation) {
        ArrayList<Annotation> annotationList = CollectionHelper.newArrayList();
        try {
            Class<?> returnType;
            Method method = ReflectionHelper.getMethod(annotation.getClass(), "value");
            if (method != null && (returnType = method.getReturnType()).isArray() && returnType.getComponentType().isAnnotation()) {
                Annotation[] annotations;
                for (Annotation a : annotations = (Annotation[])method.invoke(annotation, new Object[0])) {
                    Class<? extends Annotation> annotationType = a.annotationType();
                    if (!this.isConstraintAnnotation(annotationType) && !this.isBuiltinConstraint(annotationType)) continue;
                    annotationList.add(a);
                }
            }
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return annotationList;
    }

    public boolean isConstraintAnnotation(Class<? extends Annotation> annotationType) {
        if (annotationType.getAnnotation(Constraint.class) == null) {
            return false;
        }
        this.assertMessageParameterExists(annotationType);
        this.assertGroupsParameterExists(annotationType);
        this.assertPayloadParameterExists(annotationType);
        this.assertValidationAppliesToParameterSetUpCorrectly(annotationType);
        this.assertNoParameterStartsWithValid(annotationType);
        return true;
    }

    private void assertNoParameterStartsWithValid(Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method m : methods = ReflectionHelper.getDeclaredMethods(annotationType)) {
            if (!m.getName().startsWith("valid") || m.getName().equals(VALIDATION_APPLIES_TO)) continue;
            throw log.getConstraintParametersCannotStartWithValidException();
        }
    }

    private void assertPayloadParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ReflectionHelper.getMethod(annotationType, PAYLOAD);
            if (method == null) {
                throw log.getConstraintWithoutMandatoryParameterException(PAYLOAD, annotationType.getName());
            }
            Class[] defaultPayload = (Class[])method.getDefaultValue();
            if (defaultPayload.length != 0) {
                throw log.getWrongDefaultValueForPayloadParameterException(annotationType.getName());
            }
        }
        catch (ClassCastException e) {
            throw log.getWrongTypeForPayloadParameterException(annotationType.getName(), e);
        }
    }

    private void assertGroupsParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ReflectionHelper.getMethod(annotationType, GROUPS);
            if (method == null) {
                throw log.getConstraintWithoutMandatoryParameterException(GROUPS, annotationType.getName());
            }
            Class[] defaultGroups = (Class[])method.getDefaultValue();
            if (defaultGroups.length != 0) {
                throw log.getWrongDefaultValueForGroupsParameterException(annotationType.getName());
            }
        }
        catch (ClassCastException e) {
            throw log.getWrongTypeForGroupsParameterException(annotationType.getName(), e);
        }
    }

    private void assertMessageParameterExists(Class<? extends Annotation> annotationType) {
        Method method = ReflectionHelper.getMethod(annotationType, MESSAGE);
        if (method == null) {
            throw log.getConstraintWithoutMandatoryParameterException(MESSAGE, annotationType.getName());
        }
        if (method.getReturnType() != String.class) {
            throw log.getWrongTypeForMessageParameterException(annotationType.getName());
        }
    }

    private void assertValidationAppliesToParameterSetUpCorrectly(Class<? extends Annotation> annotationType) {
        boolean hasGenericValidators = !this.findValidatorClasses(annotationType, ValidationTarget.ANNOTATED_ELEMENT).isEmpty();
        boolean hasCrossParameterValidator = !this.findValidatorClasses(annotationType, ValidationTarget.PARAMETERS).isEmpty();
        Method method = ReflectionHelper.getMethod(annotationType, VALIDATION_APPLIES_TO);
        if (hasGenericValidators && hasCrossParameterValidator) {
            if (method == null) {
                throw log.getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException(annotationType.getName());
            }
            if (method.getReturnType() != ConstraintTarget.class) {
                throw log.getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException(annotationType.getName());
            }
            ConstraintTarget defaultValue = (ConstraintTarget)method.getDefaultValue();
            if (defaultValue != ConstraintTarget.IMPLICIT) {
                throw log.getValidationAppliesToParameterMustHaveDefaultValueImplicitException(annotationType.getName());
            }
        } else if (method != null) {
            throw log.getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException(annotationType.getName());
        }
    }

    public boolean isConstraintComposition(Class<? extends Annotation> annotationType) {
        return annotationType == ConstraintComposition.class;
    }

    private boolean isJodaTimeInClasspath() {
        boolean isInClasspath;
        try {
            ReflectionHelper.loadClass(JODA_TIME_CLASS_NAME, this.getClass());
            isInClasspath = true;
        }
        catch (ValidationException e) {
            isInClasspath = false;
        }
        return isInClasspath;
    }

    private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> getDefaultValidatorClasses(Class<A> annotationType) {
        if (this.isBuiltinConstraint(annotationType)) {
            return this.getBuiltInConstraints(annotationType);
        }
        Class[] validatedBy = annotationType.getAnnotation(Constraint.class).validatedBy();
        return Arrays.asList(validatedBy);
    }

    private static class ValidatorClassMap {
        private final ConcurrentMap<Class<? extends Annotation>, List<? extends Class<?>>> constraintValidatorClasses = CollectionHelper.newConcurrentHashMap();

        private ValidatorClassMap() {
        }

        private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> get(Class<A> annotationType) {
            return (List)this.constraintValidatorClasses.get(annotationType);
        }

        private <A extends Annotation> void put(Class<A> annotationType, List<Class<? extends ConstraintValidator<A, ?>>> validatorClasses) {
            this.constraintValidatorClasses.put(annotationType, validatorClasses);
        }

        private <A extends Annotation> List<Class<? extends ConstraintValidator<A, ?>>> putIfAbsent(Class<A> annotationType, List<Class<? extends ConstraintValidator<A, ?>>> classes) {
            return this.constraintValidatorClasses.putIfAbsent(annotationType, classes);
        }
    }
}

