/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.internal.cdi.DestructibleBeanInstance;
import org.hibernate.validator.internal.cdi.InjectingConstraintValidatorFactory;
import org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;

public class ValidatorFactoryBean
implements Bean<ValidatorFactory> {
    private final BeanManager beanManager;
    private final Set<Annotation> qualifiers;
    private final Set<DestructibleBeanInstance<?>> destructibleResources;

    public ValidatorFactoryBean(BeanManager beanManager, Set<Annotation> qualifiers) {
        this.beanManager = beanManager;
        this.destructibleResources = CollectionHelper.newHashSet();
        this.qualifiers = CollectionHelper.newHashSet();
        this.qualifiers.addAll(qualifiers);
        this.qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
    }

    public Class<?> getBeanClass() {
        return ValidatorFactoryImpl.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = CollectionHelper.newHashSet();
        types.add((Type)((Object)ValidatorFactory.class));
        types.add((Type)((Object)Object.class));
        return types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public ValidatorFactory create(CreationalContext<ValidatorFactory> ctx) {
        Configuration config = Validation.byProvider(HibernateValidator.class).configure();
        config.constraintValidatorFactory(this.createConstraintValidatorFactory(config));
        config.messageInterpolator(this.createMessageInterpolator(config));
        config.traversableResolver(this.createTraversableResolver(config));
        config.parameterNameProvider(this.createParameterNameProvider(config));
        return config.buildValidatorFactory();
    }

    public void destroy(ValidatorFactory instance, CreationalContext<ValidatorFactory> ctx) {
        for (DestructibleBeanInstance<?> resource : this.destructibleResources) {
            resource.destroy();
        }
        instance.close();
    }

    private MessageInterpolator createMessageInterpolator(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String messageInterpolatorFqcn = bootstrapConfiguration.getMessageInterpolatorClassName();
        if (messageInterpolatorFqcn == null) {
            return config.getDefaultMessageInterpolator();
        }
        Class<?> messageInterpolatorClass = ReflectionHelper.loadClass(messageInterpolatorFqcn, this.getClass());
        return (MessageInterpolator)this.createInstance(messageInterpolatorClass);
    }

    private TraversableResolver createTraversableResolver(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String traversableResolverFqcn = bootstrapConfiguration.getTraversableResolverClassName();
        if (traversableResolverFqcn == null) {
            return config.getDefaultTraversableResolver();
        }
        Class<?> traversableResolverClass = ReflectionHelper.loadClass(traversableResolverFqcn, this.getClass());
        return (TraversableResolver)this.createInstance(traversableResolverClass);
    }

    private ParameterNameProvider createParameterNameProvider(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String parameterNameProviderFqcn = bootstrapConfiguration.getParameterNameProviderClassName();
        if (parameterNameProviderFqcn == null) {
            return config.getDefaultParameterNameProvider();
        }
        Class<?> parameterNameProviderClass = ReflectionHelper.loadClass(parameterNameProviderFqcn, this.getClass());
        return (ParameterNameProvider)this.createInstance(parameterNameProviderClass);
    }

    private ConstraintValidatorFactory createConstraintValidatorFactory(Configuration<?> config) {
        BootstrapConfiguration configSource = config.getBootstrapConfiguration();
        String constraintValidatorFactoryFqcn = configSource.getConstraintValidatorFactoryClassName();
        if (constraintValidatorFactoryFqcn == null) {
            return this.createInstance(InjectingConstraintValidatorFactory.class);
        }
        Class<?> constraintValidatorFactoryClass = ReflectionHelper.loadClass(constraintValidatorFactoryFqcn, this.getClass());
        return (ConstraintValidatorFactory)this.createInstance(constraintValidatorFactoryClass);
    }

    private <T> T createInstance(Class<T> type) {
        DestructibleBeanInstance<T> destructibleInstance = new DestructibleBeanInstance<T>(this.beanManager, type);
        this.destructibleResources.add(destructibleInstance);
        return destructibleInstance.getInstance();
    }
}

