/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.logging;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintTarget;
import javax.validation.ElementKind;
import javax.validation.GroupDefinitionException;
import javax.validation.Path;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.logging.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HV";
    private static final String FQCN = Log_$logger.class.getName();
    private static final String getReservedParameterNamesException = "%s, %s, %s are reserved parameter names.";
    private static final String getTypeNotSupportedForUnwrappingException = "Type %s not supported for unwrapping.";
    private static final String getInvalidFormatException = "Invalid format: %s.";
    private static final String getIsNotAnAnnotationException = "%s is not an annotation.";
    private static final String getInvalidLengthOfParameterMetaDataListException = "Method %1$s has %2$s parameters, but the passed list of parameter meta data has a size of %3$s.";
    private static final String getConstrainedElementConfiguredMultipleTimesException = "%1$s is configured multiple times (note, <getter> and <method> nodes for the same method are not allowed)";
    private static final String getGenericAndCrossParameterValidatorWithoutConstraintTargetException = "The constraint %1$s has both generic and cross-parameter validators, but does not specify the parameter 'validationAppliesTo'";
    private static final String getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException = "Attempt to specify an array where single value is expected.";
    private static final String getMixingImplicitWithOtherExecutableTypesException = "Mixing IMPLICIT and other executable types is not allowed.";
    private static final String unableToCloseInputStream = "Unable to close input stream.";
    private static final String getWrongDefaultGroupSequenceProviderTypeException = "The default group sequence provider defined for %s has the wrong type";
    private static final String getPropertyNameCannotBeNullOrEmptyException = "Property name cannot be null or empty.";
    private static final String getUnableToResetXmlInputStreamException = "Unable to parse %s.";
    private static final String getUnableToInstantiateParameterNameProviderClassException = "Unable to instantiate parameter name provider class %s.";
    private static final String getUnableToExpandDefaultGroupListException = "Unable to expand default group list %1$s into sequence %2$s.";
    private static final String getHasToBeABoxedTypeException = "%s has to be a auto-boxed type.";
    private static final String getComposedAndComposingConstraintsHaveDifferentTypesException = "Composed and composing constraints must have the same constraint type, but composed constraint %1$s has type %3$s, while composing constraint %2$s has type %4$s.";
    private static final String getMultipleValidatorsForSameTypeException = "The constraint '%s' defines multiple validators for the type '%s'. Only one is allowed.";
    private static final String getMoreThanOneValidatorFoundForTypeException = "There are multiple validator classes which could validate the type %1$s. The validator classes are: %2$s.";
    private static final String getUnableToFindProviderException = "Unable to find provider: %s.";
    private static final String getMemberIsNeitherAFieldNorAMethodException = "Member %s is neither a field nor a method.";
    private static final String getImplicitConstraintTargetInAmbiguousConfigurationException = "The constraint %1$s used ConstraintTarget#IMPLICIT where the target cannot be inferred.";
    private static final String getUnableToLoadConstraintAnnotationClassException = "The specified constraint annotation class %1$s cannot be loaded.";
    private static final String unableToCloseXMLFileInputStream = "Unable to close input stream for %s.";
    private static final String getNoValidatorFoundForTypeException = "No validator could be found for type: %s.";
    private static final String getInvalidMethodParameterIndexException1 = "A valid parameter index has to be specified for method '%s'";
    private static final String getMinCannotBeNegativeException = "The min parameter cannot be negative.";
    private static final String getUnableToInstantiateConstraintFactoryClassException = "Unable to instantiate constraint factory class %s.";
    private static final String getUnableToReadServicesFileException = "Unable to read %s.";
    private static final String getUnableToLoadClassException = "Unable to load class: %s.";
    private static final String getInvalidCheckDigitException = "A explicitly specified check digit must lie outside the interval: [%1$d, %2$d].";
    private static final String getPropertyPathMustProvideIndexOrMapKeyException = "Property path must provide index or map key.";
    private static final String getTryingToInstantiateAnnotationWithUnknownParametersException = "Trying to instantiate %1$s with unknown parameter(s): %2$s.";
    private static final String getConstructorIsDefinedTwiceInMappingXmlForBeanException = "The constructor '%1$s' is defined twice in the mapping xml for bean %2$s.";
    private static final String getUnableToExpandGroupSequenceException = "Unable to expand group sequence.";
    private static final String getInvalidDefaultGroupSequenceDefinitionException = "Default group sequence and default group sequence provider cannot be defined at the same time.";
    private static final String getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException = "%s must be part of the redefined default group sequence.";
    private static final String getUnableToInstantiateBeanValidationProviderException = "Unable to instantiate Bean Validation provider %s.";
    private static final String getInvalidReturnTypeException = "Invalid return type: %s. Should be a enumeration type.";
    private static final String getIsNotAConstraintValidatorClassException = "%s is not a constraint validator class.";
    private static final String getUnableToOpenInputStreamForMappingFileException = "Unable to open input stream for mapping file %s.";
    private static final String getWrongPayloadClassException = "Specified payload class %s does not implement javax.validation.Payload";
    private static final String getWrongTypeForGroupsParameterException = "%s contains Constraint annotation, but the groups parameter is of wrong type.";
    private static final String getMaxCannotBeNegativeException = "The max parameter cannot be negative.";
    private static final String getUnableToFindPropertyWithAccessException = "The class %1$s does not have a property '%2$s' with access %3$s.";
    private static final String getMultipleDefinitionOfDefaultGroupSequenceProviderException = "Multiple definitions of default group sequence provider.";
    private static final String getElementTypeHasToBeFieldOrMethodException = "Element type has to be FIELD or METHOD.";
    private static final String getWrongTypeForPayloadParameterException = "%s contains Constraint annotation, but the payload parameter is of wrong type.";
    private static final String getValidationAppliesToParameterMustHaveDefaultValueImplicitException = "Default value of the attribute validationAppliesTo() of the constraint %s must be ConstraintTarget#IMPLICIT.";
    private static final String getInvalidPropertyPathException2 = "Invalid property path. There is no property %1$s in entity %2$s.";
    private static final String errorInExpressionLanguage = "Error in EL expression '%s'";
    private static final String ignoringXmlConfiguration = "Ignoring XML configuration.";
    private static final String getEndIndexCannotBeNegativeException = "End index cannot be negative: %d.";
    private static final String getNoDefaultGroupInGroupSequenceException = "'Default.class' cannot appear in default group sequence list.";
    private static final String usingConstraintFactory = "Using %s as constraint factory.";
    private static final String getInvalidLengthForFractionPartException = "The length of the fraction part cannot be negative.";
    private static final String getInvalidCharValueException = "Invalid char value: %s.";
    private static final String getMethodOrConstructorNotDefinedByValidatedTypeException = "The validated type %1$s does not specify the constructor/method: %2$s";
    private static final String getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException = "Validator for cross-parameter constraint %s does not validate Object nor Object[].";
    private static final String getUnableToInstantiateMessageInterpolatorClassException = "Unable to instantiate message interpolator class %s.";
    private static final String getExceptionDuringIsValidCallException = "Unexpected exception during isValid call.";
    private static final String usingParameterNameProvider = "Using %s as parameter name provider.";
    private static final String getGroupHasToBeAnInterfaceException = "A group has to be an interface. %s is not.";
    private static final String getInvalidMethodParameterIndexException2 = "Method %1$s doesn't have a parameter with index %2$d.";
    private static final String getBeanDoesNotContainConstructorException = "%1$s does not contain a constructor with the parameter types %2$s.";
    private static final String getUnableToFindMethodException = "Type %1$s doesn't have a method %2$s(%3$s).";
    private static final String getWrongAttributeTypeForOverriddenConstraintException = "The overriding type of a composite constraint must be identical to the overridden one. Expected %1$s found %2$s.";
    private static final String getIsDefinedTwiceInMappingXmlForBeanException = "%1$s is defined twice in mapping xml for bean %2$s.";
    private static final String getInvalidRangeException = "Invalid Range: %1$d > %2$d.";
    private static final String getMissingActualTypeArgumentForTypeParameterException = "Missing actual type argument for type parameter: %s.";
    private static final String getUnableToFindAnnotationParameterException = "The specified annotation defines no parameter '%s'.";
    private static final String getCrossParameterConstraintOnMethodWithoutParametersException = "Cross parameter constraint %1$s is illegally placed on a parameterless method or constructor '%2$s'.";
    private static final String getUnsupportedSchemaVersionException = "Unsupported schema version for %s: %s.";
    private static final String getUnableToReadAnnotationAttributesException = "Unable to read annotation attributes: %s.";
    private static final String getParameterTypesDoNotMatchException = "The actual parameter type '%1$s' is not assignable to the expected one '%2$s' for parameter %3$d of '%4$s'";
    private static final String getUnableToParsePropertyPathException = "Unable to parse property path %s.";
    private static final String getMissingFormatStringInTemplateException = "Missing format string in template: %s.";
    private static final String getUnableToInstantiateTraversableResolverClassException = "Unable to instantiate traversable resolver class %s.";
    private static final String getScriptMustReturnTrueOrFalseException3 = "Script \"%1$s\" returned %2$s (of type %3$s), but must return either true or false.";
    private static final String usingMessageInterpolator = "Using %s as message interpolator.";
    private static final String getInvalidBigDecimalFormatException = "%s does not represent a valid BigDecimal format.";
    private static final String getGroupConversionOnNonCascadingElementException = "Found group conversions for non-cascading element: %s.";
    private static final String usingTraversableResolver = "Using %s as traversable resolver.";
    private static final String getConstraintFactoryMustNotReturnNullException = "Constraint factory returned null when trying to create instance of %s.";
    private static final String getInvalidRegularExpressionException = "Invalid regular expression.";
    private static final String getUnableToInitializeConstraintValidatorException = "Unable to initialize %s.";
    private static final String getInvalidJavaIdentifierException = "%s is not a valid Java Identifier.";
    private static final String getErrorDuringScriptExecutionException = "Error during execution of script \"%s\" occurred.";
    private static final String getUnableToCreateAnnotationForConfiguredConstraintException = "Unable to create annotation for configured constraint";
    private static final String getWrongDefaultValueForGroupsParameterException = "%s contains Constraint annotation, but the groups parameter default value is not the empty array.";
    private static final String getErrorDuringCallOfTraversableResolverIsReachableException = "Call to TraversableResolver.isReachable() threw an exception.";
    private static final String getScriptMustReturnTrueOrFalseException1 = "Script \"%s\" returned null, but must return either true or false.";
    private static final String getUnexpectedParameterValueException = "Unexpected parameter value.";
    private static final String getAnnotationDoesNotContainAParameterException = "Annotation of type %1$s does not contain a parameter %2$s.";
    private static final String usingValidationProvider = "Using %s as validation provider.";
    private static final String getOverriddenConstraintAttributeNotFoundException = "Overridden constraint does not define an attribute with name %s.";
    private static final String getParameterConstraintsDefinedInMethodsFromParallelTypesException = "Two methods defined in parallel types must not declare parameter constraints, if they are overridden by the same method, but methods %s and %s both define parameter constraints.";
    private static final String getParameterConfigurationAlteredInSubTypeException = "A method overriding another method must not alter the parameter constraint configuration, but method %2$s changes the configuration of %1$s.";
    private static final String getMultipleDefinitionOfDefaultGroupSequenceException = "Multiple definitions of default group sequence.";
    private static final String getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException = "Constraints with generic as well as cross-parameter validators must define an attribute validationAppliesTo(), but constraint %s doesn't.";
    private static final String getMultipleCrossParameterValidatorClassesException = "The constraint '%1$s' defines multiple cross parameter validators. Only one is allowed.";
    private static final String getUnableToAccessMemberException = "Unable to access %s.";
    private static final String version = "Hibernate Validator %s";
    private static final String getConstraintWithoutMandatoryParameterException = "%2$s contains Constraint annotation, but does not contain a %1$s parameter.";
    private static final String getIllegalArgumentException = "%s";
    private static final String getCrossParameterConstraintOnClassException = "Cross parameter constraint %1$s is illegally placed on class level.";
    private static final String getConstraintParametersCannotStartWithValidException = "Parameters starting with 'valid' are not allowed in a constraint.";
    private static final String getBeanDoesNotContainMethodException = "%1$s does not contain a method with the name '%2$s' and parameter types %3$s.";
    private static final String getBeanClassHasAlreadyBeConfiguredInXmlException = "%s is configured at least twice in xml.";
    private static final String getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException = "Return type of the attribute validationAppliesTo() of the constraint %s must be javax.validation.ConstraintTarget.";
    private static final String getStartIndexCannotBeNegativeException = "Start index cannot be negative: %d.";
    private static final String getUnableToNarrowNodeTypeException = "Unable to cast %s (with element kind %s) to %s";
    private static final String getAtLeastOneCustomMessageMustBeCreatedException = "At least one custom message must be created if the default error message gets disabled.";
    private static final String getInvalidIndexException = "The given index must be between %1$s and %2$s.";
    private static final String getSequenceDefinitionsNotAllowedException = "Sequence definitions are not allowed as composing parts of a sequence.";
    private static final String unableToCreateSchema = "Unable to create schema for %1$s: %2$s";
    private static final String getUnableToInstantiateValidationProviderClassException = "Unable to instantiate validation provider class %s.";
    private static final String getMethodIsDefinedTwiceInMappingXmlForBeanException = "The method '%1$s' is defined twice in the mapping xml for bean %2$s.";
    private static final String evaluatingExpressionLanguageExpressionCausedException = "An exception ocurred during evaluation of EL expression '%s'";
    private static final String getUnableToRetrieveAnnotationParameterValueException = "Unable to retrieve annotation parameter value.";
    private static final String getWrongDefaultValueForPayloadParameterException = "%s contains Constraint annotation, but the payload parameter default value is not the empty array.";
    private static final String getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException = "Two methods defined in parallel types must not define group conversions for a cascaded method return value, if they are overridden by the same method, but methods %s and %s both define parameter constraints.";
    private static final String getParameterNodeAddedForNonCrossParameterConstraintException = "No parameter nodes may be added since path %s doesn't refer to a cross-parameter constraint.";
    private static final String getUnableToDetermineSchemaVersionException = "Unable to parse %s.";
    private static final String getErrorParsingMappingFileException = "Error parsing mapping file.";
    private static final String getUnableToParseValidationXmlFileException = "Unable to parse %s.";
    private static final String getCharacterIsNotADigitException = "'%c' is not a digit.";
    private static final String unknownPropertyInExpressionLanguage = "EL expression '%s' references an unknown property";
    private static final String getUnableToInstantiateException2 = "Unable to instantiate %1$s: %2$s.";
    private static final String getNullIsAnInvalidTypeForAConstraintValidatorException = "null is an invalid type for a constraint validator.";
    private static final String getExceptionOcurredDuringMessageInterpolationException = "An exception occured during message interpolation";
    private static final String getNoValueProvidedForAnnotationParameterException = "No value provided for parameter '%1$s' of annotation @%2$s.";
    private static final String getInvalidNumberFormatException = "Invalid %s format.";
    private static final String unableToLoadProviderClass = "Unable to load provider class %s.";
    private static final String getCrossParameterConstraintHasNoValidatorException = "Cross parameter constraint %1$s has no cross-parameter validator.";
    private static final String getWrongParameterTypeException = "Wrong parameter type. Expected: %1$s Actual: %2$s.";
    private static final String getMultipleGroupConversionsForSameSourceException = "Found multiple group conversions for source group %s: %s.";
    private static final String getLengthCannotBeNegativeException = "The length cannot be negative.";
    private static final String getVoidMethodsMustNotBeConstrainedException = "Void methods must not be constrained or marked for cascaded validation, but method %s is.";
    private static final String getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException = "Only constraints with generic as well as cross-parameter validators must define an attribute validationAppliesTo(), but constraint %s does.";
    private static final String getAtLeastOneGroupHasToBeSpecifiedException = "At least one group has to be specified.";
    private static final String getUnableToInstantiateException1 = "Unable to instantiate %s.";
    private static final String getValidateOnExecutionOnOverriddenOrInterfaceMethodException = "@ValidateOnExecution is not allowed on methods overriding a superclass method or implementing an interface. Check configuration for %1$s";
    private static final String getInvalidParameterTypeException = "Unable to load parameter of type '%1$s' in %2$s.";
    private static final String getInconsistentFailFastConfigurationException = "Inconsistent fail fast configuration. Fail fast enabled via programmatic API, but explicitly disabled via properties.";
    private static final String getInconsistentConfigurationException = "Assertion error: inconsistent ConfigurationImpl construction.";
    private static final String getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException = "A method return value must not be marked for cascaded validation more than once in a class hierarchy, but the following two methods are marked as such: %s, %s.";
    private static final String getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException = "The constraint %1$s used ConstraintTarget#%2$s but is not specified on a method or constructor.";
    private static final String getErrorDuringCallOfTraversableResolverIsCascadableException = "Call to TraversableResolver.isCascadable() threw an exception.";
    private static final String getCrossParameterConstraintOnFieldException = "Cross parameter constraint %1$s is illegally placed on field '%2$s'.";
    private static final String getGroupConversionForSequenceException = "Found group conversion using a group sequence as source: %s.";
    private static final String getInvalidPropertyValueException = "Invalid value for property %s: %s";
    private static final String getWrongTypeForMessageParameterException = "%s contains Constraint annotation, but the message parameter is not of type java.lang.String.";
    private static final String getBeanDoesNotContainTheFieldException = "%1$s does not contain the fieldType %2$s.";
    private static final String getInvalidPropertyPathException0 = "Invalid property path.";
    private static final String getCyclicDependencyInGroupsDefinitionException = "Cyclic dependency in groups definition";
    private static final String getHasToBeAPrimitiveTypeException = "%s has to be a primitive type.";
    private static final String getInvalidLengthForIntegerPartException = "The length of the integer part cannot be negative.";
    private static final String parsingXMLFile = "%s found. Parsing XML based configuration.";
    private static final String getAnnotationIsNoConstraintTypeException = "Annotation type %s is no constraint annotation. It needs to be annotated with @Constraint or @CrossParameterConstraint.";
    private static final String getBeanDoesNotContainThePropertyException = "%1$s does not contain the property %2$s.";
    private static final String getUnableToFindAnnotationConstraintsException = "Unable to find constraints for  %s.";
    private static final String getUnableToGetAnnotationParameterException = "Unable to get '%1$s' from %2$s.";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final ValidationException getReservedParameterNamesException(String messageParameterName, String groupsParameterName, String payloadParameterName) {
        ValidationException result = new ValidationException(String.format("HV000113: " + this.getReservedParameterNamesException$str(), messageParameterName, groupsParameterName, payloadParameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getReservedParameterNamesException$str() {
        return getReservedParameterNamesException;
    }

    public final ValidationException getTypeNotSupportedForUnwrappingException(Class type) {
        ValidationException result = new ValidationException(String.format("HV000036: " + this.getTypeNotSupportedForUnwrappingException$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getTypeNotSupportedForUnwrappingException$str() {
        return getTypeNotSupportedForUnwrappingException;
    }

    @Override
    public final ValidationException getInvalidFormatException(String message, IllegalFormatException e) {
        ValidationException result = new ValidationException(String.format("HV000051: " + this.getInvalidFormatException$str(), message), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidFormatException$str() {
        return getInvalidFormatException;
    }

    @Override
    public final ValidationException getIsNotAnAnnotationException(String annotationClassName) {
        ValidationException result = new ValidationException(String.format("HV000101: " + this.getIsNotAnAnnotationException$str(), annotationClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIsNotAnAnnotationException$str() {
        return getIsNotAnAnnotationException;
    }

    @Override
    public final IllegalArgumentException getInvalidLengthOfParameterMetaDataListException(ExecutableElement executableElement, int nbParameters, int listSize) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000062: " + this.getInvalidLengthOfParameterMetaDataListException$str(), executableElement, nbParameters, listSize));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidLengthOfParameterMetaDataListException$str() {
        return getInvalidLengthOfParameterMetaDataListException;
    }

    @Override
    public final ValidationException getConstrainedElementConfiguredMultipleTimesException(String location) {
        ValidationException result = new ValidationException(String.format("HV000147: " + this.getConstrainedElementConfiguredMultipleTimesException$str(), location));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstrainedElementConfiguredMultipleTimesException$str() {
        return getConstrainedElementConfiguredMultipleTimesException;
    }

    @Override
    public final ConstraintDefinitionException getGenericAndCrossParameterValidatorWithoutConstraintTargetException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000140: " + this.getGenericAndCrossParameterValidatorWithoutConstraintTargetException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getGenericAndCrossParameterValidatorWithoutConstraintTargetException$str() {
        return getGenericAndCrossParameterValidatorWithoutConstraintTargetException;
    }

    @Override
    public final ValidationException getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException() {
        ValidationException result = new ValidationException(String.format("HV000108: " + this.getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException$str() {
        return getAttemptToSpecifyAnArrayWhereSingleValueIsExpectedException;
    }

    @Override
    public final IllegalArgumentException getMixingImplicitWithOtherExecutableTypesException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000165: " + this.getMixingImplicitWithOtherExecutableTypesException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMixingImplicitWithOtherExecutableTypesException$str() {
        return getMixingImplicitWithOtherExecutableTypesException;
    }

    @Override
    public final void unableToCloseInputStream() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HV000008: " + this.unableToCloseInputStream$str(), new Object[0]);
    }

    protected String unableToCloseInputStream$str() {
        return unableToCloseInputStream;
    }

    @Override
    public final GroupDefinitionException getWrongDefaultGroupSequenceProviderTypeException(String beanClassName) {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000055: " + this.getWrongDefaultGroupSequenceProviderTypeException$str(), beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDefaultGroupSequenceProviderTypeException$str() {
        return getWrongDefaultGroupSequenceProviderTypeException;
    }

    @Override
    public final IllegalArgumentException getPropertyNameCannotBeNullOrEmptyException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000087: " + this.getPropertyNameCannotBeNullOrEmptyException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyNameCannotBeNullOrEmptyException$str() {
        return getPropertyNameCannotBeNullOrEmptyException;
    }

    @Override
    public final ValidationException getUnableToResetXmlInputStreamException(String file, IOException e) {
        ValidationException result = new ValidationException(String.format("HV000123: " + this.getUnableToResetXmlInputStreamException$str(), file), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToResetXmlInputStreamException$str() {
        return "Unable to parse %s.";
    }

    @Override
    public final ValidationException getUnableToInstantiateParameterNameProviderClassException(String parameterNameProviderClassName, ValidationException e) {
        ValidationException result = new ValidationException(String.format("HV000120: " + this.getUnableToInstantiateParameterNameProviderClassException$str(), parameterNameProviderClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateParameterNameProviderClassException$str() {
        return getUnableToInstantiateParameterNameProviderClassException;
    }

    public final GroupDefinitionException getUnableToExpandDefaultGroupListException(List defaultGroupList, List groupList) {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000043: " + this.getUnableToExpandDefaultGroupListException$str(), defaultGroupList, groupList));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToExpandDefaultGroupListException$str() {
        return getUnableToExpandDefaultGroupListException;
    }

    public final IllegalArgumentException getHasToBeABoxedTypeException(Class clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000164: " + this.getHasToBeABoxedTypeException$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getHasToBeABoxedTypeException$str() {
        return getHasToBeABoxedTypeException;
    }

    @Override
    public final ConstraintDefinitionException getComposedAndComposingConstraintsHaveDifferentTypesException(String composedConstraintTypeName, String composingConstraintTypeName, ConstraintDescriptorImpl.ConstraintType composedConstraintType, ConstraintDescriptorImpl.ConstraintType composingConstraintType) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000155: " + this.getComposedAndComposingConstraintsHaveDifferentTypesException$str(), new Object[]{composedConstraintTypeName, composingConstraintTypeName, composedConstraintType, composingConstraintType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getComposedAndComposingConstraintsHaveDifferentTypesException$str() {
        return getComposedAndComposingConstraintsHaveDifferentTypesException;
    }

    @Override
    public final UnexpectedTypeException getMultipleValidatorsForSameTypeException(String constraint, String type) {
        UnexpectedTypeException result = new UnexpectedTypeException(String.format("HV000150: " + this.getMultipleValidatorsForSameTypeException$str(), constraint, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleValidatorsForSameTypeException$str() {
        return getMultipleValidatorsForSameTypeException;
    }

    @Override
    public final UnexpectedTypeException getMoreThanOneValidatorFoundForTypeException(Type type, String validatorClasses) {
        UnexpectedTypeException result = new UnexpectedTypeException(String.format("HV000031: " + this.getMoreThanOneValidatorFoundForTypeException$str(), type, validatorClasses));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMoreThanOneValidatorFoundForTypeException$str() {
        return getMoreThanOneValidatorFoundForTypeException;
    }

    public final ValidationException getUnableToFindProviderException(Class providerClass) {
        ValidationException result = new ValidationException(String.format("HV000027: " + this.getUnableToFindProviderException$str(), providerClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindProviderException$str() {
        return getUnableToFindProviderException;
    }

    @Override
    public final IllegalArgumentException getMemberIsNeitherAFieldNorAMethodException(Member member) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000089: " + this.getMemberIsNeitherAFieldNorAMethodException$str(), member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMemberIsNeitherAFieldNorAMethodException$str() {
        return getMemberIsNeitherAFieldNorAMethodException;
    }

    @Override
    public final ConstraintDeclarationException getImplicitConstraintTargetInAmbiguousConfigurationException(String constraint) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000141: " + this.getImplicitConstraintTargetInAmbiguousConfigurationException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getImplicitConstraintTargetInAmbiguousConfigurationException$str() {
        return getImplicitConstraintTargetInAmbiguousConfigurationException;
    }

    @Override
    public final ValidationException getUnableToLoadConstraintAnnotationClassException(String constraintAnnotationClass, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000136: " + this.getUnableToLoadConstraintAnnotationClassException$str(), constraintAnnotationClass), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToLoadConstraintAnnotationClassException$str() {
        return getUnableToLoadConstraintAnnotationClassException;
    }

    @Override
    public final void unableToCloseXMLFileInputStream(String fileName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HV000010: " + this.unableToCloseXMLFileInputStream$str(), (Object)fileName);
    }

    protected String unableToCloseXMLFileInputStream$str() {
        return unableToCloseXMLFileInputStream;
    }

    @Override
    public final UnexpectedTypeException getNoValidatorFoundForTypeException(String className) {
        UnexpectedTypeException result = new UnexpectedTypeException(String.format("HV000030: " + this.getNoValidatorFoundForTypeException$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoValidatorFoundForTypeException$str() {
        return getNoValidatorFoundForTypeException;
    }

    @Override
    public final IllegalArgumentException getInvalidMethodParameterIndexException(String methodName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000015: " + this.getInvalidMethodParameterIndexException1$str(), methodName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidMethodParameterIndexException1$str() {
        return getInvalidMethodParameterIndexException1;
    }

    @Override
    public final IllegalArgumentException getMinCannotBeNegativeException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000019: " + this.getMinCannotBeNegativeException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMinCannotBeNegativeException$str() {
        return getMinCannotBeNegativeException;
    }

    @Override
    public final ValidationException getUnableToInstantiateConstraintFactoryClassException(String constraintFactoryClassName, ValidationException e) {
        ValidationException result = new ValidationException(String.format("HV000095: " + this.getUnableToInstantiateConstraintFactoryClassException$str(), constraintFactoryClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateConstraintFactoryClassException$str() {
        return getUnableToInstantiateConstraintFactoryClassException;
    }

    @Override
    public final ValidationException getUnableToReadServicesFileException(String servicesFileName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000067: " + this.getUnableToReadServicesFileException$str(), servicesFileName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToReadServicesFileException$str() {
        return getUnableToReadServicesFileException;
    }

    @Override
    public final ValidationException getUnableToLoadClassException(String className) {
        ValidationException result = new ValidationException(String.format("HV000065: " + this.getUnableToLoadClassException$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToLoadClassException$str() {
        return getUnableToLoadClassException;
    }

    @Override
    public final IllegalArgumentException getInvalidCheckDigitException(int startIndex, int endIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000071: " + this.getInvalidCheckDigitException$str(), startIndex, endIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidCheckDigitException$str() {
        return getInvalidCheckDigitException;
    }

    @Override
    public final IllegalArgumentException getPropertyPathMustProvideIndexOrMapKeyException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000040: " + this.getPropertyPathMustProvideIndexOrMapKeyException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getPropertyPathMustProvideIndexOrMapKeyException$str() {
        return getPropertyPathMustProvideIndexOrMapKeyException;
    }

    public final RuntimeException getTryingToInstantiateAnnotationWithUnknownParametersException(Class annotationType, Set unknownParameters) {
        RuntimeException result = new RuntimeException(String.format("HV000086: " + this.getTryingToInstantiateAnnotationWithUnknownParametersException$str(), annotationType, unknownParameters));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getTryingToInstantiateAnnotationWithUnknownParametersException$str() {
        return getTryingToInstantiateAnnotationWithUnknownParametersException;
    }

    @Override
    public final ValidationException getConstructorIsDefinedTwiceInMappingXmlForBeanException(String name, String beanClassName) {
        ValidationException result = new ValidationException(String.format("HV000138: " + this.getConstructorIsDefinedTwiceInMappingXmlForBeanException$str(), name, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstructorIsDefinedTwiceInMappingXmlForBeanException$str() {
        return getConstructorIsDefinedTwiceInMappingXmlForBeanException;
    }

    @Override
    public final GroupDefinitionException getUnableToExpandGroupSequenceException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000048: " + this.getUnableToExpandGroupSequenceException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToExpandGroupSequenceException$str() {
        return getUnableToExpandGroupSequenceException;
    }

    @Override
    public final GroupDefinitionException getInvalidDefaultGroupSequenceDefinitionException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000052: " + this.getInvalidDefaultGroupSequenceDefinitionException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidDefaultGroupSequenceDefinitionException$str() {
        return getInvalidDefaultGroupSequenceDefinitionException;
    }

    @Override
    public final GroupDefinitionException getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException(String beanClassName) {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000054: " + this.getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException$str(), beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException$str() {
        return getBeanClassMustBePartOfRedefinedDefaultGroupSequenceException;
    }

    public final ValidationException getUnableToInstantiateBeanValidationProviderException(List providerName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000066: " + this.getUnableToInstantiateBeanValidationProviderException$str(), providerName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateBeanValidationProviderException$str() {
        return getUnableToInstantiateBeanValidationProviderException;
    }

    public final ValidationException getInvalidReturnTypeException(Class returnType, ClassCastException e) {
        ValidationException result = new ValidationException(String.format("HV000112: " + this.getInvalidReturnTypeException$str(), returnType), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidReturnTypeException$str() {
        return getInvalidReturnTypeException;
    }

    public final ValidationException getIsNotAConstraintValidatorClassException(Class validatorClass) {
        ValidationException result = new ValidationException(String.format("HV000102: " + this.getIsNotAConstraintValidatorClassException$str(), validatorClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIsNotAConstraintValidatorClassException$str() {
        return getIsNotAConstraintValidatorClassException;
    }

    @Override
    public final ValidationException getUnableToOpenInputStreamForMappingFileException(String mappingFileName) {
        ValidationException result = new ValidationException(String.format("HV000096: " + this.getUnableToOpenInputStreamForMappingFileException$str(), mappingFileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToOpenInputStreamForMappingFileException$str() {
        return getUnableToOpenInputStreamForMappingFileException;
    }

    @Override
    public final ValidationException getWrongPayloadClassException(String payloadClassName) {
        ValidationException result = new ValidationException(String.format("HV000114: " + this.getWrongPayloadClassException$str(), payloadClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongPayloadClassException$str() {
        return getWrongPayloadClassException;
    }

    @Override
    public final ConstraintDefinitionException getWrongTypeForGroupsParameterException(String constraintName, ClassCastException e) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000078: " + this.getWrongTypeForGroupsParameterException$str(), constraintName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongTypeForGroupsParameterException$str() {
        return getWrongTypeForGroupsParameterException;
    }

    @Override
    public final IllegalArgumentException getMaxCannotBeNegativeException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000020: " + this.getMaxCannotBeNegativeException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMaxCannotBeNegativeException$str() {
        return getMaxCannotBeNegativeException;
    }

    public final ValidationException getUnableToFindPropertyWithAccessException(Class beanClass, String property, ElementType elementType) {
        ValidationException result = new ValidationException(String.format("HV000013: " + this.getUnableToFindPropertyWithAccessException$str(), new Object[]{beanClass, property, elementType}));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindPropertyWithAccessException$str() {
        return getUnableToFindPropertyWithAccessException;
    }

    @Override
    public final GroupDefinitionException getMultipleDefinitionOfDefaultGroupSequenceProviderException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000060: " + this.getMultipleDefinitionOfDefaultGroupSequenceProviderException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleDefinitionOfDefaultGroupSequenceProviderException$str() {
        return getMultipleDefinitionOfDefaultGroupSequenceProviderException;
    }

    @Override
    public final IllegalArgumentException getElementTypeHasToBeFieldOrMethodException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000088: " + this.getElementTypeHasToBeFieldOrMethodException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getElementTypeHasToBeFieldOrMethodException$str() {
        return getElementTypeHasToBeFieldOrMethodException;
    }

    @Override
    public final ConstraintDefinitionException getWrongTypeForPayloadParameterException(String constraintName, ClassCastException e) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000076: " + this.getWrongTypeForPayloadParameterException$str(), constraintName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongTypeForPayloadParameterException$str() {
        return getWrongTypeForPayloadParameterException;
    }

    @Override
    public final ConstraintDefinitionException getValidationAppliesToParameterMustHaveDefaultValueImplicitException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000158: " + this.getValidationAppliesToParameterMustHaveDefaultValueImplicitException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getValidationAppliesToParameterMustHaveDefaultValueImplicitException$str() {
        return getValidationAppliesToParameterMustHaveDefaultValueImplicitException;
    }

    @Override
    public final IllegalArgumentException getInvalidPropertyPathException(String propertyName, String beanClassName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000039: " + this.getInvalidPropertyPathException2$str(), propertyName, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidPropertyPathException2$str() {
        return getInvalidPropertyPathException2;
    }

    @Override
    public final void errorInExpressionLanguage(String expression, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HV000130: " + this.errorInExpressionLanguage$str(), (Object)expression);
    }

    protected String errorInExpressionLanguage$str() {
        return errorInExpressionLanguage;
    }

    @Override
    public final void ignoringXmlConfiguration() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000002: " + this.ignoringXmlConfiguration$str(), new Object[0]);
    }

    protected String ignoringXmlConfiguration$str() {
        return ignoringXmlConfiguration;
    }

    @Override
    public final IllegalArgumentException getEndIndexCannotBeNegativeException(int endIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000069: " + this.getEndIndexCannotBeNegativeException$str(), endIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getEndIndexCannotBeNegativeException$str() {
        return getEndIndexCannotBeNegativeException;
    }

    @Override
    public final GroupDefinitionException getNoDefaultGroupInGroupSequenceException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000053: " + this.getNoDefaultGroupInGroupSequenceException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoDefaultGroupInGroupSequenceException$str() {
        return getNoDefaultGroupInGroupSequenceException;
    }

    @Override
    public final void usingConstraintFactory(String constraintFactoryClassName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000003: " + this.usingConstraintFactory$str(), (Object)constraintFactoryClassName);
    }

    protected String usingConstraintFactory$str() {
        return usingConstraintFactory;
    }

    @Override
    public final IllegalArgumentException getInvalidLengthForFractionPartException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000018: " + this.getInvalidLengthForFractionPartException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidLengthForFractionPartException$str() {
        return getInvalidLengthForFractionPartException;
    }

    @Override
    public final ValidationException getInvalidCharValueException(String value) {
        ValidationException result = new ValidationException(String.format("HV000111: " + this.getInvalidCharValueException$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidCharValueException$str() {
        return getInvalidCharValueException;
    }

    @Override
    public final IllegalArgumentException getMethodOrConstructorNotDefinedByValidatedTypeException(String validatedTypeName, Member member) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000162: " + this.getMethodOrConstructorNotDefinedByValidatedTypeException$str(), validatedTypeName, member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMethodOrConstructorNotDefinedByValidatedTypeException$str() {
        return getMethodOrConstructorNotDefinedByValidatedTypeException;
    }

    @Override
    public final ConstraintDefinitionException getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000160: " + this.getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException$str() {
        return getValidatorForCrossParameterConstraintMustEitherValidateObjectOrObjectArrayException;
    }

    @Override
    public final ValidationException getUnableToInstantiateMessageInterpolatorClassException(String messageInterpolatorClassName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000097: " + this.getUnableToInstantiateMessageInterpolatorClassException$str(), messageInterpolatorClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateMessageInterpolatorClassException$str() {
        return getUnableToInstantiateMessageInterpolatorClassException;
    }

    @Override
    public final ValidationException getExceptionDuringIsValidCallException(RuntimeException e) {
        ValidationException result = new ValidationException(String.format("HV000028: " + this.getExceptionDuringIsValidCallException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getExceptionDuringIsValidCallException$str() {
        return getExceptionDuringIsValidCallException;
    }

    @Override
    public final void usingParameterNameProvider(String parameterNameProviderClassName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000119: " + this.usingParameterNameProvider$str(), (Object)parameterNameProviderClassName);
    }

    protected String usingParameterNameProvider$str() {
        return usingParameterNameProvider;
    }

    @Override
    public final ValidationException getGroupHasToBeAnInterfaceException(String className) {
        ValidationException result = new ValidationException(String.format("HV000045: " + this.getGroupHasToBeAnInterfaceException$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getGroupHasToBeAnInterfaceException$str() {
        return getGroupHasToBeAnInterfaceException;
    }

    @Override
    public final IllegalArgumentException getInvalidMethodParameterIndexException(String method, int index) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000056: " + this.getInvalidMethodParameterIndexException2$str(), method, index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidMethodParameterIndexException2$str() {
        return getInvalidMethodParameterIndexException2;
    }

    public final ValidationException getBeanDoesNotContainConstructorException(String beanClassName, List parameterTypes) {
        ValidationException result = new ValidationException(String.format("HV000133: " + this.getBeanDoesNotContainConstructorException$str(), beanClassName, parameterTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanDoesNotContainConstructorException$str() {
        return getBeanDoesNotContainConstructorException;
    }

    public final IllegalArgumentException getUnableToFindMethodException(Class beanClass, String name, String parametersType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000014: " + this.getUnableToFindMethodException$str(), beanClass, name, parametersType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindMethodException$str() {
        return getUnableToFindMethodException;
    }

    public final ConstraintDefinitionException getWrongAttributeTypeForOverriddenConstraintException(String expectedReturnType, Class currentReturnType) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000081: " + this.getWrongAttributeTypeForOverriddenConstraintException$str(), expectedReturnType, currentReturnType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongAttributeTypeForOverriddenConstraintException$str() {
        return getWrongAttributeTypeForOverriddenConstraintException;
    }

    @Override
    public final ValidationException getIsDefinedTwiceInMappingXmlForBeanException(String name, String beanClassName) {
        ValidationException result = new ValidationException(String.format("HV000104: " + this.getIsDefinedTwiceInMappingXmlForBeanException$str(), name, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIsDefinedTwiceInMappingXmlForBeanException$str() {
        return getIsDefinedTwiceInMappingXmlForBeanException;
    }

    @Override
    public final IllegalArgumentException getInvalidRangeException(int startIndex, int endIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000070: " + this.getInvalidRangeException$str(), startIndex, endIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidRangeException$str() {
        return getInvalidRangeException;
    }

    public final IllegalArgumentException getMissingActualTypeArgumentForTypeParameterException(TypeVariable typeParameter) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000094: " + this.getMissingActualTypeArgumentForTypeParameterException$str(), typeParameter));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMissingActualTypeArgumentForTypeParameterException$str() {
        return getMissingActualTypeArgumentForTypeParameterException;
    }

    @Override
    public final ValidationException getUnableToFindAnnotationParameterException(String parameterName, NoSuchMethodException e) {
        ValidationException result = new ValidationException(String.format("HV000083: " + this.getUnableToFindAnnotationParameterException$str(), parameterName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindAnnotationParameterException$str() {
        return getUnableToFindAnnotationParameterException;
    }

    @Override
    public final ConstraintDeclarationException getCrossParameterConstraintOnMethodWithoutParametersException(String constraint, String member) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000142: " + this.getCrossParameterConstraintOnMethodWithoutParametersException$str(), constraint, member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCrossParameterConstraintOnMethodWithoutParametersException$str() {
        return getCrossParameterConstraintOnMethodWithoutParametersException;
    }

    @Override
    public final ValidationException getUnsupportedSchemaVersionException(String file, String version) {
        ValidationException result = new ValidationException(String.format("HV000122: " + this.getUnsupportedSchemaVersionException$str(), file, version));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnsupportedSchemaVersionException$str() {
        return getUnsupportedSchemaVersionException;
    }

    public final ValidationException getUnableToReadAnnotationAttributesException(Class annotationClass, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000058: " + this.getUnableToReadAnnotationAttributesException$str(), annotationClass), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToReadAnnotationAttributesException$str() {
        return getUnableToReadAnnotationAttributesException;
    }

    @Override
    public final IllegalArgumentException getParameterTypesDoNotMatchException(String actualType, String expectedType, int index, Member member) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000163: " + this.getParameterTypesDoNotMatchException$str(), actualType, expectedType, index, member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getParameterTypesDoNotMatchException$str() {
        return getParameterTypesDoNotMatchException;
    }

    @Override
    public final IllegalArgumentException getUnableToParsePropertyPathException(String propertyPath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000035: " + this.getUnableToParsePropertyPathException$str(), propertyPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToParsePropertyPathException$str() {
        return getUnableToParsePropertyPathException;
    }

    @Override
    public final ValidationException getMissingFormatStringInTemplateException(String expression) {
        ValidationException result = new ValidationException(String.format("HV000050: " + this.getMissingFormatStringInTemplateException$str(), expression));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMissingFormatStringInTemplateException$str() {
        return getMissingFormatStringInTemplateException;
    }

    @Override
    public final ValidationException getUnableToInstantiateTraversableResolverClassException(String traversableResolverClassName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000098: " + this.getUnableToInstantiateTraversableResolverClassException$str(), traversableResolverClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateTraversableResolverClassException$str() {
        return getUnableToInstantiateTraversableResolverClassException;
    }

    @Override
    public final ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(String script, Object executionResult, String type) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000025: " + this.getScriptMustReturnTrueOrFalseException3$str(), script, executionResult, type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getScriptMustReturnTrueOrFalseException3$str() {
        return getScriptMustReturnTrueOrFalseException3;
    }

    @Override
    public final void usingMessageInterpolator(String messageInterpolatorClassName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000004: " + this.usingMessageInterpolator$str(), (Object)messageInterpolatorClassName);
    }

    protected String usingMessageInterpolator$str() {
        return usingMessageInterpolator;
    }

    @Override
    public final IllegalArgumentException getInvalidBigDecimalFormatException(String value, NumberFormatException e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000016: " + this.getInvalidBigDecimalFormatException$str(), value), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidBigDecimalFormatException$str() {
        return getInvalidBigDecimalFormatException;
    }

    @Override
    public final ConstraintDeclarationException getGroupConversionOnNonCascadingElementException(String location) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000125: " + this.getGroupConversionOnNonCascadingElementException$str(), location));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getGroupConversionOnNonCascadingElementException$str() {
        return getGroupConversionOnNonCascadingElementException;
    }

    @Override
    public final void usingTraversableResolver(String traversableResolverClassName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000005: " + this.usingTraversableResolver$str(), (Object)traversableResolverClassName);
    }

    protected String usingTraversableResolver$str() {
        return usingTraversableResolver;
    }

    @Override
    public final ValidationException getConstraintFactoryMustNotReturnNullException(String validatorClassName) {
        ValidationException result = new ValidationException(String.format("HV000029: " + this.getConstraintFactoryMustNotReturnNullException$str(), validatorClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstraintFactoryMustNotReturnNullException$str() {
        return getConstraintFactoryMustNotReturnNullException;
    }

    @Override
    public final IllegalArgumentException getInvalidRegularExpressionException(PatternSyntaxException e) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000022: " + this.getInvalidRegularExpressionException$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidRegularExpressionException$str() {
        return getInvalidRegularExpressionException;
    }

    @Override
    public final ValidationException getUnableToInitializeConstraintValidatorException(String validatorClassName, RuntimeException e) {
        ValidationException result = new ValidationException(String.format("HV000032: " + this.getUnableToInitializeConstraintValidatorException$str(), validatorClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInitializeConstraintValidatorException$str() {
        return getUnableToInitializeConstraintValidatorException;
    }

    @Override
    public final IllegalArgumentException getInvalidJavaIdentifierException(String identifier) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000034: " + this.getInvalidJavaIdentifierException$str(), identifier));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidJavaIdentifierException$str() {
        return getInvalidJavaIdentifierException;
    }

    @Override
    public final ConstraintDeclarationException getErrorDuringScriptExecutionException(String script, Exception e) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000023: " + this.getErrorDuringScriptExecutionException$str(), script), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorDuringScriptExecutionException$str() {
        return getErrorDuringScriptExecutionException;
    }

    @Override
    public final ValidationException getUnableToCreateAnnotationForConfiguredConstraintException(RuntimeException e) {
        ValidationException result = new ValidationException(String.format("HV000012: " + this.getUnableToCreateAnnotationForConfiguredConstraintException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToCreateAnnotationForConfiguredConstraintException$str() {
        return getUnableToCreateAnnotationForConfiguredConstraintException;
    }

    @Override
    public final ConstraintDefinitionException getWrongDefaultValueForGroupsParameterException(String constraintName) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000077: " + this.getWrongDefaultValueForGroupsParameterException$str(), constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDefaultValueForGroupsParameterException$str() {
        return getWrongDefaultValueForGroupsParameterException;
    }

    @Override
    public final ValidationException getErrorDuringCallOfTraversableResolverIsReachableException(RuntimeException e) {
        ValidationException result = new ValidationException(String.format("HV000041: " + this.getErrorDuringCallOfTraversableResolverIsReachableException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorDuringCallOfTraversableResolverIsReachableException$str() {
        return getErrorDuringCallOfTraversableResolverIsReachableException;
    }

    @Override
    public final ConstraintDeclarationException getScriptMustReturnTrueOrFalseException(String script) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000024: " + this.getScriptMustReturnTrueOrFalseException1$str(), script));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getScriptMustReturnTrueOrFalseException1$str() {
        return getScriptMustReturnTrueOrFalseException1;
    }

    @Override
    public final ValidationException getUnexpectedParameterValueException(ClassCastException e) {
        ValidationException result = new ValidationException(String.format("HV000109: " + this.getUnexpectedParameterValueException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnexpectedParameterValueException$str() {
        return getUnexpectedParameterValueException;
    }

    @Override
    public final ValidationException getAnnotationDoesNotContainAParameterException(String annotationClassName, String parameterName) {
        ValidationException result = new ValidationException(String.format("HV000107: " + this.getAnnotationDoesNotContainAParameterException$str(), annotationClassName, parameterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAnnotationDoesNotContainAParameterException$str() {
        return getAnnotationDoesNotContainAParameterException;
    }

    @Override
    public final void usingValidationProvider(String validationProviderClassName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000006: " + this.usingValidationProvider$str(), (Object)validationProviderClassName);
    }

    protected String usingValidationProvider$str() {
        return usingValidationProvider;
    }

    @Override
    public final ConstraintDefinitionException getOverriddenConstraintAttributeNotFoundException(String attributeName) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000080: " + this.getOverriddenConstraintAttributeNotFoundException$str(), attributeName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getOverriddenConstraintAttributeNotFoundException$str() {
        return getOverriddenConstraintAttributeNotFoundException;
    }

    @Override
    public final ConstraintDeclarationException getParameterConstraintsDefinedInMethodsFromParallelTypesException(Member method1, Member method2) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000152: " + this.getParameterConstraintsDefinedInMethodsFromParallelTypesException$str(), method1, method2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getParameterConstraintsDefinedInMethodsFromParallelTypesException$str() {
        return getParameterConstraintsDefinedInMethodsFromParallelTypesException;
    }

    @Override
    public final ConstraintDeclarationException getParameterConfigurationAlteredInSubTypeException(Member superMethod, Member subMethod) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000151: " + this.getParameterConfigurationAlteredInSubTypeException$str(), superMethod, subMethod));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getParameterConfigurationAlteredInSubTypeException$str() {
        return getParameterConfigurationAlteredInSubTypeException;
    }

    @Override
    public final GroupDefinitionException getMultipleDefinitionOfDefaultGroupSequenceException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000061: " + this.getMultipleDefinitionOfDefaultGroupSequenceException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleDefinitionOfDefaultGroupSequenceException$str() {
        return getMultipleDefinitionOfDefaultGroupSequenceException;
    }

    @Override
    public final ConstraintDefinitionException getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000156: " + this.getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException$str() {
        return getGenericAndCrossParameterConstraintDoesNotDefineValidationAppliesToParameterException;
    }

    @Override
    public final ConstraintDefinitionException getMultipleCrossParameterValidatorClassesException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000139: " + this.getMultipleCrossParameterValidatorClassesException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleCrossParameterValidatorClassesException$str() {
        return getMultipleCrossParameterValidatorClassesException;
    }

    @Override
    public final ValidationException getUnableToAccessMemberException(String memberName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000090: " + this.getUnableToAccessMemberException$str(), memberName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToAccessMemberException$str() {
        return getUnableToAccessMemberException;
    }

    @Override
    public final void version(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000001: " + this.version$str(), (Object)version);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final ConstraintDefinitionException getConstraintWithoutMandatoryParameterException(String parameterName, String constraintName) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000074: " + this.getConstraintWithoutMandatoryParameterException$str(), parameterName, constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstraintWithoutMandatoryParameterException$str() {
        return getConstraintWithoutMandatoryParameterException;
    }

    @Override
    public final IllegalArgumentException getIllegalArgumentException(String message) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000116: " + this.getIllegalArgumentException$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getIllegalArgumentException$str() {
        return getIllegalArgumentException;
    }

    @Override
    public final ConstraintDeclarationException getCrossParameterConstraintOnClassException(String constraint) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000143: " + this.getCrossParameterConstraintOnClassException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCrossParameterConstraintOnClassException$str() {
        return getCrossParameterConstraintOnClassException;
    }

    @Override
    public final ConstraintDefinitionException getConstraintParametersCannotStartWithValidException() {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000073: " + this.getConstraintParametersCannotStartWithValidException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getConstraintParametersCannotStartWithValidException$str() {
        return getConstraintParametersCannotStartWithValidException;
    }

    public final ValidationException getBeanDoesNotContainMethodException(String beanClassName, String methodName, List parameterTypes) {
        ValidationException result = new ValidationException(String.format("HV000135: " + this.getBeanDoesNotContainMethodException$str(), beanClassName, methodName, parameterTypes));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanDoesNotContainMethodException$str() {
        return getBeanDoesNotContainMethodException;
    }

    @Override
    public final ValidationException getBeanClassHasAlreadyBeConfiguredInXmlException(String beanClassName) {
        ValidationException result = new ValidationException(String.format("HV000103: " + this.getBeanClassHasAlreadyBeConfiguredInXmlException$str(), beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanClassHasAlreadyBeConfiguredInXmlException$str() {
        return getBeanClassHasAlreadyBeConfiguredInXmlException;
    }

    @Override
    public final ConstraintDefinitionException getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000157: " + this.getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException$str() {
        return getValidationAppliesToParameterMustHaveReturnTypeConstraintTargetException;
    }

    @Override
    public final IllegalArgumentException getStartIndexCannotBeNegativeException(int startIndex) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000068: " + this.getStartIndexCannotBeNegativeException$str(), startIndex));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getStartIndexCannotBeNegativeException$str() {
        return getStartIndexCannotBeNegativeException;
    }

    @Override
    public final ClassCastException getUnableToNarrowNodeTypeException(String actualDescriptorType, ElementKind kind, String expectedDescriptorType) {
        ClassCastException result = new ClassCastException(String.format("HV000118: " + this.getUnableToNarrowNodeTypeException$str(), actualDescriptorType, kind, expectedDescriptorType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToNarrowNodeTypeException$str() {
        return getUnableToNarrowNodeTypeException;
    }

    @Override
    public final ValidationException getAtLeastOneCustomMessageMustBeCreatedException() {
        ValidationException result = new ValidationException(String.format("HV000033: " + this.getAtLeastOneCustomMessageMustBeCreatedException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAtLeastOneCustomMessageMustBeCreatedException$str() {
        return getAtLeastOneCustomMessageMustBeCreatedException;
    }

    @Override
    public final IndexOutOfBoundsException getInvalidIndexException(String lowerBound, String upperBound) {
        IndexOutOfBoundsException result = new IndexOutOfBoundsException(String.format("HV000049: " + this.getInvalidIndexException$str(), lowerBound, upperBound));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidIndexException$str() {
        return getInvalidIndexException;
    }

    @Override
    public final GroupDefinitionException getSequenceDefinitionsNotAllowedException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000046: " + this.getSequenceDefinitionsNotAllowedException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getSequenceDefinitionsNotAllowedException$str() {
        return getSequenceDefinitionsNotAllowedException;
    }

    @Override
    public final void unableToCreateSchema(String fileName, String message) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HV000011: " + this.unableToCreateSchema$str(), (Object)fileName, (Object)message);
    }

    protected String unableToCreateSchema$str() {
        return unableToCreateSchema;
    }

    @Override
    public final ValidationException getUnableToInstantiateValidationProviderClassException(String providerClassName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000099: " + this.getUnableToInstantiateValidationProviderClassException$str(), providerClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateValidationProviderClassException$str() {
        return getUnableToInstantiateValidationProviderClassException;
    }

    @Override
    public final ValidationException getMethodIsDefinedTwiceInMappingXmlForBeanException(String name, String beanClassName) {
        ValidationException result = new ValidationException(String.format("HV000137: " + this.getMethodIsDefinedTwiceInMappingXmlForBeanException$str(), name, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMethodIsDefinedTwiceInMappingXmlForBeanException$str() {
        return getMethodIsDefinedTwiceInMappingXmlForBeanException;
    }

    @Override
    public final void evaluatingExpressionLanguageExpressionCausedException(String expression, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HV000148: " + this.evaluatingExpressionLanguageExpressionCausedException$str(), (Object)expression);
    }

    protected String evaluatingExpressionLanguageExpressionCausedException$str() {
        return evaluatingExpressionLanguageExpressionCausedException;
    }

    @Override
    public final ValidationException getUnexpectedParameterValueException() {
        ValidationException result = new ValidationException(String.format("HV000109: " + this.getUnexpectedParameterValueException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final ValidationException getUnableToRetrieveAnnotationParameterValueException(Exception e) {
        ValidationException result = new ValidationException(String.format("HV000059: " + this.getUnableToRetrieveAnnotationParameterValueException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToRetrieveAnnotationParameterValueException$str() {
        return getUnableToRetrieveAnnotationParameterValueException;
    }

    @Override
    public final ConstraintDefinitionException getWrongDefaultValueForPayloadParameterException(String constraintName) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000075: " + this.getWrongDefaultValueForPayloadParameterException$str(), constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongDefaultValueForPayloadParameterException$str() {
        return getWrongDefaultValueForPayloadParameterException;
    }

    @Override
    public final ConstraintDeclarationException getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException(Member method1, Member method2) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000161: " + this.getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException$str(), method1, method2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException$str() {
        return getMethodsFromParallelTypesMustNotDefineGroupConversionsForCascadedReturnValueException;
    }

    @Override
    public final IllegalStateException getParameterNodeAddedForNonCrossParameterConstraintException(Path path) {
        IllegalStateException result = new IllegalStateException(String.format("HV000146: " + this.getParameterNodeAddedForNonCrossParameterConstraintException$str(), path));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getParameterNodeAddedForNonCrossParameterConstraintException$str() {
        return getParameterNodeAddedForNonCrossParameterConstraintException;
    }

    @Override
    public final ValidationException getUnableToDetermineSchemaVersionException(String file, XMLStreamException e) {
        ValidationException result = new ValidationException(String.format("HV000121: " + this.getUnableToDetermineSchemaVersionException$str(), file), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToDetermineSchemaVersionException$str() {
        return "Unable to parse %s.";
    }

    @Override
    public final ValidationException getErrorParsingMappingFileException(JAXBException e) {
        ValidationException result = new ValidationException(String.format("HV000115: " + this.getErrorParsingMappingFileException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorParsingMappingFileException$str() {
        return getErrorParsingMappingFileException;
    }

    @Override
    public final ValidationException getUnableToParseValidationXmlFileException(String file, JAXBException e) {
        ValidationException result = new ValidationException(String.format("HV000100: " + this.getUnableToParseValidationXmlFileException$str(), file), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToParseValidationXmlFileException$str() {
        return "Unable to parse %s.";
    }

    @Override
    public final NumberFormatException getCharacterIsNotADigitException(char c) {
        NumberFormatException result = new NumberFormatException(String.format("HV000072: " + this.getCharacterIsNotADigitException$str(), Character.valueOf(c)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCharacterIsNotADigitException$str() {
        return getCharacterIsNotADigitException;
    }

    @Override
    public final void unknownPropertyInExpressionLanguage(String expression, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HV000129: " + this.unknownPropertyInExpressionLanguage$str(), (Object)expression);
    }

    protected String unknownPropertyInExpressionLanguage$str() {
        return unknownPropertyInExpressionLanguage;
    }

    public final ValidationException getUnableToInstantiateException(String message, Class clazz, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000064: " + this.getUnableToInstantiateException2$str(), message, clazz), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateException2$str() {
        return getUnableToInstantiateException2;
    }

    @Override
    public final ValidationException getNullIsAnInvalidTypeForAConstraintValidatorException() {
        ValidationException result = new ValidationException(String.format("HV000093: " + this.getNullIsAnInvalidTypeForAConstraintValidatorException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNullIsAnInvalidTypeForAConstraintValidatorException$str() {
        return getNullIsAnInvalidTypeForAConstraintValidatorException;
    }

    @Override
    public final ValidationException getExceptionOcurredDuringMessageInterpolationException(Exception e) {
        ValidationException result = new ValidationException(String.format("HV000149: " + this.getExceptionOcurredDuringMessageInterpolationException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getExceptionOcurredDuringMessageInterpolationException$str() {
        return getExceptionOcurredDuringMessageInterpolationException;
    }

    @Override
    public final IllegalArgumentException getNoValueProvidedForAnnotationParameterException(String parameterName, String annotation) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000085: " + this.getNoValueProvidedForAnnotationParameterException$str(), parameterName, annotation));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getNoValueProvidedForAnnotationParameterException$str() {
        return getNoValueProvidedForAnnotationParameterException;
    }

    @Override
    public final ValidationException getInvalidNumberFormatException(String formatName, NumberFormatException e) {
        ValidationException result = new ValidationException(String.format("HV000110: " + this.getInvalidNumberFormatException$str(), formatName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidNumberFormatException$str() {
        return getInvalidNumberFormatException;
    }

    @Override
    public final ValidationException getUnableToLoadClassException(String className, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000065: " + this.getUnableToLoadClassException$str(), className), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void unableToLoadProviderClass(String providerName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HV000009: " + this.unableToLoadProviderClass$str(), (Object)providerName);
    }

    protected String unableToLoadProviderClass$str() {
        return unableToLoadProviderClass;
    }

    @Override
    public final ConstraintDefinitionException getCrossParameterConstraintHasNoValidatorException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000154: " + this.getCrossParameterConstraintHasNoValidatorException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCrossParameterConstraintHasNoValidatorException$str() {
        return getCrossParameterConstraintHasNoValidatorException;
    }

    @Override
    public final ValidationException getWrongParameterTypeException(String expectedType, String currentType) {
        ValidationException result = new ValidationException(String.format("HV000082: " + this.getWrongParameterTypeException$str(), expectedType, currentType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongParameterTypeException$str() {
        return getWrongParameterTypeException;
    }

    public final ConstraintDeclarationException getMultipleGroupConversionsForSameSourceException(Class from, Set tos) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000124: " + this.getMultipleGroupConversionsForSameSourceException$str(), from, tos));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMultipleGroupConversionsForSameSourceException$str() {
        return getMultipleGroupConversionsForSameSourceException;
    }

    @Override
    public final IllegalArgumentException getLengthCannotBeNegativeException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000021: " + this.getLengthCannotBeNegativeException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getLengthCannotBeNegativeException$str() {
        return getLengthCannotBeNegativeException;
    }

    @Override
    public final ConstraintDeclarationException getVoidMethodsMustNotBeConstrainedException(Member member) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000132: " + this.getVoidMethodsMustNotBeConstrainedException$str(), member));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getVoidMethodsMustNotBeConstrainedException$str() {
        return getVoidMethodsMustNotBeConstrainedException;
    }

    @Override
    public final ConstraintDefinitionException getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException(String constraint) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000159: " + this.getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException$str(), constraint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException$str() {
        return getValidationAppliesToParameterMustNotBeDefinedForNonGenericAndCrossParameterConstraintException;
    }

    @Override
    public final IllegalArgumentException getAtLeastOneGroupHasToBeSpecifiedException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000044: " + this.getAtLeastOneGroupHasToBeSpecifiedException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAtLeastOneGroupHasToBeSpecifiedException$str() {
        return getAtLeastOneGroupHasToBeSpecifiedException;
    }

    @Override
    public final ValidationException getUnableToInstantiateException(String className, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000063: " + this.getUnableToInstantiateException1$str(), className), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToInstantiateException1$str() {
        return getUnableToInstantiateException1;
    }

    @Override
    public final ValidationException getValidateOnExecutionOnOverriddenOrInterfaceMethodException(Method m) {
        ValidationException result = new ValidationException(String.format("HV000166: " + this.getValidateOnExecutionOnOverriddenOrInterfaceMethodException$str(), m));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getValidateOnExecutionOnOverriddenOrInterfaceMethodException$str() {
        return getValidateOnExecutionOnOverriddenOrInterfaceMethodException;
    }

    @Override
    public final ValidationException getInvalidParameterTypeException(String type, String beanClassName) {
        ValidationException result = new ValidationException(String.format("HV000134: " + this.getInvalidParameterTypeException$str(), type, beanClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidParameterTypeException$str() {
        return getInvalidParameterTypeException;
    }

    @Override
    public final ValidationException getInconsistentFailFastConfigurationException() {
        ValidationException result = new ValidationException(String.format("HV000037: " + this.getInconsistentFailFastConfigurationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInconsistentFailFastConfigurationException$str() {
        return getInconsistentFailFastConfigurationException;
    }

    @Override
    public final ValidationException getInconsistentConfigurationException() {
        ValidationException result = new ValidationException(String.format("HV000026: " + this.getInconsistentConfigurationException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInconsistentConfigurationException$str() {
        return getInconsistentConfigurationException;
    }

    @Override
    public final ConstraintDeclarationException getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException(Member member1, Member member2) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000131: " + this.getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException$str(), member1, member2));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException$str() {
        return getMethodReturnValueMustNotBeMarkedMoreThanOnceForCascadedValidationException;
    }

    @Override
    public final ConstraintDeclarationException getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException(String constraint, ConstraintTarget target) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000153: " + this.getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException$str(), constraint, target));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException$str() {
        return getParametersOrReturnValueConstraintTargetGivenAtNonExecutableException;
    }

    @Override
    public final ValidationException getErrorDuringCallOfTraversableResolverIsCascadableException(RuntimeException e) {
        ValidationException result = new ValidationException(String.format("HV000042: " + this.getErrorDuringCallOfTraversableResolverIsCascadableException$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getErrorDuringCallOfTraversableResolverIsCascadableException$str() {
        return getErrorDuringCallOfTraversableResolverIsCascadableException;
    }

    @Override
    public final ConstraintDeclarationException getCrossParameterConstraintOnFieldException(String constraint, String field) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000144: " + this.getCrossParameterConstraintOnFieldException$str(), constraint, field));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCrossParameterConstraintOnFieldException$str() {
        return getCrossParameterConstraintOnFieldException;
    }

    public final ConstraintDeclarationException getGroupConversionForSequenceException(Class from) {
        ConstraintDeclarationException result = new ConstraintDeclarationException(String.format("HV000127: " + this.getGroupConversionForSequenceException$str(), from));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getGroupConversionForSequenceException$str() {
        return getGroupConversionForSequenceException;
    }

    @Override
    public final ValidationException getInvalidPropertyValueException(String propertyName, String propertyValue, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000117: " + this.getInvalidPropertyValueException$str(), propertyName, propertyValue), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidPropertyValueException$str() {
        return getInvalidPropertyValueException;
    }

    @Override
    public final ConstraintDefinitionException getWrongTypeForMessageParameterException(String constraintName) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000079: " + this.getWrongTypeForMessageParameterException$str(), constraintName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getWrongTypeForMessageParameterException$str() {
        return getWrongTypeForMessageParameterException;
    }

    @Override
    public final ValidationException getBeanDoesNotContainTheFieldException(String beanClassName, String fieldName) {
        ValidationException result = new ValidationException(String.format("HV000105: " + this.getBeanDoesNotContainTheFieldException$str(), beanClassName, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanDoesNotContainTheFieldException$str() {
        return getBeanDoesNotContainTheFieldException;
    }

    @Override
    public final IllegalArgumentException getInvalidPropertyPathException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000038: " + this.getInvalidPropertyPathException0$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidPropertyPathException0$str() {
        return getInvalidPropertyPathException0;
    }

    @Override
    public final GroupDefinitionException getCyclicDependencyInGroupsDefinitionException() {
        GroupDefinitionException result = new GroupDefinitionException(String.format("HV000047: " + this.getCyclicDependencyInGroupsDefinitionException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getCyclicDependencyInGroupsDefinitionException$str() {
        return getCyclicDependencyInGroupsDefinitionException;
    }

    public final IllegalArgumentException getHasToBeAPrimitiveTypeException(Class clazz) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000091: " + this.getHasToBeAPrimitiveTypeException$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getHasToBeAPrimitiveTypeException$str() {
        return getHasToBeAPrimitiveTypeException;
    }

    @Override
    public final IllegalArgumentException getInvalidLengthForIntegerPartException() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HV000017: " + this.getInvalidLengthForIntegerPartException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getInvalidLengthForIntegerPartException$str() {
        return getInvalidLengthForIntegerPartException;
    }

    @Override
    public final void parsingXMLFile(String fileName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HV000007: " + this.parsingXMLFile$str(), (Object)fileName);
    }

    protected String parsingXMLFile$str() {
        return parsingXMLFile;
    }

    public final ValidationException getUnableToInstantiateException(Class clazz, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000063: " + this.getUnableToInstantiateException1$str(), clazz), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    public final ConstraintDefinitionException getAnnotationIsNoConstraintTypeException(Class annotationType) {
        ConstraintDefinitionException result = new ConstraintDefinitionException(String.format("HV000128: " + this.getAnnotationIsNoConstraintTypeException$str(), annotationType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getAnnotationIsNoConstraintTypeException$str() {
        return getAnnotationIsNoConstraintTypeException;
    }

    @Override
    public final ValidationException getBeanDoesNotContainThePropertyException(String beanClassName, String getterName) {
        ValidationException result = new ValidationException(String.format("HV000106: " + this.getBeanDoesNotContainThePropertyException$str(), beanClassName, getterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getBeanDoesNotContainThePropertyException$str() {
        return getBeanDoesNotContainThePropertyException;
    }

    public final ValidationException getUnableToFindAnnotationConstraintsException(Class annotationClass) {
        ValidationException result = new ValidationException(String.format("HV000057: " + this.getUnableToFindAnnotationConstraintsException$str(), annotationClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToFindAnnotationConstraintsException$str() {
        return getUnableToFindAnnotationConstraintsException;
    }

    @Override
    public final ValidationException getUnableToGetAnnotationParameterException(String parameterName, String annotationName, Exception e) {
        ValidationException result = new ValidationException(String.format("HV000084: " + this.getUnableToGetAnnotationParameterException$str(), parameterName, annotationName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String getUnableToGetAnnotationParameterException$str() {
        return getUnableToGetAnnotationParameterException;
    }
}

