/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.ParameterNameProvider;
import org.hibernate.validator.cfg.context.ConstructorConstraintMappingContext;
import org.hibernate.validator.cfg.context.CrossParameterConstraintMappingContext;
import org.hibernate.validator.cfg.context.MethodConstraintMappingContext;
import org.hibernate.validator.cfg.context.ParameterConstraintMappingContext;
import org.hibernate.validator.cfg.context.ReturnValueConstraintMappingContext;
import org.hibernate.validator.internal.cfg.context.CrossParameterConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.ParameterConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.ReturnValueConstraintMappingContextImpl;
import org.hibernate.validator.internal.cfg.context.TypeConstraintMappingContextImpl;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.location.ExecutableConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ExecutableConstraintMappingContextImpl
implements ConstructorConstraintMappingContext,
MethodConstraintMappingContext {
    private static final Log log = LoggerFactory.make();
    private final TypeConstraintMappingContextImpl<?> typeContext;
    private final ExecutableElement executable;
    private final ParameterConstraintMappingContextImpl[] parameterContexts;
    private ReturnValueConstraintMappingContextImpl returnValueContext;
    private CrossParameterConstraintMappingContextImpl crossParameterContext;

    public ExecutableConstraintMappingContextImpl(TypeConstraintMappingContextImpl<?> typeContext, Constructor<?> constructor) {
        this(typeContext, ExecutableElement.forConstructor(constructor));
    }

    public ExecutableConstraintMappingContextImpl(TypeConstraintMappingContextImpl<?> typeContext, Method method) {
        this(typeContext, ExecutableElement.forMethod(method));
    }

    private ExecutableConstraintMappingContextImpl(TypeConstraintMappingContextImpl<?> typeContext, ExecutableElement executable) {
        this.typeContext = typeContext;
        this.executable = executable;
        this.parameterContexts = new ParameterConstraintMappingContextImpl[executable.getParameterTypes().length];
    }

    @Override
    public ParameterConstraintMappingContext parameter(int index) {
        if (index < 0 || index >= this.executable.getParameterTypes().length) {
            throw log.getInvalidExecutableParameterIndexException(this.executable.getAsString());
        }
        ParameterConstraintMappingContextImpl context = this.parameterContexts[index];
        if (context != null) {
            throw log.getParameterHasAlreadyBeConfiguredViaProgrammaticApiException(this.typeContext.getBeanClass().getName(), this.executable.getAsString(), index);
        }
        this.parameterContexts[index] = context = new ParameterConstraintMappingContextImpl(this, index);
        return context;
    }

    @Override
    public CrossParameterConstraintMappingContext crossParameter() {
        if (this.crossParameterContext != null) {
            throw log.getCrossParameterElementHasAlreadyBeConfiguredViaProgrammaticApiException(this.typeContext.getBeanClass().getName(), this.executable.getAsString());
        }
        this.crossParameterContext = new CrossParameterConstraintMappingContextImpl(this);
        return this.crossParameterContext;
    }

    @Override
    public ReturnValueConstraintMappingContext returnValue() {
        if (this.returnValueContext != null) {
            throw log.getReturnValueHasAlreadyBeConfiguredViaProgrammaticApiException(this.typeContext.getBeanClass().getName(), this.executable.getAsString());
        }
        this.returnValueContext = new ReturnValueConstraintMappingContextImpl(this);
        return this.returnValueContext;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public TypeConstraintMappingContextImpl<?> getTypeContext() {
        return this.typeContext;
    }

    public ConstrainedElement build(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider) {
        return new ConstrainedExecutable(ConfigurationSource.API, new ExecutableConstraintLocation(this.executable), this.getParameters(constraintHelper, parameterNameProvider), this.crossParameterContext != null ? this.crossParameterContext.getConstraints(constraintHelper) : Collections.emptySet(), this.returnValueContext != null ? this.returnValueContext.getConstraints(constraintHelper) : Collections.emptySet(), this.returnValueContext != null ? this.returnValueContext.getGroupConversions() : Collections.emptyMap(), this.returnValueContext != null ? this.returnValueContext.isCascading() : false);
    }

    private List<ConstrainedParameter> getParameters(ConstraintHelper constraintHelper, ParameterNameProvider parameterNameProvider) {
        ArrayList<ConstrainedParameter> constrainedParameters = CollectionHelper.newArrayList();
        for (int i = 0; i < this.parameterContexts.length; ++i) {
            ParameterConstraintMappingContextImpl parameter = this.parameterContexts[i];
            if (parameter != null) {
                constrainedParameters.add(parameter.build(constraintHelper, parameterNameProvider));
                continue;
            }
            constrainedParameters.add(new ConstrainedParameter(ConfigurationSource.API, new ExecutableConstraintLocation(this.executable, (Integer)i), this.executable.getParameterNames(parameterNameProvider).get(i)));
        }
        return constrainedParameters;
    }
}

