/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.util.List;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.constraints.LuhnCheck;
import org.hibernate.validator.internal.constraintvalidators.ModCheckBase;
import org.hibernate.validator.internal.util.ModUtil;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class LuhnCheckValidator
extends ModCheckBase
implements ConstraintValidator<LuhnCheck, CharSequence> {
    private static final Log log = LoggerFactory.make();

    public void initialize(LuhnCheck constraintAnnotation) {
        super.initialize(constraintAnnotation.startIndex(), constraintAnnotation.endIndex(), constraintAnnotation.checkDigitPosition(), constraintAnnotation.ignoreNonDigitCharacters());
    }

    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        int checkValue;
        int modResult = ModUtil.calculateLuhnMod10Check(digits);
        return modResult == (checkValue = this.extractDigit(checkDigit));
    }
}

