/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators;

import java.util.List;
import javax.validation.ConstraintValidator;
import org.hibernate.validator.constraints.Mod10Check;
import org.hibernate.validator.internal.constraintvalidators.ModCheckBase;
import org.hibernate.validator.internal.util.ModUtil;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class Mod10CheckValidator
extends ModCheckBase
implements ConstraintValidator<Mod10Check, CharSequence> {
    private static final Log log = LoggerFactory.make();
    private int multiplier;
    private int weight;

    public void initialize(Mod10Check constraintAnnotation) {
        super.initialize(constraintAnnotation.startIndex(), constraintAnnotation.endIndex(), constraintAnnotation.checkDigitPosition(), constraintAnnotation.ignoreNonDigitCharacters());
        this.multiplier = constraintAnnotation.multiplier();
        this.weight = constraintAnnotation.weight();
        if (this.multiplier < 0) {
            throw log.getMultiplierCannotBeNegativeException(this.multiplier);
        }
        if (this.weight < 0) {
            throw log.getWeightCannotBeNegativeException(this.weight);
        }
    }

    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        int modResult = ModUtil.calculateMod10Check(digits, this.multiplier, this.weight);
        int checkValue = this.extractDigit(checkDigit);
        return modResult < 10 ? checkValue == modResult : checkValue == 0;
    }
}

