/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * JBoss, Home of Professional Open Source
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.hibernate.hql.ast.spi;

import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.hibernate.hql.ast.origin.hql.parse.HQLParser;
import org.hibernate.hql.ast.origin.hql.resolve.GeneratedHQLResolver;

/**
 * An {@link AstProcessor} which resolves the elements a given source query into an output query, by invoking
 * {@link QueryResolverDelegate} while traversing the given query tree.
 * </p>
 * Input: Parse tree as created by {@link HQLParser}</br>
 * Output: Normalized parse tree
 *
 * @author Gunnar Morling
 */
public class QueryResolverProcessor implements AstProcessor {

	private final QueryResolverDelegate delegate;

	public QueryResolverProcessor(QueryResolverDelegate delegate) {
		this.delegate = delegate;
	}

	@Override
	public CommonTree process(TokenStream tokens, CommonTree tree) throws RecognitionException {
		CommonTreeNodeStream treeNodeStream = new CommonTreeNodeStream( tree );
		treeNodeStream.setTokenStream( tokens );

		return (CommonTree) new GeneratedHQLResolver( treeNodeStream, delegate ).statement().getTree();
	}
}
