// $ANTLR 3.4 org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g 2014-02-14 22:38:27

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.origin.hql.resolve;

import org.antlr.runtime.tree.CommonTree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.tree.PropertyPathTree;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class GeneratedHQLResolver extends TreeParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "WHEN", "WHERE", "WITH", "WS", "YEAR"
    };

    public static final int EOF=-1;
    public static final int ABS=4;
    public static final int ALIAS_NAME=5;
    public static final int ALIAS_REF=6;
    public static final int ALL=7;
    public static final int AMPERSAND=8;
    public static final int AND=9;
    public static final int ANY=10;
    public static final int ARROW=11;
    public static final int AS=12;
    public static final int ASTERISK=13;
    public static final int AVG=14;
    public static final int BETWEEN=15;
    public static final int BETWEEN_LIST=16;
    public static final int BIT_LENGTH=17;
    public static final int BOTH=18;
    public static final int CAST=19;
    public static final int CHARACTER_LENGTH=20;
    public static final int CHARACTER_LITERAL=21;
    public static final int CLASS=22;
    public static final int COALESCE=23;
    public static final int COLLATE=24;
    public static final int COLLECTION_EXPRESSION=25;
    public static final int COLON=26;
    public static final int COLUMN=27;
    public static final int COLUMN_LIST=28;
    public static final int COMMA=29;
    public static final int CONCAT=30;
    public static final int CONST_STRING_VALUE=31;
    public static final int COUNT=32;
    public static final int CROSS=33;
    public static final int CURRENT_DATE=34;
    public static final int CURRENT_TIME=35;
    public static final int CURRENT_TIMESTAMP=36;
    public static final int DAY=37;
    public static final int DECIMAL_LITERAL=38;
    public static final int DELETE=39;
    public static final int DISTINCT=40;
    public static final int DOT=41;
    public static final int DOT_CLASS=42;
    public static final int DOUBLE_PIPE=43;
    public static final int DYNAMIC_INSTANTIATION=44;
    public static final int DYNAMIC_INSTANTIATION_ARG=45;
    public static final int ELEMENTS=46;
    public static final int ELSE=47;
    public static final int END=48;
    public static final int ENTITY_NAME=49;
    public static final int ENTITY_PERSISTER_REF=50;
    public static final int EOL=51;
    public static final int EQUALS=52;
    public static final int ESCAPE=53;
    public static final int ESCAPE_SEQUENCE=54;
    public static final int EXCEPT=55;
    public static final int EXISTS=56;
    public static final int EXPONENT=57;
    public static final int EXTRACT=58;
    public static final int FALSE=59;
    public static final int FETCH=60;
    public static final int FILTER=61;
    public static final int FLOATING_POINT_LITERAL=62;
    public static final int FLOAT_TYPE_SUFFIX=63;
    public static final int FROM=64;
    public static final int FULL=65;
    public static final int FUNCTION=66;
    public static final int GREATER=67;
    public static final int GREATER_EQUAL=68;
    public static final int GROUPING_VALUE=69;
    public static final int GROUP_BY=70;
    public static final int HAVING=71;
    public static final int HEX_DIGIT=72;
    public static final int HEX_LITERAL=73;
    public static final int HOUR=74;
    public static final int IDENTIFIER=75;
    public static final int IN=76;
    public static final int INDEX=77;
    public static final int INDICES=78;
    public static final int INNER=79;
    public static final int INSERT=80;
    public static final int INSERTABILITY_SPEC=81;
    public static final int INTEGER_LITERAL=82;
    public static final int INTEGER_TYPE_SUFFIX=83;
    public static final int INTERSECT=84;
    public static final int INTO=85;
    public static final int IN_LIST=86;
    public static final int IS=87;
    public static final int IS_EMPTY=88;
    public static final int IS_NOT_EMPTY=89;
    public static final int IS_NOT_NULL=90;
    public static final int IS_NULL=91;
    public static final int JAVA_CONSTANT=92;
    public static final int JOIN=93;
    public static final int JPA_PARAM=94;
    public static final int LEADING=95;
    public static final int LEFT=96;
    public static final int LEFT_PAREN=97;
    public static final int LEFT_SQUARE=98;
    public static final int LENGTH=99;
    public static final int LESS=100;
    public static final int LESS_EQUAL=101;
    public static final int LIKE=102;
    public static final int LOCATE=103;
    public static final int LOWER=104;
    public static final int MAX=105;
    public static final int MAXELEMENT=106;
    public static final int MAXINDEX=107;
    public static final int MEMBER_OF=108;
    public static final int MIN=109;
    public static final int MINELEMENT=110;
    public static final int MININDEX=111;
    public static final int MINUS=112;
    public static final int MINUTE=113;
    public static final int MOD=114;
    public static final int MONTH=115;
    public static final int NAMED_PARAM=116;
    public static final int NEW=117;
    public static final int NOT=118;
    public static final int NOT_BETWEEN=119;
    public static final int NOT_EQUAL=120;
    public static final int NOT_IN=121;
    public static final int NOT_LIKE=122;
    public static final int NOT_MEMBER_OF=123;
    public static final int NULL=124;
    public static final int NULLIF=125;
    public static final int OCTAL_ESCAPE=126;
    public static final int OCTAL_LITERAL=127;
    public static final int OCTET_LENGTH=128;
    public static final int ON=129;
    public static final int OR=130;
    public static final int ORDER_BY=131;
    public static final int ORDER_SPEC=132;
    public static final int OUTER=133;
    public static final int PARAM=134;
    public static final int PATH=135;
    public static final int PERCENT=136;
    public static final int PERSISTER_JOIN=137;
    public static final int PERSISTER_SPACE=138;
    public static final int PIPE=139;
    public static final int PLUS=140;
    public static final int POSITION=141;
    public static final int PROPERTIES=142;
    public static final int PROPERTY_JOIN=143;
    public static final int PROPERTY_REFERENCE=144;
    public static final int PROP_FETCH=145;
    public static final int QUALIFIED_JOIN=146;
    public static final int QUERY=147;
    public static final int QUERY_SPEC=148;
    public static final int QUOTED_IDENTIFIER=149;
    public static final int RIGHT=150;
    public static final int RIGHT_PAREN=151;
    public static final int RIGHT_SQUARE=152;
    public static final int SEARCHED_CASE=153;
    public static final int SECOND=154;
    public static final int SELECT=155;
    public static final int SELECT_FROM=156;
    public static final int SELECT_ITEM=157;
    public static final int SELECT_LIST=158;
    public static final int SEMICOLON=159;
    public static final int SET=160;
    public static final int SIMPLE_CASE=161;
    public static final int SIZE=162;
    public static final int SOLIDUS=163;
    public static final int SOME=164;
    public static final int SORT_SPEC=165;
    public static final int SQRT=166;
    public static final int STRING_LITERAL=167;
    public static final int SUBSTRING=168;
    public static final int SUB_QUERY=169;
    public static final int SUM=170;
    public static final int TABLE=171;
    public static final int THEN=172;
    public static final int TIMEZONE_HOUR=173;
    public static final int TIMEZONE_MINUTE=174;
    public static final int TRAILING=175;
    public static final int TRIM=176;
    public static final int TRUE=177;
    public static final int UNARY_MINUS=178;
    public static final int UNARY_PLUS=179;
    public static final int UNICODE_ESCAPE=180;
    public static final int UNION=181;
    public static final int UPDATE=182;
    public static final int UPPER=183;
    public static final int VECTOR_EXPR=184;
    public static final int VERSIONED=185;
    public static final int VERSIONED_VALUE=186;
    public static final int WHEN=187;
    public static final int WHERE=188;
    public static final int WITH=189;
    public static final int WS=190;
    public static final int YEAR=191;

    // delegates
    public TreeParser[] getDelegates() {
        return new TreeParser[] {};
    }

    // delegators


    public GeneratedHQLResolver(TreeNodeStream input) {
        this(input, new RecognizerSharedState());
    }
    public GeneratedHQLResolver(TreeNodeStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return GeneratedHQLResolver.tokenNames; }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g"; }


      private QueryResolverDelegate delegate;

      public GeneratedHQLResolver(TreeNodeStream input, QueryResolverDelegate delegate) {
        this(input, new RecognizerSharedState());
        this.delegate = delegate;
      }


    public static class filterStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "filterStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:60:1: filterStatement[String collectionRole] : ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) ;
    public final GeneratedHQLResolver.filterStatement_return filterStatement(String collectionRole) throws RecognitionException {
        GeneratedHQLResolver.filterStatement_return retval = new GeneratedHQLResolver.filterStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY1=null;
        CommonTree QUERY_SPEC2=null;
        CommonTree FILTER3=null;
        GeneratedHQLResolver.selectClause_return selectClause4 =null;

        GeneratedHQLResolver.whereClause_return whereClause5 =null;

        GeneratedHQLResolver.groupByClause_return groupByClause6 =null;

        GeneratedHQLResolver.havingClause_return havingClause7 =null;

        GeneratedHQLResolver.orderByClause_return orderByClause8 =null;


        CommonTree QUERY1_tree=null;
        CommonTree QUERY_SPEC2_tree=null;
        CommonTree FILTER3_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:61:2: ( ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:61:4: ^( QUERY ^( QUERY_SPEC FILTER ( selectClause )? ( whereClause )? ( groupByClause ( havingClause )? )? ( orderByClause )? ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY1=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_filterStatement62); 


            if ( _first_0==null ) _first_0 = QUERY1;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            QUERY_SPEC2=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_filterStatement65); 


            if ( _first_1==null ) _first_1 = QUERY_SPEC2;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            FILTER3=(CommonTree)match(input,FILTER,FOLLOW_FILTER_in_filterStatement67); 
             
            if ( _first_2==null ) _first_2 = FILTER3;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:5: ( selectClause )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==SELECT) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:5: selectClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_selectClause_in_filterStatement73);
                    selectClause4=selectClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = selectClause4.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:19: ( whereClause )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==WHERE) ) {
                alt2=1;
            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:19: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_filterStatement76);
                    whereClause5=whereClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = whereClause5.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:32: ( groupByClause ( havingClause )? )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0==GROUP_BY) ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:34: groupByClause ( havingClause )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupByClause_in_filterStatement81);
                    groupByClause6=groupByClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = groupByClause6.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:48: ( havingClause )?
                    int alt3=2;
                    int LA3_0 = input.LA(1);

                    if ( (LA3_0==HAVING) ) {
                        alt3=1;
                    }
                    switch (alt3) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:48: havingClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_havingClause_in_filterStatement83);
                            havingClause7=havingClause();

                            state._fsp--;

                             
                            if ( _first_2==null ) _first_2 = havingClause7.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:64: ( orderByClause )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==ORDER_BY) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:62:64: orderByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderByClause_in_filterStatement88);
                    orderByClause8=orderByClause();

                    state._fsp--;

                     
                    if ( _first_2==null ) _first_2 = orderByClause8.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "filterStatement"


    public static class statement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:65:1: statement : ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet );
    public final GeneratedHQLResolver.statement_return statement() throws RecognitionException {
        GeneratedHQLResolver.statement_return retval = new GeneratedHQLResolver.statement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.updateStatementSet_return updateStatementSet9 =null;

        GeneratedHQLResolver.deleteStatementSet_return deleteStatementSet10 =null;

        GeneratedHQLResolver.insertStatementSet_return insertStatementSet11 =null;

        GeneratedHQLResolver.queryStatementSet_return queryStatementSet12 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:66:2: ( updateStatementSet | deleteStatementSet | insertStatementSet | queryStatementSet )
            int alt6=4;
            switch ( input.LA(1) ) {
            case UPDATE:
                {
                alt6=1;
                }
                break;
            case DELETE:
                {
                alt6=2;
                }
                break;
            case INSERT:
                {
                alt6=3;
                }
                break;
            case QUERY:
                {
                alt6=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:66:4: updateStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_updateStatementSet_in_statement102);
                    updateStatementSet9=updateStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = updateStatementSet9.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:67:4: deleteStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_deleteStatementSet_in_statement107);
                    deleteStatementSet10=deleteStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = deleteStatementSet10.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:68:4: insertStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_insertStatementSet_in_statement112);
                    insertStatementSet11=insertStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = insertStatementSet11.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:69:4: queryStatementSet
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryStatementSet_in_statement117);
                    queryStatementSet12=queryStatementSet();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = queryStatementSet12.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class updateStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:72:1: updateStatementSet : ( updateStatement )+ ;
    public final GeneratedHQLResolver.updateStatementSet_return updateStatementSet() throws RecognitionException {
        GeneratedHQLResolver.updateStatementSet_return retval = new GeneratedHQLResolver.updateStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.updateStatement_return updateStatement13 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:2: ( ( updateStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:4: ( updateStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:4: ( updateStatement )+
            int cnt7=0;
            loop7:
            do {
                int alt7=2;
                int LA7_0 = input.LA(1);

                if ( (LA7_0==UPDATE) ) {
                    alt7=1;
                }


                switch (alt7) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:73:4: updateStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_updateStatement_in_updateStatementSet128);
            	    updateStatement13=updateStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = updateStatement13.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt7 >= 1 ) break loop7;
                        EarlyExitException eee =
                            new EarlyExitException(7, input);
                        throw eee;
                }
                cnt7++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "updateStatementSet"


    public static class updateStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "updateStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:76:1: updateStatement : ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) ;
    public final GeneratedHQLResolver.updateStatement_return updateStatement() throws RecognitionException {
        GeneratedHQLResolver.updateStatement_return retval = new GeneratedHQLResolver.updateStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UPDATE14=null;
        CommonTree SET16=null;
        GeneratedHQLResolver.entityName_return entityName15 =null;

        GeneratedHQLResolver.assignment_return assignment17 =null;

        GeneratedHQLResolver.whereClause_return whereClause18 =null;


        CommonTree UPDATE14_tree=null;
        CommonTree SET16_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:2: ( ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:4: ^( UPDATE entityName ^( SET ( assignment )+ ) ( whereClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            UPDATE14=(CommonTree)match(input,UPDATE,FOLLOW_UPDATE_in_updateStatement141); 


            if ( _first_0==null ) _first_0 = UPDATE14;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_updateStatement143);
            entityName15=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName15.tree;


            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            SET16=(CommonTree)match(input,SET,FOLLOW_SET_in_updateStatement146); 


            if ( _first_1==null ) _first_1 = SET16;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:30: ( assignment )+
            int cnt8=0;
            loop8:
            do {
                int alt8=2;
                int LA8_0 = input.LA(1);

                if ( (LA8_0==EQUALS) ) {
                    alt8=1;
                }


                switch (alt8) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:30: assignment
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_assignment_in_updateStatement148);
            	    assignment17=assignment();

            	    state._fsp--;

            	     
            	    if ( _first_2==null ) _first_2 = assignment17.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt8 >= 1 ) break loop8;
                        EarlyExitException eee =
                            new EarlyExitException(8, input);
                        throw eee;
                }
                cnt8++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:43: ( whereClause )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==WHERE) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:77:43: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_updateStatement152);
                    whereClause18=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause18.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "updateStatement"


    public static class assignment_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "assignment"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:80:1: assignment : ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) );
    public final GeneratedHQLResolver.assignment_return assignment() throws RecognitionException {
        GeneratedHQLResolver.assignment_return retval = new GeneratedHQLResolver.assignment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EQUALS19=null;
        CommonTree EQUALS22=null;
        CommonTree VERSIONED_VALUE23=null;
        CommonTree STRING_LITERAL24=null;
        GeneratedHQLResolver.propertyReference_return propertyReference20 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression21 =null;


        CommonTree EQUALS19_tree=null;
        CommonTree EQUALS22_tree=null;
        CommonTree VERSIONED_VALUE23_tree=null;
        CommonTree STRING_LITERAL24_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:81:2: ( ^( EQUALS propertyReference valueExpression ) | ^( EQUALS VERSIONED_VALUE STRING_LITERAL ) )
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==EQUALS) ) {
                int LA10_1 = input.LA(2);

                if ( (LA10_1==DOWN) ) {
                    int LA10_2 = input.LA(3);

                    if ( (LA10_2==VERSIONED_VALUE) ) {
                        alt10=2;
                    }
                    else if ( (LA10_2==PROPERTY_REFERENCE) ) {
                        alt10=1;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 2, input);

                        throw nvae;

                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 10, 1, input);

                    throw nvae;

                }
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:81:4: ^( EQUALS propertyReference valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS19=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment166); 


                    if ( _first_0==null ) _first_0 = EQUALS19;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_assignment168);
                    propertyReference20=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference20.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_assignment170);
                    valueExpression21=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression21.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:82:4: ^( EQUALS VERSIONED_VALUE STRING_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS22=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_assignment177); 


                    if ( _first_0==null ) _first_0 = EQUALS22;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    VERSIONED_VALUE23=(CommonTree)match(input,VERSIONED_VALUE,FOLLOW_VERSIONED_VALUE_in_assignment179); 
                     
                    if ( _first_1==null ) _first_1 = VERSIONED_VALUE23;


                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL24=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_assignment181); 
                     
                    if ( _first_1==null ) _first_1 = STRING_LITERAL24;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "assignment"


    public static class deleteStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:85:1: deleteStatementSet : ( deleteStatement )+ ;
    public final GeneratedHQLResolver.deleteStatementSet_return deleteStatementSet() throws RecognitionException {
        GeneratedHQLResolver.deleteStatementSet_return retval = new GeneratedHQLResolver.deleteStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.deleteStatement_return deleteStatement25 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:2: ( ( deleteStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:4: ( deleteStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:4: ( deleteStatement )+
            int cnt11=0;
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( (LA11_0==DELETE) ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:86:4: deleteStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_deleteStatement_in_deleteStatementSet193);
            	    deleteStatement25=deleteStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = deleteStatement25.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt11 >= 1 ) break loop11;
                        EarlyExitException eee =
                            new EarlyExitException(11, input);
                        throw eee;
                }
                cnt11++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatementSet"


    public static class deleteStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "deleteStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:89:1: deleteStatement : ^( DELETE entityName ( whereClause )? ) ;
    public final GeneratedHQLResolver.deleteStatement_return deleteStatement() throws RecognitionException {
        GeneratedHQLResolver.deleteStatement_return retval = new GeneratedHQLResolver.deleteStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DELETE26=null;
        GeneratedHQLResolver.entityName_return entityName27 =null;

        GeneratedHQLResolver.whereClause_return whereClause28 =null;


        CommonTree DELETE26_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:2: ( ^( DELETE entityName ( whereClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:4: ^( DELETE entityName ( whereClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DELETE26=(CommonTree)match(input,DELETE,FOLLOW_DELETE_in_deleteStatement206); 


            if ( _first_0==null ) _first_0 = DELETE26;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_deleteStatement208);
            entityName27=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName27.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:24: ( whereClause )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==WHERE) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:90:24: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_deleteStatement210);
                    whereClause28=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause28.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "deleteStatement"


    public static class insertStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:93:1: insertStatementSet : ( insertStatement )+ ;
    public final GeneratedHQLResolver.insertStatementSet_return insertStatementSet() throws RecognitionException {
        GeneratedHQLResolver.insertStatementSet_return retval = new GeneratedHQLResolver.insertStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.insertStatement_return insertStatement29 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:2: ( ( insertStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:4: ( insertStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:4: ( insertStatement )+
            int cnt13=0;
            loop13:
            do {
                int alt13=2;
                int LA13_0 = input.LA(1);

                if ( (LA13_0==INSERT) ) {
                    alt13=1;
                }


                switch (alt13) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:94:4: insertStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_insertStatement_in_insertStatementSet223);
            	    insertStatement29=insertStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = insertStatement29.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt13 >= 1 ) break loop13;
                        EarlyExitException eee =
                            new EarlyExitException(13, input);
                        throw eee;
                }
                cnt13++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatementSet"


    public static class insertStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "insertStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:97:1: insertStatement : ^( INSERT intoClause queryStatementSet ) ;
    public final GeneratedHQLResolver.insertStatement_return insertStatement() throws RecognitionException {
        GeneratedHQLResolver.insertStatement_return retval = new GeneratedHQLResolver.insertStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INSERT30=null;
        GeneratedHQLResolver.intoClause_return intoClause31 =null;

        GeneratedHQLResolver.queryStatementSet_return queryStatementSet32 =null;


        CommonTree INSERT30_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:98:2: ( ^( INSERT intoClause queryStatementSet ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:98:4: ^( INSERT intoClause queryStatementSet )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INSERT30=(CommonTree)match(input,INSERT,FOLLOW_INSERT_in_insertStatement236); 


            if ( _first_0==null ) _first_0 = INSERT30;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_intoClause_in_insertStatement238);
            intoClause31=intoClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = intoClause31.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryStatementSet_in_insertStatement240);
            queryStatementSet32=queryStatementSet();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = queryStatementSet32.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "insertStatement"


    public static class intoClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intoClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:101:1: intoClause : ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) ;
    public final GeneratedHQLResolver.intoClause_return intoClause() throws RecognitionException {
        GeneratedHQLResolver.intoClause_return retval = new GeneratedHQLResolver.intoClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INTO33=null;
        CommonTree INSERTABILITY_SPEC35=null;
        GeneratedHQLResolver.entityName_return entityName34 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference36 =null;


        CommonTree INTO33_tree=null;
        CommonTree INSERTABILITY_SPEC35_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:2: ( ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:4: ^( INTO entityName ^( INSERTABILITY_SPEC ( propertyReference )+ ) )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INTO33=(CommonTree)match(input,INTO,FOLLOW_INTO_in_intoClause253); 


            if ( _first_0==null ) _first_0 = INTO33;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_intoClause255);
            entityName34=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName34.tree;


            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_2 = _last;
            CommonTree _first_2 = null;
            _last = (CommonTree)input.LT(1);
            INSERTABILITY_SPEC35=(CommonTree)match(input,INSERTABILITY_SPEC,FOLLOW_INSERTABILITY_SPEC_in_intoClause258); 


            if ( _first_1==null ) _first_1 = INSERTABILITY_SPEC35;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:43: ( propertyReference )+
            int cnt14=0;
            loop14:
            do {
                int alt14=2;
                int LA14_0 = input.LA(1);

                if ( (LA14_0==PROPERTY_REFERENCE) ) {
                    alt14=1;
                }


                switch (alt14) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:102:43: propertyReference
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_propertyReference_in_intoClause260);
            	    propertyReference36=propertyReference();

            	    state._fsp--;

            	     
            	    if ( _first_2==null ) _first_2 = propertyReference36.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt14 >= 1 ) break loop14;
                        EarlyExitException eee =
                            new EarlyExitException(14, input);
                        throw eee;
                }
                cnt14++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_2;
            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intoClause"


    public static class queryStatementSet_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryStatementSet"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:105:1: queryStatementSet : ( queryStatement )+ ;
    public final GeneratedHQLResolver.queryStatementSet_return queryStatementSet() throws RecognitionException {
        GeneratedHQLResolver.queryStatementSet_return retval = new GeneratedHQLResolver.queryStatementSet_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.queryStatement_return queryStatement37 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:2: ( ( queryStatement )+ )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:4: ( queryStatement )+
            {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:4: ( queryStatement )+
            int cnt15=0;
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( (LA15_0==QUERY) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:106:4: queryStatement
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_queryStatement_in_queryStatementSet276);
            	    queryStatement37=queryStatement();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = queryStatement37.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt15 >= 1 ) break loop15;
                        EarlyExitException eee =
                            new EarlyExitException(15, input);
                        throw eee;
                }
                cnt15++;
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryStatementSet"


    public static class queryStatement_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryStatement"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:109:1: queryStatement : ^( QUERY queryExpression ( orderByClause )? ) ;
    public final GeneratedHQLResolver.queryStatement_return queryStatement() throws RecognitionException {
        GeneratedHQLResolver.queryStatement_return retval = new GeneratedHQLResolver.queryStatement_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY38=null;
        GeneratedHQLResolver.queryExpression_return queryExpression39 =null;

        GeneratedHQLResolver.orderByClause_return orderByClause40 =null;


        CommonTree QUERY38_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:2: ( ^( QUERY queryExpression ( orderByClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:4: ^( QUERY queryExpression ( orderByClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY38=(CommonTree)match(input,QUERY,FOLLOW_QUERY_in_queryStatement289); 


            if ( _first_0==null ) _first_0 = QUERY38;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_queryExpression_in_queryStatement291);
            queryExpression39=queryExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = queryExpression39.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:28: ( orderByClause )?
            int alt16=2;
            int LA16_0 = input.LA(1);

            if ( (LA16_0==ORDER_BY) ) {
                alt16=1;
            }
            switch (alt16) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:110:28: orderByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_orderByClause_in_queryStatement293);
                    orderByClause40=orderByClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = orderByClause40.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryStatement"


    public static class queryExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "queryExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:113:1: queryExpression : ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec );
    public final GeneratedHQLResolver.queryExpression_return queryExpression() throws RecognitionException {
        GeneratedHQLResolver.queryExpression_return retval = new GeneratedHQLResolver.queryExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UNION41=null;
        CommonTree ALL42=null;
        CommonTree INTERSECT45=null;
        CommonTree ALL46=null;
        CommonTree EXCEPT49=null;
        CommonTree ALL50=null;
        GeneratedHQLResolver.queryExpression_return queryExpression43 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression44 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression47 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression48 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression51 =null;

        GeneratedHQLResolver.queryExpression_return queryExpression52 =null;

        GeneratedHQLResolver.querySpec_return querySpec53 =null;


        CommonTree UNION41_tree=null;
        CommonTree ALL42_tree=null;
        CommonTree INTERSECT45_tree=null;
        CommonTree ALL46_tree=null;
        CommonTree EXCEPT49_tree=null;
        CommonTree ALL50_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:2: ( ^( UNION ( ALL )? queryExpression queryExpression ) | ^( INTERSECT ( ALL )? queryExpression queryExpression ) | ^( EXCEPT ( ALL )? queryExpression queryExpression ) | querySpec )
            int alt20=4;
            switch ( input.LA(1) ) {
            case UNION:
                {
                alt20=1;
                }
                break;
            case INTERSECT:
                {
                alt20=2;
                }
                break;
            case EXCEPT:
                {
                alt20=3;
                }
                break;
            case QUERY_SPEC:
                {
                alt20=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 20, 0, input);

                throw nvae;

            }

            switch (alt20) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:4: ^( UNION ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNION41=(CommonTree)match(input,UNION,FOLLOW_UNION_in_queryExpression307); 


                    if ( _first_0==null ) _first_0 = UNION41;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:12: ( ALL )?
                    int alt17=2;
                    int LA17_0 = input.LA(1);

                    if ( (LA17_0==ALL) ) {
                        alt17=1;
                    }
                    switch (alt17) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:114:12: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL42=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression309); 
                             
                            if ( _first_1==null ) _first_1 = ALL42;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression312);
                    queryExpression43=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression43.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression314);
                    queryExpression44=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression44.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:115:4: ^( INTERSECT ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    INTERSECT45=(CommonTree)match(input,INTERSECT,FOLLOW_INTERSECT_in_queryExpression321); 


                    if ( _first_0==null ) _first_0 = INTERSECT45;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:115:16: ( ALL )?
                    int alt18=2;
                    int LA18_0 = input.LA(1);

                    if ( (LA18_0==ALL) ) {
                        alt18=1;
                    }
                    switch (alt18) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:115:16: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL46=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression323); 
                             
                            if ( _first_1==null ) _first_1 = ALL46;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression326);
                    queryExpression47=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression47.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression328);
                    queryExpression48=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression48.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:116:4: ^( EXCEPT ( ALL )? queryExpression queryExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EXCEPT49=(CommonTree)match(input,EXCEPT,FOLLOW_EXCEPT_in_queryExpression335); 


                    if ( _first_0==null ) _first_0 = EXCEPT49;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:116:13: ( ALL )?
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0==ALL) ) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:116:13: ALL
                            {
                            _last = (CommonTree)input.LT(1);
                            ALL50=(CommonTree)match(input,ALL,FOLLOW_ALL_in_queryExpression337); 
                             
                            if ( _first_1==null ) _first_1 = ALL50;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression340);
                    queryExpression51=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression51.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryExpression_in_queryExpression342);
                    queryExpression52=queryExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryExpression52.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:117:4: querySpec
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_querySpec_in_queryExpression348);
                    querySpec53=querySpec();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = querySpec53.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "queryExpression"


    public static class querySpec_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "querySpec"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:120:1: querySpec : ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) ;
    public final GeneratedHQLResolver.querySpec_return querySpec() throws RecognitionException {
        GeneratedHQLResolver.querySpec_return retval = new GeneratedHQLResolver.querySpec_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree QUERY_SPEC54=null;
        GeneratedHQLResolver.selectFrom_return selectFrom55 =null;

        GeneratedHQLResolver.whereClause_return whereClause56 =null;

        GeneratedHQLResolver.groupByClause_return groupByClause57 =null;

        GeneratedHQLResolver.havingClause_return havingClause58 =null;


        CommonTree QUERY_SPEC54_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:2: ( ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:4: ^( QUERY_SPEC selectFrom ( whereClause )? ( groupByClause )? ( havingClause )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            QUERY_SPEC54=(CommonTree)match(input,QUERY_SPEC,FOLLOW_QUERY_SPEC_in_querySpec360); 


            if ( _first_0==null ) _first_0 = QUERY_SPEC54;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_selectFrom_in_querySpec362);
            selectFrom55=selectFrom();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = selectFrom55.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:28: ( whereClause )?
            int alt21=2;
            int LA21_0 = input.LA(1);

            if ( (LA21_0==WHERE) ) {
                alt21=1;
            }
            switch (alt21) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:28: whereClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_whereClause_in_querySpec364);
                    whereClause56=whereClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = whereClause56.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:41: ( groupByClause )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0==GROUP_BY) ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:41: groupByClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_groupByClause_in_querySpec367);
                    groupByClause57=groupByClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = groupByClause57.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:56: ( havingClause )?
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==HAVING) ) {
                alt23=1;
            }
            switch (alt23) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:121:56: havingClause
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_havingClause_in_querySpec370);
                    havingClause58=havingClause();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = havingClause58.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "querySpec"


    public static class whereClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "whereClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:124:1: whereClause : ^( WHERE searchCondition ) ;
    public final GeneratedHQLResolver.whereClause_return whereClause() throws RecognitionException {
        GeneratedHQLResolver.whereClause_return retval = new GeneratedHQLResolver.whereClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHERE59=null;
        GeneratedHQLResolver.searchCondition_return searchCondition60 =null;


        CommonTree WHERE59_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:125:2: ( ^( WHERE searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:125:4: ^( WHERE searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHERE59=(CommonTree)match(input,WHERE,FOLLOW_WHERE_in_whereClause384); 


            if ( _first_0==null ) _first_0 = WHERE59;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_whereClause386);
            searchCondition60=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition60.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "whereClause"


    public static class groupByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupByClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:128:1: groupByClause : ^( GROUP_BY ( groupingValue )+ ) ;
    public final GeneratedHQLResolver.groupByClause_return groupByClause() throws RecognitionException {
        GeneratedHQLResolver.groupByClause_return retval = new GeneratedHQLResolver.groupByClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree GROUP_BY61=null;
        GeneratedHQLResolver.groupingValue_return groupingValue62 =null;


        CommonTree GROUP_BY61_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:2: ( ^( GROUP_BY ( groupingValue )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:4: ^( GROUP_BY ( groupingValue )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            GROUP_BY61=(CommonTree)match(input,GROUP_BY,FOLLOW_GROUP_BY_in_groupByClause399); 


            if ( _first_0==null ) _first_0 = GROUP_BY61;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:15: ( groupingValue )+
            int cnt24=0;
            loop24:
            do {
                int alt24=2;
                int LA24_0 = input.LA(1);

                if ( (LA24_0==GROUPING_VALUE) ) {
                    alt24=1;
                }


                switch (alt24) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:129:15: groupingValue
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_groupingValue_in_groupByClause401);
            	    groupingValue62=groupingValue();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = groupingValue62.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt24 >= 1 ) break loop24;
                        EarlyExitException eee =
                            new EarlyExitException(24, input);
                        throw eee;
                }
                cnt24++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupByClause"


    public static class groupingValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "groupingValue"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:132:1: groupingValue : ^( GROUPING_VALUE valueExpression ( COLLATE )? ) ;
    public final GeneratedHQLResolver.groupingValue_return groupingValue() throws RecognitionException {
        GeneratedHQLResolver.groupingValue_return retval = new GeneratedHQLResolver.groupingValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree GROUPING_VALUE63=null;
        CommonTree COLLATE65=null;
        GeneratedHQLResolver.valueExpression_return valueExpression64 =null;


        CommonTree GROUPING_VALUE63_tree=null;
        CommonTree COLLATE65_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:2: ( ^( GROUPING_VALUE valueExpression ( COLLATE )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:4: ^( GROUPING_VALUE valueExpression ( COLLATE )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            GROUPING_VALUE63=(CommonTree)match(input,GROUPING_VALUE,FOLLOW_GROUPING_VALUE_in_groupingValue415); 


            if ( _first_0==null ) _first_0 = GROUPING_VALUE63;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_groupingValue417);
            valueExpression64=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression64.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:37: ( COLLATE )?
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==COLLATE) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:133:37: COLLATE
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATE65=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_groupingValue419); 
                     
                    if ( _first_1==null ) _first_1 = COLLATE65;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "groupingValue"


    public static class havingClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "havingClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:136:1: havingClause : ^( HAVING searchCondition ) ;
    public final GeneratedHQLResolver.havingClause_return havingClause() throws RecognitionException {
        GeneratedHQLResolver.havingClause_return retval = new GeneratedHQLResolver.havingClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree HAVING66=null;
        GeneratedHQLResolver.searchCondition_return searchCondition67 =null;


        CommonTree HAVING66_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:137:2: ( ^( HAVING searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:137:4: ^( HAVING searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            HAVING66=(CommonTree)match(input,HAVING,FOLLOW_HAVING_in_havingClause433); 


            if ( _first_0==null ) _first_0 = HAVING66;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_havingClause435);
            searchCondition67=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition67.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "havingClause"


    public static class selectFrom_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectFrom"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:140:1: selectFrom : ^( SELECT_FROM fromClause selectClause ) ;
    public final GeneratedHQLResolver.selectFrom_return selectFrom() throws RecognitionException {
        GeneratedHQLResolver.selectFrom_return retval = new GeneratedHQLResolver.selectFrom_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT_FROM68=null;
        GeneratedHQLResolver.fromClause_return fromClause69 =null;

        GeneratedHQLResolver.selectClause_return selectClause70 =null;


        CommonTree SELECT_FROM68_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:141:2: ( ^( SELECT_FROM fromClause selectClause ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:141:4: ^( SELECT_FROM fromClause selectClause )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SELECT_FROM68=(CommonTree)match(input,SELECT_FROM,FOLLOW_SELECT_FROM_in_selectFrom448); 


            if ( _first_0==null ) _first_0 = SELECT_FROM68;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_fromClause_in_selectFrom450);
            fromClause69=fromClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = fromClause69.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_selectClause_in_selectFrom452);
            selectClause70=selectClause();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = selectClause70.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectFrom"


    public static class fromClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "fromClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:144:1: fromClause : ^( FROM ( persisterSpaces )+ ) ;
    public final GeneratedHQLResolver.fromClause_return fromClause() throws RecognitionException {
        GeneratedHQLResolver.fromClause_return retval = new GeneratedHQLResolver.fromClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FROM71=null;
        GeneratedHQLResolver.persisterSpaces_return persisterSpaces72 =null;


        CommonTree FROM71_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:2: ( ^( FROM ( persisterSpaces )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:4: ^( FROM ( persisterSpaces )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            FROM71=(CommonTree)match(input,FROM,FOLLOW_FROM_in_fromClause465); 


            if ( _first_0==null ) _first_0 = FROM71;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:11: ( persisterSpaces )+
            int cnt26=0;
            loop26:
            do {
                int alt26=2;
                int LA26_0 = input.LA(1);

                if ( (LA26_0==PERSISTER_SPACE) ) {
                    alt26=1;
                }


                switch (alt26) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:145:11: persisterSpaces
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_persisterSpaces_in_fromClause467);
            	    persisterSpaces72=persisterSpaces();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = persisterSpaces72.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt26 >= 1 ) break loop26;
                        EarlyExitException eee =
                            new EarlyExitException(26, input);
                        throw eee;
                }
                cnt26++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "fromClause"


    public static class persisterSpaces_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaces"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:148:1: persisterSpaces : ^( PERSISTER_SPACE persisterSpace ) ;
    public final GeneratedHQLResolver.persisterSpaces_return persisterSpaces() throws RecognitionException {
        GeneratedHQLResolver.persisterSpaces_return retval = new GeneratedHQLResolver.persisterSpaces_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PERSISTER_SPACE73=null;
        GeneratedHQLResolver.persisterSpace_return persisterSpace74 =null;


        CommonTree PERSISTER_SPACE73_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:149:2: ( ^( PERSISTER_SPACE persisterSpace ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:149:4: ^( PERSISTER_SPACE persisterSpace )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PERSISTER_SPACE73=(CommonTree)match(input,PERSISTER_SPACE,FOLLOW_PERSISTER_SPACE_in_persisterSpaces481); 


            if ( _first_0==null ) _first_0 = PERSISTER_SPACE73;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_persisterSpace_in_persisterSpaces483);
            persisterSpace74=persisterSpace();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = persisterSpace74.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaces"


    public static class persisterSpace_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpace"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:152:1: persisterSpace : persisterSpaceRoot ( joins )* ;
    public final GeneratedHQLResolver.persisterSpace_return persisterSpace() throws RecognitionException {
        GeneratedHQLResolver.persisterSpace_return retval = new GeneratedHQLResolver.persisterSpace_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot75 =null;

        GeneratedHQLResolver.joins_return joins76 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:2: ( persisterSpaceRoot ( joins )* )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:4: persisterSpaceRoot ( joins )*
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_persisterSpaceRoot_in_persisterSpace495);
            persisterSpaceRoot75=persisterSpaceRoot();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = persisterSpaceRoot75.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:23: ( joins )*
            loop27:
            do {
                int alt27=2;
                int LA27_0 = input.LA(1);

                if ( (LA27_0==PERSISTER_JOIN||LA27_0==PROPERTY_JOIN) ) {
                    alt27=1;
                }


                switch (alt27) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:153:23: joins
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_joins_in_persisterSpace497);
            	    joins76=joins();

            	    state._fsp--;

            	     
            	    if ( _first_0==null ) _first_0 = joins76.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    break loop27;
                }
            } while (true);


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpace"


    public static class persisterSpaceRoot_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "persisterSpaceRoot"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:156:1: persisterSpaceRoot : ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) ;
    public final GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot() throws RecognitionException {
        GeneratedHQLResolver.persisterSpaceRoot_return retval = new GeneratedHQLResolver.persisterSpaceRoot_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENTITY_PERSISTER_REF77=null;
        CommonTree PROP_FETCH79=null;
        GeneratedHQLResolver.entityName_return entityName78 =null;


        CommonTree ENTITY_PERSISTER_REF77_tree=null;
        CommonTree PROP_FETCH79_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:2: ( ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:4: ^( ENTITY_PERSISTER_REF entityName ( PROP_FETCH )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ENTITY_PERSISTER_REF77=(CommonTree)match(input,ENTITY_PERSISTER_REF,FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot510); 


            if ( _first_0==null ) _first_0 = ENTITY_PERSISTER_REF77;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_entityName_in_persisterSpaceRoot512);
            entityName78=entityName();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = entityName78.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:38: ( PROP_FETCH )?
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( (LA28_0==PROP_FETCH) ) {
                alt28=1;
            }
            switch (alt28) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:157:38: PROP_FETCH
                    {
                    _last = (CommonTree)input.LT(1);
                    PROP_FETCH79=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_persisterSpaceRoot514); 
                     
                    if ( _first_1==null ) _first_1 = PROP_FETCH79;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "persisterSpaceRoot"


    public static class joins_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joins"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:160:1: joins : ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | propertyReference ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) );
    public final GeneratedHQLResolver.joins_return joins() throws RecognitionException {
        GeneratedHQLResolver.joins_return retval = new GeneratedHQLResolver.joins_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ft=null;
        CommonTree an=null;
        CommonTree pf=null;
        CommonTree PROPERTY_JOIN80=null;
        CommonTree PERSISTER_JOIN84=null;
        GeneratedHQLResolver.joinType_return jt =null;

        GeneratedHQLResolver.collectionExpression_return collectionExpression81 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference82 =null;

        GeneratedHQLResolver.withClause_return withClause83 =null;

        GeneratedHQLResolver.joinType_return joinType85 =null;

        GeneratedHQLResolver.persisterSpaceRoot_return persisterSpaceRoot86 =null;

        GeneratedHQLResolver.onClause_return onClause87 =null;


        CommonTree ft_tree=null;
        CommonTree an_tree=null;
        CommonTree pf_tree=null;
        CommonTree PROPERTY_JOIN80_tree=null;
        CommonTree PERSISTER_JOIN84_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:2: ( ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | propertyReference ) ( withClause )? ) | ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? ) )
            int alt34=2;
            int LA34_0 = input.LA(1);

            if ( (LA34_0==PROPERTY_JOIN) ) {
                alt34=1;
            }
            else if ( (LA34_0==PERSISTER_JOIN) ) {
                alt34=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 34, 0, input);

                throw nvae;

            }
            switch (alt34) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:4: ^( PROPERTY_JOIN jt= joinType (ft= FETCH )? an= ALIAS_NAME (pf= PROP_FETCH )? ( collectionExpression | propertyReference ) ( withClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PROPERTY_JOIN80=(CommonTree)match(input,PROPERTY_JOIN,FOLLOW_PROPERTY_JOIN_in_joins528); 


                    if ( _first_0==null ) _first_0 = PROPERTY_JOIN80;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinType_in_joins532);
                    jt=joinType();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = jt.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:34: (ft= FETCH )?
                    int alt29=2;
                    int LA29_0 = input.LA(1);

                    if ( (LA29_0==FETCH) ) {
                        alt29=1;
                    }
                    switch (alt29) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:34: ft= FETCH
                            {
                            _last = (CommonTree)input.LT(1);
                            ft=(CommonTree)match(input,FETCH,FOLLOW_FETCH_in_joins536); 
                             
                            if ( _first_1==null ) _first_1 = ft;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    _last = (CommonTree)input.LT(1);
                    an=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_joins541); 
                     
                    if ( _first_1==null ) _first_1 = an;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:58: (pf= PROP_FETCH )?
                    int alt30=2;
                    int LA30_0 = input.LA(1);

                    if ( (LA30_0==PROP_FETCH) ) {
                        alt30=1;
                    }
                    switch (alt30) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:161:58: pf= PROP_FETCH
                            {
                            _last = (CommonTree)input.LT(1);
                            pf=(CommonTree)match(input,PROP_FETCH,FOLLOW_PROP_FETCH_in_joins545); 
                             
                            if ( _first_1==null ) _first_1 = pf;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    	delegate.pushFromStrategy((jt!=null?jt.joinType:null), ft, pf, an );	

                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:3: ( collectionExpression | propertyReference )
                    int alt31=2;
                    int LA31_0 = input.LA(1);

                    if ( (LA31_0==ELEMENTS||LA31_0==INDICES) ) {
                        alt31=1;
                    }
                    else if ( (LA31_0==PROPERTY_REFERENCE) ) {
                        alt31=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 31, 0, input);

                        throw nvae;

                    }
                    switch (alt31) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:4: collectionExpression
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_collectionExpression_in_joins555);
                            collectionExpression81=collectionExpression();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = collectionExpression81.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:25: propertyReference
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_propertyReference_in_joins557);
                            propertyReference82=propertyReference();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = propertyReference82.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:44: ( withClause )?
                    int alt32=2;
                    int LA32_0 = input.LA(1);

                    if ( (LA32_0==WITH) ) {
                        alt32=1;
                    }
                    switch (alt32) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:163:44: withClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_withClause_in_joins560);
                            withClause83=withClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = withClause83.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    	delegate.popStrategy();	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:165:4: ^( PERSISTER_JOIN joinType persisterSpaceRoot ( onClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PERSISTER_JOIN84=(CommonTree)match(input,PERSISTER_JOIN,FOLLOW_PERSISTER_JOIN_in_joins572); 


                    if ( _first_0==null ) _first_0 = PERSISTER_JOIN84;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_joinType_in_joins574);
                    joinType85=joinType();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = joinType85.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_persisterSpaceRoot_in_joins576);
                    persisterSpaceRoot86=persisterSpaceRoot();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = persisterSpaceRoot86.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:165:49: ( onClause )?
                    int alt33=2;
                    int LA33_0 = input.LA(1);

                    if ( (LA33_0==ON) ) {
                        alt33=1;
                    }
                    switch (alt33) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:165:49: onClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_onClause_in_joins578);
                            onClause87=onClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = onClause87.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joins"


    public static class withClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "withClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:168:1: withClause : ^( WITH searchCondition ) ;
    public final GeneratedHQLResolver.withClause_return withClause() throws RecognitionException {
        GeneratedHQLResolver.withClause_return retval = new GeneratedHQLResolver.withClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WITH88=null;
        GeneratedHQLResolver.searchCondition_return searchCondition89 =null;


        CommonTree WITH88_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:169:2: ( ^( WITH searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:169:4: ^( WITH searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WITH88=(CommonTree)match(input,WITH,FOLLOW_WITH_in_withClause592); 


            if ( _first_0==null ) _first_0 = WITH88;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_withClause594);
            searchCondition89=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition89.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "withClause"


    public static class onClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "onClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:172:1: onClause : ^( ON searchCondition ) ;
    public final GeneratedHQLResolver.onClause_return onClause() throws RecognitionException {
        GeneratedHQLResolver.onClause_return retval = new GeneratedHQLResolver.onClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ON90=null;
        GeneratedHQLResolver.searchCondition_return searchCondition91 =null;


        CommonTree ON90_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:173:2: ( ^( ON searchCondition ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:173:4: ^( ON searchCondition )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ON90=(CommonTree)match(input,ON,FOLLOW_ON_in_onClause607); 


            if ( _first_0==null ) _first_0 = ON90;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_onClause609);
            searchCondition91=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition91.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "onClause"


    public static class joinType_return extends TreeRuleReturnScope {
        public JoinType joinType;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "joinType"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:176:1: joinType returns [JoinType joinType] : ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? );
    public final GeneratedHQLResolver.joinType_return joinType() throws RecognitionException {
        GeneratedHQLResolver.joinType_return retval = new GeneratedHQLResolver.joinType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CROSS92=null;
        CommonTree INNER93=null;
        CommonTree LEFT94=null;
        CommonTree RIGHT95=null;
        CommonTree FULL96=null;
        CommonTree OUTER97=null;

        CommonTree CROSS92_tree=null;
        CommonTree INNER93_tree=null;
        CommonTree LEFT94_tree=null;
        CommonTree RIGHT95_tree=null;
        CommonTree FULL96_tree=null;
        CommonTree OUTER97_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:177:2: ( CROSS | INNER | ( LEFT | RIGHT | FULL ) ( OUTER )? )
            int alt37=3;
            switch ( input.LA(1) ) {
            case CROSS:
                {
                alt37=1;
                }
                break;
            case INNER:
                {
                alt37=2;
                }
                break;
            case FULL:
            case LEFT:
            case RIGHT:
                {
                alt37=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 37, 0, input);

                throw nvae;

            }

            switch (alt37) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:177:4: CROSS
                    {
                    _last = (CommonTree)input.LT(1);
                    CROSS92=(CommonTree)match(input,CROSS,FOLLOW_CROSS_in_joinType625); 
                     
                    if ( _first_0==null ) _first_0 = CROSS92;


                    	retval.joinType = JoinType.CROSS;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:178:4: INNER
                    {
                    _last = (CommonTree)input.LT(1);
                    INNER93=(CommonTree)match(input,INNER,FOLLOW_INNER_in_joinType632); 
                     
                    if ( _first_0==null ) _first_0 = INNER93;


                    	retval.joinType = JoinType.INNER;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:4: ( LEFT | RIGHT | FULL ) ( OUTER )?
                    {
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:4: ( LEFT | RIGHT | FULL )
                    int alt35=3;
                    switch ( input.LA(1) ) {
                    case LEFT:
                        {
                        alt35=1;
                        }
                        break;
                    case RIGHT:
                        {
                        alt35=2;
                        }
                        break;
                    case FULL:
                        {
                        alt35=3;
                        }
                        break;
                    default:
                        NoViableAltException nvae =
                            new NoViableAltException("", 35, 0, input);

                        throw nvae;

                    }

                    switch (alt35) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:5: LEFT
                            {
                            _last = (CommonTree)input.LT(1);
                            LEFT94=(CommonTree)match(input,LEFT,FOLLOW_LEFT_in_joinType640); 
                             
                            if ( _first_0==null ) _first_0 = LEFT94;


                            	retval.joinType = JoinType.LEFT;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:43: RIGHT
                            {
                            _last = (CommonTree)input.LT(1);
                            RIGHT95=(CommonTree)match(input,RIGHT,FOLLOW_RIGHT_in_joinType646); 
                             
                            if ( _first_0==null ) _first_0 = RIGHT95;


                            	retval.joinType = JoinType.RIGHT;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 3 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:83: FULL
                            {
                            _last = (CommonTree)input.LT(1);
                            FULL96=(CommonTree)match(input,FULL,FOLLOW_FULL_in_joinType652); 
                             
                            if ( _first_0==null ) _first_0 = FULL96;


                            	retval.joinType = JoinType.FULL;	

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:120: ( OUTER )?
                    int alt36=2;
                    int LA36_0 = input.LA(1);

                    if ( (LA36_0==OUTER) ) {
                        alt36=1;
                    }
                    switch (alt36) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:179:120: OUTER
                            {
                            _last = (CommonTree)input.LT(1);
                            OUTER97=(CommonTree)match(input,OUTER,FOLLOW_OUTER_in_joinType657); 
                             
                            if ( _first_0==null ) _first_0 = OUTER97;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "joinType"


    public static class selectClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "selectClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:182:1: selectClause : ^( SELECT ( DISTINCT )? rootSelectExpression ) ;
    public final GeneratedHQLResolver.selectClause_return selectClause() throws RecognitionException {
        GeneratedHQLResolver.selectClause_return retval = new GeneratedHQLResolver.selectClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT98=null;
        CommonTree DISTINCT99=null;
        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression100 =null;


        CommonTree SELECT98_tree=null;
        CommonTree DISTINCT99_tree=null;

        	if (state.backtracking == 0) delegate.pushSelectStrategy();	
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:185:2: ( ^( SELECT ( DISTINCT )? rootSelectExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:185:4: ^( SELECT ( DISTINCT )? rootSelectExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SELECT98=(CommonTree)match(input,SELECT,FOLLOW_SELECT_in_selectClause680); 


            if ( _first_0==null ) _first_0 = SELECT98;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:185:13: ( DISTINCT )?
            int alt38=2;
            int LA38_0 = input.LA(1);

            if ( (LA38_0==DISTINCT) ) {
                alt38=1;
            }
            switch (alt38) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:185:13: DISTINCT
                    {
                    _last = (CommonTree)input.LT(1);
                    DISTINCT99=(CommonTree)match(input,DISTINCT,FOLLOW_DISTINCT_in_selectClause682); 
                     
                    if ( _first_1==null ) _first_1 = DISTINCT99;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rootSelectExpression_in_selectClause685);
            rootSelectExpression100=rootSelectExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = rootSelectExpression100.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

            	delegate.popStrategy();	
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "selectClause"


    public static class rootSelectExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rootSelectExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:188:1: rootSelectExpression : ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? );
    public final GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression() throws RecognitionException {
        GeneratedHQLResolver.rootSelectExpression_return retval = new GeneratedHQLResolver.rootSelectExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SELECT_LIST101=null;
        CommonTree SELECT_ITEM103=null;
        CommonTree DYNAMIC_INSTANTIATION105=null;
        CommonTree DYNAMIC_INSTANTIATION_ARG107=null;
        CommonTree ALIAS_NAME110=null;
        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression102 =null;

        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression104 =null;

        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression106 =null;

        GeneratedHQLResolver.rootSelectExpression_return rootSelectExpression108 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression109 =null;


        CommonTree SELECT_LIST101_tree=null;
        CommonTree SELECT_ITEM103_tree=null;
        CommonTree DYNAMIC_INSTANTIATION105_tree=null;
        CommonTree DYNAMIC_INSTANTIATION_ARG107_tree=null;
        CommonTree ALIAS_NAME110_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:2: ( ^( SELECT_LIST ( rootSelectExpression )+ ) | ^( SELECT_ITEM rootSelectExpression ) | ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ ) | ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression ) | valueExpression ( ALIAS_NAME )? )
            int alt42=5;
            switch ( input.LA(1) ) {
            case SELECT_LIST:
                {
                alt42=1;
                }
                break;
            case SELECT_ITEM:
                {
                alt42=2;
                }
                break;
            case DYNAMIC_INSTANTIATION:
                {
                alt42=3;
                }
                break;
            case DYNAMIC_INSTANTIATION_ARG:
                {
                alt42=4;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt42=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 42, 0, input);

                throw nvae;

            }

            switch (alt42) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:4: ^( SELECT_LIST ( rootSelectExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SELECT_LIST101=(CommonTree)match(input,SELECT_LIST,FOLLOW_SELECT_LIST_in_rootSelectExpression698); 


                    if ( _first_0==null ) _first_0 = SELECT_LIST101;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:18: ( rootSelectExpression )+
                    int cnt39=0;
                    loop39:
                    do {
                        int alt39=2;
                        int LA39_0 = input.LA(1);

                        if ( (LA39_0==ABS||(LA39_0 >= ALIAS_REF && LA39_0 <= ALL)||LA39_0==ANY||(LA39_0 >= ASTERISK && LA39_0 <= AVG)||LA39_0==BIT_LENGTH||(LA39_0 >= CAST && LA39_0 <= CHARACTER_LITERAL)||LA39_0==COALESCE||(LA39_0 >= CONCAT && LA39_0 <= COUNT)||(LA39_0 >= CURRENT_DATE && LA39_0 <= CURRENT_TIMESTAMP)||LA39_0==DECIMAL_LITERAL||(LA39_0 >= DOT_CLASS && LA39_0 <= ELEMENTS)||LA39_0==EXISTS||(LA39_0 >= EXTRACT && LA39_0 <= FALSE)||LA39_0==FLOATING_POINT_LITERAL||LA39_0==FUNCTION||LA39_0==HEX_LITERAL||(LA39_0 >= INDEX && LA39_0 <= INDICES)||LA39_0==INTEGER_LITERAL||LA39_0==JAVA_CONSTANT||LA39_0==JPA_PARAM||LA39_0==LENGTH||(LA39_0 >= LOCATE && LA39_0 <= MAXINDEX)||(LA39_0 >= MIN && LA39_0 <= MINUS)||LA39_0==MOD||LA39_0==NAMED_PARAM||(LA39_0 >= NULL && LA39_0 <= NULLIF)||(LA39_0 >= OCTAL_LITERAL && LA39_0 <= OCTET_LENGTH)||(LA39_0 >= PARAM && LA39_0 <= PATH)||(LA39_0 >= PLUS && LA39_0 <= POSITION)||LA39_0==PROPERTY_REFERENCE||LA39_0==SEARCHED_CASE||(LA39_0 >= SELECT_ITEM && LA39_0 <= SELECT_LIST)||(LA39_0 >= SIMPLE_CASE && LA39_0 <= SOME)||(LA39_0 >= SQRT && LA39_0 <= SUM)||(LA39_0 >= TRIM && LA39_0 <= UNARY_PLUS)||(LA39_0 >= UPPER && LA39_0 <= VECTOR_EXPR)) ) {
                            alt39=1;
                        }


                        switch (alt39) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:189:18: rootSelectExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression700);
                    	    rootSelectExpression102=rootSelectExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = rootSelectExpression102.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt39 >= 1 ) break loop39;
                                EarlyExitException eee =
                                    new EarlyExitException(39, input);
                                throw eee;
                        }
                        cnt39++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:190:4: ^( SELECT_ITEM rootSelectExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SELECT_ITEM103=(CommonTree)match(input,SELECT_ITEM,FOLLOW_SELECT_ITEM_in_rootSelectExpression708); 


                    if ( _first_0==null ) _first_0 = SELECT_ITEM103;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression710);
                    rootSelectExpression104=rootSelectExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rootSelectExpression104.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:191:4: ^( DYNAMIC_INSTANTIATION ( rootSelectExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DYNAMIC_INSTANTIATION105=(CommonTree)match(input,DYNAMIC_INSTANTIATION,FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression717); 


                    if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION105;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:191:28: ( rootSelectExpression )+
                    int cnt40=0;
                    loop40:
                    do {
                        int alt40=2;
                        int LA40_0 = input.LA(1);

                        if ( (LA40_0==ABS||(LA40_0 >= ALIAS_REF && LA40_0 <= ALL)||LA40_0==ANY||(LA40_0 >= ASTERISK && LA40_0 <= AVG)||LA40_0==BIT_LENGTH||(LA40_0 >= CAST && LA40_0 <= CHARACTER_LITERAL)||LA40_0==COALESCE||(LA40_0 >= CONCAT && LA40_0 <= COUNT)||(LA40_0 >= CURRENT_DATE && LA40_0 <= CURRENT_TIMESTAMP)||LA40_0==DECIMAL_LITERAL||(LA40_0 >= DOT_CLASS && LA40_0 <= ELEMENTS)||LA40_0==EXISTS||(LA40_0 >= EXTRACT && LA40_0 <= FALSE)||LA40_0==FLOATING_POINT_LITERAL||LA40_0==FUNCTION||LA40_0==HEX_LITERAL||(LA40_0 >= INDEX && LA40_0 <= INDICES)||LA40_0==INTEGER_LITERAL||LA40_0==JAVA_CONSTANT||LA40_0==JPA_PARAM||LA40_0==LENGTH||(LA40_0 >= LOCATE && LA40_0 <= MAXINDEX)||(LA40_0 >= MIN && LA40_0 <= MINUS)||LA40_0==MOD||LA40_0==NAMED_PARAM||(LA40_0 >= NULL && LA40_0 <= NULLIF)||(LA40_0 >= OCTAL_LITERAL && LA40_0 <= OCTET_LENGTH)||(LA40_0 >= PARAM && LA40_0 <= PATH)||(LA40_0 >= PLUS && LA40_0 <= POSITION)||LA40_0==PROPERTY_REFERENCE||LA40_0==SEARCHED_CASE||(LA40_0 >= SELECT_ITEM && LA40_0 <= SELECT_LIST)||(LA40_0 >= SIMPLE_CASE && LA40_0 <= SOME)||(LA40_0 >= SQRT && LA40_0 <= SUM)||(LA40_0 >= TRIM && LA40_0 <= UNARY_PLUS)||(LA40_0 >= UPPER && LA40_0 <= VECTOR_EXPR)) ) {
                            alt40=1;
                        }


                        switch (alt40) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:191:28: rootSelectExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression719);
                    	    rootSelectExpression106=rootSelectExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = rootSelectExpression106.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt40 >= 1 ) break loop40;
                                EarlyExitException eee =
                                    new EarlyExitException(40, input);
                                throw eee;
                        }
                        cnt40++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:192:4: ^( DYNAMIC_INSTANTIATION_ARG rootSelectExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DYNAMIC_INSTANTIATION_ARG107=(CommonTree)match(input,DYNAMIC_INSTANTIATION_ARG,FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression727); 


                    if ( _first_0==null ) _first_0 = DYNAMIC_INSTANTIATION_ARG107;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rootSelectExpression_in_rootSelectExpression729);
                    rootSelectExpression108=rootSelectExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rootSelectExpression108.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:193:4: valueExpression ( ALIAS_NAME )?
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_rootSelectExpression735);
                    valueExpression109=valueExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = valueExpression109.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:193:20: ( ALIAS_NAME )?
                    int alt41=2;
                    int LA41_0 = input.LA(1);

                    if ( (LA41_0==ALIAS_NAME) ) {
                        alt41=1;
                    }
                    switch (alt41) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:193:20: ALIAS_NAME
                            {
                            _last = (CommonTree)input.LT(1);
                            ALIAS_NAME110=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_rootSelectExpression737); 
                             
                            if ( _first_0==null ) _first_0 = ALIAS_NAME110;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rootSelectExpression"


    public static class orderByClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderByClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:196:1: orderByClause : ^( ORDER_BY ( sortSpecification )+ ) ;
    public final GeneratedHQLResolver.orderByClause_return orderByClause() throws RecognitionException {
        GeneratedHQLResolver.orderByClause_return retval = new GeneratedHQLResolver.orderByClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ORDER_BY111=null;
        GeneratedHQLResolver.sortSpecification_return sortSpecification112 =null;


        CommonTree ORDER_BY111_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:197:2: ( ^( ORDER_BY ( sortSpecification )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:197:4: ^( ORDER_BY ( sortSpecification )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ORDER_BY111=(CommonTree)match(input,ORDER_BY,FOLLOW_ORDER_BY_in_orderByClause750); 


            if ( _first_0==null ) _first_0 = ORDER_BY111;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:197:15: ( sortSpecification )+
            int cnt43=0;
            loop43:
            do {
                int alt43=2;
                int LA43_0 = input.LA(1);

                if ( (LA43_0==SORT_SPEC) ) {
                    alt43=1;
                }


                switch (alt43) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:197:15: sortSpecification
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_sortSpecification_in_orderByClause752);
            	    sortSpecification112=sortSpecification();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = sortSpecification112.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt43 >= 1 ) break loop43;
                        EarlyExitException eee =
                            new EarlyExitException(43, input);
                        throw eee;
                }
                cnt43++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderByClause"


    public static class sortSpecification_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortSpecification"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:200:1: sortSpecification : ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) ;
    public final GeneratedHQLResolver.sortSpecification_return sortSpecification() throws RecognitionException {
        GeneratedHQLResolver.sortSpecification_return retval = new GeneratedHQLResolver.sortSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SORT_SPEC113=null;
        CommonTree COLLATE115=null;
        CommonTree ORDER_SPEC116=null;
        GeneratedHQLResolver.valueExpression_return valueExpression114 =null;


        CommonTree SORT_SPEC113_tree=null;
        CommonTree COLLATE115_tree=null;
        CommonTree ORDER_SPEC116_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:201:2: ( ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:201:4: ^( SORT_SPEC valueExpression ( COLLATE )? ORDER_SPEC )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SORT_SPEC113=(CommonTree)match(input,SORT_SPEC,FOLLOW_SORT_SPEC_in_sortSpecification766); 


            if ( _first_0==null ) _first_0 = SORT_SPEC113;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_sortSpecification768);
            valueExpression114=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression114.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:201:32: ( COLLATE )?
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( (LA44_0==COLLATE) ) {
                alt44=1;
            }
            switch (alt44) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:201:32: COLLATE
                    {
                    _last = (CommonTree)input.LT(1);
                    COLLATE115=(CommonTree)match(input,COLLATE,FOLLOW_COLLATE_in_sortSpecification770); 
                     
                    if ( _first_1==null ) _first_1 = COLLATE115;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            _last = (CommonTree)input.LT(1);
            ORDER_SPEC116=(CommonTree)match(input,ORDER_SPEC,FOLLOW_ORDER_SPEC_in_sortSpecification773); 
             
            if ( _first_1==null ) _first_1 = ORDER_SPEC116;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortSpecification"


    public static class searchCondition_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchCondition"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:204:1: searchCondition : ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate );
    public final GeneratedHQLResolver.searchCondition_return searchCondition() throws RecognitionException {
        GeneratedHQLResolver.searchCondition_return retval = new GeneratedHQLResolver.searchCondition_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OR117=null;
        CommonTree AND120=null;
        CommonTree NOT123=null;
        GeneratedHQLResolver.searchCondition_return searchCondition118 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition119 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition121 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition122 =null;

        GeneratedHQLResolver.searchCondition_return searchCondition124 =null;

        GeneratedHQLResolver.predicate_return predicate125 =null;


        CommonTree OR117_tree=null;
        CommonTree AND120_tree=null;
        CommonTree NOT123_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:205:2: ( ^( OR searchCondition searchCondition ) | ^( AND searchCondition searchCondition ) | ^( NOT searchCondition ) | predicate )
            int alt45=4;
            switch ( input.LA(1) ) {
            case OR:
                {
                alt45=1;
                }
                break;
            case AND:
                {
                alt45=2;
                }
                break;
            case NOT:
                {
                alt45=3;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BETWEEN:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EQUALS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case GREATER:
            case GREATER_EQUAL:
            case HEX_LITERAL:
            case IN:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case IS_EMPTY:
            case IS_NOT_EMPTY:
            case IS_NOT_NULL:
            case IS_NULL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LESS:
            case LESS_EQUAL:
            case LIKE:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MEMBER_OF:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NOT_BETWEEN:
            case NOT_EQUAL:
            case NOT_IN:
            case NOT_LIKE:
            case NOT_MEMBER_OF:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt45=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;

            }

            switch (alt45) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:205:4: ^( OR searchCondition searchCondition )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    OR117=(CommonTree)match(input,OR,FOLLOW_OR_in_searchCondition787); 


                    if ( _first_0==null ) _first_0 = OR117;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition789);
                    searchCondition118=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition118.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition791);
                    searchCondition119=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition119.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:206:4: ^( AND searchCondition searchCondition )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    AND120=(CommonTree)match(input,AND,FOLLOW_AND_in_searchCondition800); 


                    if ( _first_0==null ) _first_0 = AND120;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition802);
                    searchCondition121=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition121.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition804);
                    searchCondition122=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition122.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:207:4: ^( NOT searchCondition )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT123=(CommonTree)match(input,NOT,FOLLOW_NOT_in_searchCondition813); 


                    if ( _first_0==null ) _first_0 = NOT123;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_searchCondition_in_searchCondition815);
                    searchCondition124=searchCondition();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = searchCondition124.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:208:4: predicate
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_predicate_in_searchCondition822);
                    predicate125=predicate();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = predicate125.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchCondition"


    public static class predicate_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "predicate"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:211:1: predicate : ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( IS_NOT_NULL rowValueConstructor ) -> ^( NOT ^( IS_NULL rowValueConstructor ) ) | ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? ) -> ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( NOT_BETWEEN rowValueConstructor betweenList ) -> ^( NOT ^( BETWEEN rowValueConstructor betweenList ) ) | ^( IN rowValueConstructor inPredicateValue ) | ^( NOT_IN rowValueConstructor inPredicateValue ) -> ^( NOT ^( IN rowValueConstructor inPredicateValue ) ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor );
    public final GeneratedHQLResolver.predicate_return predicate() throws RecognitionException {
        GeneratedHQLResolver.predicate_return retval = new GeneratedHQLResolver.predicate_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EQUALS126=null;
        CommonTree NOT_EQUAL129=null;
        CommonTree LESS132=null;
        CommonTree LESS_EQUAL135=null;
        CommonTree GREATER138=null;
        CommonTree GREATER_EQUAL141=null;
        CommonTree IS_NULL144=null;
        CommonTree IS_NOT_NULL146=null;
        CommonTree LIKE148=null;
        CommonTree NOT_LIKE152=null;
        CommonTree BETWEEN156=null;
        CommonTree NOT_BETWEEN159=null;
        CommonTree IN162=null;
        CommonTree NOT_IN165=null;
        CommonTree MEMBER_OF168=null;
        CommonTree NOT_MEMBER_OF171=null;
        CommonTree IS_EMPTY174=null;
        CommonTree IS_NOT_EMPTY176=null;
        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor127 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue128 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor130 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue131 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor133 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue134 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor136 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue137 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor139 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue140 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor142 =null;

        GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue143 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor145 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor147 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression149 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression150 =null;

        GeneratedHQLResolver.escapeSpecification_return escapeSpecification151 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression153 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression154 =null;

        GeneratedHQLResolver.escapeSpecification_return escapeSpecification155 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor157 =null;

        GeneratedHQLResolver.betweenList_return betweenList158 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor160 =null;

        GeneratedHQLResolver.betweenList_return betweenList161 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor163 =null;

        GeneratedHQLResolver.inPredicateValue_return inPredicateValue164 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor166 =null;

        GeneratedHQLResolver.inPredicateValue_return inPredicateValue167 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor169 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor170 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor172 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor173 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor175 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor177 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor178 =null;


        CommonTree EQUALS126_tree=null;
        CommonTree NOT_EQUAL129_tree=null;
        CommonTree LESS132_tree=null;
        CommonTree LESS_EQUAL135_tree=null;
        CommonTree GREATER138_tree=null;
        CommonTree GREATER_EQUAL141_tree=null;
        CommonTree IS_NULL144_tree=null;
        CommonTree IS_NOT_NULL146_tree=null;
        CommonTree LIKE148_tree=null;
        CommonTree NOT_LIKE152_tree=null;
        CommonTree BETWEEN156_tree=null;
        CommonTree NOT_BETWEEN159_tree=null;
        CommonTree IN162_tree=null;
        CommonTree NOT_IN165_tree=null;
        CommonTree MEMBER_OF168_tree=null;
        CommonTree NOT_MEMBER_OF171_tree=null;
        CommonTree IS_EMPTY174_tree=null;
        CommonTree IS_NOT_EMPTY176_tree=null;
        RewriteRuleNodeStream stream_NOT_LIKE=new RewriteRuleNodeStream(adaptor,"token NOT_LIKE");
        RewriteRuleNodeStream stream_NOT_BETWEEN=new RewriteRuleNodeStream(adaptor,"token NOT_BETWEEN");
        RewriteRuleNodeStream stream_IS_NOT_NULL=new RewriteRuleNodeStream(adaptor,"token IS_NOT_NULL");
        RewriteRuleNodeStream stream_NOT_IN=new RewriteRuleNodeStream(adaptor,"token NOT_IN");
        RewriteRuleSubtreeStream stream_inPredicateValue=new RewriteRuleSubtreeStream(adaptor,"rule inPredicateValue");
        RewriteRuleSubtreeStream stream_valueExpression=new RewriteRuleSubtreeStream(adaptor,"rule valueExpression");
        RewriteRuleSubtreeStream stream_escapeSpecification=new RewriteRuleSubtreeStream(adaptor,"rule escapeSpecification");
        RewriteRuleSubtreeStream stream_betweenList=new RewriteRuleSubtreeStream(adaptor,"rule betweenList");
        RewriteRuleSubtreeStream stream_rowValueConstructor=new RewriteRuleSubtreeStream(adaptor,"rule rowValueConstructor");
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:212:2: ( ^( EQUALS rowValueConstructor comparativePredicateValue ) | ^( NOT_EQUAL rowValueConstructor comparativePredicateValue ) | ^( LESS rowValueConstructor comparativePredicateValue ) | ^( LESS_EQUAL rowValueConstructor comparativePredicateValue ) | ^( GREATER rowValueConstructor comparativePredicateValue ) | ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue ) | ^( IS_NULL rowValueConstructor ) | ^( IS_NOT_NULL rowValueConstructor ) -> ^( NOT ^( IS_NULL rowValueConstructor ) ) | ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) | ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? ) -> ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) ) | ^( BETWEEN rowValueConstructor betweenList ) | ^( NOT_BETWEEN rowValueConstructor betweenList ) -> ^( NOT ^( BETWEEN rowValueConstructor betweenList ) ) | ^( IN rowValueConstructor inPredicateValue ) | ^( NOT_IN rowValueConstructor inPredicateValue ) -> ^( NOT ^( IN rowValueConstructor inPredicateValue ) ) | ^( MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor ) | ^( IS_EMPTY rowValueConstructor ) | ^( IS_NOT_EMPTY rowValueConstructor ) | rowValueConstructor )
            int alt48=19;
            switch ( input.LA(1) ) {
            case EQUALS:
                {
                alt48=1;
                }
                break;
            case NOT_EQUAL:
                {
                alt48=2;
                }
                break;
            case LESS:
                {
                alt48=3;
                }
                break;
            case LESS_EQUAL:
                {
                alt48=4;
                }
                break;
            case GREATER:
                {
                alt48=5;
                }
                break;
            case GREATER_EQUAL:
                {
                alt48=6;
                }
                break;
            case IS_NULL:
                {
                alt48=7;
                }
                break;
            case IS_NOT_NULL:
                {
                alt48=8;
                }
                break;
            case LIKE:
                {
                alt48=9;
                }
                break;
            case NOT_LIKE:
                {
                alt48=10;
                }
                break;
            case BETWEEN:
                {
                alt48=11;
                }
                break;
            case NOT_BETWEEN:
                {
                alt48=12;
                }
                break;
            case IN:
                {
                alt48=13;
                }
                break;
            case NOT_IN:
                {
                alt48=14;
                }
                break;
            case MEMBER_OF:
                {
                alt48=15;
                }
                break;
            case NOT_MEMBER_OF:
                {
                alt48=16;
                }
                break;
            case IS_EMPTY:
                {
                alt48=17;
                }
                break;
            case IS_NOT_EMPTY:
                {
                alt48=18;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case ALL:
            case ANY:
            case ASTERISK:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case DOUBLE_PIPE:
            case ELEMENTS:
            case EXISTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MINUS:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case PLUS:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SOLIDUS:
            case SOME:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UNARY_MINUS:
            case UNARY_PLUS:
            case UPPER:
            case VECTOR_EXPR:
                {
                alt48=19;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;

            }

            switch (alt48) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:212:4: ^( EQUALS rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EQUALS126=(CommonTree)match(input,EQUALS,FOLLOW_EQUALS_in_predicate835); 


                    if ( _first_0==null ) _first_0 = EQUALS126;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate837);
                    rowValueConstructor127=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor127.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate839);
                    comparativePredicateValue128=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue128.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:213:4: ^( NOT_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_EQUAL129=(CommonTree)match(input,NOT_EQUAL,FOLLOW_NOT_EQUAL_in_predicate848); 


                    if ( _first_0==null ) _first_0 = NOT_EQUAL129;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate850);
                    rowValueConstructor130=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor130.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate852);
                    comparativePredicateValue131=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue131.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:214:4: ^( LESS rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LESS132=(CommonTree)match(input,LESS,FOLLOW_LESS_in_predicate861); 


                    if ( _first_0==null ) _first_0 = LESS132;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate863);
                    rowValueConstructor133=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor133.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate865);
                    comparativePredicateValue134=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue134.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:215:4: ^( LESS_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LESS_EQUAL135=(CommonTree)match(input,LESS_EQUAL,FOLLOW_LESS_EQUAL_in_predicate874); 


                    if ( _first_0==null ) _first_0 = LESS_EQUAL135;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate876);
                    rowValueConstructor136=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor136.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate878);
                    comparativePredicateValue137=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue137.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:216:4: ^( GREATER rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    GREATER138=(CommonTree)match(input,GREATER,FOLLOW_GREATER_in_predicate887); 


                    if ( _first_0==null ) _first_0 = GREATER138;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate889);
                    rowValueConstructor139=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor139.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate891);
                    comparativePredicateValue140=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue140.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:217:4: ^( GREATER_EQUAL rowValueConstructor comparativePredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    GREATER_EQUAL141=(CommonTree)match(input,GREATER_EQUAL,FOLLOW_GREATER_EQUAL_in_predicate900); 


                    if ( _first_0==null ) _first_0 = GREATER_EQUAL141;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate902);
                    rowValueConstructor142=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor142.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_comparativePredicateValue_in_predicate904);
                    comparativePredicateValue143=comparativePredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = comparativePredicateValue143.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:218:4: ^( IS_NULL rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NULL144=(CommonTree)match(input,IS_NULL,FOLLOW_IS_NULL_in_predicate913); 


                    if ( _first_0==null ) _first_0 = IS_NULL144;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate915);
                    rowValueConstructor145=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor145.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:4: ^( IS_NOT_NULL rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NOT_NULL146=(CommonTree)match(input,IS_NOT_NULL,FOLLOW_IS_NOT_NULL_in_predicate924);  
                    stream_IS_NOT_NULL.add(IS_NOT_NULL146);


                    if ( _first_0==null ) _first_0 = IS_NOT_NULL146;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate926);
                    rowValueConstructor147=rowValueConstructor();

                    state._fsp--;

                    stream_rowValueConstructor.add(rowValueConstructor147.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: rowValueConstructor
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 219:41: -> ^( NOT ^( IS_NULL rowValueConstructor ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:44: ^( NOT ^( IS_NULL rowValueConstructor ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:219:51: ^( IS_NULL rowValueConstructor )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(IS_NULL, "IS_NULL")
                        , root_2);

                        adaptor.addChild(root_2, stream_rowValueConstructor.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:220:4: ^( LIKE valueExpression valueExpression ( escapeSpecification )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LIKE148=(CommonTree)match(input,LIKE,FOLLOW_LIKE_in_predicate951); 


                    if ( _first_0==null ) _first_0 = LIKE148;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate953);
                    valueExpression149=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression149.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate955);
                    valueExpression150=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression150.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:220:44: ( escapeSpecification )?
                    int alt46=2;
                    int LA46_0 = input.LA(1);

                    if ( (LA46_0==ESCAPE) ) {
                        alt46=1;
                    }
                    switch (alt46) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:220:44: escapeSpecification
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_escapeSpecification_in_predicate957);
                            escapeSpecification151=escapeSpecification();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = escapeSpecification151.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:4: ^( NOT_LIKE valueExpression valueExpression ( escapeSpecification )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_LIKE152=(CommonTree)match(input,NOT_LIKE,FOLLOW_NOT_LIKE_in_predicate967);  
                    stream_NOT_LIKE.add(NOT_LIKE152);


                    if ( _first_0==null ) _first_0 = NOT_LIKE152;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate969);
                    valueExpression153=valueExpression();

                    state._fsp--;

                    stream_valueExpression.add(valueExpression153.getTree());

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_predicate971);
                    valueExpression154=valueExpression();

                    state._fsp--;

                    stream_valueExpression.add(valueExpression154.getTree());

                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:48: ( escapeSpecification )?
                    int alt47=2;
                    int LA47_0 = input.LA(1);

                    if ( (LA47_0==ESCAPE) ) {
                        alt47=1;
                    }
                    switch (alt47) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:48: escapeSpecification
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_escapeSpecification_in_predicate973);
                            escapeSpecification155=escapeSpecification();

                            state._fsp--;

                            stream_escapeSpecification.add(escapeSpecification155.getTree());

                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: valueExpression, escapeSpecification, valueExpression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 221:71: -> ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:74: ^( NOT ^( LIKE valueExpression valueExpression ( escapeSpecification )? ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:81: ^( LIKE valueExpression valueExpression ( escapeSpecification )? )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(LIKE, "LIKE")
                        , root_2);

                        adaptor.addChild(root_2, stream_valueExpression.nextTree());

                        adaptor.addChild(root_2, stream_valueExpression.nextTree());

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:221:121: ( escapeSpecification )?
                        if ( stream_escapeSpecification.hasNext() ) {
                            adaptor.addChild(root_2, stream_escapeSpecification.nextTree());

                        }
                        stream_escapeSpecification.reset();

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:222:4: ^( BETWEEN rowValueConstructor betweenList )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    BETWEEN156=(CommonTree)match(input,BETWEEN,FOLLOW_BETWEEN_in_predicate1004); 


                    if ( _first_0==null ) _first_0 = BETWEEN156;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1006);
                    rowValueConstructor157=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor157.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_betweenList_in_predicate1008);
                    betweenList158=betweenList();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = betweenList158.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:223:4: ^( NOT_BETWEEN rowValueConstructor betweenList )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_BETWEEN159=(CommonTree)match(input,NOT_BETWEEN,FOLLOW_NOT_BETWEEN_in_predicate1017);  
                    stream_NOT_BETWEEN.add(NOT_BETWEEN159);


                    if ( _first_0==null ) _first_0 = NOT_BETWEEN159;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1019);
                    rowValueConstructor160=rowValueConstructor();

                    state._fsp--;

                    stream_rowValueConstructor.add(rowValueConstructor160.getTree());

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_betweenList_in_predicate1021);
                    betweenList161=betweenList();

                    state._fsp--;

                    stream_betweenList.add(betweenList161.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: betweenList, rowValueConstructor
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 223:53: -> ^( NOT ^( BETWEEN rowValueConstructor betweenList ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:223:56: ^( NOT ^( BETWEEN rowValueConstructor betweenList ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:223:63: ^( BETWEEN rowValueConstructor betweenList )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(BETWEEN, "BETWEEN")
                        , root_2);

                        adaptor.addChild(root_2, stream_rowValueConstructor.nextTree());

                        adaptor.addChild(root_2, stream_betweenList.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:224:4: ^( IN rowValueConstructor inPredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IN162=(CommonTree)match(input,IN,FOLLOW_IN_in_predicate1048); 


                    if ( _first_0==null ) _first_0 = IN162;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1050);
                    rowValueConstructor163=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor163.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_inPredicateValue_in_predicate1052);
                    inPredicateValue164=inPredicateValue();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = inPredicateValue164.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:225:4: ^( NOT_IN rowValueConstructor inPredicateValue )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_IN165=(CommonTree)match(input,NOT_IN,FOLLOW_NOT_IN_in_predicate1061);  
                    stream_NOT_IN.add(NOT_IN165);


                    if ( _first_0==null ) _first_0 = NOT_IN165;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1063);
                    rowValueConstructor166=rowValueConstructor();

                    state._fsp--;

                    stream_rowValueConstructor.add(rowValueConstructor166.getTree());

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_inPredicateValue_in_predicate1065);
                    inPredicateValue167=inPredicateValue();

                    state._fsp--;

                    stream_inPredicateValue.add(inPredicateValue167.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: inPredicateValue, rowValueConstructor
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 225:53: -> ^( NOT ^( IN rowValueConstructor inPredicateValue ) )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:225:56: ^( NOT ^( IN rowValueConstructor inPredicateValue ) )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(NOT, "NOT")
                        , root_1);

                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:225:63: ^( IN rowValueConstructor inPredicateValue )
                        {
                        CommonTree root_2 = (CommonTree)adaptor.nil();
                        root_2 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(IN, "IN")
                        , root_2);

                        adaptor.addChild(root_2, stream_rowValueConstructor.nextTree());

                        adaptor.addChild(root_2, stream_inPredicateValue.nextTree());

                        adaptor.addChild(root_1, root_2);
                        }

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:226:4: ^( MEMBER_OF rowValueConstructor rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MEMBER_OF168=(CommonTree)match(input,MEMBER_OF,FOLLOW_MEMBER_OF_in_predicate1092); 


                    if ( _first_0==null ) _first_0 = MEMBER_OF168;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1094);
                    rowValueConstructor169=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor169.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1096);
                    rowValueConstructor170=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor170.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:227:4: ^( NOT_MEMBER_OF rowValueConstructor rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NOT_MEMBER_OF171=(CommonTree)match(input,NOT_MEMBER_OF,FOLLOW_NOT_MEMBER_OF_in_predicate1105); 


                    if ( _first_0==null ) _first_0 = NOT_MEMBER_OF171;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1107);
                    rowValueConstructor172=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor172.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1109);
                    rowValueConstructor173=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor173.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:228:4: ^( IS_EMPTY rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_EMPTY174=(CommonTree)match(input,IS_EMPTY,FOLLOW_IS_EMPTY_in_predicate1119); 


                    if ( _first_0==null ) _first_0 = IS_EMPTY174;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1121);
                    rowValueConstructor175=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor175.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:229:4: ^( IS_NOT_EMPTY rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    IS_NOT_EMPTY176=(CommonTree)match(input,IS_NOT_EMPTY,FOLLOW_IS_NOT_EMPTY_in_predicate1130); 


                    if ( _first_0==null ) _first_0 = IS_NOT_EMPTY176;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1132);
                    rowValueConstructor177=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor177.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:230:4: rowValueConstructor
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_predicate1139);
                    rowValueConstructor178=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = rowValueConstructor178.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "predicate"


    public static class betweenList_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "betweenList"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:233:1: betweenList : ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor ) ;
    public final GeneratedHQLResolver.betweenList_return betweenList() throws RecognitionException {
        GeneratedHQLResolver.betweenList_return retval = new GeneratedHQLResolver.betweenList_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BETWEEN_LIST179=null;
        GeneratedHQLResolver.rowValueConstructor_return lower =null;

        GeneratedHQLResolver.rowValueConstructor_return upper =null;


        CommonTree BETWEEN_LIST179_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:234:2: ( ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:234:4: ^( BETWEEN_LIST lower= rowValueConstructor upper= rowValueConstructor )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            BETWEEN_LIST179=(CommonTree)match(input,BETWEEN_LIST,FOLLOW_BETWEEN_LIST_in_betweenList1152); 


            if ( _first_0==null ) _first_0 = BETWEEN_LIST179;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_betweenList1156);
            lower=rowValueConstructor();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = lower.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_betweenList1160);
            upper=rowValueConstructor();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = upper.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "betweenList"


    public static class comparativePredicateValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "comparativePredicateValue"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:237:1: comparativePredicateValue : rowValueConstructor ;
    public final GeneratedHQLResolver.comparativePredicateValue_return comparativePredicateValue() throws RecognitionException {
        GeneratedHQLResolver.comparativePredicateValue_return retval = new GeneratedHQLResolver.comparativePredicateValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor180 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:238:2: ( rowValueConstructor )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:238:4: rowValueConstructor
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_rowValueConstructor_in_comparativePredicateValue1173);
            rowValueConstructor180=rowValueConstructor();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = rowValueConstructor180.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "comparativePredicateValue"


    public static class rowValueConstructor_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rowValueConstructor"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:241:1: rowValueConstructor : valueExpression ;
    public final GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor() throws RecognitionException {
        GeneratedHQLResolver.rowValueConstructor_return retval = new GeneratedHQLResolver.rowValueConstructor_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression181 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:242:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:242:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_rowValueConstructor1184);
            valueExpression181=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression181.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rowValueConstructor"


    public static class escapeSpecification_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "escapeSpecification"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:245:1: escapeSpecification : ^( ESCAPE characterValueExpression ) ;
    public final GeneratedHQLResolver.escapeSpecification_return escapeSpecification() throws RecognitionException {
        GeneratedHQLResolver.escapeSpecification_return retval = new GeneratedHQLResolver.escapeSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ESCAPE182=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression183 =null;


        CommonTree ESCAPE182_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:246:2: ( ^( ESCAPE characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:246:4: ^( ESCAPE characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ESCAPE182=(CommonTree)match(input,ESCAPE,FOLLOW_ESCAPE_in_escapeSpecification1196); 


            if ( _first_0==null ) _first_0 = ESCAPE182;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_escapeSpecification1198);
            characterValueExpression183=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression183.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "escapeSpecification"


    public static class inPredicateValue_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "inPredicateValue"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:249:1: inPredicateValue : ^( IN_LIST ( valueExpression )+ ) ;
    public final GeneratedHQLResolver.inPredicateValue_return inPredicateValue() throws RecognitionException {
        GeneratedHQLResolver.inPredicateValue_return retval = new GeneratedHQLResolver.inPredicateValue_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IN_LIST184=null;
        GeneratedHQLResolver.valueExpression_return valueExpression185 =null;


        CommonTree IN_LIST184_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:250:2: ( ^( IN_LIST ( valueExpression )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:250:4: ^( IN_LIST ( valueExpression )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            IN_LIST184=(CommonTree)match(input,IN_LIST,FOLLOW_IN_LIST_in_inPredicateValue1211); 


            if ( _first_0==null ) _first_0 = IN_LIST184;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:250:14: ( valueExpression )+
            int cnt49=0;
            loop49:
            do {
                int alt49=2;
                int LA49_0 = input.LA(1);

                if ( (LA49_0==ABS||(LA49_0 >= ALIAS_REF && LA49_0 <= ALL)||LA49_0==ANY||(LA49_0 >= ASTERISK && LA49_0 <= AVG)||LA49_0==BIT_LENGTH||(LA49_0 >= CAST && LA49_0 <= CHARACTER_LITERAL)||LA49_0==COALESCE||(LA49_0 >= CONCAT && LA49_0 <= COUNT)||(LA49_0 >= CURRENT_DATE && LA49_0 <= CURRENT_TIMESTAMP)||LA49_0==DECIMAL_LITERAL||(LA49_0 >= DOT_CLASS && LA49_0 <= DOUBLE_PIPE)||LA49_0==ELEMENTS||LA49_0==EXISTS||(LA49_0 >= EXTRACT && LA49_0 <= FALSE)||LA49_0==FLOATING_POINT_LITERAL||LA49_0==FUNCTION||LA49_0==HEX_LITERAL||(LA49_0 >= INDEX && LA49_0 <= INDICES)||LA49_0==INTEGER_LITERAL||LA49_0==JAVA_CONSTANT||LA49_0==JPA_PARAM||LA49_0==LENGTH||(LA49_0 >= LOCATE && LA49_0 <= MAXINDEX)||(LA49_0 >= MIN && LA49_0 <= MINUS)||LA49_0==MOD||LA49_0==NAMED_PARAM||(LA49_0 >= NULL && LA49_0 <= NULLIF)||(LA49_0 >= OCTAL_LITERAL && LA49_0 <= OCTET_LENGTH)||(LA49_0 >= PARAM && LA49_0 <= PATH)||(LA49_0 >= PLUS && LA49_0 <= POSITION)||LA49_0==PROPERTY_REFERENCE||LA49_0==SEARCHED_CASE||(LA49_0 >= SIMPLE_CASE && LA49_0 <= SOME)||(LA49_0 >= SQRT && LA49_0 <= SUM)||(LA49_0 >= TRIM && LA49_0 <= UNARY_PLUS)||(LA49_0 >= UPPER && LA49_0 <= VECTOR_EXPR)) ) {
                    alt49=1;
                }


                switch (alt49) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:250:14: valueExpression
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_valueExpression_in_inPredicateValue1213);
            	    valueExpression185=valueExpression();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = valueExpression185.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt49 >= 1 ) break loop49;
                        EarlyExitException eee =
                            new EarlyExitException(49, input);
                        throw eee;
                }
                cnt49++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "inPredicateValue"


    public static class numericValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numericValueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:253:1: numericValueExpression : valueExpression ;
    public final GeneratedHQLResolver.numericValueExpression_return numericValueExpression() throws RecognitionException {
        GeneratedHQLResolver.numericValueExpression_return retval = new GeneratedHQLResolver.numericValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression186 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:254:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:254:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_numericValueExpression1226);
            valueExpression186=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression186.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numericValueExpression"


    public static class characterValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "characterValueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:257:1: characterValueExpression : valueExpression ;
    public final GeneratedHQLResolver.characterValueExpression_return characterValueExpression() throws RecognitionException {
        GeneratedHQLResolver.characterValueExpression_return retval = new GeneratedHQLResolver.characterValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression187 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:258:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:258:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_characterValueExpression1237);
            valueExpression187=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression187.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "characterValueExpression"


    public static class datetimeValueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeValueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:261:1: datetimeValueExpression : valueExpression ;
    public final GeneratedHQLResolver.datetimeValueExpression_return datetimeValueExpression() throws RecognitionException {
        GeneratedHQLResolver.datetimeValueExpression_return retval = new GeneratedHQLResolver.datetimeValueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression188 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:262:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:262:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_datetimeValueExpression1248);
            valueExpression188=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression188.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeValueExpression"


    public static class valueExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "valueExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:265:1: valueExpression : ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary );
    public final GeneratedHQLResolver.valueExpression_return valueExpression() throws RecognitionException {
        GeneratedHQLResolver.valueExpression_return retval = new GeneratedHQLResolver.valueExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOUBLE_PIPE189=null;
        CommonTree UNARY_MINUS191=null;
        CommonTree UNARY_PLUS193=null;
        CommonTree PLUS195=null;
        CommonTree MINUS198=null;
        CommonTree ASTERISK201=null;
        CommonTree SOLIDUS204=null;
        CommonTree EXISTS207=null;
        CommonTree SOME209=null;
        CommonTree ALL211=null;
        CommonTree ANY213=null;
        CommonTree VECTOR_EXPR215=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression190 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression192 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression194 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression196 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression197 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression199 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression200 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression202 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression203 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression205 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression206 =null;

        GeneratedHQLResolver.rowValueConstructor_return rowValueConstructor208 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression210 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression212 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression214 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression216 =null;

        GeneratedHQLResolver.valueExpressionPrimary_return valueExpressionPrimary217 =null;


        CommonTree DOUBLE_PIPE189_tree=null;
        CommonTree UNARY_MINUS191_tree=null;
        CommonTree UNARY_PLUS193_tree=null;
        CommonTree PLUS195_tree=null;
        CommonTree MINUS198_tree=null;
        CommonTree ASTERISK201_tree=null;
        CommonTree SOLIDUS204_tree=null;
        CommonTree EXISTS207_tree=null;
        CommonTree SOME209_tree=null;
        CommonTree ALL211_tree=null;
        CommonTree ANY213_tree=null;
        CommonTree VECTOR_EXPR215_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:266:2: ( ^( DOUBLE_PIPE ( characterValueExpression )+ ) | ^( UNARY_MINUS numericValueExpression ) | ^( UNARY_PLUS numericValueExpression ) | ^( PLUS valueExpression valueExpression ) | ^( MINUS valueExpression valueExpression ) | ^( ASTERISK numericValueExpression numericValueExpression ) | ^( SOLIDUS numericValueExpression numericValueExpression ) | ^( EXISTS rowValueConstructor ) | ^( SOME valueExpression ) | ^( ALL valueExpression ) | ^( ANY valueExpression ) | ^( VECTOR_EXPR ( valueExpression )+ ) | valueExpressionPrimary )
            int alt52=13;
            switch ( input.LA(1) ) {
            case DOUBLE_PIPE:
                {
                alt52=1;
                }
                break;
            case UNARY_MINUS:
                {
                alt52=2;
                }
                break;
            case UNARY_PLUS:
                {
                alt52=3;
                }
                break;
            case PLUS:
                {
                alt52=4;
                }
                break;
            case MINUS:
                {
                alt52=5;
                }
                break;
            case ASTERISK:
                {
                alt52=6;
                }
                break;
            case SOLIDUS:
                {
                alt52=7;
                }
                break;
            case EXISTS:
                {
                alt52=8;
                }
                break;
            case SOME:
                {
                alt52=9;
                }
                break;
            case ALL:
                {
                alt52=10;
                }
                break;
            case ANY:
                {
                alt52=11;
                }
                break;
            case VECTOR_EXPR:
                {
                alt52=12;
                }
                break;
            case ABS:
            case ALIAS_REF:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CHARACTER_LITERAL:
            case COALESCE:
            case CONCAT:
            case CONST_STRING_VALUE:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case DECIMAL_LITERAL:
            case DOT_CLASS:
            case ELEMENTS:
            case EXTRACT:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case FUNCTION:
            case HEX_LITERAL:
            case INDEX:
            case INDICES:
            case INTEGER_LITERAL:
            case JAVA_CONSTANT:
            case JPA_PARAM:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MAXELEMENT:
            case MAXINDEX:
            case MIN:
            case MINELEMENT:
            case MININDEX:
            case MOD:
            case NAMED_PARAM:
            case NULL:
            case NULLIF:
            case OCTAL_LITERAL:
            case OCTET_LENGTH:
            case PARAM:
            case PATH:
            case POSITION:
            case PROPERTY_REFERENCE:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
            case SIZE:
            case SQRT:
            case STRING_LITERAL:
            case SUBSTRING:
            case SUB_QUERY:
            case SUM:
            case TRIM:
            case TRUE:
            case UPPER:
                {
                alt52=13;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 52, 0, input);

                throw nvae;

            }

            switch (alt52) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:266:4: ^( DOUBLE_PIPE ( characterValueExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOUBLE_PIPE189=(CommonTree)match(input,DOUBLE_PIPE,FOLLOW_DOUBLE_PIPE_in_valueExpression1261); 


                    if ( _first_0==null ) _first_0 = DOUBLE_PIPE189;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:266:19: ( characterValueExpression )+
                    int cnt50=0;
                    loop50:
                    do {
                        int alt50=2;
                        int LA50_0 = input.LA(1);

                        if ( (LA50_0==ABS||(LA50_0 >= ALIAS_REF && LA50_0 <= ALL)||LA50_0==ANY||(LA50_0 >= ASTERISK && LA50_0 <= AVG)||LA50_0==BIT_LENGTH||(LA50_0 >= CAST && LA50_0 <= CHARACTER_LITERAL)||LA50_0==COALESCE||(LA50_0 >= CONCAT && LA50_0 <= COUNT)||(LA50_0 >= CURRENT_DATE && LA50_0 <= CURRENT_TIMESTAMP)||LA50_0==DECIMAL_LITERAL||(LA50_0 >= DOT_CLASS && LA50_0 <= DOUBLE_PIPE)||LA50_0==ELEMENTS||LA50_0==EXISTS||(LA50_0 >= EXTRACT && LA50_0 <= FALSE)||LA50_0==FLOATING_POINT_LITERAL||LA50_0==FUNCTION||LA50_0==HEX_LITERAL||(LA50_0 >= INDEX && LA50_0 <= INDICES)||LA50_0==INTEGER_LITERAL||LA50_0==JAVA_CONSTANT||LA50_0==JPA_PARAM||LA50_0==LENGTH||(LA50_0 >= LOCATE && LA50_0 <= MAXINDEX)||(LA50_0 >= MIN && LA50_0 <= MINUS)||LA50_0==MOD||LA50_0==NAMED_PARAM||(LA50_0 >= NULL && LA50_0 <= NULLIF)||(LA50_0 >= OCTAL_LITERAL && LA50_0 <= OCTET_LENGTH)||(LA50_0 >= PARAM && LA50_0 <= PATH)||(LA50_0 >= PLUS && LA50_0 <= POSITION)||LA50_0==PROPERTY_REFERENCE||LA50_0==SEARCHED_CASE||(LA50_0 >= SIMPLE_CASE && LA50_0 <= SOME)||(LA50_0 >= SQRT && LA50_0 <= SUM)||(LA50_0 >= TRIM && LA50_0 <= UNARY_PLUS)||(LA50_0 >= UPPER && LA50_0 <= VECTOR_EXPR)) ) {
                            alt50=1;
                        }


                        switch (alt50) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:266:19: characterValueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_characterValueExpression_in_valueExpression1263);
                    	    characterValueExpression190=characterValueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = characterValueExpression190.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt50 >= 1 ) break loop50;
                                EarlyExitException eee =
                                    new EarlyExitException(50, input);
                                throw eee;
                        }
                        cnt50++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:267:4: ^( UNARY_MINUS numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNARY_MINUS191=(CommonTree)match(input,UNARY_MINUS,FOLLOW_UNARY_MINUS_in_valueExpression1273); 


                    if ( _first_0==null ) _first_0 = UNARY_MINUS191;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1275);
                    numericValueExpression192=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression192.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:268:4: ^( UNARY_PLUS numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    UNARY_PLUS193=(CommonTree)match(input,UNARY_PLUS,FOLLOW_UNARY_PLUS_in_valueExpression1284); 


                    if ( _first_0==null ) _first_0 = UNARY_PLUS193;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1286);
                    numericValueExpression194=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression194.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:269:4: ^( PLUS valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PLUS195=(CommonTree)match(input,PLUS,FOLLOW_PLUS_in_valueExpression1295); 


                    if ( _first_0==null ) _first_0 = PLUS195;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1297);
                    valueExpression196=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression196.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1299);
                    valueExpression197=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression197.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:270:4: ^( MINUS valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MINUS198=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_valueExpression1308); 


                    if ( _first_0==null ) _first_0 = MINUS198;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1310);
                    valueExpression199=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression199.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1312);
                    valueExpression200=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression200.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:271:4: ^( ASTERISK numericValueExpression numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ASTERISK201=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_valueExpression1321); 


                    if ( _first_0==null ) _first_0 = ASTERISK201;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1323);
                    numericValueExpression202=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression202.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1325);
                    numericValueExpression203=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression203.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:272:4: ^( SOLIDUS numericValueExpression numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SOLIDUS204=(CommonTree)match(input,SOLIDUS,FOLLOW_SOLIDUS_in_valueExpression1334); 


                    if ( _first_0==null ) _first_0 = SOLIDUS204;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1336);
                    numericValueExpression205=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression205.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_valueExpression1338);
                    numericValueExpression206=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression206.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:273:4: ^( EXISTS rowValueConstructor )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    EXISTS207=(CommonTree)match(input,EXISTS,FOLLOW_EXISTS_in_valueExpression1347); 


                    if ( _first_0==null ) _first_0 = EXISTS207;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_rowValueConstructor_in_valueExpression1349);
                    rowValueConstructor208=rowValueConstructor();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = rowValueConstructor208.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:274:4: ^( SOME valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SOME209=(CommonTree)match(input,SOME,FOLLOW_SOME_in_valueExpression1357); 


                    if ( _first_0==null ) _first_0 = SOME209;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1359);
                    valueExpression210=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression210.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:275:4: ^( ALL valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ALL211=(CommonTree)match(input,ALL,FOLLOW_ALL_in_valueExpression1368); 


                    if ( _first_0==null ) _first_0 = ALL211;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1370);
                    valueExpression212=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression212.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:276:4: ^( ANY valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ANY213=(CommonTree)match(input,ANY,FOLLOW_ANY_in_valueExpression1379); 


                    if ( _first_0==null ) _first_0 = ANY213;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_valueExpression1381);
                    valueExpression214=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression214.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:277:4: ^( VECTOR_EXPR ( valueExpression )+ )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    VECTOR_EXPR215=(CommonTree)match(input,VECTOR_EXPR,FOLLOW_VECTOR_EXPR_in_valueExpression1390); 


                    if ( _first_0==null ) _first_0 = VECTOR_EXPR215;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:277:19: ( valueExpression )+
                    int cnt51=0;
                    loop51:
                    do {
                        int alt51=2;
                        int LA51_0 = input.LA(1);

                        if ( (LA51_0==ABS||(LA51_0 >= ALIAS_REF && LA51_0 <= ALL)||LA51_0==ANY||(LA51_0 >= ASTERISK && LA51_0 <= AVG)||LA51_0==BIT_LENGTH||(LA51_0 >= CAST && LA51_0 <= CHARACTER_LITERAL)||LA51_0==COALESCE||(LA51_0 >= CONCAT && LA51_0 <= COUNT)||(LA51_0 >= CURRENT_DATE && LA51_0 <= CURRENT_TIMESTAMP)||LA51_0==DECIMAL_LITERAL||(LA51_0 >= DOT_CLASS && LA51_0 <= DOUBLE_PIPE)||LA51_0==ELEMENTS||LA51_0==EXISTS||(LA51_0 >= EXTRACT && LA51_0 <= FALSE)||LA51_0==FLOATING_POINT_LITERAL||LA51_0==FUNCTION||LA51_0==HEX_LITERAL||(LA51_0 >= INDEX && LA51_0 <= INDICES)||LA51_0==INTEGER_LITERAL||LA51_0==JAVA_CONSTANT||LA51_0==JPA_PARAM||LA51_0==LENGTH||(LA51_0 >= LOCATE && LA51_0 <= MAXINDEX)||(LA51_0 >= MIN && LA51_0 <= MINUS)||LA51_0==MOD||LA51_0==NAMED_PARAM||(LA51_0 >= NULL && LA51_0 <= NULLIF)||(LA51_0 >= OCTAL_LITERAL && LA51_0 <= OCTET_LENGTH)||(LA51_0 >= PARAM && LA51_0 <= PATH)||(LA51_0 >= PLUS && LA51_0 <= POSITION)||LA51_0==PROPERTY_REFERENCE||LA51_0==SEARCHED_CASE||(LA51_0 >= SIMPLE_CASE && LA51_0 <= SOME)||(LA51_0 >= SQRT && LA51_0 <= SUM)||(LA51_0 >= TRIM && LA51_0 <= UNARY_PLUS)||(LA51_0 >= UPPER && LA51_0 <= VECTOR_EXPR)) ) {
                            alt51=1;
                        }


                        switch (alt51) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:277:19: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_valueExpression1392);
                    	    valueExpression216=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression216.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt51 >= 1 ) break loop51;
                                EarlyExitException eee =
                                    new EarlyExitException(51, input);
                                throw eee;
                        }
                        cnt51++;
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:278:4: valueExpressionPrimary
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpressionPrimary_in_valueExpression1400);
                    valueExpressionPrimary217=valueExpressionPrimary();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = valueExpressionPrimary217.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpression"


    public static class valueExpressionPrimary_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "valueExpressionPrimary"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:281:1: valueExpressionPrimary : ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH ret= propertyReferencePath ) -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath ) );
    public final GeneratedHQLResolver.valueExpressionPrimary_return valueExpressionPrimary() throws RecognitionException {
        GeneratedHQLResolver.valueExpressionPrimary_return retval = new GeneratedHQLResolver.valueExpressionPrimary_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUB_QUERY225=null;
        CommonTree ALIAS_REF227=null;
        CommonTree DOT_CLASS228=null;
        CommonTree JAVA_CONSTANT230=null;
        CommonTree PATH232=null;
        GeneratedHQLResolver.propertyReferencePath_return ret =null;

        GeneratedHQLResolver.caseExpression_return caseExpression218 =null;

        GeneratedHQLResolver.function_return function219 =null;

        GeneratedHQLResolver.collectionFunction_return collectionFunction220 =null;

        GeneratedHQLResolver.collectionExpression_return collectionExpression221 =null;

        GeneratedHQLResolver.constant_return constant222 =null;

        GeneratedHQLResolver.parameter_return parameter223 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference224 =null;

        GeneratedHQLResolver.queryStatementSet_return queryStatementSet226 =null;

        GeneratedHQLResolver.path_return path229 =null;

        GeneratedHQLResolver.path_return path231 =null;


        CommonTree SUB_QUERY225_tree=null;
        CommonTree ALIAS_REF227_tree=null;
        CommonTree DOT_CLASS228_tree=null;
        CommonTree JAVA_CONSTANT230_tree=null;
        CommonTree PATH232_tree=null;
        RewriteRuleNodeStream stream_PATH=new RewriteRuleNodeStream(adaptor,"token PATH");
        RewriteRuleSubtreeStream stream_propertyReferencePath=new RewriteRuleSubtreeStream(adaptor,"rule propertyReferencePath");
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:282:2: ( caseExpression | function | collectionFunction | collectionExpression | constant | parameter | propertyReference | ^( SUB_QUERY queryStatementSet ) | ALIAS_REF | ^( DOT_CLASS path ) | ^( JAVA_CONSTANT path ) | ^( PATH ret= propertyReferencePath ) -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath ) )
            int alt53=12;
            switch ( input.LA(1) ) {
            case COALESCE:
            case NULLIF:
            case SEARCHED_CASE:
            case SIMPLE_CASE:
                {
                alt53=1;
                }
                break;
            case ABS:
            case AVG:
            case BIT_LENGTH:
            case CAST:
            case CHARACTER_LENGTH:
            case CONCAT:
            case COUNT:
            case CURRENT_DATE:
            case CURRENT_TIME:
            case CURRENT_TIMESTAMP:
            case EXTRACT:
            case FUNCTION:
            case INDEX:
            case LENGTH:
            case LOCATE:
            case LOWER:
            case MAX:
            case MIN:
            case MOD:
            case OCTET_LENGTH:
            case POSITION:
            case SIZE:
            case SQRT:
            case SUBSTRING:
            case SUM:
            case TRIM:
            case UPPER:
                {
                alt53=2;
                }
                break;
            case MAXELEMENT:
            case MAXINDEX:
            case MINELEMENT:
            case MININDEX:
                {
                alt53=3;
                }
                break;
            case ELEMENTS:
            case INDICES:
                {
                alt53=4;
                }
                break;
            case CHARACTER_LITERAL:
            case CONST_STRING_VALUE:
            case DECIMAL_LITERAL:
            case FALSE:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case NULL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
            case TRUE:
                {
                alt53=5;
                }
                break;
            case JPA_PARAM:
            case NAMED_PARAM:
            case PARAM:
                {
                alt53=6;
                }
                break;
            case PROPERTY_REFERENCE:
                {
                alt53=7;
                }
                break;
            case SUB_QUERY:
                {
                alt53=8;
                }
                break;
            case ALIAS_REF:
                {
                alt53=9;
                }
                break;
            case DOT_CLASS:
                {
                alt53=10;
                }
                break;
            case JAVA_CONSTANT:
                {
                alt53=11;
                }
                break;
            case PATH:
                {
                alt53=12;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 53, 0, input);

                throw nvae;

            }

            switch (alt53) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:282:4: caseExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_caseExpression_in_valueExpressionPrimary1411);
                    caseExpression218=caseExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = caseExpression218.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:283:4: function
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_function_in_valueExpressionPrimary1416);
                    function219=function();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = function219.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:284:4: collectionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionFunction_in_valueExpressionPrimary1421);
                    collectionFunction220=collectionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionFunction220.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:285:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_valueExpressionPrimary1426);
                    collectionExpression221=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression221.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:286:4: constant
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_constant_in_valueExpressionPrimary1431);
                    constant222=constant();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = constant222.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:287:4: parameter
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_parameter_in_valueExpressionPrimary1436);
                    parameter223=parameter();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = parameter223.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:288:4: propertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_valueExpressionPrimary1441);
                    propertyReference224=propertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = propertyReference224.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:289:4: ^( SUB_QUERY queryStatementSet )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SUB_QUERY225=(CommonTree)match(input,SUB_QUERY,FOLLOW_SUB_QUERY_in_valueExpressionPrimary1447); 


                    if ( _first_0==null ) _first_0 = SUB_QUERY225;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_queryStatementSet_in_valueExpressionPrimary1449);
                    queryStatementSet226=queryStatementSet();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = queryStatementSet226.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:290:4: ALIAS_REF
                    {
                    _last = (CommonTree)input.LT(1);
                    ALIAS_REF227=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_valueExpressionPrimary1455); 
                     
                    if ( _first_0==null ) _first_0 = ALIAS_REF227;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:291:4: ^( DOT_CLASS path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT_CLASS228=(CommonTree)match(input,DOT_CLASS,FOLLOW_DOT_CLASS_in_valueExpressionPrimary1462); 


                    if ( _first_0==null ) _first_0 = DOT_CLASS228;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_valueExpressionPrimary1464);
                    path229=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path229.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:292:4: ^( JAVA_CONSTANT path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    JAVA_CONSTANT230=(CommonTree)match(input,JAVA_CONSTANT,FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1472); 


                    if ( _first_0==null ) _first_0 = JAVA_CONSTANT230;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_valueExpressionPrimary1474);
                    path231=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path231.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:293:4: ^( PATH ret= propertyReferencePath )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    PATH232=(CommonTree)match(input,PATH,FOLLOW_PATH_in_valueExpressionPrimary1482);  
                    stream_PATH.add(PATH232);


                    if ( _first_0==null ) _first_0 = PATH232;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReferencePath_in_valueExpressionPrimary1486);
                    ret=propertyReferencePath();

                    state._fsp--;

                    stream_propertyReferencePath.add(ret.getTree());

                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    // AST REWRITE
                    // elements: PATH, propertyReferencePath
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 293:38: -> ^( PATH[$PATH, $ret.retPath] propertyReferencePath )
                    {
                        // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:293:41: ^( PATH[$PATH, $ret.retPath] propertyReferencePath )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        new PropertyPathTree(PATH, PATH232, (ret!=null?ret.retPath:null))
                        , root_1);

                        adaptor.addChild(root_1, stream_propertyReferencePath.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
                    input.replaceChildren(adaptor.getParent(retval.start),
                                          adaptor.getChildIndex(retval.start),
                                          adaptor.getChildIndex(_last),
                                          retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "valueExpressionPrimary"


    public static class caseExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "caseExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:296:1: caseExpression : ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) );
    public final GeneratedHQLResolver.caseExpression_return caseExpression() throws RecognitionException {
        GeneratedHQLResolver.caseExpression_return retval = new GeneratedHQLResolver.caseExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NULLIF233=null;
        CommonTree COALESCE236=null;
        CommonTree SIMPLE_CASE239=null;
        CommonTree SEARCHED_CASE243=null;
        GeneratedHQLResolver.valueExpression_return valueExpression234 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression235 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression237 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression238 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression240 =null;

        GeneratedHQLResolver.simpleCaseWhenClause_return simpleCaseWhenClause241 =null;

        GeneratedHQLResolver.elseClause_return elseClause242 =null;

        GeneratedHQLResolver.searchedWhenClause_return searchedWhenClause244 =null;

        GeneratedHQLResolver.elseClause_return elseClause245 =null;


        CommonTree NULLIF233_tree=null;
        CommonTree COALESCE236_tree=null;
        CommonTree SIMPLE_CASE239_tree=null;
        CommonTree SEARCHED_CASE243_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:297:2: ( ^( NULLIF valueExpression valueExpression ) | ^( COALESCE valueExpression ( valueExpression )* ) | ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? ) | ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? ) )
            int alt59=4;
            switch ( input.LA(1) ) {
            case NULLIF:
                {
                alt59=1;
                }
                break;
            case COALESCE:
                {
                alt59=2;
                }
                break;
            case SIMPLE_CASE:
                {
                alt59=3;
                }
                break;
            case SEARCHED_CASE:
                {
                alt59=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 59, 0, input);

                throw nvae;

            }

            switch (alt59) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:297:4: ^( NULLIF valueExpression valueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    NULLIF233=(CommonTree)match(input,NULLIF,FOLLOW_NULLIF_in_caseExpression1513); 


                    if ( _first_0==null ) _first_0 = NULLIF233;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1515);
                    valueExpression234=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression234.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1517);
                    valueExpression235=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression235.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:298:4: ^( COALESCE valueExpression ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    COALESCE236=(CommonTree)match(input,COALESCE,FOLLOW_COALESCE_in_caseExpression1524); 


                    if ( _first_0==null ) _first_0 = COALESCE236;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1526);
                    valueExpression237=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression237.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:298:31: ( valueExpression )*
                    loop54:
                    do {
                        int alt54=2;
                        int LA54_0 = input.LA(1);

                        if ( (LA54_0==ABS||(LA54_0 >= ALIAS_REF && LA54_0 <= ALL)||LA54_0==ANY||(LA54_0 >= ASTERISK && LA54_0 <= AVG)||LA54_0==BIT_LENGTH||(LA54_0 >= CAST && LA54_0 <= CHARACTER_LITERAL)||LA54_0==COALESCE||(LA54_0 >= CONCAT && LA54_0 <= COUNT)||(LA54_0 >= CURRENT_DATE && LA54_0 <= CURRENT_TIMESTAMP)||LA54_0==DECIMAL_LITERAL||(LA54_0 >= DOT_CLASS && LA54_0 <= DOUBLE_PIPE)||LA54_0==ELEMENTS||LA54_0==EXISTS||(LA54_0 >= EXTRACT && LA54_0 <= FALSE)||LA54_0==FLOATING_POINT_LITERAL||LA54_0==FUNCTION||LA54_0==HEX_LITERAL||(LA54_0 >= INDEX && LA54_0 <= INDICES)||LA54_0==INTEGER_LITERAL||LA54_0==JAVA_CONSTANT||LA54_0==JPA_PARAM||LA54_0==LENGTH||(LA54_0 >= LOCATE && LA54_0 <= MAXINDEX)||(LA54_0 >= MIN && LA54_0 <= MINUS)||LA54_0==MOD||LA54_0==NAMED_PARAM||(LA54_0 >= NULL && LA54_0 <= NULLIF)||(LA54_0 >= OCTAL_LITERAL && LA54_0 <= OCTET_LENGTH)||(LA54_0 >= PARAM && LA54_0 <= PATH)||(LA54_0 >= PLUS && LA54_0 <= POSITION)||LA54_0==PROPERTY_REFERENCE||LA54_0==SEARCHED_CASE||(LA54_0 >= SIMPLE_CASE && LA54_0 <= SOME)||(LA54_0 >= SQRT && LA54_0 <= SUM)||(LA54_0 >= TRIM && LA54_0 <= UNARY_PLUS)||(LA54_0 >= UPPER && LA54_0 <= VECTOR_EXPR)) ) {
                            alt54=1;
                        }


                        switch (alt54) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:298:31: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_caseExpression1528);
                    	    valueExpression238=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression238.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop54;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:299:4: ^( SIMPLE_CASE valueExpression ( simpleCaseWhenClause )+ ( elseClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SIMPLE_CASE239=(CommonTree)match(input,SIMPLE_CASE,FOLLOW_SIMPLE_CASE_in_caseExpression1536); 


                    if ( _first_0==null ) _first_0 = SIMPLE_CASE239;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_valueExpression_in_caseExpression1538);
                    valueExpression240=valueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = valueExpression240.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:299:34: ( simpleCaseWhenClause )+
                    int cnt55=0;
                    loop55:
                    do {
                        int alt55=2;
                        int LA55_0 = input.LA(1);

                        if ( (LA55_0==WHEN) ) {
                            alt55=1;
                        }


                        switch (alt55) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:299:34: simpleCaseWhenClause
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_simpleCaseWhenClause_in_caseExpression1540);
                    	    simpleCaseWhenClause241=simpleCaseWhenClause();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = simpleCaseWhenClause241.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt55 >= 1 ) break loop55;
                                EarlyExitException eee =
                                    new EarlyExitException(55, input);
                                throw eee;
                        }
                        cnt55++;
                    } while (true);


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:299:56: ( elseClause )?
                    int alt56=2;
                    int LA56_0 = input.LA(1);

                    if ( (LA56_0==ELSE) ) {
                        alt56=1;
                    }
                    switch (alt56) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:299:56: elseClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_elseClause_in_caseExpression1543);
                            elseClause242=elseClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = elseClause242.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:300:4: ^( SEARCHED_CASE ( searchedWhenClause )+ ( elseClause )? )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SEARCHED_CASE243=(CommonTree)match(input,SEARCHED_CASE,FOLLOW_SEARCHED_CASE_in_caseExpression1551); 


                    if ( _first_0==null ) _first_0 = SEARCHED_CASE243;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:300:20: ( searchedWhenClause )+
                    int cnt57=0;
                    loop57:
                    do {
                        int alt57=2;
                        int LA57_0 = input.LA(1);

                        if ( (LA57_0==WHEN) ) {
                            alt57=1;
                        }


                        switch (alt57) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:300:20: searchedWhenClause
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_searchedWhenClause_in_caseExpression1553);
                    	    searchedWhenClause244=searchedWhenClause();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = searchedWhenClause244.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt57 >= 1 ) break loop57;
                                EarlyExitException eee =
                                    new EarlyExitException(57, input);
                                throw eee;
                        }
                        cnt57++;
                    } while (true);


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:300:40: ( elseClause )?
                    int alt58=2;
                    int LA58_0 = input.LA(1);

                    if ( (LA58_0==ELSE) ) {
                        alt58=1;
                    }
                    switch (alt58) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:300:40: elseClause
                            {
                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_elseClause_in_caseExpression1556);
                            elseClause245=elseClause();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = elseClause245.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "caseExpression"


    public static class simpleCaseWhenClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "simpleCaseWhenClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:303:1: simpleCaseWhenClause : ^( WHEN valueExpression valueExpression ) ;
    public final GeneratedHQLResolver.simpleCaseWhenClause_return simpleCaseWhenClause() throws RecognitionException {
        GeneratedHQLResolver.simpleCaseWhenClause_return retval = new GeneratedHQLResolver.simpleCaseWhenClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHEN246=null;
        GeneratedHQLResolver.valueExpression_return valueExpression247 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression248 =null;


        CommonTree WHEN246_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:2: ( ^( WHEN valueExpression valueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:304:4: ^( WHEN valueExpression valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHEN246=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_simpleCaseWhenClause1570); 


            if ( _first_0==null ) _first_0 = WHEN246;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1572);
            valueExpression247=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression247.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_simpleCaseWhenClause1574);
            valueExpression248=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression248.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "simpleCaseWhenClause"


    public static class searchedWhenClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "searchedWhenClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:307:1: searchedWhenClause : ^( WHEN searchCondition valueExpression ) ;
    public final GeneratedHQLResolver.searchedWhenClause_return searchedWhenClause() throws RecognitionException {
        GeneratedHQLResolver.searchedWhenClause_return retval = new GeneratedHQLResolver.searchedWhenClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree WHEN249=null;
        GeneratedHQLResolver.searchCondition_return searchCondition250 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression251 =null;


        CommonTree WHEN249_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:308:2: ( ^( WHEN searchCondition valueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:308:4: ^( WHEN searchCondition valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            WHEN249=(CommonTree)match(input,WHEN,FOLLOW_WHEN_in_searchedWhenClause1587); 


            if ( _first_0==null ) _first_0 = WHEN249;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_searchCondition_in_searchedWhenClause1589);
            searchCondition250=searchCondition();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = searchCondition250.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_searchedWhenClause1591);
            valueExpression251=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression251.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "searchedWhenClause"


    public static class elseClause_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "elseClause"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:311:1: elseClause : ^( ELSE valueExpression ) ;
    public final GeneratedHQLResolver.elseClause_return elseClause() throws RecognitionException {
        GeneratedHQLResolver.elseClause_return retval = new GeneratedHQLResolver.elseClause_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELSE252=null;
        GeneratedHQLResolver.valueExpression_return valueExpression253 =null;


        CommonTree ELSE252_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:312:2: ( ^( ELSE valueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:312:4: ^( ELSE valueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ELSE252=(CommonTree)match(input,ELSE,FOLLOW_ELSE_in_elseClause1604); 


            if ( _first_0==null ) _first_0 = ELSE252;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_elseClause1606);
            valueExpression253=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression253.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "elseClause"


    public static class function_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "function"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:315:1: function : ( setFunction | standardFunction );
    public final GeneratedHQLResolver.function_return function() throws RecognitionException {
        GeneratedHQLResolver.function_return retval = new GeneratedHQLResolver.function_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.setFunction_return setFunction254 =null;

        GeneratedHQLResolver.standardFunction_return standardFunction255 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:316:2: ( setFunction | standardFunction )
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( (LA60_0==AVG||LA60_0==COUNT||LA60_0==MAX||LA60_0==MIN||LA60_0==SUM) ) {
                alt60=1;
            }
            else if ( (LA60_0==ABS||LA60_0==BIT_LENGTH||(LA60_0 >= CAST && LA60_0 <= CHARACTER_LENGTH)||LA60_0==CONCAT||(LA60_0 >= CURRENT_DATE && LA60_0 <= CURRENT_TIMESTAMP)||LA60_0==EXTRACT||LA60_0==FUNCTION||LA60_0==INDEX||LA60_0==LENGTH||(LA60_0 >= LOCATE && LA60_0 <= LOWER)||LA60_0==MOD||LA60_0==OCTET_LENGTH||LA60_0==POSITION||LA60_0==SIZE||LA60_0==SQRT||LA60_0==SUBSTRING||LA60_0==TRIM||LA60_0==UPPER) ) {
                alt60=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 60, 0, input);

                throw nvae;

            }
            switch (alt60) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:316:4: setFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_setFunction_in_function1618);
                    setFunction254=setFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = setFunction254.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:317:4: standardFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_standardFunction_in_function1623);
                    standardFunction255=standardFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = standardFunction255.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "function"


    public static class setFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "setFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:320:1: setFunction : ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) );
    public final GeneratedHQLResolver.setFunction_return setFunction() throws RecognitionException {
        GeneratedHQLResolver.setFunction_return retval = new GeneratedHQLResolver.setFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUM256=null;
        CommonTree AVG258=null;
        CommonTree MAX260=null;
        CommonTree MIN262=null;
        CommonTree COUNT264=null;
        CommonTree ASTERISK265=null;
        CommonTree set266=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression257 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression259 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression261 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression263 =null;

        GeneratedHQLResolver.countFunctionArguments_return countFunctionArguments267 =null;


        CommonTree SUM256_tree=null;
        CommonTree AVG258_tree=null;
        CommonTree MAX260_tree=null;
        CommonTree MIN262_tree=null;
        CommonTree COUNT264_tree=null;
        CommonTree ASTERISK265_tree=null;
        CommonTree set266_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:321:2: ( ^( SUM numericValueExpression ) | ^( AVG numericValueExpression ) | ^( MAX numericValueExpression ) | ^( MIN numericValueExpression ) | ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) ) )
            int alt62=5;
            switch ( input.LA(1) ) {
            case SUM:
                {
                alt62=1;
                }
                break;
            case AVG:
                {
                alt62=2;
                }
                break;
            case MAX:
                {
                alt62=3;
                }
                break;
            case MIN:
                {
                alt62=4;
                }
                break;
            case COUNT:
                {
                alt62=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 62, 0, input);

                throw nvae;

            }

            switch (alt62) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:321:4: ^( SUM numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    SUM256=(CommonTree)match(input,SUM,FOLLOW_SUM_in_setFunction1635); 


                    if ( _first_0==null ) _first_0 = SUM256;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1637);
                    numericValueExpression257=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression257.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:322:4: ^( AVG numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    AVG258=(CommonTree)match(input,AVG,FOLLOW_AVG_in_setFunction1644); 


                    if ( _first_0==null ) _first_0 = AVG258;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1646);
                    numericValueExpression259=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression259.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:323:4: ^( MAX numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MAX260=(CommonTree)match(input,MAX,FOLLOW_MAX_in_setFunction1653); 


                    if ( _first_0==null ) _first_0 = MAX260;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1655);
                    numericValueExpression261=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression261.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:324:4: ^( MIN numericValueExpression )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    MIN262=(CommonTree)match(input,MIN,FOLLOW_MIN_in_setFunction1662); 


                    if ( _first_0==null ) _first_0 = MIN262;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_setFunction1664);
                    numericValueExpression263=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression263.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:325:4: ^( COUNT ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments ) )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    COUNT264=(CommonTree)match(input,COUNT,FOLLOW_COUNT_in_setFunction1671); 


                    if ( _first_0==null ) _first_0 = COUNT264;
                    match(input, Token.DOWN, null); 
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:325:12: ( ASTERISK | ( DISTINCT | ALL ) countFunctionArguments )
                    int alt61=2;
                    int LA61_0 = input.LA(1);

                    if ( (LA61_0==ASTERISK) ) {
                        alt61=1;
                    }
                    else if ( (LA61_0==ALL||LA61_0==DISTINCT) ) {
                        alt61=2;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 61, 0, input);

                        throw nvae;

                    }
                    switch (alt61) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:325:13: ASTERISK
                            {
                            _last = (CommonTree)input.LT(1);
                            ASTERISK265=(CommonTree)match(input,ASTERISK,FOLLOW_ASTERISK_in_setFunction1674); 
                             
                            if ( _first_1==null ) _first_1 = ASTERISK265;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;
                        case 2 :
                            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:325:24: ( DISTINCT | ALL ) countFunctionArguments
                            {
                            _last = (CommonTree)input.LT(1);
                            set266=(CommonTree)input.LT(1);

                            if ( input.LA(1)==ALL||input.LA(1)==DISTINCT ) {
                                input.consume();
                                state.errorRecovery=false;
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                throw mse;
                            }


                            _last = (CommonTree)input.LT(1);
                            pushFollow(FOLLOW_countFunctionArguments_in_setFunction1684);
                            countFunctionArguments267=countFunctionArguments();

                            state._fsp--;

                             
                            if ( _first_1==null ) _first_1 = countFunctionArguments267.tree;


                            retval.tree = (CommonTree)_first_0;
                            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                            }
                            break;

                    }


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "setFunction"


    public static class standardFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "standardFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:328:1: standardFunction : ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction );
    public final GeneratedHQLResolver.standardFunction_return standardFunction() throws RecognitionException {
        GeneratedHQLResolver.standardFunction_return retval = new GeneratedHQLResolver.standardFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.functionFunction_return functionFunction268 =null;

        GeneratedHQLResolver.castFunction_return castFunction269 =null;

        GeneratedHQLResolver.concatFunction_return concatFunction270 =null;

        GeneratedHQLResolver.substringFunction_return substringFunction271 =null;

        GeneratedHQLResolver.trimFunction_return trimFunction272 =null;

        GeneratedHQLResolver.upperFunction_return upperFunction273 =null;

        GeneratedHQLResolver.lowerFunction_return lowerFunction274 =null;

        GeneratedHQLResolver.lengthFunction_return lengthFunction275 =null;

        GeneratedHQLResolver.locateFunction_return locateFunction276 =null;

        GeneratedHQLResolver.absFunction_return absFunction277 =null;

        GeneratedHQLResolver.sqrtFunction_return sqrtFunction278 =null;

        GeneratedHQLResolver.modFunction_return modFunction279 =null;

        GeneratedHQLResolver.sizeFunction_return sizeFunction280 =null;

        GeneratedHQLResolver.indexFunction_return indexFunction281 =null;

        GeneratedHQLResolver.currentDateFunction_return currentDateFunction282 =null;

        GeneratedHQLResolver.currentTimeFunction_return currentTimeFunction283 =null;

        GeneratedHQLResolver.currentTimestampFunction_return currentTimestampFunction284 =null;

        GeneratedHQLResolver.extractFunction_return extractFunction285 =null;

        GeneratedHQLResolver.positionFunction_return positionFunction286 =null;

        GeneratedHQLResolver.charLengthFunction_return charLengthFunction287 =null;

        GeneratedHQLResolver.octetLengthFunction_return octetLengthFunction288 =null;

        GeneratedHQLResolver.bitLengthFunction_return bitLengthFunction289 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:329:2: ( functionFunction | castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | sizeFunction | indexFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction )
            int alt63=22;
            switch ( input.LA(1) ) {
            case FUNCTION:
                {
                alt63=1;
                }
                break;
            case CAST:
                {
                alt63=2;
                }
                break;
            case CONCAT:
                {
                alt63=3;
                }
                break;
            case SUBSTRING:
                {
                alt63=4;
                }
                break;
            case TRIM:
                {
                alt63=5;
                }
                break;
            case UPPER:
                {
                alt63=6;
                }
                break;
            case LOWER:
                {
                alt63=7;
                }
                break;
            case LENGTH:
                {
                alt63=8;
                }
                break;
            case LOCATE:
                {
                alt63=9;
                }
                break;
            case ABS:
                {
                alt63=10;
                }
                break;
            case SQRT:
                {
                alt63=11;
                }
                break;
            case MOD:
                {
                alt63=12;
                }
                break;
            case SIZE:
                {
                alt63=13;
                }
                break;
            case INDEX:
                {
                alt63=14;
                }
                break;
            case CURRENT_DATE:
                {
                alt63=15;
                }
                break;
            case CURRENT_TIME:
                {
                alt63=16;
                }
                break;
            case CURRENT_TIMESTAMP:
                {
                alt63=17;
                }
                break;
            case EXTRACT:
                {
                alt63=18;
                }
                break;
            case POSITION:
                {
                alt63=19;
                }
                break;
            case CHARACTER_LENGTH:
                {
                alt63=20;
                }
                break;
            case OCTET_LENGTH:
                {
                alt63=21;
                }
                break;
            case BIT_LENGTH:
                {
                alt63=22;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 63, 0, input);

                throw nvae;

            }

            switch (alt63) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:329:4: functionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_functionFunction_in_standardFunction1697);
                    functionFunction268=functionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = functionFunction268.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:330:4: castFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_castFunction_in_standardFunction1702);
                    castFunction269=castFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = castFunction269.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:331:4: concatFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_concatFunction_in_standardFunction1707);
                    concatFunction270=concatFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = concatFunction270.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:332:4: substringFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_substringFunction_in_standardFunction1712);
                    substringFunction271=substringFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = substringFunction271.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:333:4: trimFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_trimFunction_in_standardFunction1717);
                    trimFunction272=trimFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = trimFunction272.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:334:4: upperFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_upperFunction_in_standardFunction1722);
                    upperFunction273=upperFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = upperFunction273.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:335:4: lowerFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_lowerFunction_in_standardFunction1727);
                    lowerFunction274=lowerFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = lowerFunction274.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:336:4: lengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_lengthFunction_in_standardFunction1732);
                    lengthFunction275=lengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = lengthFunction275.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:337:4: locateFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_locateFunction_in_standardFunction1737);
                    locateFunction276=locateFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = locateFunction276.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:338:4: absFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_absFunction_in_standardFunction1742);
                    absFunction277=absFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = absFunction277.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:339:4: sqrtFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sqrtFunction_in_standardFunction1747);
                    sqrtFunction278=sqrtFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = sqrtFunction278.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:340:4: modFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_modFunction_in_standardFunction1752);
                    modFunction279=modFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = modFunction279.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:341:4: sizeFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_sizeFunction_in_standardFunction1757);
                    sizeFunction280=sizeFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = sizeFunction280.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:342:4: indexFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_indexFunction_in_standardFunction1762);
                    indexFunction281=indexFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = indexFunction281.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:343:4: currentDateFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentDateFunction_in_standardFunction1767);
                    currentDateFunction282=currentDateFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentDateFunction282.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:344:4: currentTimeFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentTimeFunction_in_standardFunction1772);
                    currentTimeFunction283=currentTimeFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentTimeFunction283.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:345:4: currentTimestampFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_currentTimestampFunction_in_standardFunction1777);
                    currentTimestampFunction284=currentTimestampFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = currentTimestampFunction284.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:346:4: extractFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_extractFunction_in_standardFunction1782);
                    extractFunction285=extractFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = extractFunction285.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:347:4: positionFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_positionFunction_in_standardFunction1787);
                    positionFunction286=positionFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = positionFunction286.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 20 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:348:4: charLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_charLengthFunction_in_standardFunction1792);
                    charLengthFunction287=charLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = charLengthFunction287.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 21 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:349:4: octetLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_octetLengthFunction_in_standardFunction1797);
                    octetLengthFunction288=octetLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = octetLengthFunction288.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 22 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:350:4: bitLengthFunction
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_bitLengthFunction_in_standardFunction1802);
                    bitLengthFunction289=bitLengthFunction();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = bitLengthFunction289.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "standardFunction"


    public static class functionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "functionFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:353:1: functionFunction : ^( FUNCTION ( valueExpression )* ) ;
    public final GeneratedHQLResolver.functionFunction_return functionFunction() throws RecognitionException {
        GeneratedHQLResolver.functionFunction_return retval = new GeneratedHQLResolver.functionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree FUNCTION290=null;
        GeneratedHQLResolver.valueExpression_return valueExpression291 =null;


        CommonTree FUNCTION290_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:354:2: ( ^( FUNCTION ( valueExpression )* ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:354:4: ^( FUNCTION ( valueExpression )* )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            FUNCTION290=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_functionFunction1815); 


            if ( _first_0==null ) _first_0 = FUNCTION290;
            if ( input.LA(1)==Token.DOWN ) {
                match(input, Token.DOWN, null); 
                // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:354:16: ( valueExpression )*
                loop64:
                do {
                    int alt64=2;
                    int LA64_0 = input.LA(1);

                    if ( (LA64_0==ABS||(LA64_0 >= ALIAS_REF && LA64_0 <= ALL)||LA64_0==ANY||(LA64_0 >= ASTERISK && LA64_0 <= AVG)||LA64_0==BIT_LENGTH||(LA64_0 >= CAST && LA64_0 <= CHARACTER_LITERAL)||LA64_0==COALESCE||(LA64_0 >= CONCAT && LA64_0 <= COUNT)||(LA64_0 >= CURRENT_DATE && LA64_0 <= CURRENT_TIMESTAMP)||LA64_0==DECIMAL_LITERAL||(LA64_0 >= DOT_CLASS && LA64_0 <= DOUBLE_PIPE)||LA64_0==ELEMENTS||LA64_0==EXISTS||(LA64_0 >= EXTRACT && LA64_0 <= FALSE)||LA64_0==FLOATING_POINT_LITERAL||LA64_0==FUNCTION||LA64_0==HEX_LITERAL||(LA64_0 >= INDEX && LA64_0 <= INDICES)||LA64_0==INTEGER_LITERAL||LA64_0==JAVA_CONSTANT||LA64_0==JPA_PARAM||LA64_0==LENGTH||(LA64_0 >= LOCATE && LA64_0 <= MAXINDEX)||(LA64_0 >= MIN && LA64_0 <= MINUS)||LA64_0==MOD||LA64_0==NAMED_PARAM||(LA64_0 >= NULL && LA64_0 <= NULLIF)||(LA64_0 >= OCTAL_LITERAL && LA64_0 <= OCTET_LENGTH)||(LA64_0 >= PARAM && LA64_0 <= PATH)||(LA64_0 >= PLUS && LA64_0 <= POSITION)||LA64_0==PROPERTY_REFERENCE||LA64_0==SEARCHED_CASE||(LA64_0 >= SIMPLE_CASE && LA64_0 <= SOME)||(LA64_0 >= SQRT && LA64_0 <= SUM)||(LA64_0 >= TRIM && LA64_0 <= UNARY_PLUS)||(LA64_0 >= UPPER && LA64_0 <= VECTOR_EXPR)) ) {
                        alt64=1;
                    }


                    switch (alt64) {
                	case 1 :
                	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:354:16: valueExpression
                	    {
                	    _last = (CommonTree)input.LT(1);
                	    pushFollow(FOLLOW_valueExpression_in_functionFunction1817);
                	    valueExpression291=valueExpression();

                	    state._fsp--;

                	     
                	    if ( _first_1==null ) _first_1 = valueExpression291.tree;


                	    retval.tree = (CommonTree)_first_0;
                	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                	    }
                	    break;

                	default :
                	    break loop64;
                    }
                } while (true);


                match(input, Token.UP, null); 
            }
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "functionFunction"


    public static class castFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "castFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:357:1: castFunction : ^( CAST valueExpression IDENTIFIER ) ;
    public final GeneratedHQLResolver.castFunction_return castFunction() throws RecognitionException {
        GeneratedHQLResolver.castFunction_return retval = new GeneratedHQLResolver.castFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CAST292=null;
        CommonTree IDENTIFIER294=null;
        GeneratedHQLResolver.valueExpression_return valueExpression293 =null;


        CommonTree CAST292_tree=null;
        CommonTree IDENTIFIER294_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:358:2: ( ^( CAST valueExpression IDENTIFIER ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:358:4: ^( CAST valueExpression IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CAST292=(CommonTree)match(input,CAST,FOLLOW_CAST_in_castFunction1832); 


            if ( _first_0==null ) _first_0 = CAST292;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_castFunction1834);
            valueExpression293=valueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = valueExpression293.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER294=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_castFunction1836); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER294;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "castFunction"


    public static class concatFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concatFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:362:1: concatFunction : ^( CONCAT ( valueExpression )+ ) ;
    public final GeneratedHQLResolver.concatFunction_return concatFunction() throws RecognitionException {
        GeneratedHQLResolver.concatFunction_return retval = new GeneratedHQLResolver.concatFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CONCAT295=null;
        GeneratedHQLResolver.valueExpression_return valueExpression296 =null;


        CommonTree CONCAT295_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:2: ( ^( CONCAT ( valueExpression )+ ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:4: ^( CONCAT ( valueExpression )+ )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CONCAT295=(CommonTree)match(input,CONCAT,FOLLOW_CONCAT_in_concatFunction1851); 


            if ( _first_0==null ) _first_0 = CONCAT295;
            match(input, Token.DOWN, null); 
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:13: ( valueExpression )+
            int cnt65=0;
            loop65:
            do {
                int alt65=2;
                int LA65_0 = input.LA(1);

                if ( (LA65_0==ABS||(LA65_0 >= ALIAS_REF && LA65_0 <= ALL)||LA65_0==ANY||(LA65_0 >= ASTERISK && LA65_0 <= AVG)||LA65_0==BIT_LENGTH||(LA65_0 >= CAST && LA65_0 <= CHARACTER_LITERAL)||LA65_0==COALESCE||(LA65_0 >= CONCAT && LA65_0 <= COUNT)||(LA65_0 >= CURRENT_DATE && LA65_0 <= CURRENT_TIMESTAMP)||LA65_0==DECIMAL_LITERAL||(LA65_0 >= DOT_CLASS && LA65_0 <= DOUBLE_PIPE)||LA65_0==ELEMENTS||LA65_0==EXISTS||(LA65_0 >= EXTRACT && LA65_0 <= FALSE)||LA65_0==FLOATING_POINT_LITERAL||LA65_0==FUNCTION||LA65_0==HEX_LITERAL||(LA65_0 >= INDEX && LA65_0 <= INDICES)||LA65_0==INTEGER_LITERAL||LA65_0==JAVA_CONSTANT||LA65_0==JPA_PARAM||LA65_0==LENGTH||(LA65_0 >= LOCATE && LA65_0 <= MAXINDEX)||(LA65_0 >= MIN && LA65_0 <= MINUS)||LA65_0==MOD||LA65_0==NAMED_PARAM||(LA65_0 >= NULL && LA65_0 <= NULLIF)||(LA65_0 >= OCTAL_LITERAL && LA65_0 <= OCTET_LENGTH)||(LA65_0 >= PARAM && LA65_0 <= PATH)||(LA65_0 >= PLUS && LA65_0 <= POSITION)||LA65_0==PROPERTY_REFERENCE||LA65_0==SEARCHED_CASE||(LA65_0 >= SIMPLE_CASE && LA65_0 <= SOME)||(LA65_0 >= SQRT && LA65_0 <= SUM)||(LA65_0 >= TRIM && LA65_0 <= UNARY_PLUS)||(LA65_0 >= UPPER && LA65_0 <= VECTOR_EXPR)) ) {
                    alt65=1;
                }


                switch (alt65) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:363:13: valueExpression
            	    {
            	    _last = (CommonTree)input.LT(1);
            	    pushFollow(FOLLOW_valueExpression_in_concatFunction1853);
            	    valueExpression296=valueExpression();

            	    state._fsp--;

            	     
            	    if ( _first_1==null ) _first_1 = valueExpression296.tree;


            	    retval.tree = (CommonTree)_first_0;
            	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
            	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            	    }
            	    break;

            	default :
            	    if ( cnt65 >= 1 ) break loop65;
                        EarlyExitException eee =
                            new EarlyExitException(65, input);
                        throw eee;
                }
                cnt65++;
            } while (true);


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatFunction"


    public static class substringFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substringFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:366:1: substringFunction : ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) ;
    public final GeneratedHQLResolver.substringFunction_return substringFunction() throws RecognitionException {
        GeneratedHQLResolver.substringFunction_return retval = new GeneratedHQLResolver.substringFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SUBSTRING297=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression298 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression299 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression300 =null;


        CommonTree SUBSTRING297_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:367:2: ( ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:367:4: ^( SUBSTRING characterValueExpression numericValueExpression ( numericValueExpression )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SUBSTRING297=(CommonTree)match(input,SUBSTRING,FOLLOW_SUBSTRING_in_substringFunction1867); 


            if ( _first_0==null ) _first_0 = SUBSTRING297;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_substringFunction1869);
            characterValueExpression298=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression298.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_substringFunction1871);
            numericValueExpression299=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression299.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:367:64: ( numericValueExpression )?
            int alt66=2;
            int LA66_0 = input.LA(1);

            if ( (LA66_0==ABS||(LA66_0 >= ALIAS_REF && LA66_0 <= ALL)||LA66_0==ANY||(LA66_0 >= ASTERISK && LA66_0 <= AVG)||LA66_0==BIT_LENGTH||(LA66_0 >= CAST && LA66_0 <= CHARACTER_LITERAL)||LA66_0==COALESCE||(LA66_0 >= CONCAT && LA66_0 <= COUNT)||(LA66_0 >= CURRENT_DATE && LA66_0 <= CURRENT_TIMESTAMP)||LA66_0==DECIMAL_LITERAL||(LA66_0 >= DOT_CLASS && LA66_0 <= DOUBLE_PIPE)||LA66_0==ELEMENTS||LA66_0==EXISTS||(LA66_0 >= EXTRACT && LA66_0 <= FALSE)||LA66_0==FLOATING_POINT_LITERAL||LA66_0==FUNCTION||LA66_0==HEX_LITERAL||(LA66_0 >= INDEX && LA66_0 <= INDICES)||LA66_0==INTEGER_LITERAL||LA66_0==JAVA_CONSTANT||LA66_0==JPA_PARAM||LA66_0==LENGTH||(LA66_0 >= LOCATE && LA66_0 <= MAXINDEX)||(LA66_0 >= MIN && LA66_0 <= MINUS)||LA66_0==MOD||LA66_0==NAMED_PARAM||(LA66_0 >= NULL && LA66_0 <= NULLIF)||(LA66_0 >= OCTAL_LITERAL && LA66_0 <= OCTET_LENGTH)||(LA66_0 >= PARAM && LA66_0 <= PATH)||(LA66_0 >= PLUS && LA66_0 <= POSITION)||LA66_0==PROPERTY_REFERENCE||LA66_0==SEARCHED_CASE||(LA66_0 >= SIMPLE_CASE && LA66_0 <= SOME)||(LA66_0 >= SQRT && LA66_0 <= SUM)||(LA66_0 >= TRIM && LA66_0 <= UNARY_PLUS)||(LA66_0 >= UPPER && LA66_0 <= VECTOR_EXPR)) ) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:367:64: numericValueExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_substringFunction1873);
                    numericValueExpression300=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression300.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substringFunction"


    public static class trimFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:370:1: trimFunction : ^( TRIM trimOperands ) ;
    public final GeneratedHQLResolver.trimFunction_return trimFunction() throws RecognitionException {
        GeneratedHQLResolver.trimFunction_return retval = new GeneratedHQLResolver.trimFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree TRIM301=null;
        GeneratedHQLResolver.trimOperands_return trimOperands302 =null;


        CommonTree TRIM301_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:371:2: ( ^( TRIM trimOperands ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:371:4: ^( TRIM trimOperands )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            TRIM301=(CommonTree)match(input,TRIM,FOLLOW_TRIM_in_trimFunction1887); 


            if ( _first_0==null ) _first_0 = TRIM301;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_trimOperands_in_trimFunction1889);
            trimOperands302=trimOperands();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = trimOperands302.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimFunction"


    public static class trimOperands_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimOperands"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:374:1: trimOperands : ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) ;
    public final GeneratedHQLResolver.trimOperands_return trimOperands() throws RecognitionException {
        GeneratedHQLResolver.trimOperands_return retval = new GeneratedHQLResolver.trimOperands_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set303=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression304 =null;

        GeneratedHQLResolver.characterValueExpression_return characterValueExpression305 =null;


        CommonTree set303_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:375:2: ( ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:375:4: ^( ( LEADING | TRAILING | BOTH ) characterValueExpression characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            set303=(CommonTree)input.LT(1);

            if ( input.LA(1)==BOTH||input.LA(1)==LEADING||input.LA(1)==TRAILING ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( _first_0==null ) _first_0 = set303;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_trimOperands1910);
            characterValueExpression304=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression304.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_trimOperands1912);
            characterValueExpression305=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression305.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimOperands"


    public static class upperFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upperFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:378:1: upperFunction : ^( UPPER characterValueExpression ) ;
    public final GeneratedHQLResolver.upperFunction_return upperFunction() throws RecognitionException {
        GeneratedHQLResolver.upperFunction_return retval = new GeneratedHQLResolver.upperFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree UPPER306=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression307 =null;


        CommonTree UPPER306_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:379:2: ( ^( UPPER characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:379:4: ^( UPPER characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            UPPER306=(CommonTree)match(input,UPPER,FOLLOW_UPPER_in_upperFunction1925); 


            if ( _first_0==null ) _first_0 = UPPER306;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_upperFunction1927);
            characterValueExpression307=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression307.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upperFunction"


    public static class lowerFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lowerFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:382:1: lowerFunction : ^( LOWER characterValueExpression ) ;
    public final GeneratedHQLResolver.lowerFunction_return lowerFunction() throws RecognitionException {
        GeneratedHQLResolver.lowerFunction_return retval = new GeneratedHQLResolver.lowerFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LOWER308=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression309 =null;


        CommonTree LOWER308_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:383:2: ( ^( LOWER characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:383:4: ^( LOWER characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LOWER308=(CommonTree)match(input,LOWER,FOLLOW_LOWER_in_lowerFunction1940); 


            if ( _first_0==null ) _first_0 = LOWER308;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_lowerFunction1942);
            characterValueExpression309=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression309.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lowerFunction"


    public static class lengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:386:1: lengthFunction : ^( LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.lengthFunction_return lengthFunction() throws RecognitionException {
        GeneratedHQLResolver.lengthFunction_return retval = new GeneratedHQLResolver.lengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LENGTH310=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression311 =null;


        CommonTree LENGTH310_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:387:2: ( ^( LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:387:4: ^( LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LENGTH310=(CommonTree)match(input,LENGTH,FOLLOW_LENGTH_in_lengthFunction1955); 


            if ( _first_0==null ) _first_0 = LENGTH310;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_lengthFunction1957);
            characterValueExpression311=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression311.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lengthFunction"


    public static class locateFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:390:1: locateFunction : ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) ;
    public final GeneratedHQLResolver.locateFunction_return locateFunction() throws RecognitionException {
        GeneratedHQLResolver.locateFunction_return retval = new GeneratedHQLResolver.locateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LOCATE312=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression313 =null;

        GeneratedHQLResolver.characterValueExpression_return characterValueExpression314 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression315 =null;


        CommonTree LOCATE312_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:391:2: ( ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:391:4: ^( LOCATE characterValueExpression characterValueExpression ( numericValueExpression )? )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LOCATE312=(CommonTree)match(input,LOCATE,FOLLOW_LOCATE_in_locateFunction1970); 


            if ( _first_0==null ) _first_0 = LOCATE312;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1972);
            characterValueExpression313=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression313.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_locateFunction1974);
            characterValueExpression314=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression314.tree;


            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:391:63: ( numericValueExpression )?
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==ABS||(LA67_0 >= ALIAS_REF && LA67_0 <= ALL)||LA67_0==ANY||(LA67_0 >= ASTERISK && LA67_0 <= AVG)||LA67_0==BIT_LENGTH||(LA67_0 >= CAST && LA67_0 <= CHARACTER_LITERAL)||LA67_0==COALESCE||(LA67_0 >= CONCAT && LA67_0 <= COUNT)||(LA67_0 >= CURRENT_DATE && LA67_0 <= CURRENT_TIMESTAMP)||LA67_0==DECIMAL_LITERAL||(LA67_0 >= DOT_CLASS && LA67_0 <= DOUBLE_PIPE)||LA67_0==ELEMENTS||LA67_0==EXISTS||(LA67_0 >= EXTRACT && LA67_0 <= FALSE)||LA67_0==FLOATING_POINT_LITERAL||LA67_0==FUNCTION||LA67_0==HEX_LITERAL||(LA67_0 >= INDEX && LA67_0 <= INDICES)||LA67_0==INTEGER_LITERAL||LA67_0==JAVA_CONSTANT||LA67_0==JPA_PARAM||LA67_0==LENGTH||(LA67_0 >= LOCATE && LA67_0 <= MAXINDEX)||(LA67_0 >= MIN && LA67_0 <= MINUS)||LA67_0==MOD||LA67_0==NAMED_PARAM||(LA67_0 >= NULL && LA67_0 <= NULLIF)||(LA67_0 >= OCTAL_LITERAL && LA67_0 <= OCTET_LENGTH)||(LA67_0 >= PARAM && LA67_0 <= PATH)||(LA67_0 >= PLUS && LA67_0 <= POSITION)||LA67_0==PROPERTY_REFERENCE||LA67_0==SEARCHED_CASE||(LA67_0 >= SIMPLE_CASE && LA67_0 <= SOME)||(LA67_0 >= SQRT && LA67_0 <= SUM)||(LA67_0 >= TRIM && LA67_0 <= UNARY_PLUS)||(LA67_0 >= UPPER && LA67_0 <= VECTOR_EXPR)) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:391:63: numericValueExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numericValueExpression_in_locateFunction1976);
                    numericValueExpression315=numericValueExpression();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = numericValueExpression315.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateFunction"


    public static class absFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "absFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:394:1: absFunction : ^( ABS numericValueExpression ) ;
    public final GeneratedHQLResolver.absFunction_return absFunction() throws RecognitionException {
        GeneratedHQLResolver.absFunction_return retval = new GeneratedHQLResolver.absFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ABS316=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression317 =null;


        CommonTree ABS316_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:395:2: ( ^( ABS numericValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:395:4: ^( ABS numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            ABS316=(CommonTree)match(input,ABS,FOLLOW_ABS_in_absFunction1990); 


            if ( _first_0==null ) _first_0 = ABS316;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_absFunction1992);
            numericValueExpression317=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression317.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "absFunction"


    public static class sqrtFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrtFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:398:1: sqrtFunction : ^( SQRT numericValueExpression ) ;
    public final GeneratedHQLResolver.sqrtFunction_return sqrtFunction() throws RecognitionException {
        GeneratedHQLResolver.sqrtFunction_return retval = new GeneratedHQLResolver.sqrtFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SQRT318=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression319 =null;


        CommonTree SQRT318_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:2: ( ^( SQRT numericValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:399:4: ^( SQRT numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SQRT318=(CommonTree)match(input,SQRT,FOLLOW_SQRT_in_sqrtFunction2005); 


            if ( _first_0==null ) _first_0 = SQRT318;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_sqrtFunction2007);
            numericValueExpression319=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression319.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrtFunction"


    public static class modFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "modFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:402:1: modFunction : ^( MOD numericValueExpression numericValueExpression ) ;
    public final GeneratedHQLResolver.modFunction_return modFunction() throws RecognitionException {
        GeneratedHQLResolver.modFunction_return retval = new GeneratedHQLResolver.modFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree MOD320=null;
        GeneratedHQLResolver.numericValueExpression_return numericValueExpression321 =null;

        GeneratedHQLResolver.numericValueExpression_return numericValueExpression322 =null;


        CommonTree MOD320_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:403:2: ( ^( MOD numericValueExpression numericValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:403:4: ^( MOD numericValueExpression numericValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            MOD320=(CommonTree)match(input,MOD,FOLLOW_MOD_in_modFunction2020); 


            if ( _first_0==null ) _first_0 = MOD320;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_modFunction2022);
            numericValueExpression321=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression321.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_numericValueExpression_in_modFunction2024);
            numericValueExpression322=numericValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = numericValueExpression322.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "modFunction"


    public static class sizeFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sizeFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:406:1: sizeFunction : ^( SIZE propertyReference ) ;
    public final GeneratedHQLResolver.sizeFunction_return sizeFunction() throws RecognitionException {
        GeneratedHQLResolver.sizeFunction_return retval = new GeneratedHQLResolver.sizeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree SIZE323=null;
        GeneratedHQLResolver.propertyReference_return propertyReference324 =null;


        CommonTree SIZE323_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:407:2: ( ^( SIZE propertyReference ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:407:4: ^( SIZE propertyReference )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            SIZE323=(CommonTree)match(input,SIZE,FOLLOW_SIZE_in_sizeFunction2037); 


            if ( _first_0==null ) _first_0 = SIZE323;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReference_in_sizeFunction2039);
            propertyReference324=propertyReference();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = propertyReference324.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sizeFunction"


    public static class indexFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:410:1: indexFunction : ^( INDEX ALIAS_REF ) ;
    public final GeneratedHQLResolver.indexFunction_return indexFunction() throws RecognitionException {
        GeneratedHQLResolver.indexFunction_return retval = new GeneratedHQLResolver.indexFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree INDEX325=null;
        CommonTree ALIAS_REF326=null;

        CommonTree INDEX325_tree=null;
        CommonTree ALIAS_REF326_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:411:2: ( ^( INDEX ALIAS_REF ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:411:4: ^( INDEX ALIAS_REF )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            INDEX325=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_indexFunction2052); 


            if ( _first_0==null ) _first_0 = INDEX325;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            ALIAS_REF326=(CommonTree)match(input,ALIAS_REF,FOLLOW_ALIAS_REF_in_indexFunction2054); 
             
            if ( _first_1==null ) _first_1 = ALIAS_REF326;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexFunction"


    public static class currentDateFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentDateFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:414:1: currentDateFunction : CURRENT_DATE ;
    public final GeneratedHQLResolver.currentDateFunction_return currentDateFunction() throws RecognitionException {
        GeneratedHQLResolver.currentDateFunction_return retval = new GeneratedHQLResolver.currentDateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_DATE327=null;

        CommonTree CURRENT_DATE327_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:415:2: ( CURRENT_DATE )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:415:4: CURRENT_DATE
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_DATE327=(CommonTree)match(input,CURRENT_DATE,FOLLOW_CURRENT_DATE_in_currentDateFunction2066); 
             
            if ( _first_0==null ) _first_0 = CURRENT_DATE327;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentDateFunction"


    public static class currentTimeFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimeFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:418:1: currentTimeFunction : CURRENT_TIME ;
    public final GeneratedHQLResolver.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
        GeneratedHQLResolver.currentTimeFunction_return retval = new GeneratedHQLResolver.currentTimeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_TIME328=null;

        CommonTree CURRENT_TIME328_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:419:2: ( CURRENT_TIME )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:419:4: CURRENT_TIME
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_TIME328=(CommonTree)match(input,CURRENT_TIME,FOLLOW_CURRENT_TIME_in_currentTimeFunction2077); 
             
            if ( _first_0==null ) _first_0 = CURRENT_TIME328;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimeFunction"


    public static class currentTimestampFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimestampFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:422:1: currentTimestampFunction : CURRENT_TIMESTAMP ;
    public final GeneratedHQLResolver.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
        GeneratedHQLResolver.currentTimestampFunction_return retval = new GeneratedHQLResolver.currentTimestampFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CURRENT_TIMESTAMP329=null;

        CommonTree CURRENT_TIMESTAMP329_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:423:2: ( CURRENT_TIMESTAMP )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:423:4: CURRENT_TIMESTAMP
            {
            _last = (CommonTree)input.LT(1);
            CURRENT_TIMESTAMP329=(CommonTree)match(input,CURRENT_TIMESTAMP,FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2088); 
             
            if ( _first_0==null ) _first_0 = CURRENT_TIMESTAMP329;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimestampFunction"


    public static class extractFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:426:1: extractFunction : ^( EXTRACT extractField datetimeValueExpression ) ;
    public final GeneratedHQLResolver.extractFunction_return extractFunction() throws RecognitionException {
        GeneratedHQLResolver.extractFunction_return retval = new GeneratedHQLResolver.extractFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree EXTRACT330=null;
        GeneratedHQLResolver.extractField_return extractField331 =null;

        GeneratedHQLResolver.datetimeValueExpression_return datetimeValueExpression332 =null;


        CommonTree EXTRACT330_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:427:2: ( ^( EXTRACT extractField datetimeValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:427:4: ^( EXTRACT extractField datetimeValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            EXTRACT330=(CommonTree)match(input,EXTRACT,FOLLOW_EXTRACT_in_extractFunction2100); 


            if ( _first_0==null ) _first_0 = EXTRACT330;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_extractField_in_extractFunction2102);
            extractField331=extractField();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = extractField331.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_datetimeValueExpression_in_extractFunction2104);
            datetimeValueExpression332=datetimeValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = datetimeValueExpression332.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractFunction"


    public static class extractField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractField"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:430:1: extractField : ( datetimeField | timeZoneField );
    public final GeneratedHQLResolver.extractField_return extractField() throws RecognitionException {
        GeneratedHQLResolver.extractField_return retval = new GeneratedHQLResolver.extractField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.datetimeField_return datetimeField333 =null;

        GeneratedHQLResolver.timeZoneField_return timeZoneField334 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:431:2: ( datetimeField | timeZoneField )
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( (LA68_0==DAY||LA68_0==HOUR||LA68_0==MINUTE||LA68_0==MONTH||LA68_0==SECOND||LA68_0==YEAR) ) {
                alt68=1;
            }
            else if ( ((LA68_0 >= TIMEZONE_HOUR && LA68_0 <= TIMEZONE_MINUTE)) ) {
                alt68=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 68, 0, input);

                throw nvae;

            }
            switch (alt68) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:431:4: datetimeField
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_datetimeField_in_extractField2116);
                    datetimeField333=datetimeField();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = datetimeField333.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:432:4: timeZoneField
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_timeZoneField_in_extractField2121);
                    timeZoneField334=timeZoneField();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = timeZoneField334.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractField"


    public static class datetimeField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeField"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:435:1: datetimeField : ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND );
    public final GeneratedHQLResolver.datetimeField_return datetimeField() throws RecognitionException {
        GeneratedHQLResolver.datetimeField_return retval = new GeneratedHQLResolver.datetimeField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set335=null;

        CommonTree set335_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:436:2: ( YEAR | MONTH | DAY | HOUR | MINUTE | SECOND )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set335=(CommonTree)input.LT(1);

            if ( input.LA(1)==DAY||input.LA(1)==HOUR||input.LA(1)==MINUTE||input.LA(1)==MONTH||input.LA(1)==SECOND||input.LA(1)==YEAR ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeField"


    public static class timeZoneField_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeZoneField"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:444:1: timeZoneField : ( TIMEZONE_HOUR | TIMEZONE_MINUTE );
    public final GeneratedHQLResolver.timeZoneField_return timeZoneField() throws RecognitionException {
        GeneratedHQLResolver.timeZoneField_return retval = new GeneratedHQLResolver.timeZoneField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set336=null;

        CommonTree set336_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:445:2: ( TIMEZONE_HOUR | TIMEZONE_MINUTE )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set336=(CommonTree)input.LT(1);

            if ( (input.LA(1) >= TIMEZONE_HOUR && input.LA(1) <= TIMEZONE_MINUTE) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeZoneField"


    public static class positionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "positionFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:449:1: positionFunction : ^( POSITION characterValueExpression characterValueExpression ) ;
    public final GeneratedHQLResolver.positionFunction_return positionFunction() throws RecognitionException {
        GeneratedHQLResolver.positionFunction_return retval = new GeneratedHQLResolver.positionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree POSITION337=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression338 =null;

        GeneratedHQLResolver.characterValueExpression_return characterValueExpression339 =null;


        CommonTree POSITION337_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:450:2: ( ^( POSITION characterValueExpression characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:450:4: ^( POSITION characterValueExpression characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            POSITION337=(CommonTree)match(input,POSITION,FOLLOW_POSITION_in_positionFunction2185); 


            if ( _first_0==null ) _first_0 = POSITION337;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_positionFunction2187);
            characterValueExpression338=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression338.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_positionFunction2189);
            characterValueExpression339=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression339.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "positionFunction"


    public static class charLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "charLengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:453:1: charLengthFunction : ^( CHARACTER_LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.charLengthFunction_return charLengthFunction() throws RecognitionException {
        GeneratedHQLResolver.charLengthFunction_return retval = new GeneratedHQLResolver.charLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree CHARACTER_LENGTH340=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression341 =null;


        CommonTree CHARACTER_LENGTH340_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:454:2: ( ^( CHARACTER_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:454:4: ^( CHARACTER_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            CHARACTER_LENGTH340=(CommonTree)match(input,CHARACTER_LENGTH,FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2202); 


            if ( _first_0==null ) _first_0 = CHARACTER_LENGTH340;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_charLengthFunction2204);
            characterValueExpression341=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression341.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "charLengthFunction"


    public static class octetLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octetLengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:457:1: octetLengthFunction : ^( OCTET_LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
        GeneratedHQLResolver.octetLengthFunction_return retval = new GeneratedHQLResolver.octetLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree OCTET_LENGTH342=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression343 =null;


        CommonTree OCTET_LENGTH342_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:458:2: ( ^( OCTET_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:458:4: ^( OCTET_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            OCTET_LENGTH342=(CommonTree)match(input,OCTET_LENGTH,FOLLOW_OCTET_LENGTH_in_octetLengthFunction2217); 


            if ( _first_0==null ) _first_0 = OCTET_LENGTH342;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_octetLengthFunction2219);
            characterValueExpression343=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression343.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octetLengthFunction"


    public static class bitLengthFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bitLengthFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:461:1: bitLengthFunction : ^( BIT_LENGTH characterValueExpression ) ;
    public final GeneratedHQLResolver.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
        GeneratedHQLResolver.bitLengthFunction_return retval = new GeneratedHQLResolver.bitLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree BIT_LENGTH344=null;
        GeneratedHQLResolver.characterValueExpression_return characterValueExpression345 =null;


        CommonTree BIT_LENGTH344_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:462:2: ( ^( BIT_LENGTH characterValueExpression ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:462:4: ^( BIT_LENGTH characterValueExpression )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            BIT_LENGTH344=(CommonTree)match(input,BIT_LENGTH,FOLLOW_BIT_LENGTH_in_bitLengthFunction2232); 


            if ( _first_0==null ) _first_0 = BIT_LENGTH344;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_characterValueExpression_in_bitLengthFunction2234);
            characterValueExpression345=characterValueExpression();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = characterValueExpression345.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bitLengthFunction"


    public static class countFunctionArguments_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "countFunctionArguments"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:466:1: countFunctionArguments : ( collectionExpression | propertyReference | numeric_literal );
    public final GeneratedHQLResolver.countFunctionArguments_return countFunctionArguments() throws RecognitionException {
        GeneratedHQLResolver.countFunctionArguments_return retval = new GeneratedHQLResolver.countFunctionArguments_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.collectionExpression_return collectionExpression346 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference347 =null;

        GeneratedHQLResolver.numeric_literal_return numeric_literal348 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:467:2: ( collectionExpression | propertyReference | numeric_literal )
            int alt69=3;
            switch ( input.LA(1) ) {
            case ELEMENTS:
            case INDICES:
                {
                alt69=1;
                }
                break;
            case PROPERTY_REFERENCE:
                {
                alt69=2;
                }
                break;
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt69=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;

            }

            switch (alt69) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:467:4: collectionExpression
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_collectionExpression_in_countFunctionArguments2247);
                    collectionExpression346=collectionExpression();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = collectionExpression346.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:468:4: propertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_countFunctionArguments2252);
                    propertyReference347=propertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = propertyReference347.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:469:4: numeric_literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numeric_literal_in_countFunctionArguments2257);
                    numeric_literal348=numeric_literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = numeric_literal348.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "countFunctionArguments"


    public static class collectionFunction_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionFunction"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:472:1: collectionFunction : ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) ;
    public final GeneratedHQLResolver.collectionFunction_return collectionFunction() throws RecognitionException {
        GeneratedHQLResolver.collectionFunction_return retval = new GeneratedHQLResolver.collectionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set349=null;
        GeneratedHQLResolver.collectionPropertyReference_return collectionPropertyReference350 =null;


        CommonTree set349_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:473:2: ( ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:473:4: ^( ( MAXELEMENT | MAXINDEX | MINELEMENT | MININDEX ) collectionPropertyReference )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            set349=(CommonTree)input.LT(1);

            if ( (input.LA(1) >= MAXELEMENT && input.LA(1) <= MAXINDEX)||(input.LA(1) >= MINELEMENT && input.LA(1) <= MININDEX) ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( _first_0==null ) _first_0 = set349;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_collectionPropertyReference_in_collectionFunction2279);
            collectionPropertyReference350=collectionPropertyReference();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = collectionPropertyReference350.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionFunction"


    public static class collectionPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:477:1: collectionPropertyReference : propertyReference ;
    public final GeneratedHQLResolver.collectionPropertyReference_return collectionPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.collectionPropertyReference_return retval = new GeneratedHQLResolver.collectionPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.propertyReference_return propertyReference351 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:478:2: ( propertyReference )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:478:4: propertyReference
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReference_in_collectionPropertyReference2294);
            propertyReference351=propertyReference();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = propertyReference351.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionPropertyReference"


    public static class collectionExpression_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collectionExpression"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:481:1: collectionExpression : ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) );
    public final GeneratedHQLResolver.collectionExpression_return collectionExpression() throws RecognitionException {
        GeneratedHQLResolver.collectionExpression_return retval = new GeneratedHQLResolver.collectionExpression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ELEMENTS352=null;
        CommonTree INDICES354=null;
        GeneratedHQLResolver.propertyReference_return propertyReference353 =null;

        GeneratedHQLResolver.propertyReference_return propertyReference355 =null;


        CommonTree ELEMENTS352_tree=null;
        CommonTree INDICES354_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:482:2: ( ^( ELEMENTS propertyReference ) | ^( INDICES propertyReference ) )
            int alt70=2;
            int LA70_0 = input.LA(1);

            if ( (LA70_0==ELEMENTS) ) {
                alt70=1;
            }
            else if ( (LA70_0==INDICES) ) {
                alt70=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 70, 0, input);

                throw nvae;

            }
            switch (alt70) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:482:4: ^( ELEMENTS propertyReference )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    ELEMENTS352=(CommonTree)match(input,ELEMENTS,FOLLOW_ELEMENTS_in_collectionExpression2306); 


                    if ( _first_0==null ) _first_0 = ELEMENTS352;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_collectionExpression2308);
                    propertyReference353=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference353.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:483:4: ^( INDICES propertyReference )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    INDICES354=(CommonTree)match(input,INDICES,FOLLOW_INDICES_in_collectionExpression2316); 


                    if ( _first_0==null ) _first_0 = INDICES354;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_propertyReference_in_collectionExpression2318);
                    propertyReference355=propertyReference();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = propertyReference355.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collectionExpression"


    public static class parameter_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "parameter"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:486:1: parameter : ( NAMED_PARAM | JPA_PARAM | PARAM );
    public final GeneratedHQLResolver.parameter_return parameter() throws RecognitionException {
        GeneratedHQLResolver.parameter_return retval = new GeneratedHQLResolver.parameter_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set356=null;

        CommonTree set356_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:487:2: ( NAMED_PARAM | JPA_PARAM | PARAM )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set356=(CommonTree)input.LT(1);

            if ( input.LA(1)==JPA_PARAM||input.LA(1)==NAMED_PARAM||input.LA(1)==PARAM ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "parameter"


    public static class constant_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "constant"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:492:1: constant : ( literal | NULL | TRUE | FALSE );
    public final GeneratedHQLResolver.constant_return constant() throws RecognitionException {
        GeneratedHQLResolver.constant_return retval = new GeneratedHQLResolver.constant_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree NULL358=null;
        CommonTree TRUE359=null;
        CommonTree FALSE360=null;
        GeneratedHQLResolver.literal_return literal357 =null;


        CommonTree NULL358_tree=null;
        CommonTree TRUE359_tree=null;
        CommonTree FALSE360_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:493:2: ( literal | NULL | TRUE | FALSE )
            int alt71=4;
            switch ( input.LA(1) ) {
            case CHARACTER_LITERAL:
            case CONST_STRING_VALUE:
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
                {
                alt71=1;
                }
                break;
            case NULL:
                {
                alt71=2;
                }
                break;
            case TRUE:
                {
                alt71=3;
                }
                break;
            case FALSE:
                {
                alt71=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 71, 0, input);

                throw nvae;

            }

            switch (alt71) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:493:4: literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_literal_in_constant2351);
                    literal357=literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = literal357.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:494:4: NULL
                    {
                    _last = (CommonTree)input.LT(1);
                    NULL358=(CommonTree)match(input,NULL,FOLLOW_NULL_in_constant2356); 
                     
                    if ( _first_0==null ) _first_0 = NULL358;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:495:4: TRUE
                    {
                    _last = (CommonTree)input.LT(1);
                    TRUE359=(CommonTree)match(input,TRUE,FOLLOW_TRUE_in_constant2361); 
                     
                    if ( _first_0==null ) _first_0 = TRUE359;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:496:4: FALSE
                    {
                    _last = (CommonTree)input.LT(1);
                    FALSE360=(CommonTree)match(input,FALSE,FOLLOW_FALSE_in_constant2366); 
                     
                    if ( _first_0==null ) _first_0 = FALSE360;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "constant"


    public static class literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:499:1: literal : ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | ^( CONST_STRING_VALUE STRING_LITERAL ) );
    public final GeneratedHQLResolver.literal_return literal() throws RecognitionException {
        GeneratedHQLResolver.literal_return retval = new GeneratedHQLResolver.literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree HEX_LITERAL362=null;
        CommonTree OCTAL_LITERAL363=null;
        CommonTree CHARACTER_LITERAL364=null;
        CommonTree STRING_LITERAL365=null;
        CommonTree CONST_STRING_VALUE366=null;
        CommonTree CHARACTER_LITERAL367=null;
        CommonTree CONST_STRING_VALUE368=null;
        CommonTree STRING_LITERAL369=null;
        GeneratedHQLResolver.numeric_literal_return numeric_literal361 =null;


        CommonTree HEX_LITERAL362_tree=null;
        CommonTree OCTAL_LITERAL363_tree=null;
        CommonTree CHARACTER_LITERAL364_tree=null;
        CommonTree STRING_LITERAL365_tree=null;
        CommonTree CONST_STRING_VALUE366_tree=null;
        CommonTree CHARACTER_LITERAL367_tree=null;
        CommonTree CONST_STRING_VALUE368_tree=null;
        CommonTree STRING_LITERAL369_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:500:2: ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | ^( CONST_STRING_VALUE CHARACTER_LITERAL ) | ^( CONST_STRING_VALUE STRING_LITERAL ) )
            int alt72=7;
            switch ( input.LA(1) ) {
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt72=1;
                }
                break;
            case HEX_LITERAL:
                {
                alt72=2;
                }
                break;
            case OCTAL_LITERAL:
                {
                alt72=3;
                }
                break;
            case CHARACTER_LITERAL:
                {
                alt72=4;
                }
                break;
            case STRING_LITERAL:
                {
                alt72=5;
                }
                break;
            case CONST_STRING_VALUE:
                {
                int LA72_6 = input.LA(2);

                if ( (LA72_6==DOWN) ) {
                    int LA72_7 = input.LA(3);

                    if ( (LA72_7==CHARACTER_LITERAL) ) {
                        alt72=6;
                    }
                    else if ( (LA72_7==STRING_LITERAL) ) {
                        alt72=7;
                    }
                    else {
                        NoViableAltException nvae =
                            new NoViableAltException("", 72, 7, input);

                        throw nvae;

                    }
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 72, 6, input);

                    throw nvae;

                }
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 72, 0, input);

                throw nvae;

            }

            switch (alt72) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:500:4: numeric_literal
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_numeric_literal_in_literal2377);
                    numeric_literal361=numeric_literal();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = numeric_literal361.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:501:4: HEX_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    HEX_LITERAL362=(CommonTree)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal2382); 
                     
                    if ( _first_0==null ) _first_0 = HEX_LITERAL362;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:502:4: OCTAL_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    OCTAL_LITERAL363=(CommonTree)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal2387); 
                     
                    if ( _first_0==null ) _first_0 = OCTAL_LITERAL363;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:503:4: CHARACTER_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    CHARACTER_LITERAL364=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2392); 
                     
                    if ( _first_0==null ) _first_0 = CHARACTER_LITERAL364;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:504:4: STRING_LITERAL
                    {
                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL365=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2397); 
                     
                    if ( _first_0==null ) _first_0 = STRING_LITERAL365;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:505:4: ^( CONST_STRING_VALUE CHARACTER_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    CONST_STRING_VALUE366=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2403); 


                    if ( _first_0==null ) _first_0 = CONST_STRING_VALUE366;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    CHARACTER_LITERAL367=(CommonTree)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal2405); 
                     
                    if ( _first_1==null ) _first_1 = CHARACTER_LITERAL367;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:506:4: ^( CONST_STRING_VALUE STRING_LITERAL )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    CONST_STRING_VALUE368=(CommonTree)match(input,CONST_STRING_VALUE,FOLLOW_CONST_STRING_VALUE_in_literal2412); 


                    if ( _first_0==null ) _first_0 = CONST_STRING_VALUE368;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    STRING_LITERAL369=(CommonTree)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal2414); 
                     
                    if ( _first_1==null ) _first_1 = STRING_LITERAL369;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class numeric_literal_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numeric_literal"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:509:1: numeric_literal : ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL );
    public final GeneratedHQLResolver.numeric_literal_return numeric_literal() throws RecognitionException {
        GeneratedHQLResolver.numeric_literal_return retval = new GeneratedHQLResolver.numeric_literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree set370=null;

        CommonTree set370_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:510:2: ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:
            {
            _last = (CommonTree)input.LT(1);
            set370=(CommonTree)input.LT(1);

            if ( input.LA(1)==DECIMAL_LITERAL||input.LA(1)==FLOATING_POINT_LITERAL||input.LA(1)==INTEGER_LITERAL ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);
             

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal"


    public static class entityName_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "entityName"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:515:1: entityName : ENTITY_NAME ALIAS_NAME ;
    public final GeneratedHQLResolver.entityName_return entityName() throws RecognitionException {
        GeneratedHQLResolver.entityName_return retval = new GeneratedHQLResolver.entityName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree ENTITY_NAME371=null;
        CommonTree ALIAS_NAME372=null;

        CommonTree ENTITY_NAME371_tree=null;
        CommonTree ALIAS_NAME372_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:516:2: ( ENTITY_NAME ALIAS_NAME )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:516:4: ENTITY_NAME ALIAS_NAME
            {
            _last = (CommonTree)input.LT(1);
            ENTITY_NAME371=(CommonTree)match(input,ENTITY_NAME,FOLLOW_ENTITY_NAME_in_entityName2447); 
             
            if ( _first_0==null ) _first_0 = ENTITY_NAME371;


            _last = (CommonTree)input.LT(1);
            ALIAS_NAME372=(CommonTree)match(input,ALIAS_NAME,FOLLOW_ALIAS_NAME_in_entityName2449); 
             
            if ( _first_0==null ) _first_0 = ALIAS_NAME372;


            	delegate.registerPersisterSpace(ENTITY_NAME371, ALIAS_NAME372);	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "entityName"


    public static class propertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:520:1: propertyReference : ^( PROPERTY_REFERENCE propertyReferencePath ) ;
    public final GeneratedHQLResolver.propertyReference_return propertyReference() throws RecognitionException {
        GeneratedHQLResolver.propertyReference_return retval = new GeneratedHQLResolver.propertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree PROPERTY_REFERENCE373=null;
        GeneratedHQLResolver.propertyReferencePath_return propertyReferencePath374 =null;


        CommonTree PROPERTY_REFERENCE373_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:521:2: ( ^( PROPERTY_REFERENCE propertyReferencePath ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:521:4: ^( PROPERTY_REFERENCE propertyReferencePath )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            PROPERTY_REFERENCE373=(CommonTree)match(input,PROPERTY_REFERENCE,FOLLOW_PROPERTY_REFERENCE_in_propertyReference2464); 


            if ( _first_0==null ) _first_0 = PROPERTY_REFERENCE373;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_propertyReferencePath_in_propertyReference2466);
            propertyReferencePath374=propertyReferencePath();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = propertyReferencePath374.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "propertyReference"


    protected static class propertyReferencePath_scope {
        PropertyPath path;
    }
    protected Stack propertyReferencePath_stack = new Stack();


    public static class propertyReferencePath_return extends TreeRuleReturnScope {
        public PropertyPath retPath;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "propertyReferencePath"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:524:1: propertyReferencePath returns [PropertyPath retPath] : ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation );
    public final GeneratedHQLResolver.propertyReferencePath_return propertyReferencePath() throws RecognitionException {
        propertyReferencePath_stack.push(new propertyReferencePath_scope());
        GeneratedHQLResolver.propertyReferencePath_return retval = new GeneratedHQLResolver.propertyReferencePath_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.unqualifiedPropertyReference_return unqualifiedPropertyReference375 =null;

        GeneratedHQLResolver.pathedPropertyReference_return pathedPropertyReference376 =null;

        GeneratedHQLResolver.terminalIndexOperation_return terminalIndexOperation377 =null;




        		((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path = new PropertyPath();
        	
        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:532:2: ({...}? unqualifiedPropertyReference | pathedPropertyReference | terminalIndexOperation )
            int alt73=3;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt73=1;
                }
                break;
            case DOT:
                {
                alt73=2;
                }
                break;
            case LEFT_SQUARE:
                {
                alt73=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 73, 0, input);

                throw nvae;

            }

            switch (alt73) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:532:5: {...}? unqualifiedPropertyReference
                    {
                    if ( !((delegate.isUnqualifiedPropertyReference())) ) {
                        throw new FailedPredicateException(input, "propertyReferencePath", "delegate.isUnqualifiedPropertyReference()");
                    }

                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2502);
                    unqualifiedPropertyReference375=unqualifiedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = unqualifiedPropertyReference375.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:533:4: pathedPropertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathedPropertyReference_in_propertyReferencePath2507);
                    pathedPropertyReference376=pathedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = pathedPropertyReference376.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:534:4: terminalIndexOperation
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_terminalIndexOperation_in_propertyReferencePath2512);
                    terminalIndexOperation377=terminalIndexOperation();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = terminalIndexOperation377.tree;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
             retval.retPath = ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path; delegate.propertyPathCompleted( ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path ); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            propertyReferencePath_stack.pop();
        }
        return retval;
    }
    // $ANTLR end "propertyReferencePath"


    public static class unqualifiedPropertyReference_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "unqualifiedPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:537:1: unqualifiedPropertyReference returns [PathedPropertyReferenceSource propertyReferenceSource] : IDENTIFIER ;
    public final GeneratedHQLResolver.unqualifiedPropertyReference_return unqualifiedPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.unqualifiedPropertyReference_return retval = new GeneratedHQLResolver.unqualifiedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER378=null;

        CommonTree IDENTIFIER378_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:539:2: ( IDENTIFIER )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:539:4: IDENTIFIER
            {
            _last = (CommonTree)input.LT(1);
            IDENTIFIER378=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2533); 
             
            if ( _first_0==null ) _first_0 = IDENTIFIER378;


            	retval.propertyReferenceSource = delegate.normalizeUnqualifiedPropertyReference( IDENTIFIER378 ); 

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

             ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path.appendNode( retval.propertyReferenceSource ); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "unqualifiedPropertyReference"


    public static class pathedPropertyReference_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pathedPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:543:1: pathedPropertyReference : ^( DOT pathedPropertyReferenceSource IDENTIFIER ) ;
    public final GeneratedHQLResolver.pathedPropertyReference_return pathedPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.pathedPropertyReference_return retval = new GeneratedHQLResolver.pathedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT379=null;
        CommonTree IDENTIFIER381=null;
        GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource380 =null;


        CommonTree DOT379_tree=null;
        CommonTree IDENTIFIER381_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:544:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:544:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DOT379=(CommonTree)match(input,DOT,FOLLOW_DOT_in_pathedPropertyReference2548); 


            if ( _first_0==null ) _first_0 = DOT379;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2550);
            pathedPropertyReferenceSource380=pathedPropertyReferenceSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = pathedPropertyReferenceSource380.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER381=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReference2552); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER381;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }



            		((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path.appendNode( delegate.normalizePropertyPathTerminus( ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path, IDENTIFIER381 ) );
            	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pathedPropertyReference"


    public static class pathedPropertyReferenceSource_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pathedPropertyReferenceSource"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:550:1: pathedPropertyReferenceSource returns [PathedPropertyReferenceSource propertyReferenceSource] : ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation );
    public final GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource() throws RecognitionException {
        GeneratedHQLResolver.pathedPropertyReferenceSource_return retval = new GeneratedHQLResolver.pathedPropertyReferenceSource_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER382=null;
        CommonTree IDENTIFIER383=null;
        GeneratedHQLResolver.intermediatePathedPropertyReference_return intermediatePathedPropertyReference384 =null;

        GeneratedHQLResolver.intermediateIndexOperation_return intermediateIndexOperation385 =null;


        CommonTree IDENTIFIER382_tree=null;
        CommonTree IDENTIFIER383_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:552:2: ({...}? => IDENTIFIER |{...}? => IDENTIFIER | intermediatePathedPropertyReference | intermediateIndexOperation )
            int alt74=4;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==IDENTIFIER) && ((((delegate.isUnqualifiedPropertyReference()))||((delegate.isPersisterReferenceAlias()))))) {
                int LA74_1 = input.LA(2);

                if ( (((delegate.isPersisterReferenceAlias()))) ) {
                    alt74=1;
                }
                else if ( (((delegate.isUnqualifiedPropertyReference()))) ) {
                    alt74=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 74, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA74_0==DOT) ) {
                alt74=3;
            }
            else if ( (LA74_0==LEFT_SQUARE) ) {
                alt74=4;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;

            }
            switch (alt74) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:552:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isPersisterReferenceAlias()))) ) {
                        throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(delegate.isPersisterReferenceAlias())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER382=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2580); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER382;


                     retval.propertyReferenceSource = delegate.normalizeQualifiedRoot( IDENTIFIER382 ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:553:4: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isUnqualifiedPropertyReference()))) ) {
                        throw new FailedPredicateException(input, "pathedPropertyReferenceSource", "(delegate.isUnqualifiedPropertyReference())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER383=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2590); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER383;


                     retval.propertyReferenceSource = delegate.normalizeUnqualifiedRoot( IDENTIFIER383 ); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:554:4: intermediatePathedPropertyReference
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2597);
                    intermediatePathedPropertyReference384=intermediatePathedPropertyReference();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = intermediatePathedPropertyReference384.tree;


                     retval.propertyReferenceSource = (intermediatePathedPropertyReference384!=null?intermediatePathedPropertyReference384.propertyReferenceSource:null); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:555:4: intermediateIndexOperation
                    {
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2604);
                    intermediateIndexOperation385=intermediateIndexOperation();

                    state._fsp--;

                     
                    if ( _first_0==null ) _first_0 = intermediateIndexOperation385.tree;


                     retval.propertyReferenceSource = (intermediateIndexOperation385!=null?intermediateIndexOperation385.propertyReferenceSource:null); 

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
             ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path.appendNode( retval.propertyReferenceSource ); 
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pathedPropertyReferenceSource"


    public static class intermediatePathedPropertyReference_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intermediatePathedPropertyReference"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:558:1: intermediatePathedPropertyReference returns [PathedPropertyReferenceSource propertyReferenceSource] : ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) ;
    public final GeneratedHQLResolver.intermediatePathedPropertyReference_return intermediatePathedPropertyReference() throws RecognitionException {
        GeneratedHQLResolver.intermediatePathedPropertyReference_return retval = new GeneratedHQLResolver.intermediatePathedPropertyReference_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT386=null;
        CommonTree IDENTIFIER387=null;
        GeneratedHQLResolver.pathedPropertyReferenceSource_return source =null;


        CommonTree DOT386_tree=null;
        CommonTree IDENTIFIER387_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:559:2: ( ^( DOT source= pathedPropertyReferenceSource IDENTIFIER ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:559:4: ^( DOT source= pathedPropertyReferenceSource IDENTIFIER )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            DOT386=(CommonTree)match(input,DOT,FOLLOW_DOT_in_intermediatePathedPropertyReference2622); 


            if ( _first_0==null ) _first_0 = DOT386;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2626);
            source=pathedPropertyReferenceSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = source.tree;


            _last = (CommonTree)input.LT(1);
            IDENTIFIER387=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2628); 
             
            if ( _first_1==null ) _first_1 = IDENTIFIER387;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            	retval.propertyReferenceSource = delegate.normalizePropertyPathIntermediary( ((propertyReferencePath_scope)propertyReferencePath_stack.peek()).path, IDENTIFIER387 );	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intermediatePathedPropertyReference"


    public static class intermediateIndexOperation_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "intermediateIndexOperation"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:563:1: intermediateIndexOperation returns [PathedPropertyReferenceSource propertyReferenceSource] : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
    public final GeneratedHQLResolver.intermediateIndexOperation_return intermediateIndexOperation() throws RecognitionException {
        GeneratedHQLResolver.intermediateIndexOperation_return retval = new GeneratedHQLResolver.intermediateIndexOperation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LEFT_SQUARE388=null;
        GeneratedHQLResolver.indexOperationSource_return indexOperationSource389 =null;

        GeneratedHQLResolver.indexSelector_return indexSelector390 =null;


        CommonTree LEFT_SQUARE388_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:564:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:564:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LEFT_SQUARE388=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2650); 


            if ( _first_0==null ) _first_0 = LEFT_SQUARE388;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexOperationSource_in_intermediateIndexOperation2652);
            indexOperationSource389=indexOperationSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexOperationSource389.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexSelector_in_intermediateIndexOperation2654);
            indexSelector390=indexSelector();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexSelector390.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            	retval.propertyReferenceSource = delegate.normalizeIntermediateIndexOperation( (indexOperationSource389!=null?indexOperationSource389.propertyReferenceSource:null), (indexOperationSource389!=null?indexOperationSource389.collectionProperty:null), (indexSelector390!=null?((CommonTree)indexSelector390.tree):null) );	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "intermediateIndexOperation"


    public static class terminalIndexOperation_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "terminalIndexOperation"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:568:1: terminalIndexOperation : ^( LEFT_SQUARE indexOperationSource indexSelector ) ;
    public final GeneratedHQLResolver.terminalIndexOperation_return terminalIndexOperation() throws RecognitionException {
        GeneratedHQLResolver.terminalIndexOperation_return retval = new GeneratedHQLResolver.terminalIndexOperation_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree LEFT_SQUARE391=null;
        GeneratedHQLResolver.indexOperationSource_return indexOperationSource392 =null;

        GeneratedHQLResolver.indexSelector_return indexSelector393 =null;


        CommonTree LEFT_SQUARE391_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:569:2: ( ^( LEFT_SQUARE indexOperationSource indexSelector ) )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:569:4: ^( LEFT_SQUARE indexOperationSource indexSelector )
            {
            _last = (CommonTree)input.LT(1);
            {
            CommonTree _save_last_1 = _last;
            CommonTree _first_1 = null;
            _last = (CommonTree)input.LT(1);
            LEFT_SQUARE391=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2672); 


            if ( _first_0==null ) _first_0 = LEFT_SQUARE391;
            match(input, Token.DOWN, null); 
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexOperationSource_in_terminalIndexOperation2674);
            indexOperationSource392=indexOperationSource();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexOperationSource392.tree;


            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_indexSelector_in_terminalIndexOperation2676);
            indexSelector393=indexSelector();

            state._fsp--;

             
            if ( _first_1==null ) _first_1 = indexSelector393.tree;


            match(input, Token.UP, null); 
            _last = _save_last_1;
            }


            	delegate.normalizeTerminalIndexOperation( (indexOperationSource392!=null?indexOperationSource392.propertyReferenceSource:null), (indexOperationSource392!=null?indexOperationSource392.collectionProperty:null), (indexSelector393!=null?((CommonTree)indexSelector393.tree):null) );	

            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "terminalIndexOperation"


    public static class indexOperationSource_return extends TreeRuleReturnScope {
        public PathedPropertyReferenceSource propertyReferenceSource;
        public Tree collectionProperty;
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexOperationSource"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:573:1: indexOperationSource returns [PathedPropertyReferenceSource propertyReferenceSource, Tree collectionProperty] : ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER );
    public final GeneratedHQLResolver.indexOperationSource_return indexOperationSource() throws RecognitionException {
        GeneratedHQLResolver.indexOperationSource_return retval = new GeneratedHQLResolver.indexOperationSource_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree DOT394=null;
        CommonTree IDENTIFIER396=null;
        CommonTree IDENTIFIER397=null;
        GeneratedHQLResolver.pathedPropertyReferenceSource_return pathedPropertyReferenceSource395 =null;


        CommonTree DOT394_tree=null;
        CommonTree IDENTIFIER396_tree=null;
        CommonTree IDENTIFIER397_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:574:2: ( ^( DOT pathedPropertyReferenceSource IDENTIFIER ) |{...}? => IDENTIFIER )
            int alt75=2;
            int LA75_0 = input.LA(1);

            if ( (LA75_0==DOT) ) {
                alt75=1;
            }
            else if ( (LA75_0==IDENTIFIER) && (((delegate.isUnqualifiedPropertyReference())))) {
                alt75=2;
            }
            else {
                NoViableAltException nvae =
                    new NoViableAltException("", 75, 0, input);

                throw nvae;

            }
            switch (alt75) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:574:4: ^( DOT pathedPropertyReferenceSource IDENTIFIER )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT394=(CommonTree)match(input,DOT,FOLLOW_DOT_in_indexOperationSource2697); 


                    if ( _first_0==null ) _first_0 = DOT394;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2699);
                    pathedPropertyReferenceSource395=pathedPropertyReferenceSource();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = pathedPropertyReferenceSource395.tree;


                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER396=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2701); 
                     
                    if ( _first_1==null ) _first_1 = IDENTIFIER396;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    	retval.propertyReferenceSource = (pathedPropertyReferenceSource395!=null?pathedPropertyReferenceSource395.propertyReferenceSource:null);
                    		retval.collectionProperty = IDENTIFIER396;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:577:5: {...}? => IDENTIFIER
                    {
                    if ( !(((delegate.isUnqualifiedPropertyReference()))) ) {
                        throw new FailedPredicateException(input, "indexOperationSource", "(delegate.isUnqualifiedPropertyReference())");
                    }

                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER397=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_indexOperationSource2715); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER397;


                    	retval.propertyReferenceSource = delegate.normalizeUnqualifiedPropertyReferenceSource( IDENTIFIER397 );
                    			retval.collectionProperty = IDENTIFIER397;	

                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexOperationSource"


    public static class indexSelector_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "indexSelector"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:582:1: indexSelector : valueExpression ;
    public final GeneratedHQLResolver.indexSelector_return indexSelector() throws RecognitionException {
        GeneratedHQLResolver.indexSelector_return retval = new GeneratedHQLResolver.indexSelector_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        GeneratedHQLResolver.valueExpression_return valueExpression398 =null;



        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:583:2: ( valueExpression )
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:583:4: valueExpression
            {
            _last = (CommonTree)input.LT(1);
            pushFollow(FOLLOW_valueExpression_in_indexSelector2730);
            valueExpression398=valueExpression();

            state._fsp--;

             
            if ( _first_0==null ) _first_0 = valueExpression398.tree;


            retval.tree = (CommonTree)_first_0;
            if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                retval.tree = (CommonTree)adaptor.getParent(retval.tree);

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "indexSelector"


    public static class path_return extends TreeRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "path"
    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:586:1: path : ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) );
    public final GeneratedHQLResolver.path_return path() throws RecognitionException {
        GeneratedHQLResolver.path_return retval = new GeneratedHQLResolver.path_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonTree _first_0 = null;
        CommonTree _last = null;

        CommonTree IDENTIFIER399=null;
        CommonTree DOT400=null;
        CommonTree LEFT_SQUARE403=null;
        CommonTree LEFT_PAREN406=null;
        GeneratedHQLResolver.path_return path401 =null;

        GeneratedHQLResolver.path_return path402 =null;

        GeneratedHQLResolver.path_return path404 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression405 =null;

        GeneratedHQLResolver.path_return path407 =null;

        GeneratedHQLResolver.valueExpression_return valueExpression408 =null;


        CommonTree IDENTIFIER399_tree=null;
        CommonTree DOT400_tree=null;
        CommonTree LEFT_SQUARE403_tree=null;
        CommonTree LEFT_PAREN406_tree=null;

        try {
            // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:587:2: ( IDENTIFIER | ^( DOT path path ) | ^( LEFT_SQUARE path ( valueExpression )* ) | ^( LEFT_PAREN path ( valueExpression )* ) )
            int alt78=4;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt78=1;
                }
                break;
            case DOT:
                {
                alt78=2;
                }
                break;
            case LEFT_SQUARE:
                {
                alt78=3;
                }
                break;
            case LEFT_PAREN:
                {
                alt78=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 78, 0, input);

                throw nvae;

            }

            switch (alt78) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:587:5: IDENTIFIER
                    {
                    _last = (CommonTree)input.LT(1);
                    IDENTIFIER399=(CommonTree)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_path2742); 
                     
                    if ( _first_0==null ) _first_0 = IDENTIFIER399;


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:588:4: ^( DOT path path )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    DOT400=(CommonTree)match(input,DOT,FOLLOW_DOT_in_path2748); 


                    if ( _first_0==null ) _first_0 = DOT400;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2750);
                    path401=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path401.tree;


                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2752);
                    path402=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path402.tree;


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:589:4: ^( LEFT_SQUARE path ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LEFT_SQUARE403=(CommonTree)match(input,LEFT_SQUARE,FOLLOW_LEFT_SQUARE_in_path2760); 


                    if ( _first_0==null ) _first_0 = LEFT_SQUARE403;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2762);
                    path404=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path404.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:589:23: ( valueExpression )*
                    loop76:
                    do {
                        int alt76=2;
                        int LA76_0 = input.LA(1);

                        if ( (LA76_0==ABS||(LA76_0 >= ALIAS_REF && LA76_0 <= ALL)||LA76_0==ANY||(LA76_0 >= ASTERISK && LA76_0 <= AVG)||LA76_0==BIT_LENGTH||(LA76_0 >= CAST && LA76_0 <= CHARACTER_LITERAL)||LA76_0==COALESCE||(LA76_0 >= CONCAT && LA76_0 <= COUNT)||(LA76_0 >= CURRENT_DATE && LA76_0 <= CURRENT_TIMESTAMP)||LA76_0==DECIMAL_LITERAL||(LA76_0 >= DOT_CLASS && LA76_0 <= DOUBLE_PIPE)||LA76_0==ELEMENTS||LA76_0==EXISTS||(LA76_0 >= EXTRACT && LA76_0 <= FALSE)||LA76_0==FLOATING_POINT_LITERAL||LA76_0==FUNCTION||LA76_0==HEX_LITERAL||(LA76_0 >= INDEX && LA76_0 <= INDICES)||LA76_0==INTEGER_LITERAL||LA76_0==JAVA_CONSTANT||LA76_0==JPA_PARAM||LA76_0==LENGTH||(LA76_0 >= LOCATE && LA76_0 <= MAXINDEX)||(LA76_0 >= MIN && LA76_0 <= MINUS)||LA76_0==MOD||LA76_0==NAMED_PARAM||(LA76_0 >= NULL && LA76_0 <= NULLIF)||(LA76_0 >= OCTAL_LITERAL && LA76_0 <= OCTET_LENGTH)||(LA76_0 >= PARAM && LA76_0 <= PATH)||(LA76_0 >= PLUS && LA76_0 <= POSITION)||LA76_0==PROPERTY_REFERENCE||LA76_0==SEARCHED_CASE||(LA76_0 >= SIMPLE_CASE && LA76_0 <= SOME)||(LA76_0 >= SQRT && LA76_0 <= SUM)||(LA76_0 >= TRIM && LA76_0 <= UNARY_PLUS)||(LA76_0 >= UPPER && LA76_0 <= VECTOR_EXPR)) ) {
                            alt76=1;
                        }


                        switch (alt76) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:589:23: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_path2764);
                    	    valueExpression405=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression405.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop76;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:590:4: ^( LEFT_PAREN path ( valueExpression )* )
                    {
                    _last = (CommonTree)input.LT(1);
                    {
                    CommonTree _save_last_1 = _last;
                    CommonTree _first_1 = null;
                    _last = (CommonTree)input.LT(1);
                    LEFT_PAREN406=(CommonTree)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_path2773); 


                    if ( _first_0==null ) _first_0 = LEFT_PAREN406;
                    match(input, Token.DOWN, null); 
                    _last = (CommonTree)input.LT(1);
                    pushFollow(FOLLOW_path_in_path2775);
                    path407=path();

                    state._fsp--;

                     
                    if ( _first_1==null ) _first_1 = path407.tree;


                    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:590:22: ( valueExpression )*
                    loop77:
                    do {
                        int alt77=2;
                        int LA77_0 = input.LA(1);

                        if ( (LA77_0==ABS||(LA77_0 >= ALIAS_REF && LA77_0 <= ALL)||LA77_0==ANY||(LA77_0 >= ASTERISK && LA77_0 <= AVG)||LA77_0==BIT_LENGTH||(LA77_0 >= CAST && LA77_0 <= CHARACTER_LITERAL)||LA77_0==COALESCE||(LA77_0 >= CONCAT && LA77_0 <= COUNT)||(LA77_0 >= CURRENT_DATE && LA77_0 <= CURRENT_TIMESTAMP)||LA77_0==DECIMAL_LITERAL||(LA77_0 >= DOT_CLASS && LA77_0 <= DOUBLE_PIPE)||LA77_0==ELEMENTS||LA77_0==EXISTS||(LA77_0 >= EXTRACT && LA77_0 <= FALSE)||LA77_0==FLOATING_POINT_LITERAL||LA77_0==FUNCTION||LA77_0==HEX_LITERAL||(LA77_0 >= INDEX && LA77_0 <= INDICES)||LA77_0==INTEGER_LITERAL||LA77_0==JAVA_CONSTANT||LA77_0==JPA_PARAM||LA77_0==LENGTH||(LA77_0 >= LOCATE && LA77_0 <= MAXINDEX)||(LA77_0 >= MIN && LA77_0 <= MINUS)||LA77_0==MOD||LA77_0==NAMED_PARAM||(LA77_0 >= NULL && LA77_0 <= NULLIF)||(LA77_0 >= OCTAL_LITERAL && LA77_0 <= OCTET_LENGTH)||(LA77_0 >= PARAM && LA77_0 <= PATH)||(LA77_0 >= PLUS && LA77_0 <= POSITION)||LA77_0==PROPERTY_REFERENCE||LA77_0==SEARCHED_CASE||(LA77_0 >= SIMPLE_CASE && LA77_0 <= SOME)||(LA77_0 >= SQRT && LA77_0 <= SUM)||(LA77_0 >= TRIM && LA77_0 <= UNARY_PLUS)||(LA77_0 >= UPPER && LA77_0 <= VECTOR_EXPR)) ) {
                            alt77=1;
                        }


                        switch (alt77) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/resolve/GeneratedHQLResolver.g:590:22: valueExpression
                    	    {
                    	    _last = (CommonTree)input.LT(1);
                    	    pushFollow(FOLLOW_valueExpression_in_path2777);
                    	    valueExpression408=valueExpression();

                    	    state._fsp--;

                    	     
                    	    if ( _first_1==null ) _first_1 = valueExpression408.tree;


                    	    retval.tree = (CommonTree)_first_0;
                    	    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                    	        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    	    }
                    	    break;

                    	default :
                    	    break loop77;
                        }
                    } while (true);


                    match(input, Token.UP, null); 
                    _last = _save_last_1;
                    }


                    retval.tree = (CommonTree)_first_0;
                    if ( adaptor.getParent(retval.tree)!=null && adaptor.isNil( adaptor.getParent(retval.tree) ) )
                        retval.tree = (CommonTree)adaptor.getParent(retval.tree);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "path"

    // Delegated rules


 

    public static final BitSet FOLLOW_QUERY_in_filterStatement62 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_QUERY_SPEC_in_filterStatement65 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_FILTER_in_filterStatement67 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000040L,0x1000000008000008L});
    public static final BitSet FOLLOW_selectClause_in_filterStatement73 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000040L,0x1000000000000008L});
    public static final BitSet FOLLOW_whereClause_in_filterStatement76 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000040L,0x0000000000000008L});
    public static final BitSet FOLLOW_groupByClause_in_filterStatement81 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000080L,0x0000000000000008L});
    public static final BitSet FOLLOW_havingClause_in_filterStatement83 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_orderByClause_in_filterStatement88 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_updateStatementSet_in_statement102 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_deleteStatementSet_in_statement107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_insertStatementSet_in_statement112 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_queryStatementSet_in_statement117 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_updateStatement_in_updateStatementSet128 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0040000000000000L});
    public static final BitSet FOLLOW_UPDATE_in_updateStatement141 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_updateStatement143 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000100000000L});
    public static final BitSet FOLLOW_SET_in_updateStatement146 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_assignment_in_updateStatement148 = new BitSet(new long[]{0x0010000000000008L});
    public static final BitSet FOLLOW_whereClause_in_updateStatement152 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUALS_in_assignment166 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_assignment168 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_assignment170 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EQUALS_in_assignment177 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_VERSIONED_VALUE_in_assignment179 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000008000000000L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_assignment181 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_deleteStatement_in_deleteStatementSet193 = new BitSet(new long[]{0x0000008000000002L});
    public static final BitSet FOLLOW_DELETE_in_deleteStatement206 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_deleteStatement208 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x1000000000000000L});
    public static final BitSet FOLLOW_whereClause_in_deleteStatement210 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_insertStatement_in_insertStatementSet223 = new BitSet(new long[]{0x0000000000000002L,0x0000000000010000L});
    public static final BitSet FOLLOW_INSERT_in_insertStatement236 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_intoClause_in_insertStatement238 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_queryStatementSet_in_insertStatement240 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INTO_in_intoClause253 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_intoClause255 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_INSERTABILITY_SPEC_in_intoClause258 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_intoClause260 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000010000L});
    public static final BitSet FOLLOW_queryStatement_in_queryStatementSet276 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000080000L});
    public static final BitSet FOLLOW_QUERY_in_queryStatement289 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_queryExpression_in_queryStatement291 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000008L});
    public static final BitSet FOLLOW_orderByClause_in_queryStatement293 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNION_in_queryExpression307 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression309 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression312 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression314 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INTERSECT_in_queryExpression321 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression323 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression326 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression328 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXCEPT_in_queryExpression335 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALL_in_queryExpression337 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression340 = new BitSet(new long[]{0x0080000000000000L,0x0000000000100000L,0x0020000000100000L});
    public static final BitSet FOLLOW_queryExpression_in_queryExpression342 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_querySpec_in_queryExpression348 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUERY_SPEC_in_querySpec360 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_selectFrom_in_querySpec362 = new BitSet(new long[]{0x0000000000000008L,0x00000000000000C0L,0x1000000000000000L});
    public static final BitSet FOLLOW_whereClause_in_querySpec364 = new BitSet(new long[]{0x0000000000000008L,0x00000000000000C0L});
    public static final BitSet FOLLOW_groupByClause_in_querySpec367 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000080L});
    public static final BitSet FOLLOW_havingClause_in_querySpec370 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHERE_in_whereClause384 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_whereClause386 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GROUP_BY_in_groupByClause399 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_groupingValue_in_groupByClause401 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000020L});
    public static final BitSet FOLLOW_GROUPING_VALUE_in_groupingValue415 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_groupingValue417 = new BitSet(new long[]{0x0000000001000008L});
    public static final BitSet FOLLOW_COLLATE_in_groupingValue419 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_HAVING_in_havingClause433 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_havingClause435 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SELECT_FROM_in_selectFrom448 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_fromClause_in_selectFrom450 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000008000000L});
    public static final BitSet FOLLOW_selectClause_in_selectFrom452 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_FROM_in_fromClause465 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_persisterSpaces_in_fromClause467 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000400L});
    public static final BitSet FOLLOW_PERSISTER_SPACE_in_persisterSpaces481 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_persisterSpace_in_persisterSpaces483 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_persisterSpace495 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008200L});
    public static final BitSet FOLLOW_joins_in_persisterSpace497 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000008200L});
    public static final BitSet FOLLOW_ENTITY_PERSISTER_REF_in_persisterSpaceRoot510 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_entityName_in_persisterSpaceRoot512 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000020000L});
    public static final BitSet FOLLOW_PROP_FETCH_in_persisterSpaceRoot514 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PROPERTY_JOIN_in_joins528 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_joinType_in_joins532 = new BitSet(new long[]{0x1000000000000020L});
    public static final BitSet FOLLOW_FETCH_in_joins536 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_joins541 = new BitSet(new long[]{0x0000400000000000L,0x0000000000004000L,0x0000000000030000L});
    public static final BitSet FOLLOW_PROP_FETCH_in_joins545 = new BitSet(new long[]{0x0000400000000000L,0x0000000000004000L,0x0000000000010000L});
    public static final BitSet FOLLOW_collectionExpression_in_joins555 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_propertyReference_in_joins557 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x2000000000000000L});
    public static final BitSet FOLLOW_withClause_in_joins560 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PERSISTER_JOIN_in_joins572 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_joinType_in_joins574 = new BitSet(new long[]{0x0004000000000000L});
    public static final BitSet FOLLOW_persisterSpaceRoot_in_joins576 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000000000000002L});
    public static final BitSet FOLLOW_onClause_in_joins578 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WITH_in_withClause592 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_withClause594 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ON_in_onClause607 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_onClause609 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CROSS_in_joinType625 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INNER_in_joinType632 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LEFT_in_joinType640 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_RIGHT_in_joinType646 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_FULL_in_joinType652 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_OUTER_in_joinType657 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SELECT_in_selectClause680 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_DISTINCT_in_selectClause682 = new BitSet(new long[]{0x4D007C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE620130C1L});
    public static final BitSet FOLLOW_rootSelectExpression_in_selectClause685 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SELECT_LIST_in_rootSelectExpression698 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression700 = new BitSet(new long[]{0x4D007C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE620130C1L});
    public static final BitSet FOLLOW_SELECT_ITEM_in_rootSelectExpression708 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression710 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_in_rootSelectExpression717 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression719 = new BitSet(new long[]{0x4D007C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE620130C1L});
    public static final BitSet FOLLOW_DYNAMIC_INSTANTIATION_ARG_in_rootSelectExpression727 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rootSelectExpression_in_rootSelectExpression729 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_valueExpression_in_rootSelectExpression735 = new BitSet(new long[]{0x0000000000000022L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_rootSelectExpression737 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ORDER_BY_in_orderByClause750 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByClause752 = new BitSet(new long[]{0x0000000000000008L,0x0000000000000000L,0x0000002000000000L});
    public static final BitSet FOLLOW_SORT_SPEC_in_sortSpecification766 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_sortSpecification768 = new BitSet(new long[]{0x0000000001000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_COLLATE_in_sortSpecification770 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_ORDER_SPEC_in_sortSpecification773 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OR_in_searchCondition787 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition789 = new BitSet(new long[]{0x4D104C5DC0BAE6D0L,0xBFD5FFF85F04721CL,0x018F07DE020130C5L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition791 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AND_in_searchCondition800 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition802 = new BitSet(new long[]{0x4D104C5DC0BAE6D0L,0xBFD5FFF85F04721CL,0x018F07DE020130C5L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition804 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_in_searchCondition813 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchCondition815 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_predicate_in_searchCondition822 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EQUALS_in_predicate835 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate837 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate839 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_EQUAL_in_predicate848 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate850 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate852 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_in_predicate861 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate863 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate865 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LESS_EQUAL_in_predicate874 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate876 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate878 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GREATER_in_predicate887 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate889 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate891 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_GREATER_EQUAL_in_predicate900 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate902 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_comparativePredicateValue_in_predicate904 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NULL_in_predicate913 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate915 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NOT_NULL_in_predicate924 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate926 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LIKE_in_predicate951 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_predicate953 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_predicate955 = new BitSet(new long[]{0x0020000000000008L});
    public static final BitSet FOLLOW_escapeSpecification_in_predicate957 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_LIKE_in_predicate967 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_predicate969 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_predicate971 = new BitSet(new long[]{0x0020000000000008L});
    public static final BitSet FOLLOW_escapeSpecification_in_predicate973 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BETWEEN_in_predicate1004 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1006 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_betweenList_in_predicate1008 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_BETWEEN_in_predicate1017 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1019 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_betweenList_in_predicate1021 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_in_predicate1048 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1050 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_inPredicateValue_in_predicate1052 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_IN_in_predicate1061 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1063 = new BitSet(new long[]{0x0000000000000000L,0x0000000000400000L});
    public static final BitSet FOLLOW_inPredicateValue_in_predicate1065 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MEMBER_OF_in_predicate1092 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1094 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1096 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NOT_MEMBER_OF_in_predicate1105 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1107 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1109 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_EMPTY_in_predicate1119 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1121 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IS_NOT_EMPTY_in_predicate1130 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1132 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_rowValueConstructor_in_predicate1139 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BETWEEN_LIST_in_betweenList1152 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1156 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_rowValueConstructor_in_betweenList1160 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_rowValueConstructor_in_comparativePredicateValue1173 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_rowValueConstructor1184 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ESCAPE_in_escapeSpecification1196 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_escapeSpecification1198 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IN_LIST_in_inPredicateValue1211 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_inPredicateValue1213 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_numericValueExpression1226 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_characterValueExpression1237 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_datetimeValueExpression1248 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLE_PIPE_in_valueExpression1261 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_valueExpression1263 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_UNARY_MINUS_in_valueExpression1273 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1275 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UNARY_PLUS_in_valueExpression1284 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1286 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PLUS_in_valueExpression1295 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1297 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1299 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MINUS_in_valueExpression1308 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1310 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1312 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ASTERISK_in_valueExpression1321 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1323 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1325 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SOLIDUS_in_valueExpression1334 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1336 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_numericValueExpression_in_valueExpression1338 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_EXISTS_in_valueExpression1347 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_rowValueConstructor_in_valueExpression1349 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SOME_in_valueExpression1357 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1359 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ALL_in_valueExpression1368 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1370 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ANY_in_valueExpression1379 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1381 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_VECTOR_EXPR_in_valueExpression1390 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_valueExpression1392 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpressionPrimary_in_valueExpression1400 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_caseExpression_in_valueExpressionPrimary1411 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_function_in_valueExpressionPrimary1416 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionFunction_in_valueExpressionPrimary1421 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collectionExpression_in_valueExpressionPrimary1426 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_constant_in_valueExpressionPrimary1431 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_parameter_in_valueExpressionPrimary1436 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyReference_in_valueExpressionPrimary1441 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SUB_QUERY_in_valueExpressionPrimary1447 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_queryStatementSet_in_valueExpressionPrimary1449 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ALIAS_REF_in_valueExpressionPrimary1455 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_CLASS_in_valueExpressionPrimary1462 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_valueExpressionPrimary1464 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_JAVA_CONSTANT_in_valueExpressionPrimary1472 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_valueExpressionPrimary1474 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_PATH_in_valueExpressionPrimary1482 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_valueExpressionPrimary1486 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_NULLIF_in_caseExpression1513 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1515 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1517 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COALESCE_in_caseExpression1524 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1526 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1528 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_SIMPLE_CASE_in_caseExpression1536 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_caseExpression1538 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_simpleCaseWhenClause_in_caseExpression1540 = new BitSet(new long[]{0x0000800000000008L,0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_elseClause_in_caseExpression1543 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SEARCHED_CASE_in_caseExpression1551 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchedWhenClause_in_caseExpression1553 = new BitSet(new long[]{0x0000800000000008L,0x0000000000000000L,0x0800000000000000L});
    public static final BitSet FOLLOW_elseClause_in_caseExpression1556 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHEN_in_simpleCaseWhenClause1570 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1572 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_simpleCaseWhenClause1574 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_WHEN_in_searchedWhenClause1587 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_searchCondition_in_searchedWhenClause1589 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_searchedWhenClause1591 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ELSE_in_elseClause1604 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_elseClause1606 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_setFunction_in_function1618 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_standardFunction_in_function1623 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SUM_in_setFunction1635 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1637 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_AVG_in_setFunction1644 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1646 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MAX_in_setFunction1653 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1655 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MIN_in_setFunction1662 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_setFunction1664 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_COUNT_in_setFunction1671 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ASTERISK_in_setFunction1674 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_setFunction1678 = new BitSet(new long[]{0x4000404000000000L,0x0000000000044000L,0x0000000000010000L});
    public static final BitSet FOLLOW_countFunctionArguments_in_setFunction1684 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_functionFunction_in_standardFunction1697 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_castFunction_in_standardFunction1702 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatFunction_in_standardFunction1707 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_substringFunction_in_standardFunction1712 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimFunction_in_standardFunction1717 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upperFunction_in_standardFunction1722 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lowerFunction_in_standardFunction1727 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lengthFunction_in_standardFunction1732 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateFunction_in_standardFunction1737 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_absFunction_in_standardFunction1742 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sqrtFunction_in_standardFunction1747 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modFunction_in_standardFunction1752 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sizeFunction_in_standardFunction1757 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_indexFunction_in_standardFunction1762 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentDateFunction_in_standardFunction1767 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimeFunction_in_standardFunction1772 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimestampFunction_in_standardFunction1777 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_extractFunction_in_standardFunction1782 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_positionFunction_in_standardFunction1787 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_charLengthFunction_in_standardFunction1792 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_octetLengthFunction_in_standardFunction1797 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bitLengthFunction_in_standardFunction1802 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FUNCTION_in_functionFunction1815 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_functionFunction1817 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_CAST_in_castFunction1832 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_castFunction1834 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_castFunction1836 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONCAT_in_concatFunction1851 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_valueExpression_in_concatFunction1853 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_SUBSTRING_in_substringFunction1867 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_substringFunction1869 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1871 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_numericValueExpression_in_substringFunction1873 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_TRIM_in_trimFunction1887 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_trimOperands_in_trimFunction1889 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_set_in_trimOperands1902 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1910 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_characterValueExpression_in_trimOperands1912 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_UPPER_in_upperFunction1925 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_upperFunction1927 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOWER_in_lowerFunction1940 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lowerFunction1942 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LENGTH_in_lengthFunction1955 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_lengthFunction1957 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LOCATE_in_locateFunction1970 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1972 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_characterValueExpression_in_locateFunction1974 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_numericValueExpression_in_locateFunction1976 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ABS_in_absFunction1990 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_absFunction1992 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SQRT_in_sqrtFunction2005 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_sqrtFunction2007 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_MOD_in_modFunction2020 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_numericValueExpression_in_modFunction2022 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_numericValueExpression_in_modFunction2024 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_SIZE_in_sizeFunction2037 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_sizeFunction2039 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INDEX_in_indexFunction2052 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_ALIAS_REF_in_indexFunction2054 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CURRENT_DATE_in_currentDateFunction2066 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIME_in_currentTimeFunction2077 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CURRENT_TIMESTAMP_in_currentTimestampFunction2088 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXTRACT_in_extractFunction2100 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_extractField_in_extractFunction2102 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_datetimeValueExpression_in_extractFunction2104 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_datetimeField_in_extractField2116 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timeZoneField_in_extractField2121 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_POSITION_in_positionFunction2185 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2187 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_characterValueExpression_in_positionFunction2189 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CHARACTER_LENGTH_in_charLengthFunction2202 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_charLengthFunction2204 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_OCTET_LENGTH_in_octetLengthFunction2217 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_octetLengthFunction2219 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_BIT_LENGTH_in_bitLengthFunction2232 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_characterValueExpression_in_bitLengthFunction2234 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_collectionExpression_in_countFunctionArguments2247 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_propertyReference_in_countFunctionArguments2252 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_countFunctionArguments2257 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_collectionFunction2269 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_collectionPropertyReference_in_collectionFunction2279 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_propertyReference_in_collectionPropertyReference2294 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ELEMENTS_in_collectionExpression2306 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_collectionExpression2308 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_INDICES_in_collectionExpression2316 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReference_in_collectionExpression2318 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_literal_in_constant2351 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_constant2356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_constant2361 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_constant2366 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_literal2377 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEX_LITERAL_in_literal2382 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OCTAL_LITERAL_in_literal2387 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2392 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal2397 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2403 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal2405 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_CONST_STRING_VALUE_in_literal2412 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal2414 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_ENTITY_NAME_in_entityName2447 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_ALIAS_NAME_in_entityName2449 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PROPERTY_REFERENCE_in_propertyReference2464 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_propertyReferencePath_in_propertyReference2466 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_unqualifiedPropertyReference_in_propertyReferencePath2502 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pathedPropertyReference_in_propertyReferencePath2507 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_terminalIndexOperation_in_propertyReferencePath2512 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_unqualifiedPropertyReference2533 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_pathedPropertyReference2548 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_pathedPropertyReference2550 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReference2552 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2580 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_pathedPropertyReferenceSource2590 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_intermediatePathedPropertyReference_in_pathedPropertyReferenceSource2597 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_intermediateIndexOperation_in_pathedPropertyReferenceSource2604 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_intermediatePathedPropertyReference2622 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_intermediatePathedPropertyReference2626 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_intermediatePathedPropertyReference2628 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_intermediateIndexOperation2650 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_indexOperationSource_in_intermediateIndexOperation2652 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_indexSelector_in_intermediateIndexOperation2654 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_terminalIndexOperation2672 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_indexOperationSource_in_terminalIndexOperation2674 = new BitSet(new long[]{0x4D004C5DC0BA64D0L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_indexSelector_in_terminalIndexOperation2676 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_DOT_in_indexOperationSource2697 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_pathedPropertyReferenceSource_in_indexOperationSource2699 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2701 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_IDENTIFIER_in_indexOperationSource2715 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_valueExpression_in_indexSelector2730 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_path2742 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOT_in_path2748 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2750 = new BitSet(new long[]{0x0000020000000000L,0x0000000600000800L});
    public static final BitSet FOLLOW_path_in_path2752 = new BitSet(new long[]{0x0000000000000008L});
    public static final BitSet FOLLOW_LEFT_SQUARE_in_path2760 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2762 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_path2764 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_path2773 = new BitSet(new long[]{0x0000000000000004L});
    public static final BitSet FOLLOW_path_in_path2775 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});
    public static final BitSet FOLLOW_valueExpression_in_path2777 = new BitSet(new long[]{0x4D004C5DC0BA64D8L,0xB015EF8850046204L,0x018F07DE020130C1L});

}