// $ANTLR 3.4 org/hibernate/hql/ast/origin/ordering/OrderByParser.g 2014-02-14 22:38:27

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.origin.ordering;

import org.hibernate.hql.ast.TemplateConstants;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class OrderByParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABS", "ALIAS_NAME", "ALIAS_REF", "ALL", "AMPERSAND", "AND", "ANY", "ARROW", "AS", "ASTERISK", "AVG", "BETWEEN", "BETWEEN_LIST", "BIT_LENGTH", "BOTH", "CAST", "CHARACTER_LENGTH", "CHARACTER_LITERAL", "CLASS", "COALESCE", "COLLATE", "COLLECTION_EXPRESSION", "COLON", "COLUMN", "COLUMN_LIST", "COMMA", "CONCAT", "CONST_STRING_VALUE", "COUNT", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DAY", "DECIMAL_LITERAL", "DELETE", "DISTINCT", "DOT", "DOT_CLASS", "DOUBLE_PIPE", "DYNAMIC_INSTANTIATION", "DYNAMIC_INSTANTIATION_ARG", "ELEMENTS", "ELSE", "END", "ENTITY_NAME", "ENTITY_PERSISTER_REF", "EOL", "EQUALS", "ESCAPE", "ESCAPE_SEQUENCE", "EXCEPT", "EXISTS", "EXPONENT", "EXTRACT", "FALSE", "FETCH", "FILTER", "FLOATING_POINT_LITERAL", "FLOAT_TYPE_SUFFIX", "FROM", "FULL", "FUNCTION", "GREATER", "GREATER_EQUAL", "GROUPING_VALUE", "GROUP_BY", "HAVING", "HEX_DIGIT", "HEX_LITERAL", "HOUR", "IDENTIFIER", "IN", "INDEX", "INDICES", "INNER", "INSERT", "INSERTABILITY_SPEC", "INTEGER_LITERAL", "INTEGER_TYPE_SUFFIX", "INTERSECT", "INTO", "IN_LIST", "IS", "IS_EMPTY", "IS_NOT_EMPTY", "IS_NOT_NULL", "IS_NULL", "JAVA_CONSTANT", "JOIN", "JPA_PARAM", "LEADING", "LEFT", "LEFT_PAREN", "LEFT_SQUARE", "LENGTH", "LESS", "LESS_EQUAL", "LIKE", "LOCATE", "LOWER", "MAX", "MAXELEMENT", "MAXINDEX", "MEMBER_OF", "MIN", "MINELEMENT", "MININDEX", "MINUS", "MINUTE", "MOD", "MONTH", "NAMED_PARAM", "NEW", "NOT", "NOT_BETWEEN", "NOT_EQUAL", "NOT_IN", "NOT_LIKE", "NOT_MEMBER_OF", "NULL", "NULLIF", "OCTAL_ESCAPE", "OCTAL_LITERAL", "OCTET_LENGTH", "ON", "OR", "ORDER_BY", "ORDER_SPEC", "OUTER", "PARAM", "PATH", "PERCENT", "PERSISTER_JOIN", "PERSISTER_SPACE", "PIPE", "PLUS", "POSITION", "PROPERTIES", "PROPERTY_JOIN", "PROPERTY_REFERENCE", "PROP_FETCH", "QUALIFIED_JOIN", "QUERY", "QUERY_SPEC", "QUOTED_IDENTIFIER", "RIGHT", "RIGHT_PAREN", "RIGHT_SQUARE", "SEARCHED_CASE", "SECOND", "SELECT", "SELECT_FROM", "SELECT_ITEM", "SELECT_LIST", "SEMICOLON", "SET", "SIMPLE_CASE", "SIZE", "SOLIDUS", "SOME", "SORT_SPEC", "SQRT", "STRING_LITERAL", "SUBSTRING", "SUB_QUERY", "SUM", "TABLE", "THEN", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TRAILING", "TRIM", "TRUE", "UNARY_MINUS", "UNARY_PLUS", "UNICODE_ESCAPE", "UNION", "UPDATE", "UPPER", "VECTOR_EXPR", "VERSIONED", "VERSIONED_VALUE", "WHEN", "WHERE", "WITH", "WS", "YEAR"
    };

    public static final int EOF=-1;
    public static final int ABS=4;
    public static final int ALIAS_NAME=5;
    public static final int ALIAS_REF=6;
    public static final int ALL=7;
    public static final int AMPERSAND=8;
    public static final int AND=9;
    public static final int ANY=10;
    public static final int ARROW=11;
    public static final int AS=12;
    public static final int ASTERISK=13;
    public static final int AVG=14;
    public static final int BETWEEN=15;
    public static final int BETWEEN_LIST=16;
    public static final int BIT_LENGTH=17;
    public static final int BOTH=18;
    public static final int CAST=19;
    public static final int CHARACTER_LENGTH=20;
    public static final int CHARACTER_LITERAL=21;
    public static final int CLASS=22;
    public static final int COALESCE=23;
    public static final int COLLATE=24;
    public static final int COLLECTION_EXPRESSION=25;
    public static final int COLON=26;
    public static final int COLUMN=27;
    public static final int COLUMN_LIST=28;
    public static final int COMMA=29;
    public static final int CONCAT=30;
    public static final int CONST_STRING_VALUE=31;
    public static final int COUNT=32;
    public static final int CROSS=33;
    public static final int CURRENT_DATE=34;
    public static final int CURRENT_TIME=35;
    public static final int CURRENT_TIMESTAMP=36;
    public static final int DAY=37;
    public static final int DECIMAL_LITERAL=38;
    public static final int DELETE=39;
    public static final int DISTINCT=40;
    public static final int DOT=41;
    public static final int DOT_CLASS=42;
    public static final int DOUBLE_PIPE=43;
    public static final int DYNAMIC_INSTANTIATION=44;
    public static final int DYNAMIC_INSTANTIATION_ARG=45;
    public static final int ELEMENTS=46;
    public static final int ELSE=47;
    public static final int END=48;
    public static final int ENTITY_NAME=49;
    public static final int ENTITY_PERSISTER_REF=50;
    public static final int EOL=51;
    public static final int EQUALS=52;
    public static final int ESCAPE=53;
    public static final int ESCAPE_SEQUENCE=54;
    public static final int EXCEPT=55;
    public static final int EXISTS=56;
    public static final int EXPONENT=57;
    public static final int EXTRACT=58;
    public static final int FALSE=59;
    public static final int FETCH=60;
    public static final int FILTER=61;
    public static final int FLOATING_POINT_LITERAL=62;
    public static final int FLOAT_TYPE_SUFFIX=63;
    public static final int FROM=64;
    public static final int FULL=65;
    public static final int FUNCTION=66;
    public static final int GREATER=67;
    public static final int GREATER_EQUAL=68;
    public static final int GROUPING_VALUE=69;
    public static final int GROUP_BY=70;
    public static final int HAVING=71;
    public static final int HEX_DIGIT=72;
    public static final int HEX_LITERAL=73;
    public static final int HOUR=74;
    public static final int IDENTIFIER=75;
    public static final int IN=76;
    public static final int INDEX=77;
    public static final int INDICES=78;
    public static final int INNER=79;
    public static final int INSERT=80;
    public static final int INSERTABILITY_SPEC=81;
    public static final int INTEGER_LITERAL=82;
    public static final int INTEGER_TYPE_SUFFIX=83;
    public static final int INTERSECT=84;
    public static final int INTO=85;
    public static final int IN_LIST=86;
    public static final int IS=87;
    public static final int IS_EMPTY=88;
    public static final int IS_NOT_EMPTY=89;
    public static final int IS_NOT_NULL=90;
    public static final int IS_NULL=91;
    public static final int JAVA_CONSTANT=92;
    public static final int JOIN=93;
    public static final int JPA_PARAM=94;
    public static final int LEADING=95;
    public static final int LEFT=96;
    public static final int LEFT_PAREN=97;
    public static final int LEFT_SQUARE=98;
    public static final int LENGTH=99;
    public static final int LESS=100;
    public static final int LESS_EQUAL=101;
    public static final int LIKE=102;
    public static final int LOCATE=103;
    public static final int LOWER=104;
    public static final int MAX=105;
    public static final int MAXELEMENT=106;
    public static final int MAXINDEX=107;
    public static final int MEMBER_OF=108;
    public static final int MIN=109;
    public static final int MINELEMENT=110;
    public static final int MININDEX=111;
    public static final int MINUS=112;
    public static final int MINUTE=113;
    public static final int MOD=114;
    public static final int MONTH=115;
    public static final int NAMED_PARAM=116;
    public static final int NEW=117;
    public static final int NOT=118;
    public static final int NOT_BETWEEN=119;
    public static final int NOT_EQUAL=120;
    public static final int NOT_IN=121;
    public static final int NOT_LIKE=122;
    public static final int NOT_MEMBER_OF=123;
    public static final int NULL=124;
    public static final int NULLIF=125;
    public static final int OCTAL_ESCAPE=126;
    public static final int OCTAL_LITERAL=127;
    public static final int OCTET_LENGTH=128;
    public static final int ON=129;
    public static final int OR=130;
    public static final int ORDER_BY=131;
    public static final int ORDER_SPEC=132;
    public static final int OUTER=133;
    public static final int PARAM=134;
    public static final int PATH=135;
    public static final int PERCENT=136;
    public static final int PERSISTER_JOIN=137;
    public static final int PERSISTER_SPACE=138;
    public static final int PIPE=139;
    public static final int PLUS=140;
    public static final int POSITION=141;
    public static final int PROPERTIES=142;
    public static final int PROPERTY_JOIN=143;
    public static final int PROPERTY_REFERENCE=144;
    public static final int PROP_FETCH=145;
    public static final int QUALIFIED_JOIN=146;
    public static final int QUERY=147;
    public static final int QUERY_SPEC=148;
    public static final int QUOTED_IDENTIFIER=149;
    public static final int RIGHT=150;
    public static final int RIGHT_PAREN=151;
    public static final int RIGHT_SQUARE=152;
    public static final int SEARCHED_CASE=153;
    public static final int SECOND=154;
    public static final int SELECT=155;
    public static final int SELECT_FROM=156;
    public static final int SELECT_ITEM=157;
    public static final int SELECT_LIST=158;
    public static final int SEMICOLON=159;
    public static final int SET=160;
    public static final int SIMPLE_CASE=161;
    public static final int SIZE=162;
    public static final int SOLIDUS=163;
    public static final int SOME=164;
    public static final int SORT_SPEC=165;
    public static final int SQRT=166;
    public static final int STRING_LITERAL=167;
    public static final int SUBSTRING=168;
    public static final int SUB_QUERY=169;
    public static final int SUM=170;
    public static final int TABLE=171;
    public static final int THEN=172;
    public static final int TIMEZONE_HOUR=173;
    public static final int TIMEZONE_MINUTE=174;
    public static final int TRAILING=175;
    public static final int TRIM=176;
    public static final int TRUE=177;
    public static final int UNARY_MINUS=178;
    public static final int UNARY_PLUS=179;
    public static final int UNICODE_ESCAPE=180;
    public static final int UNION=181;
    public static final int UPDATE=182;
    public static final int UPPER=183;
    public static final int VECTOR_EXPR=184;
    public static final int VERSIONED=185;
    public static final int VERSIONED_VALUE=186;
    public static final int WHEN=187;
    public static final int WHERE=188;
    public static final int WITH=189;
    public static final int WS=190;
    public static final int YEAR=191;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public OrderByParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public OrderByParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return OrderByParser.tokenNames; }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/origin/ordering/OrderByParser.g"; }


    	private Stack flattenTuples = new Stack();

        protected void prepareFlattenTuplesStack() {
            flattenTuples.push( Boolean.FALSE );
        }

        /**
         * A check to see if the text represents a known function name (in addition to the
         * set of known {@link #standardFunction "standard"} functions.  This is only needed in the
         * case of seeing a dot-ident structure which is not followed by a paren; such structures
         * which are followed by a paren are explicitly assumed to be a function name.
         *
         * @param text The text to check as a  function name.
         *
         * @return True if the text is a known function name, false otherwise.
         *
         * @see #standardFunction
         */
        protected boolean isFunctionName(String text) {
            // by default, assume it is not
    	return false;
        }

        /**
         * A check to see if the text represents a mapped property name.
         *
         * @param text The text to check as a property name.
         *
         * @return True if the text is a mapped property name, false otherwise.
         */
        protected boolean isPropertyName(String text) {
            // by default, assume it is not
    	return false;
        }

        /**
         * Given a property, resolve it's {@link #COLUMN} or {@link #VECTOR_EXPR} tree.
         *
         * @param propertyTree The tree representing the property name.
         *
         * @return The column(s) tree.
         */
        protected CommonTree buildPropertyColumns(CommonTree propertyTree) {
            throw new UnsupportedOperationException( "must be overridden!" );
        }

        private boolean validateSoftKeyword(String text) {
    		return validateLT(1, text);
    	}

    	private boolean validateLT(int offset, String text) {
    		String text2Validate = retrieveLT( offset );
    		return text2Validate == null ? false : text2Validate.equalsIgnoreCase( text );
    	}

    	private String retrieveLT(int offset) {
    	if (null == input) {
    		return null;
    	}
    		Token token = input.LT(offset);
    		return token == null ? null : token.getText();
    	}

        public Boolean shouldFlattenTuplesInOrderBy() {
            return Boolean.TRUE;
        }


    public static class orderByFragment_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderByFragment"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:121:1: orderByFragment : sortSpecification ( COMMA sortSpecification )* -> ^( ORDER_BY ( sortSpecification )+ ) ;
    public final OrderByParser.orderByFragment_return orderByFragment() throws RecognitionException {
        OrderByParser.orderByFragment_return retval = new OrderByParser.orderByFragment_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken COMMA2=null;
        OrderByParser.sortSpecification_return sortSpecification1 =null;

        OrderByParser.sortSpecification_return sortSpecification3 =null;


        CommonTree COMMA2_tree=null;
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_sortSpecification=new RewriteRuleSubtreeStream(adaptor,"rule sortSpecification");

            if ( state.backtracking == 0 ) {
                flattenTuples.push( shouldFlattenTuplesInOrderBy() );
            }

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:131:3: ( sortSpecification ( COMMA sortSpecification )* -> ^( ORDER_BY ( sortSpecification )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:131:5: sortSpecification ( COMMA sortSpecification )*
            {
            pushFollow(FOLLOW_sortSpecification_in_orderByFragment83);
            sortSpecification1=sortSpecification();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sortSpecification.add(sortSpecification1.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:131:23: ( COMMA sortSpecification )*
            loop1:
            do {
                int alt1=2;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==COMMA) ) {
                    alt1=1;
                }


                switch (alt1) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:131:25: COMMA sortSpecification
            	    {
            	    COMMA2=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_orderByFragment87); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA2);


            	    pushFollow(FOLLOW_sortSpecification_in_orderByFragment89);
            	    sortSpecification3=sortSpecification();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_sortSpecification.add(sortSpecification3.getTree());

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            // AST REWRITE
            // elements: sortSpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 132:9: -> ^( ORDER_BY ( sortSpecification )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:132:12: ^( ORDER_BY ( sortSpecification )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(ORDER_BY, "ORDER_BY")
                , root_1);

                if ( !(stream_sortSpecification.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_sortSpecification.hasNext() ) {
                    adaptor.addChild(root_1, stream_sortSpecification.nextTree());

                }
                stream_sortSpecification.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {
                if ( state.backtracking == 0 ) {
                    flattenTuples.pop();
                }
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderByFragment"


    public static class sortSpecification_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortSpecification"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:143:1: sortSpecification : sortKey ( collationSpecification )? ( orderingSpecification )? -> ( ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? ) )+ ;
    public final OrderByParser.sortSpecification_return sortSpecification() throws RecognitionException {
        OrderByParser.sortSpecification_return retval = new OrderByParser.sortSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.sortKey_return sortKey4 =null;

        OrderByParser.collationSpecification_return collationSpecification5 =null;

        OrderByParser.orderingSpecification_return orderingSpecification6 =null;


        RewriteRuleSubtreeStream stream_orderingSpecification=new RewriteRuleSubtreeStream(adaptor,"rule orderingSpecification");
        RewriteRuleSubtreeStream stream_sortKey=new RewriteRuleSubtreeStream(adaptor,"rule sortKey");
        RewriteRuleSubtreeStream stream_collationSpecification=new RewriteRuleSubtreeStream(adaptor,"rule collationSpecification");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:144:5: ( sortKey ( collationSpecification )? ( orderingSpecification )? -> ( ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? ) )+ )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:144:7: sortKey ( collationSpecification )? ( orderingSpecification )?
            {
            pushFollow(FOLLOW_sortKey_in_sortSpecification131);
            sortKey4=sortKey();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sortKey.add(sortKey4.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:144:15: ( collationSpecification )?
            int alt2=2;
            int LA2_0 = input.LA(1);

            if ( (LA2_0==IDENTIFIER) && ((((validateSoftKeyword("collate")))||((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))||((validateSoftKeyword("descending") || validateSoftKeyword("desc")))))) {
                int LA2_1 = input.LA(2);

                if ( (LA2_1==IDENTIFIER) && (((validateSoftKeyword("collate"))))) {
                    alt2=1;
                }
            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:144:15: collationSpecification
                    {
                    pushFollow(FOLLOW_collationSpecification_in_sortSpecification133);
                    collationSpecification5=collationSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_collationSpecification.add(collationSpecification5.getTree());

                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:144:39: ( orderingSpecification )?
            int alt3=2;
            int LA3_0 = input.LA(1);

            if ( (LA3_0==IDENTIFIER) && ((((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))||((validateSoftKeyword("descending") || validateSoftKeyword("desc")))))) {
                alt3=1;
            }
            switch (alt3) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:144:39: orderingSpecification
                    {
                    pushFollow(FOLLOW_orderingSpecification_in_sortSpecification136);
                    orderingSpecification6=orderingSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_orderingSpecification.add(orderingSpecification6.getTree());

                    }
                    break;

            }


            // AST REWRITE
            // elements: orderingSpecification, sortKey, collationSpecification
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 145:9: -> ( ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? ) )+
            {
                if ( !(stream_sortKey.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_sortKey.hasNext() ) {
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:145:12: ^( SORT_SPEC sortKey ( collationSpecification )? ( orderingSpecification )? )
                    {
                    CommonTree root_1 = (CommonTree)adaptor.nil();
                    root_1 = (CommonTree)adaptor.becomeRoot(
                    (CommonTree)adaptor.create(SORT_SPEC, "SORT_SPEC")
                    , root_1);

                    adaptor.addChild(root_1, stream_sortKey.nextTree());

                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:145:33: ( collationSpecification )?
                    if ( stream_collationSpecification.hasNext() ) {
                        adaptor.addChild(root_1, stream_collationSpecification.nextTree());

                    }
                    stream_collationSpecification.reset();

                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:145:57: ( orderingSpecification )?
                    if ( stream_orderingSpecification.hasNext() ) {
                        adaptor.addChild(root_1, stream_orderingSpecification.nextTree());

                    }
                    stream_orderingSpecification.reset();

                    adaptor.addChild(root_0, root_1);
                    }

                }
                stream_sortKey.reset();

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortSpecification"


    public static class sortKey_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sortKey"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:153:1: sortKey : expression ;
    public final OrderByParser.sortKey_return sortKey() throws RecognitionException {
        OrderByParser.sortKey_return retval = new OrderByParser.sortKey_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.expression_return expression7 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:154:5: ( expression )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:154:7: expression
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_expression_in_sortKey182);
            expression7=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expression7.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sortKey"


    public static class expression_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expression"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:160:1: expression : ( QUOTED_IDENTIFIER -> ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] QUOTED_IDENTIFIER[$QUOTED_IDENTIFIER] ) | standardFunction | literal | ( IDENTIFIER ( DOT IDENTIFIER )* LEFT_PAREN )=> generalFunction | identDotIdentStructure -> { ( isFunctionName($identDotIdentStructure.text) ) }? ^( FUNCTION[$identDotIdentStructure.start,$identDotIdentStructure.text] ) -> { ( isPropertyName($identDotIdentStructure.text) ) }? -> { ( $identDotIdentStructure.tree.getType() == DOT ) }? identDotIdentStructure -> ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] IDENTIFIER[$identDotIdentStructure.start,$identDotIdentStructure.text] ) );
    public final OrderByParser.expression_return expression() throws RecognitionException {
        OrderByParser.expression_return retval = new OrderByParser.expression_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken QUOTED_IDENTIFIER8=null;
        OrderByParser.standardFunction_return standardFunction9 =null;

        OrderByParser.literal_return literal10 =null;

        OrderByParser.generalFunction_return generalFunction11 =null;

        OrderByParser.identDotIdentStructure_return identDotIdentStructure12 =null;


        CommonTree QUOTED_IDENTIFIER8_tree=null;
        RewriteRuleTokenStream stream_QUOTED_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token QUOTED_IDENTIFIER");
        RewriteRuleSubtreeStream stream_identDotIdentStructure=new RewriteRuleSubtreeStream(adaptor,"rule identDotIdentStructure");

            if ( state.backtracking == 0 ) {
                //enableParameterUsage.push(Boolean.TRUE); //FIXME
            }

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:171:4: ( QUOTED_IDENTIFIER -> ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] QUOTED_IDENTIFIER[$QUOTED_IDENTIFIER] ) | standardFunction | literal | ( IDENTIFIER ( DOT IDENTIFIER )* LEFT_PAREN )=> generalFunction | identDotIdentStructure -> { ( isFunctionName($identDotIdentStructure.text) ) }? ^( FUNCTION[$identDotIdentStructure.start,$identDotIdentStructure.text] ) -> { ( isPropertyName($identDotIdentStructure.text) ) }? -> { ( $identDotIdentStructure.tree.getType() == DOT ) }? identDotIdentStructure -> ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] IDENTIFIER[$identDotIdentStructure.start,$identDotIdentStructure.text] ) )
            int alt4=5;
            switch ( input.LA(1) ) {
            case QUOTED_IDENTIFIER:
                {
                alt4=1;
                }
                break;
            case IDENTIFIER:
                {
                int LA4_2 = input.LA(2);

                if ( (LA4_2==DOT) && (synpred1_OrderByParser())) {
                    alt4=4;
                }
                else if ( ((((validateSoftKeyword("substring")))||((validateSoftKeyword("current_time")))||((validateSoftKeyword("concat")))||((validateSoftKeyword("octet_length")))||((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))||((validateSoftKeyword("upper")))||((validateSoftKeyword("mod")))||((validateSoftKeyword("abs")))||((validateSoftKeyword("extract")))||((validateSoftKeyword("locate")))||((validateSoftKeyword("trim")))||((validateSoftKeyword("length")))||((validateSoftKeyword("cast")))||((validateSoftKeyword("bit_length")))||((validateSoftKeyword("lower")))||((validateSoftKeyword("position")))||((validateSoftKeyword("current_timestamp")))||((validateSoftKeyword("sqrt")))||((validateSoftKeyword("current_date"))))) ) {
                    alt4=2;
                }
                else if ( (true) ) {
                    alt4=5;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 2, input);

                    throw nvae;

                }
                }
                break;
            case CHARACTER_LITERAL:
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case OCTAL_LITERAL:
            case STRING_LITERAL:
                {
                alt4=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:171:6: QUOTED_IDENTIFIER
                    {
                    QUOTED_IDENTIFIER8=(CommonToken)match(input,QUOTED_IDENTIFIER,FOLLOW_QUOTED_IDENTIFIER_in_expression210); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_QUOTED_IDENTIFIER.add(QUOTED_IDENTIFIER8);


                    // AST REWRITE
                    // elements: QUOTED_IDENTIFIER
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 171:24: -> ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] QUOTED_IDENTIFIER[$QUOTED_IDENTIFIER] )
                    {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:171:27: ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] QUOTED_IDENTIFIER[$QUOTED_IDENTIFIER] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(COLUMN, "COLUMN")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(ALIAS_REF, TemplateConstants.TEMPLATE)
                        );

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(QUOTED_IDENTIFIER, QUOTED_IDENTIFIER8)
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:173:7: standardFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_standardFunction_in_expression237);
                    standardFunction9=standardFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, standardFunction9.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:174:7: literal
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_literal_in_expression245);
                    literal10=literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, literal10.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:176:7: ( IDENTIFIER ( DOT IDENTIFIER )* LEFT_PAREN )=> generalFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_generalFunction_in_expression277);
                    generalFunction11=generalFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, generalFunction11.getTree());

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:178:7: identDotIdentStructure
                    {
                    pushFollow(FOLLOW_identDotIdentStructure_in_expression290);
                    identDotIdentStructure12=identDotIdentStructure();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_identDotIdentStructure.add(identDotIdentStructure12.getTree());

                    // AST REWRITE
                    // elements: identDotIdentStructure
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 179:9: -> { ( isFunctionName($identDotIdentStructure.text) ) }? ^( FUNCTION[$identDotIdentStructure.start,$identDotIdentStructure.text] )
                    if ( ( isFunctionName((identDotIdentStructure12!=null?input.toString(identDotIdentStructure12.start,identDotIdentStructure12.stop):null)) ) ) {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:181:15: ^( FUNCTION[$identDotIdentStructure.start,$identDotIdentStructure.text] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(FUNCTION, (identDotIdentStructure12!=null?((CommonToken)identDotIdentStructure12.start):null), (identDotIdentStructure12!=null?input.toString(identDotIdentStructure12.start,identDotIdentStructure12.stop):null))
                        , root_1);

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 182:9: -> { ( isPropertyName($identDotIdentStructure.text) ) }?
                    if ( ( isPropertyName((identDotIdentStructure12!=null?input.toString(identDotIdentStructure12.start,identDotIdentStructure12.stop):null)) ) ) {
                        adaptor.addChild(root_0,  buildPropertyColumns( (identDotIdentStructure12!=null?((CommonTree)identDotIdentStructure12.tree):null) ) );

                    }

                    else // 185:9: -> { ( $identDotIdentStructure.tree.getType() == DOT ) }? identDotIdentStructure
                    if ( ( (identDotIdentStructure12!=null?((CommonTree)identDotIdentStructure12.tree):null).getType() == DOT ) ) {
                        adaptor.addChild(root_0, stream_identDotIdentStructure.nextTree());

                    }

                    else // 188:9: -> ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] IDENTIFIER[$identDotIdentStructure.start,$identDotIdentStructure.text] )
                    {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:190:15: ^( COLUMN ALIAS_REF[TemplateConstants.TEMPLATE] IDENTIFIER[$identDotIdentStructure.start,$identDotIdentStructure.text] )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(COLUMN, "COLUMN")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(ALIAS_REF, TemplateConstants.TEMPLATE)
                        );

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(IDENTIFIER, (identDotIdentStructure12!=null?((CommonToken)identDotIdentStructure12.start):null), (identDotIdentStructure12!=null?input.toString(identDotIdentStructure12.start,identDotIdentStructure12.stop):null))
                        );

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
            if ( state.backtracking==0 ) {
                if ( state.backtracking == 0 ) {
                    //enableParameterUsage.pop(); //FIXME
                }
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expression"


    public static class identifier_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "identifier"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:194:1: fragment identifier : ( IDENTIFIER | QUOTED_IDENTIFIER );
    public final OrderByParser.identifier_return identifier() throws RecognitionException {
        OrderByParser.identifier_return retval = new OrderByParser.identifier_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken set13=null;

        CommonTree set13_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:195:5: ( IDENTIFIER | QUOTED_IDENTIFIER )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set13=(CommonToken)input.LT(1);

            if ( input.LA(1)==IDENTIFIER||input.LA(1)==QUOTED_IDENTIFIER ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set13)
                );
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "identifier"


    public static class identDotIdentStructure_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "identDotIdentStructure"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:200:1: fragment identDotIdentStructure : IDENTIFIER ( DOT ^ identifier )* ;
    public final OrderByParser.identDotIdentStructure_return identDotIdentStructure() throws RecognitionException {
        OrderByParser.identDotIdentStructure_return retval = new OrderByParser.identDotIdentStructure_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken IDENTIFIER14=null;
        CommonToken DOT15=null;
        OrderByParser.identifier_return identifier16 =null;


        CommonTree IDENTIFIER14_tree=null;
        CommonTree DOT15_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:201:5: ( IDENTIFIER ( DOT ^ identifier )* )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:201:7: IDENTIFIER ( DOT ^ identifier )*
            {
            root_0 = (CommonTree)adaptor.nil();


            IDENTIFIER14=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_identDotIdentStructure521); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER14_tree = 
            (CommonTree)adaptor.create(IDENTIFIER14)
            ;
            adaptor.addChild(root_0, IDENTIFIER14_tree);
            }

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:201:18: ( DOT ^ identifier )*
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( (LA5_0==DOT) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:201:20: DOT ^ identifier
            	    {
            	    DOT15=(CommonToken)match(input,DOT,FOLLOW_DOT_in_identDotIdentStructure525); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOT15_tree = 
            	    (CommonTree)adaptor.create(DOT15)
            	    ;
            	    root_0 = (CommonTree)adaptor.becomeRoot(DOT15_tree, root_0);
            	    }

            	    pushFollow(FOLLOW_identifier_in_identDotIdentStructure528);
            	    identifier16=identifier();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) adaptor.addChild(root_0, identifier16.getTree());

            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "identDotIdentStructure"


    public static class standardFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "standardFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:204:1: standardFunction : ( castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction );
    public final OrderByParser.standardFunction_return standardFunction() throws RecognitionException {
        OrderByParser.standardFunction_return retval = new OrderByParser.standardFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.castFunction_return castFunction17 =null;

        OrderByParser.concatFunction_return concatFunction18 =null;

        OrderByParser.substringFunction_return substringFunction19 =null;

        OrderByParser.trimFunction_return trimFunction20 =null;

        OrderByParser.upperFunction_return upperFunction21 =null;

        OrderByParser.lowerFunction_return lowerFunction22 =null;

        OrderByParser.lengthFunction_return lengthFunction23 =null;

        OrderByParser.locateFunction_return locateFunction24 =null;

        OrderByParser.absFunction_return absFunction25 =null;

        OrderByParser.sqrtFunction_return sqrtFunction26 =null;

        OrderByParser.modFunction_return modFunction27 =null;

        OrderByParser.currentDateFunction_return currentDateFunction28 =null;

        OrderByParser.currentTimeFunction_return currentTimeFunction29 =null;

        OrderByParser.currentTimestampFunction_return currentTimestampFunction30 =null;

        OrderByParser.extractFunction_return extractFunction31 =null;

        OrderByParser.positionFunction_return positionFunction32 =null;

        OrderByParser.charLengthFunction_return charLengthFunction33 =null;

        OrderByParser.octetLengthFunction_return octetLengthFunction34 =null;

        OrderByParser.bitLengthFunction_return bitLengthFunction35 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:205:2: ( castFunction | concatFunction | substringFunction | trimFunction | upperFunction | lowerFunction | lengthFunction | locateFunction | absFunction | sqrtFunction | modFunction | currentDateFunction | currentTimeFunction | currentTimestampFunction | extractFunction | positionFunction | charLengthFunction | octetLengthFunction | bitLengthFunction )
            int alt6=19;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==IDENTIFIER) && ((((validateSoftKeyword("substring")))||((validateSoftKeyword("current_time")))||((validateSoftKeyword("concat")))||((validateSoftKeyword("octet_length")))||((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))||((validateSoftKeyword("upper")))||((validateSoftKeyword("mod")))||((validateSoftKeyword("abs")))||((validateSoftKeyword("extract")))||((validateSoftKeyword("locate")))||((validateSoftKeyword("trim")))||((validateSoftKeyword("length")))||((validateSoftKeyword("cast")))||((validateSoftKeyword("bit_length")))||((validateSoftKeyword("lower")))||((validateSoftKeyword("position")))||((validateSoftKeyword("current_timestamp")))||((validateSoftKeyword("sqrt")))||((validateSoftKeyword("current_date")))))) {
                int LA6_1 = input.LA(2);

                if ( (((validateSoftKeyword("cast")))) ) {
                    alt6=1;
                }
                else if ( (((validateSoftKeyword("concat")))) ) {
                    alt6=2;
                }
                else if ( (((validateSoftKeyword("substring")))) ) {
                    alt6=3;
                }
                else if ( (((validateSoftKeyword("trim")))) ) {
                    alt6=4;
                }
                else if ( (((validateSoftKeyword("upper")))) ) {
                    alt6=5;
                }
                else if ( (((validateSoftKeyword("lower")))) ) {
                    alt6=6;
                }
                else if ( (((validateSoftKeyword("length")))) ) {
                    alt6=7;
                }
                else if ( (((validateSoftKeyword("locate")))) ) {
                    alt6=8;
                }
                else if ( (((validateSoftKeyword("abs")))) ) {
                    alt6=9;
                }
                else if ( (((validateSoftKeyword("sqrt")))) ) {
                    alt6=10;
                }
                else if ( (((validateSoftKeyword("mod")))) ) {
                    alt6=11;
                }
                else if ( (((validateSoftKeyword("current_date")))) ) {
                    alt6=12;
                }
                else if ( (((validateSoftKeyword("current_time")))) ) {
                    alt6=13;
                }
                else if ( (((validateSoftKeyword("current_timestamp")))) ) {
                    alt6=14;
                }
                else if ( (((validateSoftKeyword("extract")))) ) {
                    alt6=15;
                }
                else if ( (((validateSoftKeyword("position")))) ) {
                    alt6=16;
                }
                else if ( (((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))) ) {
                    alt6=17;
                }
                else if ( (((validateSoftKeyword("octet_length")))) ) {
                    alt6=18;
                }
                else if ( (((validateSoftKeyword("bit_length")))) ) {
                    alt6=19;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 6, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }
            switch (alt6) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:205:4: castFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_castFunction_in_standardFunction545);
                    castFunction17=castFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, castFunction17.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:206:4: concatFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_concatFunction_in_standardFunction550);
                    concatFunction18=concatFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, concatFunction18.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:207:4: substringFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_substringFunction_in_standardFunction555);
                    substringFunction19=substringFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, substringFunction19.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:208:4: trimFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_trimFunction_in_standardFunction560);
                    trimFunction20=trimFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, trimFunction20.getTree());

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:209:4: upperFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_upperFunction_in_standardFunction565);
                    upperFunction21=upperFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, upperFunction21.getTree());

                    }
                    break;
                case 6 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:210:4: lowerFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lowerFunction_in_standardFunction570);
                    lowerFunction22=lowerFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, lowerFunction22.getTree());

                    }
                    break;
                case 7 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:211:4: lengthFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_lengthFunction_in_standardFunction575);
                    lengthFunction23=lengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, lengthFunction23.getTree());

                    }
                    break;
                case 8 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:212:4: locateFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_locateFunction_in_standardFunction580);
                    locateFunction24=locateFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, locateFunction24.getTree());

                    }
                    break;
                case 9 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:213:4: absFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_absFunction_in_standardFunction585);
                    absFunction25=absFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, absFunction25.getTree());

                    }
                    break;
                case 10 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:214:4: sqrtFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_sqrtFunction_in_standardFunction590);
                    sqrtFunction26=sqrtFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, sqrtFunction26.getTree());

                    }
                    break;
                case 11 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:215:4: modFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_modFunction_in_standardFunction595);
                    modFunction27=modFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, modFunction27.getTree());

                    }
                    break;
                case 12 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:216:4: currentDateFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_currentDateFunction_in_standardFunction600);
                    currentDateFunction28=currentDateFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, currentDateFunction28.getTree());

                    }
                    break;
                case 13 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:217:4: currentTimeFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_currentTimeFunction_in_standardFunction605);
                    currentTimeFunction29=currentTimeFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, currentTimeFunction29.getTree());

                    }
                    break;
                case 14 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:218:4: currentTimestampFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_currentTimestampFunction_in_standardFunction610);
                    currentTimestampFunction30=currentTimestampFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, currentTimestampFunction30.getTree());

                    }
                    break;
                case 15 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:219:4: extractFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_extractFunction_in_standardFunction615);
                    extractFunction31=extractFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, extractFunction31.getTree());

                    }
                    break;
                case 16 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:220:4: positionFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_positionFunction_in_standardFunction620);
                    positionFunction32=positionFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, positionFunction32.getTree());

                    }
                    break;
                case 17 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:221:4: charLengthFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_charLengthFunction_in_standardFunction625);
                    charLengthFunction33=charLengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, charLengthFunction33.getTree());

                    }
                    break;
                case 18 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:222:4: octetLengthFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_octetLengthFunction_in_standardFunction630);
                    octetLengthFunction34=octetLengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, octetLengthFunction34.getTree());

                    }
                    break;
                case 19 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:223:4: bitLengthFunction
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_bitLengthFunction_in_standardFunction635);
                    bitLengthFunction35=bitLengthFunction();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, bitLengthFunction35.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "standardFunction"


    public static class castFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "castFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:226:1: castFunction : cast_keyword LEFT_PAREN expression as_keyword dataType RIGHT_PAREN -> ^( cast_keyword expression dataType ) ;
    public final OrderByParser.castFunction_return castFunction() throws RecognitionException {
        OrderByParser.castFunction_return retval = new OrderByParser.castFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN37=null;
        CommonToken RIGHT_PAREN41=null;
        OrderByParser.cast_keyword_return cast_keyword36 =null;

        OrderByParser.expression_return expression38 =null;

        OrderByParser.as_keyword_return as_keyword39 =null;

        OrderByParser.dataType_return dataType40 =null;


        CommonTree LEFT_PAREN37_tree=null;
        CommonTree RIGHT_PAREN41_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_as_keyword=new RewriteRuleSubtreeStream(adaptor,"rule as_keyword");
        RewriteRuleSubtreeStream stream_dataType=new RewriteRuleSubtreeStream(adaptor,"rule dataType");
        RewriteRuleSubtreeStream stream_cast_keyword=new RewriteRuleSubtreeStream(adaptor,"rule cast_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:227:2: ( cast_keyword LEFT_PAREN expression as_keyword dataType RIGHT_PAREN -> ^( cast_keyword expression dataType ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:227:4: cast_keyword LEFT_PAREN expression as_keyword dataType RIGHT_PAREN
            {
            pushFollow(FOLLOW_cast_keyword_in_castFunction646);
            cast_keyword36=cast_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_cast_keyword.add(cast_keyword36.getTree());

            LEFT_PAREN37=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_castFunction648); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN37);


            pushFollow(FOLLOW_expression_in_castFunction650);
            expression38=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression38.getTree());

            pushFollow(FOLLOW_as_keyword_in_castFunction652);
            as_keyword39=as_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_as_keyword.add(as_keyword39.getTree());

            pushFollow(FOLLOW_dataType_in_castFunction654);
            dataType40=dataType();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_dataType.add(dataType40.getTree());

            RIGHT_PAREN41=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_castFunction656); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN41);


            // AST REWRITE
            // elements: expression, cast_keyword, dataType
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 228:6: -> ^( cast_keyword expression dataType )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:228:9: ^( cast_keyword expression dataType )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_cast_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_1, stream_dataType.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "castFunction"


    public static class dataType_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "dataType"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:232:1: fragment dataType : IDENTIFIER ;
    public final OrderByParser.dataType_return dataType() throws RecognitionException {
        OrderByParser.dataType_return retval = new OrderByParser.dataType_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken IDENTIFIER42=null;

        CommonTree IDENTIFIER42_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:233:2: ( IDENTIFIER )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:233:4: IDENTIFIER
            {
            root_0 = (CommonTree)adaptor.nil();


            IDENTIFIER42=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_dataType686); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER42_tree = 
            (CommonTree)adaptor.create(IDENTIFIER42)
            ;
            adaptor.addChild(root_0, IDENTIFIER42_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "dataType"


    public static class concatFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concatFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:236:1: concatFunction : concat_keyword LEFT_PAREN expression ( COMMA expression )+ RIGHT_PAREN -> ^( concat_keyword ( expression )+ ) ;
    public final OrderByParser.concatFunction_return concatFunction() throws RecognitionException {
        OrderByParser.concatFunction_return retval = new OrderByParser.concatFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN44=null;
        CommonToken COMMA46=null;
        CommonToken RIGHT_PAREN48=null;
        OrderByParser.concat_keyword_return concat_keyword43 =null;

        OrderByParser.expression_return expression45 =null;

        OrderByParser.expression_return expression47 =null;


        CommonTree LEFT_PAREN44_tree=null;
        CommonTree COMMA46_tree=null;
        CommonTree RIGHT_PAREN48_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_concat_keyword=new RewriteRuleSubtreeStream(adaptor,"rule concat_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:237:2: ( concat_keyword LEFT_PAREN expression ( COMMA expression )+ RIGHT_PAREN -> ^( concat_keyword ( expression )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:237:4: concat_keyword LEFT_PAREN expression ( COMMA expression )+ RIGHT_PAREN
            {
            pushFollow(FOLLOW_concat_keyword_in_concatFunction697);
            concat_keyword43=concat_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_concat_keyword.add(concat_keyword43.getTree());

            LEFT_PAREN44=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_concatFunction699); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN44);


            pushFollow(FOLLOW_expression_in_concatFunction701);
            expression45=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression45.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:237:41: ( COMMA expression )+
            int cnt7=0;
            loop7:
            do {
                int alt7=2;
                int LA7_0 = input.LA(1);

                if ( (LA7_0==COMMA) ) {
                    alt7=1;
                }


                switch (alt7) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:237:43: COMMA expression
            	    {
            	    COMMA46=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_concatFunction705); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA46);


            	    pushFollow(FOLLOW_expression_in_concatFunction707);
            	    expression47=expression();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_expression.add(expression47.getTree());

            	    }
            	    break;

            	default :
            	    if ( cnt7 >= 1 ) break loop7;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(7, input);
                        throw eee;
                }
                cnt7++;
            } while (true);


            RIGHT_PAREN48=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_concatFunction712); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN48);


            // AST REWRITE
            // elements: concat_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 238:6: -> ^( concat_keyword ( expression )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:238:9: ^( concat_keyword ( expression )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_concat_keyword.nextNode(), root_1);

                if ( !(stream_expression.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_expression.hasNext() ) {
                    adaptor.addChild(root_1, stream_expression.nextTree());

                }
                stream_expression.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concatFunction"


    public static class substringFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substringFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:241:1: substringFunction : substring_keyword LEFT_PAREN expression COMMA expression ( COMMA expression )? RIGHT_PAREN -> ^( substring_keyword ( expression )+ ) ;
    public final OrderByParser.substringFunction_return substringFunction() throws RecognitionException {
        OrderByParser.substringFunction_return retval = new OrderByParser.substringFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN50=null;
        CommonToken COMMA52=null;
        CommonToken COMMA54=null;
        CommonToken RIGHT_PAREN56=null;
        OrderByParser.substring_keyword_return substring_keyword49 =null;

        OrderByParser.expression_return expression51 =null;

        OrderByParser.expression_return expression53 =null;

        OrderByParser.expression_return expression55 =null;


        CommonTree LEFT_PAREN50_tree=null;
        CommonTree COMMA52_tree=null;
        CommonTree COMMA54_tree=null;
        CommonTree RIGHT_PAREN56_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_substring_keyword=new RewriteRuleSubtreeStream(adaptor,"rule substring_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:242:2: ( substring_keyword LEFT_PAREN expression COMMA expression ( COMMA expression )? RIGHT_PAREN -> ^( substring_keyword ( expression )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:242:4: substring_keyword LEFT_PAREN expression COMMA expression ( COMMA expression )? RIGHT_PAREN
            {
            pushFollow(FOLLOW_substring_keyword_in_substringFunction739);
            substring_keyword49=substring_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_substring_keyword.add(substring_keyword49.getTree());

            LEFT_PAREN50=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_substringFunction741); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN50);


            pushFollow(FOLLOW_expression_in_substringFunction743);
            expression51=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression51.getTree());

            COMMA52=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_substringFunction745); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_COMMA.add(COMMA52);


            pushFollow(FOLLOW_expression_in_substringFunction747);
            expression53=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression53.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:242:61: ( COMMA expression )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==COMMA) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:242:63: COMMA expression
                    {
                    COMMA54=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_substringFunction751); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_COMMA.add(COMMA54);


                    pushFollow(FOLLOW_expression_in_substringFunction753);
                    expression55=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression55.getTree());

                    }
                    break;

            }


            RIGHT_PAREN56=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_substringFunction757); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN56);


            // AST REWRITE
            // elements: substring_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 243:6: -> ^( substring_keyword ( expression )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:243:9: ^( substring_keyword ( expression )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_substring_keyword.nextNode(), root_1);

                if ( !(stream_expression.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_expression.hasNext() ) {
                    adaptor.addChild(root_1, stream_expression.nextTree());

                }
                stream_expression.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substringFunction"


    public static class trimFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:246:1: trimFunction : trim_keyword LEFT_PAREN trimOperands RIGHT_PAREN -> ^( trim_keyword trimOperands ) ;
    public final OrderByParser.trimFunction_return trimFunction() throws RecognitionException {
        OrderByParser.trimFunction_return retval = new OrderByParser.trimFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN58=null;
        CommonToken RIGHT_PAREN60=null;
        OrderByParser.trim_keyword_return trim_keyword57 =null;

        OrderByParser.trimOperands_return trimOperands59 =null;


        CommonTree LEFT_PAREN58_tree=null;
        CommonTree RIGHT_PAREN60_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_trim_keyword=new RewriteRuleSubtreeStream(adaptor,"rule trim_keyword");
        RewriteRuleSubtreeStream stream_trimOperands=new RewriteRuleSubtreeStream(adaptor,"rule trimOperands");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:248:2: ( trim_keyword LEFT_PAREN trimOperands RIGHT_PAREN -> ^( trim_keyword trimOperands ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:248:4: trim_keyword LEFT_PAREN trimOperands RIGHT_PAREN
            {
            pushFollow(FOLLOW_trim_keyword_in_trimFunction789);
            trim_keyword57=trim_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_trim_keyword.add(trim_keyword57.getTree());

            LEFT_PAREN58=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_trimFunction791); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN58);


            pushFollow(FOLLOW_trimOperands_in_trimFunction793);
            trimOperands59=trimOperands();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_trimOperands.add(trimOperands59.getTree());

            RIGHT_PAREN60=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_trimFunction795); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN60);


            // AST REWRITE
            // elements: trimOperands, trim_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 249:6: -> ^( trim_keyword trimOperands )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:249:9: ^( trim_keyword trimOperands )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_trim_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_trimOperands.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimFunction"


    public static class trimOperands_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimOperands"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:253:1: fragment trimOperands options {k=2; } : ( trimSpecification from_keyword expression -> ^( trimSpecification STRING_LITERAL[\"' '\"] expression ) | trimSpecification expression from_keyword expression -> ^( trimSpecification ( expression )+ ) | from_keyword expression -> ^( BOTH STRING_LITERAL[\"' '\"] expression ) |cn= expression ( from_keyword expression )? -> {hasSecondExpression}? ^( BOTH ( expression )+ ) -> ^( BOTH STRING_LITERAL[\"' '\"] $cn) );
    public final OrderByParser.trimOperands_return trimOperands() throws RecognitionException {
        OrderByParser.trimOperands_return retval = new OrderByParser.trimOperands_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.expression_return cn =null;

        OrderByParser.trimSpecification_return trimSpecification61 =null;

        OrderByParser.from_keyword_return from_keyword62 =null;

        OrderByParser.expression_return expression63 =null;

        OrderByParser.trimSpecification_return trimSpecification64 =null;

        OrderByParser.expression_return expression65 =null;

        OrderByParser.from_keyword_return from_keyword66 =null;

        OrderByParser.expression_return expression67 =null;

        OrderByParser.from_keyword_return from_keyword68 =null;

        OrderByParser.expression_return expression69 =null;

        OrderByParser.from_keyword_return from_keyword70 =null;

        OrderByParser.expression_return expression71 =null;


        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_from_keyword=new RewriteRuleSubtreeStream(adaptor,"rule from_keyword");
        RewriteRuleSubtreeStream stream_trimSpecification=new RewriteRuleSubtreeStream(adaptor,"rule trimSpecification");
        boolean hasSecondExpression = false;
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:258:2: ( trimSpecification from_keyword expression -> ^( trimSpecification STRING_LITERAL[\"' '\"] expression ) | trimSpecification expression from_keyword expression -> ^( trimSpecification ( expression )+ ) | from_keyword expression -> ^( BOTH STRING_LITERAL[\"' '\"] expression ) |cn= expression ( from_keyword expression )? -> {hasSecondExpression}? ^( BOTH ( expression )+ ) -> ^( BOTH STRING_LITERAL[\"' '\"] $cn) )
            int alt10=4;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==IDENTIFIER) ) {
                int LA10_1 = input.LA(2);

                if ( (LA10_1==IDENTIFIER) ) {
                    int LA10_8 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=1;
                    }
                    else if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else if ( (true) ) {
                        alt10=4;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 8, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==QUOTED_IDENTIFIER) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA10_9 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 9, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==DECIMAL_LITERAL||LA10_1==FLOATING_POINT_LITERAL||LA10_1==INTEGER_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA10_10 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 10, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==HEX_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA10_11 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 11, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==OCTAL_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA10_12 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 12, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==CHARACTER_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA10_13 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 13, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==STRING_LITERAL) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))||((validateSoftKeyword("from")))))) {
                    int LA10_14 = input.LA(3);

                    if ( ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading"))))) ) {
                        alt10=2;
                    }
                    else if ( (((validateSoftKeyword("from")))) ) {
                        alt10=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 10, 14, input);

                        throw nvae;

                    }
                }
                else if ( (LA10_1==LEFT_PAREN) && ((((validateSoftKeyword("substring")))||((validateSoftKeyword("current_time")))||((validateSoftKeyword("concat")))||((validateSoftKeyword("octet_length")))||((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))||((validateSoftKeyword("upper")))||((validateSoftKeyword("mod")))||((validateSoftKeyword("abs")))||((validateSoftKeyword("extract")))||((validateSoftKeyword("locate")))||((validateSoftKeyword("trim")))||((validateSoftKeyword("length")))||((validateSoftKeyword("cast")))||((validateSoftKeyword("bit_length")))||((validateSoftKeyword("lower")))||((validateSoftKeyword("position")))||((validateSoftKeyword("current_timestamp")))||((validateSoftKeyword("sqrt")))||((validateSoftKeyword("current_date")))))) {
                    alt10=4;
                }
                else if ( (LA10_1==DOT||LA10_1==RIGHT_PAREN) ) {
                    alt10=4;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 10, 1, input);

                    throw nvae;

                }
            }
            else if ( (LA10_0==CHARACTER_LITERAL||LA10_0==DECIMAL_LITERAL||LA10_0==FLOATING_POINT_LITERAL||LA10_0==HEX_LITERAL||LA10_0==INTEGER_LITERAL||LA10_0==OCTAL_LITERAL||LA10_0==QUOTED_IDENTIFIER||LA10_0==STRING_LITERAL) ) {
                alt10=4;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 10, 0, input);

                throw nvae;

            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:258:4: trimSpecification from_keyword expression
                    {
                    pushFollow(FOLLOW_trimSpecification_in_trimOperands837);
                    trimSpecification61=trimSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_trimSpecification.add(trimSpecification61.getTree());

                    pushFollow(FOLLOW_from_keyword_in_trimOperands839);
                    from_keyword62=from_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_keyword.add(from_keyword62.getTree());

                    pushFollow(FOLLOW_expression_in_trimOperands841);
                    expression63=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression63.getTree());

                    // AST REWRITE
                    // elements: trimSpecification, expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 259:6: -> ^( trimSpecification STRING_LITERAL[\"' '\"] expression )
                    {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:259:9: ^( trimSpecification STRING_LITERAL[\"' '\"] expression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_trimSpecification.nextNode(), root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(STRING_LITERAL, "' '")
                        );

                        adaptor.addChild(root_1, stream_expression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:260:4: trimSpecification expression from_keyword expression
                    {
                    pushFollow(FOLLOW_trimSpecification_in_trimOperands863);
                    trimSpecification64=trimSpecification();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_trimSpecification.add(trimSpecification64.getTree());

                    pushFollow(FOLLOW_expression_in_trimOperands865);
                    expression65=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression65.getTree());

                    pushFollow(FOLLOW_from_keyword_in_trimOperands867);
                    from_keyword66=from_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_keyword.add(from_keyword66.getTree());

                    pushFollow(FOLLOW_expression_in_trimOperands869);
                    expression67=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression67.getTree());

                    // AST REWRITE
                    // elements: trimSpecification, expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 261:6: -> ^( trimSpecification ( expression )+ )
                    {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:261:9: ^( trimSpecification ( expression )+ )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(stream_trimSpecification.nextNode(), root_1);

                        if ( !(stream_expression.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_expression.hasNext() ) {
                            adaptor.addChild(root_1, stream_expression.nextTree());

                        }
                        stream_expression.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:262:4: from_keyword expression
                    {
                    pushFollow(FOLLOW_from_keyword_in_trimOperands888);
                    from_keyword68=from_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_from_keyword.add(from_keyword68.getTree());

                    pushFollow(FOLLOW_expression_in_trimOperands890);
                    expression69=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression69.getTree());

                    // AST REWRITE
                    // elements: expression
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 263:6: -> ^( BOTH STRING_LITERAL[\"' '\"] expression )
                    {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:263:9: ^( BOTH STRING_LITERAL[\"' '\"] expression )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(BOTH, "BOTH")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(STRING_LITERAL, "' '")
                        );

                        adaptor.addChild(root_1, stream_expression.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:264:4: cn= expression ( from_keyword expression )?
                    {
                    pushFollow(FOLLOW_expression_in_trimOperands913);
                    cn=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(cn.getTree());

                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:264:18: ( from_keyword expression )?
                    int alt9=2;
                    int LA9_0 = input.LA(1);

                    if ( (LA9_0==IDENTIFIER) && (((validateSoftKeyword("from"))))) {
                        alt9=1;
                    }
                    switch (alt9) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:264:20: from_keyword expression
                            {
                            pushFollow(FOLLOW_from_keyword_in_trimOperands917);
                            from_keyword70=from_keyword();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_from_keyword.add(from_keyword70.getTree());

                            pushFollow(FOLLOW_expression_in_trimOperands919);
                            expression71=expression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) stream_expression.add(expression71.getTree());

                            if ( state.backtracking==0 ) {hasSecondExpression = true;}

                            }
                            break;

                    }


                    // AST REWRITE
                    // elements: expression, cn
                    // token labels: 
                    // rule labels: retval, cn
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);
                    RewriteRuleSubtreeStream stream_cn=new RewriteRuleSubtreeStream(adaptor,"rule cn",cn!=null?cn.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 265:6: -> {hasSecondExpression}? ^( BOTH ( expression )+ )
                    if (hasSecondExpression) {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:265:32: ^( BOTH ( expression )+ )
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(BOTH, "BOTH")
                        , root_1);

                        if ( !(stream_expression.hasNext()) ) {
                            throw new RewriteEarlyExitException();
                        }
                        while ( stream_expression.hasNext() ) {
                            adaptor.addChild(root_1, stream_expression.nextTree());

                        }
                        stream_expression.reset();

                        adaptor.addChild(root_0, root_1);
                        }

                    }

                    else // 266:3: -> ^( BOTH STRING_LITERAL[\"' '\"] $cn)
                    {
                        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:266:6: ^( BOTH STRING_LITERAL[\"' '\"] $cn)
                        {
                        CommonTree root_1 = (CommonTree)adaptor.nil();
                        root_1 = (CommonTree)adaptor.becomeRoot(
                        (CommonTree)adaptor.create(BOTH, "BOTH")
                        , root_1);

                        adaptor.addChild(root_1, 
                        (CommonTree)adaptor.create(STRING_LITERAL, "' '")
                        );

                        adaptor.addChild(root_1, stream_cn.nextTree());

                        adaptor.addChild(root_0, root_1);
                        }

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimOperands"


    public static class trimSpecification_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trimSpecification"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:270:1: fragment trimSpecification : ( leading_keyword | trailing_keyword | both_keyword );
    public final OrderByParser.trimSpecification_return trimSpecification() throws RecognitionException {
        OrderByParser.trimSpecification_return retval = new OrderByParser.trimSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.leading_keyword_return leading_keyword72 =null;

        OrderByParser.trailing_keyword_return trailing_keyword73 =null;

        OrderByParser.both_keyword_return both_keyword74 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:271:2: ( leading_keyword | trailing_keyword | both_keyword )
            int alt11=3;
            int LA11_0 = input.LA(1);

            if ( (LA11_0==IDENTIFIER) && ((((validateSoftKeyword("trailing")))||((validateSoftKeyword("both")))||((validateSoftKeyword("leading")))))) {
                int LA11_1 = input.LA(2);

                if ( (((validateSoftKeyword("leading")))) ) {
                    alt11=1;
                }
                else if ( (((validateSoftKeyword("trailing")))) ) {
                    alt11=2;
                }
                else if ( (((validateSoftKeyword("both")))) ) {
                    alt11=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 11, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 11, 0, input);

                throw nvae;

            }
            switch (alt11) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:271:4: leading_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_leading_keyword_in_trimSpecification967);
                    leading_keyword72=leading_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, leading_keyword72.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:272:4: trailing_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_trailing_keyword_in_trimSpecification972);
                    trailing_keyword73=trailing_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, trailing_keyword73.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:273:4: both_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_both_keyword_in_trimSpecification977);
                    both_keyword74=both_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, both_keyword74.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trimSpecification"


    public static class upperFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upperFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:276:1: upperFunction : upper_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( upper_keyword expression ) ;
    public final OrderByParser.upperFunction_return upperFunction() throws RecognitionException {
        OrderByParser.upperFunction_return retval = new OrderByParser.upperFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN76=null;
        CommonToken RIGHT_PAREN78=null;
        OrderByParser.upper_keyword_return upper_keyword75 =null;

        OrderByParser.expression_return expression77 =null;


        CommonTree LEFT_PAREN76_tree=null;
        CommonTree RIGHT_PAREN78_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_upper_keyword=new RewriteRuleSubtreeStream(adaptor,"rule upper_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:277:2: ( upper_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( upper_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:277:4: upper_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_upper_keyword_in_upperFunction988);
            upper_keyword75=upper_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_upper_keyword.add(upper_keyword75.getTree());

            LEFT_PAREN76=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_upperFunction990); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN76);


            pushFollow(FOLLOW_expression_in_upperFunction992);
            expression77=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression77.getTree());

            RIGHT_PAREN78=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_upperFunction994); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN78);


            // AST REWRITE
            // elements: expression, upper_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 278:6: -> ^( upper_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:278:9: ^( upper_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_upper_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upperFunction"


    public static class lowerFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lowerFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:281:1: lowerFunction : lower_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( lower_keyword expression ) ;
    public final OrderByParser.lowerFunction_return lowerFunction() throws RecognitionException {
        OrderByParser.lowerFunction_return retval = new OrderByParser.lowerFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN80=null;
        CommonToken RIGHT_PAREN82=null;
        OrderByParser.lower_keyword_return lower_keyword79 =null;

        OrderByParser.expression_return expression81 =null;


        CommonTree LEFT_PAREN80_tree=null;
        CommonTree RIGHT_PAREN82_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_lower_keyword=new RewriteRuleSubtreeStream(adaptor,"rule lower_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:282:2: ( lower_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( lower_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:282:4: lower_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_lower_keyword_in_lowerFunction1020);
            lower_keyword79=lower_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_lower_keyword.add(lower_keyword79.getTree());

            LEFT_PAREN80=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_lowerFunction1022); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN80);


            pushFollow(FOLLOW_expression_in_lowerFunction1024);
            expression81=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression81.getTree());

            RIGHT_PAREN82=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_lowerFunction1026); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN82);


            // AST REWRITE
            // elements: expression, lower_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 283:6: -> ^( lower_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:283:9: ^( lower_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_lower_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lowerFunction"


    public static class lengthFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lengthFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:286:1: lengthFunction : length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( length_keyword expression ) ;
    public final OrderByParser.lengthFunction_return lengthFunction() throws RecognitionException {
        OrderByParser.lengthFunction_return retval = new OrderByParser.lengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN84=null;
        CommonToken RIGHT_PAREN86=null;
        OrderByParser.length_keyword_return length_keyword83 =null;

        OrderByParser.expression_return expression85 =null;


        CommonTree LEFT_PAREN84_tree=null;
        CommonTree RIGHT_PAREN86_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_length_keyword=new RewriteRuleSubtreeStream(adaptor,"rule length_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:287:2: ( length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( length_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:287:4: length_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_length_keyword_in_lengthFunction1052);
            length_keyword83=length_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_length_keyword.add(length_keyword83.getTree());

            LEFT_PAREN84=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_lengthFunction1054); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN84);


            pushFollow(FOLLOW_expression_in_lengthFunction1056);
            expression85=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression85.getTree());

            RIGHT_PAREN86=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_lengthFunction1058); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN86);


            // AST REWRITE
            // elements: length_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 288:6: -> ^( length_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:288:9: ^( length_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_length_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lengthFunction"


    public static class locateFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:291:1: locateFunction : locate_keyword LEFT_PAREN expression COMMA expression ( COMMA expression )? RIGHT_PAREN -> ^( locate_keyword ( expression )+ ) ;
    public final OrderByParser.locateFunction_return locateFunction() throws RecognitionException {
        OrderByParser.locateFunction_return retval = new OrderByParser.locateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN88=null;
        CommonToken COMMA90=null;
        CommonToken COMMA92=null;
        CommonToken RIGHT_PAREN94=null;
        OrderByParser.locate_keyword_return locate_keyword87 =null;

        OrderByParser.expression_return expression89 =null;

        OrderByParser.expression_return expression91 =null;

        OrderByParser.expression_return expression93 =null;


        CommonTree LEFT_PAREN88_tree=null;
        CommonTree COMMA90_tree=null;
        CommonTree COMMA92_tree=null;
        CommonTree RIGHT_PAREN94_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_locate_keyword=new RewriteRuleSubtreeStream(adaptor,"rule locate_keyword");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:292:2: ( locate_keyword LEFT_PAREN expression COMMA expression ( COMMA expression )? RIGHT_PAREN -> ^( locate_keyword ( expression )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:292:4: locate_keyword LEFT_PAREN expression COMMA expression ( COMMA expression )? RIGHT_PAREN
            {
            pushFollow(FOLLOW_locate_keyword_in_locateFunction1084);
            locate_keyword87=locate_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_locate_keyword.add(locate_keyword87.getTree());

            LEFT_PAREN88=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_locateFunction1086); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN88);


            pushFollow(FOLLOW_expression_in_locateFunction1088);
            expression89=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression89.getTree());

            COMMA90=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_locateFunction1090); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_COMMA.add(COMMA90);


            pushFollow(FOLLOW_expression_in_locateFunction1092);
            expression91=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression91.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:292:58: ( COMMA expression )?
            int alt12=2;
            int LA12_0 = input.LA(1);

            if ( (LA12_0==COMMA) ) {
                alt12=1;
            }
            switch (alt12) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:292:60: COMMA expression
                    {
                    COMMA92=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_locateFunction1096); if (state.failed) return retval; 
                    if ( state.backtracking==0 ) stream_COMMA.add(COMMA92);


                    pushFollow(FOLLOW_expression_in_locateFunction1098);
                    expression93=expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_expression.add(expression93.getTree());

                    }
                    break;

            }


            RIGHT_PAREN94=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_locateFunction1103); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN94);


            // AST REWRITE
            // elements: locate_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 293:6: -> ^( locate_keyword ( expression )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:293:9: ^( locate_keyword ( expression )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_locate_keyword.nextNode(), root_1);

                if ( !(stream_expression.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_expression.hasNext() ) {
                    adaptor.addChild(root_1, stream_expression.nextTree());

                }
                stream_expression.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateFunction"


    public static class absFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "absFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:296:1: absFunction : abs_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( abs_keyword expression ) ;
    public final OrderByParser.absFunction_return absFunction() throws RecognitionException {
        OrderByParser.absFunction_return retval = new OrderByParser.absFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN96=null;
        CommonToken RIGHT_PAREN98=null;
        OrderByParser.abs_keyword_return abs_keyword95 =null;

        OrderByParser.expression_return expression97 =null;


        CommonTree LEFT_PAREN96_tree=null;
        CommonTree RIGHT_PAREN98_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_abs_keyword=new RewriteRuleSubtreeStream(adaptor,"rule abs_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:297:2: ( abs_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( abs_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:297:4: abs_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_abs_keyword_in_absFunction1130);
            abs_keyword95=abs_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_abs_keyword.add(abs_keyword95.getTree());

            LEFT_PAREN96=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_absFunction1132); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN96);


            pushFollow(FOLLOW_expression_in_absFunction1134);
            expression97=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression97.getTree());

            RIGHT_PAREN98=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_absFunction1136); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN98);


            // AST REWRITE
            // elements: expression, abs_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 298:6: -> ^( abs_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:298:9: ^( abs_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_abs_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "absFunction"


    public static class sqrtFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrtFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:301:1: sqrtFunction : sqrt_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( sqrt_keyword expression ) ;
    public final OrderByParser.sqrtFunction_return sqrtFunction() throws RecognitionException {
        OrderByParser.sqrtFunction_return retval = new OrderByParser.sqrtFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN100=null;
        CommonToken RIGHT_PAREN102=null;
        OrderByParser.sqrt_keyword_return sqrt_keyword99 =null;

        OrderByParser.expression_return expression101 =null;


        CommonTree LEFT_PAREN100_tree=null;
        CommonTree RIGHT_PAREN102_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_sqrt_keyword=new RewriteRuleSubtreeStream(adaptor,"rule sqrt_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:302:2: ( sqrt_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( sqrt_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:302:4: sqrt_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_sqrt_keyword_in_sqrtFunction1162);
            sqrt_keyword99=sqrt_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_sqrt_keyword.add(sqrt_keyword99.getTree());

            LEFT_PAREN100=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_sqrtFunction1164); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN100);


            pushFollow(FOLLOW_expression_in_sqrtFunction1166);
            expression101=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression101.getTree());

            RIGHT_PAREN102=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_sqrtFunction1168); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN102);


            // AST REWRITE
            // elements: expression, sqrt_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 303:6: -> ^( sqrt_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:303:9: ^( sqrt_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_sqrt_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrtFunction"


    public static class modFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "modFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:306:1: modFunction : mod_keyword LEFT_PAREN expression COMMA expression RIGHT_PAREN -> ^( mod_keyword ( expression )+ ) ;
    public final OrderByParser.modFunction_return modFunction() throws RecognitionException {
        OrderByParser.modFunction_return retval = new OrderByParser.modFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN104=null;
        CommonToken COMMA106=null;
        CommonToken RIGHT_PAREN108=null;
        OrderByParser.mod_keyword_return mod_keyword103 =null;

        OrderByParser.expression_return expression105 =null;

        OrderByParser.expression_return expression107 =null;


        CommonTree LEFT_PAREN104_tree=null;
        CommonTree COMMA106_tree=null;
        CommonTree RIGHT_PAREN108_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_mod_keyword=new RewriteRuleSubtreeStream(adaptor,"rule mod_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:307:2: ( mod_keyword LEFT_PAREN expression COMMA expression RIGHT_PAREN -> ^( mod_keyword ( expression )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:307:4: mod_keyword LEFT_PAREN expression COMMA expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_mod_keyword_in_modFunction1194);
            mod_keyword103=mod_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_mod_keyword.add(mod_keyword103.getTree());

            LEFT_PAREN104=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_modFunction1196); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN104);


            pushFollow(FOLLOW_expression_in_modFunction1198);
            expression105=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression105.getTree());

            COMMA106=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_modFunction1200); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_COMMA.add(COMMA106);


            pushFollow(FOLLOW_expression_in_modFunction1202);
            expression107=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression107.getTree());

            RIGHT_PAREN108=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_modFunction1204); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN108);


            // AST REWRITE
            // elements: expression, mod_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 308:6: -> ^( mod_keyword ( expression )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:308:9: ^( mod_keyword ( expression )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_mod_keyword.nextNode(), root_1);

                if ( !(stream_expression.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_expression.hasNext() ) {
                    adaptor.addChild(root_1, stream_expression.nextTree());

                }
                stream_expression.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "modFunction"


    public static class currentDateFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentDateFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:311:1: currentDateFunction : current_date_keyword ( LEFT_PAREN ! RIGHT_PAREN !)? ;
    public final OrderByParser.currentDateFunction_return currentDateFunction() throws RecognitionException {
        OrderByParser.currentDateFunction_return retval = new OrderByParser.currentDateFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN110=null;
        CommonToken RIGHT_PAREN111=null;
        OrderByParser.current_date_keyword_return current_date_keyword109 =null;


        CommonTree LEFT_PAREN110_tree=null;
        CommonTree RIGHT_PAREN111_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:312:2: ( current_date_keyword ( LEFT_PAREN ! RIGHT_PAREN !)? )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:312:4: current_date_keyword ( LEFT_PAREN ! RIGHT_PAREN !)?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_current_date_keyword_in_currentDateFunction1231);
            current_date_keyword109=current_date_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, current_date_keyword109.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:312:25: ( LEFT_PAREN ! RIGHT_PAREN !)?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==LEFT_PAREN) ) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:312:27: LEFT_PAREN ! RIGHT_PAREN !
                    {
                    LEFT_PAREN110=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_currentDateFunction1235); if (state.failed) return retval;

                    RIGHT_PAREN111=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_currentDateFunction1238); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentDateFunction"


    public static class currentTimeFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimeFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:315:1: currentTimeFunction : current_time_keyword ( LEFT_PAREN ! RIGHT_PAREN !)? ;
    public final OrderByParser.currentTimeFunction_return currentTimeFunction() throws RecognitionException {
        OrderByParser.currentTimeFunction_return retval = new OrderByParser.currentTimeFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN113=null;
        CommonToken RIGHT_PAREN114=null;
        OrderByParser.current_time_keyword_return current_time_keyword112 =null;


        CommonTree LEFT_PAREN113_tree=null;
        CommonTree RIGHT_PAREN114_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:316:2: ( current_time_keyword ( LEFT_PAREN ! RIGHT_PAREN !)? )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:316:4: current_time_keyword ( LEFT_PAREN ! RIGHT_PAREN !)?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_current_time_keyword_in_currentTimeFunction1253);
            current_time_keyword112=current_time_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, current_time_keyword112.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:316:25: ( LEFT_PAREN ! RIGHT_PAREN !)?
            int alt14=2;
            int LA14_0 = input.LA(1);

            if ( (LA14_0==LEFT_PAREN) ) {
                alt14=1;
            }
            switch (alt14) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:316:27: LEFT_PAREN ! RIGHT_PAREN !
                    {
                    LEFT_PAREN113=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_currentTimeFunction1257); if (state.failed) return retval;

                    RIGHT_PAREN114=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_currentTimeFunction1260); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimeFunction"


    public static class currentTimestampFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "currentTimestampFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:319:1: currentTimestampFunction : current_timestamp_keyword ( LEFT_PAREN ! RIGHT_PAREN !)? ;
    public final OrderByParser.currentTimestampFunction_return currentTimestampFunction() throws RecognitionException {
        OrderByParser.currentTimestampFunction_return retval = new OrderByParser.currentTimestampFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN116=null;
        CommonToken RIGHT_PAREN117=null;
        OrderByParser.current_timestamp_keyword_return current_timestamp_keyword115 =null;


        CommonTree LEFT_PAREN116_tree=null;
        CommonTree RIGHT_PAREN117_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:320:2: ( current_timestamp_keyword ( LEFT_PAREN ! RIGHT_PAREN !)? )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:320:4: current_timestamp_keyword ( LEFT_PAREN ! RIGHT_PAREN !)?
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_current_timestamp_keyword_in_currentTimestampFunction1275);
            current_timestamp_keyword115=current_timestamp_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, current_timestamp_keyword115.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:320:30: ( LEFT_PAREN ! RIGHT_PAREN !)?
            int alt15=2;
            int LA15_0 = input.LA(1);

            if ( (LA15_0==LEFT_PAREN) ) {
                alt15=1;
            }
            switch (alt15) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:320:32: LEFT_PAREN ! RIGHT_PAREN !
                    {
                    LEFT_PAREN116=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_currentTimestampFunction1279); if (state.failed) return retval;

                    RIGHT_PAREN117=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_currentTimestampFunction1282); if (state.failed) return retval;

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "currentTimestampFunction"


    public static class extractFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:323:1: extractFunction : extract_keyword LEFT_PAREN extractField from_keyword expression RIGHT_PAREN -> ^( extract_keyword extractField expression ) ;
    public final OrderByParser.extractFunction_return extractFunction() throws RecognitionException {
        OrderByParser.extractFunction_return retval = new OrderByParser.extractFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN119=null;
        CommonToken RIGHT_PAREN123=null;
        OrderByParser.extract_keyword_return extract_keyword118 =null;

        OrderByParser.extractField_return extractField120 =null;

        OrderByParser.from_keyword_return from_keyword121 =null;

        OrderByParser.expression_return expression122 =null;


        CommonTree LEFT_PAREN119_tree=null;
        CommonTree RIGHT_PAREN123_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_extractField=new RewriteRuleSubtreeStream(adaptor,"rule extractField");
        RewriteRuleSubtreeStream stream_from_keyword=new RewriteRuleSubtreeStream(adaptor,"rule from_keyword");
        RewriteRuleSubtreeStream stream_extract_keyword=new RewriteRuleSubtreeStream(adaptor,"rule extract_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:324:2: ( extract_keyword LEFT_PAREN extractField from_keyword expression RIGHT_PAREN -> ^( extract_keyword extractField expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:324:4: extract_keyword LEFT_PAREN extractField from_keyword expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_extract_keyword_in_extractFunction1297);
            extract_keyword118=extract_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_extract_keyword.add(extract_keyword118.getTree());

            LEFT_PAREN119=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_extractFunction1299); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN119);


            pushFollow(FOLLOW_extractField_in_extractFunction1301);
            extractField120=extractField();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_extractField.add(extractField120.getTree());

            pushFollow(FOLLOW_from_keyword_in_extractFunction1303);
            from_keyword121=from_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_from_keyword.add(from_keyword121.getTree());

            pushFollow(FOLLOW_expression_in_extractFunction1305);
            expression122=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression122.getTree());

            RIGHT_PAREN123=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_extractFunction1307); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN123);


            // AST REWRITE
            // elements: extract_keyword, expression, extractField
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 325:6: -> ^( extract_keyword extractField expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:325:9: ^( extract_keyword extractField expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_extract_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_extractField.nextTree());

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractFunction"


    public static class extractField_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extractField"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:328:1: extractField : ( datetimeField | timeZoneField );
    public final OrderByParser.extractField_return extractField() throws RecognitionException {
        OrderByParser.extractField_return retval = new OrderByParser.extractField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.datetimeField_return datetimeField124 =null;

        OrderByParser.timeZoneField_return timeZoneField125 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:329:2: ( datetimeField | timeZoneField )
            int alt16=2;
            int LA16_0 = input.LA(1);

            if ( (LA16_0==IDENTIFIER) && ((((validateSoftKeyword("timezone_minute")))||((validateSoftKeyword("timezone_hour")))||((validateSoftKeyword("second")))||((validateSoftKeyword("year")))||((validateSoftKeyword("day")))||((validateSoftKeyword("minute")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("month")))))) {
                int LA16_1 = input.LA(2);

                if ( ((((validateSoftKeyword("second")))||((validateSoftKeyword("year")))||((validateSoftKeyword("day")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("month")))||((validateSoftKeyword("minute"))))) ) {
                    alt16=1;
                }
                else if ( ((((validateSoftKeyword("timezone_minute")))||((validateSoftKeyword("timezone_hour"))))) ) {
                    alt16=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 16, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 16, 0, input);

                throw nvae;

            }
            switch (alt16) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:329:4: datetimeField
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_datetimeField_in_extractField1335);
                    datetimeField124=datetimeField();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, datetimeField124.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:330:4: timeZoneField
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_timeZoneField_in_extractField1340);
                    timeZoneField125=timeZoneField();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, timeZoneField125.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extractField"


    public static class datetimeField_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "datetimeField"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:333:1: datetimeField : ( nonSecondDatetimeField | second_keyword );
    public final OrderByParser.datetimeField_return datetimeField() throws RecognitionException {
        OrderByParser.datetimeField_return retval = new OrderByParser.datetimeField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.nonSecondDatetimeField_return nonSecondDatetimeField126 =null;

        OrderByParser.second_keyword_return second_keyword127 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:334:2: ( nonSecondDatetimeField | second_keyword )
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( (LA17_0==IDENTIFIER) && ((((validateSoftKeyword("second")))||((validateSoftKeyword("day")))||((validateSoftKeyword("year")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("minute")))||((validateSoftKeyword("month")))))) {
                int LA17_1 = input.LA(2);

                if ( ((((validateSoftKeyword("day")))||((validateSoftKeyword("year")))||((validateSoftKeyword("minute")))||((validateSoftKeyword("month")))||((validateSoftKeyword("hour"))))) ) {
                    alt17=1;
                }
                else if ( (((validateSoftKeyword("second")))) ) {
                    alt17=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 17, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 17, 0, input);

                throw nvae;

            }
            switch (alt17) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:334:4: nonSecondDatetimeField
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_nonSecondDatetimeField_in_datetimeField1351);
                    nonSecondDatetimeField126=nonSecondDatetimeField();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, nonSecondDatetimeField126.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:335:4: second_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_second_keyword_in_datetimeField1356);
                    second_keyword127=second_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, second_keyword127.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "datetimeField"


    public static class nonSecondDatetimeField_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "nonSecondDatetimeField"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:338:1: nonSecondDatetimeField : ( year_keyword | month_keyword | day_keyword | hour_keyword | minute_keyword );
    public final OrderByParser.nonSecondDatetimeField_return nonSecondDatetimeField() throws RecognitionException {
        OrderByParser.nonSecondDatetimeField_return retval = new OrderByParser.nonSecondDatetimeField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.year_keyword_return year_keyword128 =null;

        OrderByParser.month_keyword_return month_keyword129 =null;

        OrderByParser.day_keyword_return day_keyword130 =null;

        OrderByParser.hour_keyword_return hour_keyword131 =null;

        OrderByParser.minute_keyword_return minute_keyword132 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:339:2: ( year_keyword | month_keyword | day_keyword | hour_keyword | minute_keyword )
            int alt18=5;
            int LA18_0 = input.LA(1);

            if ( (LA18_0==IDENTIFIER) && ((((validateSoftKeyword("year")))||((validateSoftKeyword("day")))||((validateSoftKeyword("hour")))||((validateSoftKeyword("month")))||((validateSoftKeyword("minute")))))) {
                int LA18_1 = input.LA(2);

                if ( (((validateSoftKeyword("year")))) ) {
                    alt18=1;
                }
                else if ( (((validateSoftKeyword("month")))) ) {
                    alt18=2;
                }
                else if ( (((validateSoftKeyword("day")))) ) {
                    alt18=3;
                }
                else if ( (((validateSoftKeyword("hour")))) ) {
                    alt18=4;
                }
                else if ( (((validateSoftKeyword("minute")))) ) {
                    alt18=5;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 18, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;

            }
            switch (alt18) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:339:4: year_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_year_keyword_in_nonSecondDatetimeField1367);
                    year_keyword128=year_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, year_keyword128.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:340:4: month_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_month_keyword_in_nonSecondDatetimeField1372);
                    month_keyword129=month_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, month_keyword129.getTree());

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:341:4: day_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_day_keyword_in_nonSecondDatetimeField1377);
                    day_keyword130=day_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, day_keyword130.getTree());

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:342:4: hour_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_hour_keyword_in_nonSecondDatetimeField1382);
                    hour_keyword131=hour_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, hour_keyword131.getTree());

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:343:4: minute_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_minute_keyword_in_nonSecondDatetimeField1387);
                    minute_keyword132=minute_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, minute_keyword132.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "nonSecondDatetimeField"


    public static class timeZoneField_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeZoneField"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:346:1: timeZoneField : ( timezone_hour_keyword | timezone_minute_keyword );
    public final OrderByParser.timeZoneField_return timeZoneField() throws RecognitionException {
        OrderByParser.timeZoneField_return retval = new OrderByParser.timeZoneField_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.timezone_hour_keyword_return timezone_hour_keyword133 =null;

        OrderByParser.timezone_minute_keyword_return timezone_minute_keyword134 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:347:2: ( timezone_hour_keyword | timezone_minute_keyword )
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0==IDENTIFIER) && ((((validateSoftKeyword("timezone_minute")))||((validateSoftKeyword("timezone_hour")))))) {
                int LA19_1 = input.LA(2);

                if ( (((validateSoftKeyword("timezone_hour")))) ) {
                    alt19=1;
                }
                else if ( (((validateSoftKeyword("timezone_minute")))) ) {
                    alt19=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 19, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;

            }
            switch (alt19) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:347:4: timezone_hour_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_timezone_hour_keyword_in_timeZoneField1398);
                    timezone_hour_keyword133=timezone_hour_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, timezone_hour_keyword133.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:348:4: timezone_minute_keyword
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_timezone_minute_keyword_in_timeZoneField1403);
                    timezone_minute_keyword134=timezone_minute_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, timezone_minute_keyword134.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeZoneField"


    public static class positionFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "positionFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:351:1: positionFunction : position_keyword LEFT_PAREN expression in_keyword expression RIGHT_PAREN -> ^( position_keyword ( expression )+ ) ;
    public final OrderByParser.positionFunction_return positionFunction() throws RecognitionException {
        OrderByParser.positionFunction_return retval = new OrderByParser.positionFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN136=null;
        CommonToken RIGHT_PAREN140=null;
        OrderByParser.position_keyword_return position_keyword135 =null;

        OrderByParser.expression_return expression137 =null;

        OrderByParser.in_keyword_return in_keyword138 =null;

        OrderByParser.expression_return expression139 =null;


        CommonTree LEFT_PAREN136_tree=null;
        CommonTree RIGHT_PAREN140_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_position_keyword=new RewriteRuleSubtreeStream(adaptor,"rule position_keyword");
        RewriteRuleSubtreeStream stream_in_keyword=new RewriteRuleSubtreeStream(adaptor,"rule in_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:352:2: ( position_keyword LEFT_PAREN expression in_keyword expression RIGHT_PAREN -> ^( position_keyword ( expression )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:352:4: position_keyword LEFT_PAREN expression in_keyword expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_position_keyword_in_positionFunction1414);
            position_keyword135=position_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_position_keyword.add(position_keyword135.getTree());

            LEFT_PAREN136=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_positionFunction1416); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN136);


            pushFollow(FOLLOW_expression_in_positionFunction1418);
            expression137=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression137.getTree());

            pushFollow(FOLLOW_in_keyword_in_positionFunction1420);
            in_keyword138=in_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_in_keyword.add(in_keyword138.getTree());

            pushFollow(FOLLOW_expression_in_positionFunction1422);
            expression139=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression139.getTree());

            RIGHT_PAREN140=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_positionFunction1424); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN140);


            // AST REWRITE
            // elements: position_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 353:6: -> ^( position_keyword ( expression )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:353:9: ^( position_keyword ( expression )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_position_keyword.nextNode(), root_1);

                if ( !(stream_expression.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_expression.hasNext() ) {
                    adaptor.addChild(root_1, stream_expression.nextTree());

                }
                stream_expression.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "positionFunction"


    public static class charLengthFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "charLengthFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:356:1: charLengthFunction : character_length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( character_length_keyword expression ) ;
    public final OrderByParser.charLengthFunction_return charLengthFunction() throws RecognitionException {
        OrderByParser.charLengthFunction_return retval = new OrderByParser.charLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN142=null;
        CommonToken RIGHT_PAREN144=null;
        OrderByParser.character_length_keyword_return character_length_keyword141 =null;

        OrderByParser.expression_return expression143 =null;


        CommonTree LEFT_PAREN142_tree=null;
        CommonTree RIGHT_PAREN144_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_character_length_keyword=new RewriteRuleSubtreeStream(adaptor,"rule character_length_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:357:2: ( character_length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( character_length_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:357:4: character_length_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_character_length_keyword_in_charLengthFunction1451);
            character_length_keyword141=character_length_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_character_length_keyword.add(character_length_keyword141.getTree());

            LEFT_PAREN142=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_charLengthFunction1453); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN142);


            pushFollow(FOLLOW_expression_in_charLengthFunction1455);
            expression143=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression143.getTree());

            RIGHT_PAREN144=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_charLengthFunction1457); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN144);


            // AST REWRITE
            // elements: expression, character_length_keyword
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 358:6: -> ^( character_length_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:358:9: ^( character_length_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_character_length_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "charLengthFunction"


    public static class octetLengthFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octetLengthFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:361:1: octetLengthFunction : octet_length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( octet_length_keyword expression ) ;
    public final OrderByParser.octetLengthFunction_return octetLengthFunction() throws RecognitionException {
        OrderByParser.octetLengthFunction_return retval = new OrderByParser.octetLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN146=null;
        CommonToken RIGHT_PAREN148=null;
        OrderByParser.octet_length_keyword_return octet_length_keyword145 =null;

        OrderByParser.expression_return expression147 =null;


        CommonTree LEFT_PAREN146_tree=null;
        CommonTree RIGHT_PAREN148_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_octet_length_keyword=new RewriteRuleSubtreeStream(adaptor,"rule octet_length_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:362:2: ( octet_length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( octet_length_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:362:4: octet_length_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_octet_length_keyword_in_octetLengthFunction1483);
            octet_length_keyword145=octet_length_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_octet_length_keyword.add(octet_length_keyword145.getTree());

            LEFT_PAREN146=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_octetLengthFunction1485); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN146);


            pushFollow(FOLLOW_expression_in_octetLengthFunction1487);
            expression147=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression147.getTree());

            RIGHT_PAREN148=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_octetLengthFunction1489); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN148);


            // AST REWRITE
            // elements: octet_length_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 363:6: -> ^( octet_length_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:363:9: ^( octet_length_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_octet_length_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octetLengthFunction"


    public static class bitLengthFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bitLengthFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:366:1: bitLengthFunction : bit_length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( bit_length_keyword expression ) ;
    public final OrderByParser.bitLengthFunction_return bitLengthFunction() throws RecognitionException {
        OrderByParser.bitLengthFunction_return retval = new OrderByParser.bitLengthFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN150=null;
        CommonToken RIGHT_PAREN152=null;
        OrderByParser.bit_length_keyword_return bit_length_keyword149 =null;

        OrderByParser.expression_return expression151 =null;


        CommonTree LEFT_PAREN150_tree=null;
        CommonTree RIGHT_PAREN152_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleSubtreeStream stream_expression=new RewriteRuleSubtreeStream(adaptor,"rule expression");
        RewriteRuleSubtreeStream stream_bit_length_keyword=new RewriteRuleSubtreeStream(adaptor,"rule bit_length_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:367:2: ( bit_length_keyword LEFT_PAREN expression RIGHT_PAREN -> ^( bit_length_keyword expression ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:367:4: bit_length_keyword LEFT_PAREN expression RIGHT_PAREN
            {
            pushFollow(FOLLOW_bit_length_keyword_in_bitLengthFunction1515);
            bit_length_keyword149=bit_length_keyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_bit_length_keyword.add(bit_length_keyword149.getTree());

            LEFT_PAREN150=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_bitLengthFunction1517); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN150);


            pushFollow(FOLLOW_expression_in_bitLengthFunction1519);
            expression151=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_expression.add(expression151.getTree());

            RIGHT_PAREN152=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_bitLengthFunction1521); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN152);


            // AST REWRITE
            // elements: bit_length_keyword, expression
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 368:6: -> ^( bit_length_keyword expression )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:368:9: ^( bit_length_keyword expression )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(stream_bit_length_keyword.nextNode(), root_1);

                adaptor.addChild(root_1, stream_expression.nextTree());

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bitLengthFunction"


    public static class generalFunction_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "generalFunction"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:372:1: generalFunction : generalFunctionName LEFT_PAREN functionArgument ( COMMA functionArgument )* RIGHT_PAREN -> ^( FUNCTION[$generalFunctionName.start,$generalFunctionName.text] ( functionArgument )+ ) ;
    public final OrderByParser.generalFunction_return generalFunction() throws RecognitionException {
        OrderByParser.generalFunction_return retval = new OrderByParser.generalFunction_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken LEFT_PAREN154=null;
        CommonToken COMMA156=null;
        CommonToken RIGHT_PAREN158=null;
        OrderByParser.generalFunctionName_return generalFunctionName153 =null;

        OrderByParser.functionArgument_return functionArgument155 =null;

        OrderByParser.functionArgument_return functionArgument157 =null;


        CommonTree LEFT_PAREN154_tree=null;
        CommonTree COMMA156_tree=null;
        CommonTree RIGHT_PAREN158_tree=null;
        RewriteRuleTokenStream stream_LEFT_PAREN=new RewriteRuleTokenStream(adaptor,"token LEFT_PAREN");
        RewriteRuleTokenStream stream_RIGHT_PAREN=new RewriteRuleTokenStream(adaptor,"token RIGHT_PAREN");
        RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
        RewriteRuleSubtreeStream stream_generalFunctionName=new RewriteRuleSubtreeStream(adaptor,"rule generalFunctionName");
        RewriteRuleSubtreeStream stream_functionArgument=new RewriteRuleSubtreeStream(adaptor,"rule functionArgument");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:373:5: ( generalFunctionName LEFT_PAREN functionArgument ( COMMA functionArgument )* RIGHT_PAREN -> ^( FUNCTION[$generalFunctionName.start,$generalFunctionName.text] ( functionArgument )+ ) )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:373:7: generalFunctionName LEFT_PAREN functionArgument ( COMMA functionArgument )* RIGHT_PAREN
            {
            pushFollow(FOLLOW_generalFunctionName_in_generalFunction1551);
            generalFunctionName153=generalFunctionName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_generalFunctionName.add(generalFunctionName153.getTree());

            LEFT_PAREN154=(CommonToken)match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_generalFunction1553); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_LEFT_PAREN.add(LEFT_PAREN154);


            pushFollow(FOLLOW_functionArgument_in_generalFunction1555);
            functionArgument155=functionArgument();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_functionArgument.add(functionArgument155.getTree());

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:373:55: ( COMMA functionArgument )*
            loop20:
            do {
                int alt20=2;
                int LA20_0 = input.LA(1);

                if ( (LA20_0==COMMA) ) {
                    alt20=1;
                }


                switch (alt20) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:373:57: COMMA functionArgument
            	    {
            	    COMMA156=(CommonToken)match(input,COMMA,FOLLOW_COMMA_in_generalFunction1559); if (state.failed) return retval; 
            	    if ( state.backtracking==0 ) stream_COMMA.add(COMMA156);


            	    pushFollow(FOLLOW_functionArgument_in_generalFunction1561);
            	    functionArgument157=functionArgument();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) stream_functionArgument.add(functionArgument157.getTree());

            	    }
            	    break;

            	default :
            	    break loop20;
                }
            } while (true);


            RIGHT_PAREN158=(CommonToken)match(input,RIGHT_PAREN,FOLLOW_RIGHT_PAREN_in_generalFunction1566); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_RIGHT_PAREN.add(RIGHT_PAREN158);


            // AST REWRITE
            // elements: functionArgument
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 374:11: -> ^( FUNCTION[$generalFunctionName.start,$generalFunctionName.text] ( functionArgument )+ )
            {
                // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:374:14: ^( FUNCTION[$generalFunctionName.start,$generalFunctionName.text] ( functionArgument )+ )
                {
                CommonTree root_1 = (CommonTree)adaptor.nil();
                root_1 = (CommonTree)adaptor.becomeRoot(
                (CommonTree)adaptor.create(FUNCTION, (generalFunctionName153!=null?((CommonToken)generalFunctionName153.start):null), (generalFunctionName153!=null?input.toString(generalFunctionName153.start,generalFunctionName153.stop):null))
                , root_1);

                if ( !(stream_functionArgument.hasNext()) ) {
                    throw new RewriteEarlyExitException();
                }
                while ( stream_functionArgument.hasNext() ) {
                    adaptor.addChild(root_1, stream_functionArgument.nextTree());

                }
                stream_functionArgument.reset();

                adaptor.addChild(root_0, root_1);
                }

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "generalFunction"


    public static class generalFunctionName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "generalFunctionName"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:377:1: generalFunctionName : IDENTIFIER ( DOT IDENTIFIER )+ ;
    public final OrderByParser.generalFunctionName_return generalFunctionName() throws RecognitionException {
        OrderByParser.generalFunctionName_return retval = new OrderByParser.generalFunctionName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken IDENTIFIER159=null;
        CommonToken DOT160=null;
        CommonToken IDENTIFIER161=null;

        CommonTree IDENTIFIER159_tree=null;
        CommonTree DOT160_tree=null;
        CommonTree IDENTIFIER161_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:377:21: ( IDENTIFIER ( DOT IDENTIFIER )+ )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:378:5: IDENTIFIER ( DOT IDENTIFIER )+
            {
            root_0 = (CommonTree)adaptor.nil();


            IDENTIFIER159=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_generalFunctionName1605); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER159_tree = 
            (CommonTree)adaptor.create(IDENTIFIER159)
            ;
            adaptor.addChild(root_0, IDENTIFIER159_tree);
            }

            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:378:16: ( DOT IDENTIFIER )+
            int cnt21=0;
            loop21:
            do {
                int alt21=2;
                int LA21_0 = input.LA(1);

                if ( (LA21_0==DOT) ) {
                    alt21=1;
                }


                switch (alt21) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:378:18: DOT IDENTIFIER
            	    {
            	    DOT160=(CommonToken)match(input,DOT,FOLLOW_DOT_in_generalFunctionName1609); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    DOT160_tree = 
            	    (CommonTree)adaptor.create(DOT160)
            	    ;
            	    adaptor.addChild(root_0, DOT160_tree);
            	    }

            	    IDENTIFIER161=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_generalFunctionName1611); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {
            	    IDENTIFIER161_tree = 
            	    (CommonTree)adaptor.create(IDENTIFIER161)
            	    ;
            	    adaptor.addChild(root_0, IDENTIFIER161_tree);
            	    }

            	    }
            	    break;

            	default :
            	    if ( cnt21 >= 1 ) break loop21;
            	    if (state.backtracking>0) {state.failed=true; return retval;}
                        EarlyExitException eee =
                            new EarlyExitException(21, input);
                        throw eee;
                }
                cnt21++;
            } while (true);


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "generalFunctionName"


    public static class functionArgument_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "functionArgument"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:384:1: functionArgument : expression ;
    public final OrderByParser.functionArgument_return functionArgument() throws RecognitionException {
        OrderByParser.functionArgument_return retval = new OrderByParser.functionArgument_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.expression_return expression162 =null;



        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:385:5: ( expression )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:385:7: expression
            {
            root_0 = (CommonTree)adaptor.nil();


            pushFollow(FOLLOW_expression_in_functionArgument1629);
            expression162=expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) adaptor.addChild(root_0, expression162.getTree());

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "functionArgument"


    public static class literal_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:388:1: literal : ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL );
    public final OrderByParser.literal_return literal() throws RecognitionException {
        OrderByParser.literal_return retval = new OrderByParser.literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken HEX_LITERAL164=null;
        CommonToken OCTAL_LITERAL165=null;
        CommonToken CHARACTER_LITERAL166=null;
        CommonToken STRING_LITERAL167=null;
        OrderByParser.numeric_literal_return numeric_literal163 =null;


        CommonTree HEX_LITERAL164_tree=null;
        CommonTree OCTAL_LITERAL165_tree=null;
        CommonTree CHARACTER_LITERAL166_tree=null;
        CommonTree STRING_LITERAL167_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:389:2: ( numeric_literal | HEX_LITERAL | OCTAL_LITERAL | CHARACTER_LITERAL | STRING_LITERAL )
            int alt22=5;
            switch ( input.LA(1) ) {
            case DECIMAL_LITERAL:
            case FLOATING_POINT_LITERAL:
            case INTEGER_LITERAL:
                {
                alt22=1;
                }
                break;
            case HEX_LITERAL:
                {
                alt22=2;
                }
                break;
            case OCTAL_LITERAL:
                {
                alt22=3;
                }
                break;
            case CHARACTER_LITERAL:
                {
                alt22=4;
                }
                break;
            case STRING_LITERAL:
                {
                alt22=5;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 22, 0, input);

                throw nvae;

            }

            switch (alt22) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:389:4: numeric_literal
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    pushFollow(FOLLOW_numeric_literal_in_literal1643);
                    numeric_literal163=numeric_literal();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) adaptor.addChild(root_0, numeric_literal163.getTree());

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:390:4: HEX_LITERAL
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    HEX_LITERAL164=(CommonToken)match(input,HEX_LITERAL,FOLLOW_HEX_LITERAL_in_literal1648); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    HEX_LITERAL164_tree = 
                    (CommonTree)adaptor.create(HEX_LITERAL164)
                    ;
                    adaptor.addChild(root_0, HEX_LITERAL164_tree);
                    }

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:391:4: OCTAL_LITERAL
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    OCTAL_LITERAL165=(CommonToken)match(input,OCTAL_LITERAL,FOLLOW_OCTAL_LITERAL_in_literal1653); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    OCTAL_LITERAL165_tree = 
                    (CommonTree)adaptor.create(OCTAL_LITERAL165)
                    ;
                    adaptor.addChild(root_0, OCTAL_LITERAL165_tree);
                    }

                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:392:4: CHARACTER_LITERAL
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    CHARACTER_LITERAL166=(CommonToken)match(input,CHARACTER_LITERAL,FOLLOW_CHARACTER_LITERAL_in_literal1658); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    CHARACTER_LITERAL166_tree = 
                    (CommonTree)adaptor.create(CHARACTER_LITERAL166)
                    ;
                    adaptor.addChild(root_0, CHARACTER_LITERAL166_tree);
                    }

                    }
                    break;
                case 5 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:393:4: STRING_LITERAL
                    {
                    root_0 = (CommonTree)adaptor.nil();


                    STRING_LITERAL167=(CommonToken)match(input,STRING_LITERAL,FOLLOW_STRING_LITERAL_in_literal1663); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                    STRING_LITERAL167_tree = 
                    (CommonTree)adaptor.create(STRING_LITERAL167)
                    ;
                    adaptor.addChild(root_0, STRING_LITERAL167_tree);
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class numeric_literal_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "numeric_literal"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:396:1: numeric_literal : ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL );
    public final OrderByParser.numeric_literal_return numeric_literal() throws RecognitionException {
        OrderByParser.numeric_literal_return retval = new OrderByParser.numeric_literal_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken set168=null;

        CommonTree set168_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:397:2: ( INTEGER_LITERAL | DECIMAL_LITERAL | FLOATING_POINT_LITERAL )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:
            {
            root_0 = (CommonTree)adaptor.nil();


            set168=(CommonToken)input.LT(1);

            if ( input.LA(1)==DECIMAL_LITERAL||input.LA(1)==FLOATING_POINT_LITERAL||input.LA(1)==INTEGER_LITERAL ) {
                input.consume();
                if ( state.backtracking==0 ) adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(set168)
                );
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "numeric_literal"


    public static class collationSpecification_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collationSpecification"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:406:1: collationSpecification : collateKeyword collationName -> COLLATE[$collateKeyword.start,$collationName.text] ;
    public final OrderByParser.collationSpecification_return collationSpecification() throws RecognitionException {
        OrderByParser.collationSpecification_return retval = new OrderByParser.collationSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.collateKeyword_return collateKeyword169 =null;

        OrderByParser.collationName_return collationName170 =null;


        RewriteRuleSubtreeStream stream_collateKeyword=new RewriteRuleSubtreeStream(adaptor,"rule collateKeyword");
        RewriteRuleSubtreeStream stream_collationName=new RewriteRuleSubtreeStream(adaptor,"rule collationName");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:407:5: ( collateKeyword collationName -> COLLATE[$collateKeyword.start,$collationName.text] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:407:7: collateKeyword collationName
            {
            pushFollow(FOLLOW_collateKeyword_in_collationSpecification1701);
            collateKeyword169=collateKeyword();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_collateKeyword.add(collateKeyword169.getTree());

            pushFollow(FOLLOW_collationName_in_collationSpecification1703);
            collationName170=collationName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) stream_collationName.add(collationName170.getTree());

            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 408:9: -> COLLATE[$collateKeyword.start,$collationName.text]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(COLLATE, (collateKeyword169!=null?((CommonToken)collateKeyword169.start):null), (collationName170!=null?input.toString(collationName170.start,collationName170.stop):null))
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collationSpecification"


    public static class collateKeyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collateKeyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:411:1: collateKeyword :{...}? =>id= IDENTIFIER -> COLLATE[$id] ;
    public final OrderByParser.collateKeyword_return collateKeyword() throws RecognitionException {
        OrderByParser.collateKeyword_return retval = new OrderByParser.collateKeyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:412:5: ({...}? =>id= IDENTIFIER -> COLLATE[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:412:7: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("collate")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "collateKeyword", "(validateSoftKeyword(\"collate\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_collateKeyword1739); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 413:9: -> COLLATE[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(COLLATE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collateKeyword"


    public static class collationName_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "collationName"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:419:1: collationName : IDENTIFIER ;
    public final OrderByParser.collationName_return collationName() throws RecognitionException {
        OrderByParser.collationName_return retval = new OrderByParser.collationName_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken IDENTIFIER171=null;

        CommonTree IDENTIFIER171_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:420:5: ( IDENTIFIER )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:420:7: IDENTIFIER
            {
            root_0 = (CommonTree)adaptor.nil();


            IDENTIFIER171=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_collationName1771); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER171_tree = 
            (CommonTree)adaptor.create(IDENTIFIER171)
            ;
            adaptor.addChild(root_0, IDENTIFIER171_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "collationName"


    public static class orderingSpecification_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "orderingSpecification"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:427:1: orderingSpecification : ( ascending_keyword -> ORDER_SPEC[$ascending_keyword.start,$ascending_keyword.text] | descending_keyword -> ORDER_SPEC[$descending_keyword.start,$descending_keyword.text] );
    public final OrderByParser.orderingSpecification_return orderingSpecification() throws RecognitionException {
        OrderByParser.orderingSpecification_return retval = new OrderByParser.orderingSpecification_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        OrderByParser.ascending_keyword_return ascending_keyword172 =null;

        OrderByParser.descending_keyword_return descending_keyword173 =null;


        RewriteRuleSubtreeStream stream_descending_keyword=new RewriteRuleSubtreeStream(adaptor,"rule descending_keyword");
        RewriteRuleSubtreeStream stream_ascending_keyword=new RewriteRuleSubtreeStream(adaptor,"rule ascending_keyword");
        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:428:5: ( ascending_keyword -> ORDER_SPEC[$ascending_keyword.start,$ascending_keyword.text] | descending_keyword -> ORDER_SPEC[$descending_keyword.start,$descending_keyword.text] )
            int alt23=2;
            int LA23_0 = input.LA(1);

            if ( (LA23_0==IDENTIFIER) && ((((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))||((validateSoftKeyword("descending") || validateSoftKeyword("desc")))))) {
                int LA23_1 = input.LA(2);

                if ( (((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))) ) {
                    alt23=1;
                }
                else if ( (((validateSoftKeyword("descending") || validateSoftKeyword("desc")))) ) {
                    alt23=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 23, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 23, 0, input);

                throw nvae;

            }
            switch (alt23) {
                case 1 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:428:7: ascending_keyword
                    {
                    pushFollow(FOLLOW_ascending_keyword_in_orderingSpecification1791);
                    ascending_keyword172=ascending_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_ascending_keyword.add(ascending_keyword172.getTree());

                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 429:9: -> ORDER_SPEC[$ascending_keyword.start,$ascending_keyword.text]
                    {
                        adaptor.addChild(root_0, 
                        (CommonTree)adaptor.create(ORDER_SPEC, (ascending_keyword172!=null?((CommonToken)ascending_keyword172.start):null), (ascending_keyword172!=null?input.toString(ascending_keyword172.start,ascending_keyword172.stop):null))
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:430:7: descending_keyword
                    {
                    pushFollow(FOLLOW_descending_keyword_in_orderingSpecification1812);
                    descending_keyword173=descending_keyword();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) stream_descending_keyword.add(descending_keyword173.getTree());

                    // AST REWRITE
                    // elements: 
                    // token labels: 
                    // rule labels: retval
                    // token list labels: 
                    // rule list labels: 
                    // wildcard labels: 
                    if ( state.backtracking==0 ) {

                    retval.tree = root_0;
                    RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

                    root_0 = (CommonTree)adaptor.nil();
                    // 431:9: -> ORDER_SPEC[$descending_keyword.start,$descending_keyword.text]
                    {
                        adaptor.addChild(root_0, 
                        (CommonTree)adaptor.create(ORDER_SPEC, (descending_keyword173!=null?((CommonToken)descending_keyword173.start):null), (descending_keyword173!=null?input.toString(descending_keyword173.start,descending_keyword173.stop):null))
                        );

                    }


                    retval.tree = root_0;
                    }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "orderingSpecification"


    public static class abs_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abs_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:439:1: abs_keyword :{...}? =>id= IDENTIFIER -> ABS[$id] ;
    public final OrderByParser.abs_keyword_return abs_keyword() throws RecognitionException {
        OrderByParser.abs_keyword_return retval = new OrderByParser.abs_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:440:2: ({...}? =>id= IDENTIFIER -> ABS[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:440:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("abs")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "abs_keyword", "(validateSoftKeyword(\"abs\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_abs_keyword1850); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 441:3: -> ABS[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(ABS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abs_keyword"


    public static class as_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "as_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:444:1: as_keyword :{...}? =>id= IDENTIFIER -> AS[$id] ;
    public final OrderByParser.as_keyword_return as_keyword() throws RecognitionException {
        OrderByParser.as_keyword_return retval = new OrderByParser.as_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:445:2: ({...}? =>id= IDENTIFIER -> AS[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:445:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("as")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "as_keyword", "(validateSoftKeyword(\"as\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_as_keyword1874); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 446:3: -> AS[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(AS, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "as_keyword"


    public static class ascending_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "ascending_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:449:1: ascending_keyword :{...}? => IDENTIFIER ;
    public final OrderByParser.ascending_keyword_return ascending_keyword() throws RecognitionException {
        OrderByParser.ascending_keyword_return retval = new OrderByParser.ascending_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken IDENTIFIER174=null;

        CommonTree IDENTIFIER174_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:449:19: ({...}? => IDENTIFIER )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:450:5: {...}? => IDENTIFIER
            {
            root_0 = (CommonTree)adaptor.nil();


            if ( !(((validateSoftKeyword("ascending") || validateSoftKeyword("asc")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "ascending_keyword", "(validateSoftKeyword(\"ascending\") || validateSoftKeyword(\"asc\"))");
            }

            IDENTIFIER174=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_ascending_keyword1899); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER174_tree = 
            (CommonTree)adaptor.create(IDENTIFIER174)
            ;
            adaptor.addChild(root_0, IDENTIFIER174_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "ascending_keyword"


    public static class bit_length_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "bit_length_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:453:1: bit_length_keyword :{...}? =>id= IDENTIFIER -> BIT_LENGTH[$id] ;
    public final OrderByParser.bit_length_keyword_return bit_length_keyword() throws RecognitionException {
        OrderByParser.bit_length_keyword_return retval = new OrderByParser.bit_length_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:454:2: ({...}? =>id= IDENTIFIER -> BIT_LENGTH[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:454:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("bit_length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "bit_length_keyword", "(validateSoftKeyword(\"bit_length\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_bit_length_keyword1915); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 455:3: -> BIT_LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(BIT_LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "bit_length_keyword"


    public static class both_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "both_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:458:1: both_keyword :{...}? =>id= IDENTIFIER -> BOTH[$id] ;
    public final OrderByParser.both_keyword_return both_keyword() throws RecognitionException {
        OrderByParser.both_keyword_return retval = new OrderByParser.both_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:459:2: ({...}? =>id= IDENTIFIER -> BOTH[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:459:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("both")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "both_keyword", "(validateSoftKeyword(\"both\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_both_keyword1939); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 460:3: -> BOTH[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(BOTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "both_keyword"


    public static class cast_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cast_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:463:1: cast_keyword :{...}? =>id= IDENTIFIER -> CAST[$id] ;
    public final OrderByParser.cast_keyword_return cast_keyword() throws RecognitionException {
        OrderByParser.cast_keyword_return retval = new OrderByParser.cast_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:464:2: ({...}? =>id= IDENTIFIER -> CAST[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:464:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("cast")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "cast_keyword", "(validateSoftKeyword(\"cast\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_cast_keyword1963); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 465:3: -> CAST[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(CAST, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cast_keyword"


    public static class character_length_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "character_length_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:468:1: character_length_keyword :{...}? =>id= IDENTIFIER -> CHARACTER_LENGTH[$id] ;
    public final OrderByParser.character_length_keyword_return character_length_keyword() throws RecognitionException {
        OrderByParser.character_length_keyword_return retval = new OrderByParser.character_length_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:469:2: ({...}? =>id= IDENTIFIER -> CHARACTER_LENGTH[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:469:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("character_length") || validateSoftKeyword("char_length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "character_length_keyword", "(validateSoftKeyword(\"character_length\") || validateSoftKeyword(\"char_length\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_character_length_keyword1987); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 470:3: -> CHARACTER_LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(CHARACTER_LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "character_length_keyword"


    public static class concat_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "concat_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:473:1: concat_keyword :{...}? =>id= IDENTIFIER -> CONCAT[$id] ;
    public final OrderByParser.concat_keyword_return concat_keyword() throws RecognitionException {
        OrderByParser.concat_keyword_return retval = new OrderByParser.concat_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:474:2: ({...}? =>id= IDENTIFIER -> CONCAT[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:474:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("concat")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "concat_keyword", "(validateSoftKeyword(\"concat\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_concat_keyword2011); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 475:3: -> CONCAT[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(CONCAT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "concat_keyword"


    public static class current_date_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "current_date_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:478:1: current_date_keyword :{...}? =>id= IDENTIFIER -> CURRENT_DATE[$id] ;
    public final OrderByParser.current_date_keyword_return current_date_keyword() throws RecognitionException {
        OrderByParser.current_date_keyword_return retval = new OrderByParser.current_date_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:479:2: ({...}? =>id= IDENTIFIER -> CURRENT_DATE[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:479:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("current_date")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "current_date_keyword", "(validateSoftKeyword(\"current_date\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_current_date_keyword2035); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 480:3: -> CURRENT_DATE[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(CURRENT_DATE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "current_date_keyword"


    public static class current_time_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "current_time_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:483:1: current_time_keyword :{...}? =>id= IDENTIFIER -> CURRENT_TIME[$id] ;
    public final OrderByParser.current_time_keyword_return current_time_keyword() throws RecognitionException {
        OrderByParser.current_time_keyword_return retval = new OrderByParser.current_time_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:484:2: ({...}? =>id= IDENTIFIER -> CURRENT_TIME[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:484:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("current_time")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "current_time_keyword", "(validateSoftKeyword(\"current_time\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_current_time_keyword2059); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 485:3: -> CURRENT_TIME[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(CURRENT_TIME, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "current_time_keyword"


    public static class current_timestamp_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "current_timestamp_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:488:1: current_timestamp_keyword :{...}? =>id= IDENTIFIER -> CURRENT_TIMESTAMP[$id] ;
    public final OrderByParser.current_timestamp_keyword_return current_timestamp_keyword() throws RecognitionException {
        OrderByParser.current_timestamp_keyword_return retval = new OrderByParser.current_timestamp_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:489:2: ({...}? =>id= IDENTIFIER -> CURRENT_TIMESTAMP[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:489:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("current_timestamp")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "current_timestamp_keyword", "(validateSoftKeyword(\"current_timestamp\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_current_timestamp_keyword2083); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 490:3: -> CURRENT_TIMESTAMP[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(CURRENT_TIMESTAMP, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "current_timestamp_keyword"


    public static class day_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "day_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:493:1: day_keyword :{...}? =>id= IDENTIFIER -> DAY[$id] ;
    public final OrderByParser.day_keyword_return day_keyword() throws RecognitionException {
        OrderByParser.day_keyword_return retval = new OrderByParser.day_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:494:2: ({...}? =>id= IDENTIFIER -> DAY[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:494:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("day")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "day_keyword", "(validateSoftKeyword(\"day\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_day_keyword2107); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 495:3: -> DAY[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(DAY, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "day_keyword"


    public static class descending_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "descending_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:498:1: descending_keyword :{...}? => IDENTIFIER ;
    public final OrderByParser.descending_keyword_return descending_keyword() throws RecognitionException {
        OrderByParser.descending_keyword_return retval = new OrderByParser.descending_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken IDENTIFIER175=null;

        CommonTree IDENTIFIER175_tree=null;

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:498:20: ({...}? => IDENTIFIER )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:499:5: {...}? => IDENTIFIER
            {
            root_0 = (CommonTree)adaptor.nil();


            if ( !(((validateSoftKeyword("descending") || validateSoftKeyword("desc")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "descending_keyword", "(validateSoftKeyword(\"descending\") || validateSoftKeyword(\"desc\"))");
            }

            IDENTIFIER175=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_descending_keyword2132); if (state.failed) return retval;
            if ( state.backtracking==0 ) {
            IDENTIFIER175_tree = 
            (CommonTree)adaptor.create(IDENTIFIER175)
            ;
            adaptor.addChild(root_0, IDENTIFIER175_tree);
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "descending_keyword"


    public static class extract_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "extract_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:502:1: extract_keyword :{...}? =>id= IDENTIFIER -> EXTRACT[$id] ;
    public final OrderByParser.extract_keyword_return extract_keyword() throws RecognitionException {
        OrderByParser.extract_keyword_return retval = new OrderByParser.extract_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:503:2: ({...}? =>id= IDENTIFIER -> EXTRACT[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:503:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("extract")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "extract_keyword", "(validateSoftKeyword(\"extract\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_extract_keyword2148); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 504:3: -> EXTRACT[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(EXTRACT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "extract_keyword"


    public static class from_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "from_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:507:1: from_keyword :{...}? =>id= IDENTIFIER -> FROM[$id] ;
    public final OrderByParser.from_keyword_return from_keyword() throws RecognitionException {
        OrderByParser.from_keyword_return retval = new OrderByParser.from_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:508:2: ({...}? =>id= IDENTIFIER -> FROM[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:508:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("from")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "from_keyword", "(validateSoftKeyword(\"from\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_from_keyword2172); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 509:3: -> FROM[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(FROM, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "from_keyword"


    public static class hour_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "hour_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:512:1: hour_keyword :{...}? =>id= IDENTIFIER -> HOUR[$id] ;
    public final OrderByParser.hour_keyword_return hour_keyword() throws RecognitionException {
        OrderByParser.hour_keyword_return retval = new OrderByParser.hour_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:513:2: ({...}? =>id= IDENTIFIER -> HOUR[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:513:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("hour")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "hour_keyword", "(validateSoftKeyword(\"hour\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_hour_keyword2196); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 514:3: -> HOUR[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(HOUR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "hour_keyword"


    public static class in_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "in_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:517:1: in_keyword :{...}? =>id= IDENTIFIER -> IN[$id] ;
    public final OrderByParser.in_keyword_return in_keyword() throws RecognitionException {
        OrderByParser.in_keyword_return retval = new OrderByParser.in_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:518:2: ({...}? =>id= IDENTIFIER -> IN[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:518:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("in")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "in_keyword", "(validateSoftKeyword(\"in\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_in_keyword2220); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 519:3: -> IN[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(IN, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "in_keyword"


    public static class leading_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "leading_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:521:1: leading_keyword :{...}? =>id= IDENTIFIER -> LEADING[$id] ;
    public final OrderByParser.leading_keyword_return leading_keyword() throws RecognitionException {
        OrderByParser.leading_keyword_return retval = new OrderByParser.leading_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:522:2: ({...}? =>id= IDENTIFIER -> LEADING[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:522:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("leading")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "leading_keyword", "(validateSoftKeyword(\"leading\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_leading_keyword2243); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 523:3: -> LEADING[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(LEADING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "leading_keyword"


    public static class length_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "length_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:526:1: length_keyword :{...}? =>id= IDENTIFIER -> LENGTH[$id] ;
    public final OrderByParser.length_keyword_return length_keyword() throws RecognitionException {
        OrderByParser.length_keyword_return retval = new OrderByParser.length_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:527:2: ({...}? =>id= IDENTIFIER -> LENGTH[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:527:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "length_keyword", "(validateSoftKeyword(\"length\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_length_keyword2267); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 528:3: -> LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "length_keyword"


    public static class locate_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locate_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:531:1: locate_keyword :{...}? =>id= IDENTIFIER -> LOCATE[$id] ;
    public final OrderByParser.locate_keyword_return locate_keyword() throws RecognitionException {
        OrderByParser.locate_keyword_return retval = new OrderByParser.locate_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:532:2: ({...}? =>id= IDENTIFIER -> LOCATE[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:532:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("locate")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "locate_keyword", "(validateSoftKeyword(\"locate\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_locate_keyword2291); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 533:3: -> LOCATE[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(LOCATE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locate_keyword"


    public static class lower_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "lower_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:536:1: lower_keyword :{...}? =>id= IDENTIFIER -> LOWER[$id] ;
    public final OrderByParser.lower_keyword_return lower_keyword() throws RecognitionException {
        OrderByParser.lower_keyword_return retval = new OrderByParser.lower_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:537:2: ({...}? =>id= IDENTIFIER -> LOWER[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:537:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("lower")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "lower_keyword", "(validateSoftKeyword(\"lower\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_lower_keyword2315); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 538:3: -> LOWER[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(LOWER, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "lower_keyword"


    public static class minute_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "minute_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:541:1: minute_keyword :{...}? =>id= IDENTIFIER -> MINUTE[$id] ;
    public final OrderByParser.minute_keyword_return minute_keyword() throws RecognitionException {
        OrderByParser.minute_keyword_return retval = new OrderByParser.minute_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:542:2: ({...}? =>id= IDENTIFIER -> MINUTE[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:542:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("minute")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "minute_keyword", "(validateSoftKeyword(\"minute\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_minute_keyword2339); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 543:3: -> MINUTE[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(MINUTE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "minute_keyword"


    public static class mod_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "mod_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:546:1: mod_keyword :{...}? =>id= IDENTIFIER -> MOD[$id] ;
    public final OrderByParser.mod_keyword_return mod_keyword() throws RecognitionException {
        OrderByParser.mod_keyword_return retval = new OrderByParser.mod_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:547:2: ({...}? =>id= IDENTIFIER -> MOD[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:547:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("mod")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "mod_keyword", "(validateSoftKeyword(\"mod\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_mod_keyword2363); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 548:3: -> MOD[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(MOD, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "mod_keyword"


    public static class month_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "month_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:551:1: month_keyword :{...}? =>id= IDENTIFIER -> MONTH[$id] ;
    public final OrderByParser.month_keyword_return month_keyword() throws RecognitionException {
        OrderByParser.month_keyword_return retval = new OrderByParser.month_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:552:2: ({...}? =>id= IDENTIFIER -> MONTH[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:552:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("month")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "month_keyword", "(validateSoftKeyword(\"month\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_month_keyword2387); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 553:3: -> MONTH[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(MONTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "month_keyword"


    public static class octet_length_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "octet_length_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:556:1: octet_length_keyword :{...}? =>id= IDENTIFIER -> OCTET_LENGTH[$id] ;
    public final OrderByParser.octet_length_keyword_return octet_length_keyword() throws RecognitionException {
        OrderByParser.octet_length_keyword_return retval = new OrderByParser.octet_length_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:557:2: ({...}? =>id= IDENTIFIER -> OCTET_LENGTH[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:557:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("octet_length")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "octet_length_keyword", "(validateSoftKeyword(\"octet_length\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_octet_length_keyword2411); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 558:3: -> OCTET_LENGTH[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(OCTET_LENGTH, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "octet_length_keyword"


    public static class position_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "position_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:561:1: position_keyword :{...}? =>id= IDENTIFIER -> POSITION[$id] ;
    public final OrderByParser.position_keyword_return position_keyword() throws RecognitionException {
        OrderByParser.position_keyword_return retval = new OrderByParser.position_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:562:2: ({...}? =>id= IDENTIFIER -> POSITION[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:562:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("position")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "position_keyword", "(validateSoftKeyword(\"position\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_position_keyword2435); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 563:3: -> POSITION[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(POSITION, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "position_keyword"


    public static class second_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "second_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:566:1: second_keyword :{...}? =>id= IDENTIFIER -> SECOND[$id] ;
    public final OrderByParser.second_keyword_return second_keyword() throws RecognitionException {
        OrderByParser.second_keyword_return retval = new OrderByParser.second_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:567:2: ({...}? =>id= IDENTIFIER -> SECOND[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:567:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("second")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "second_keyword", "(validateSoftKeyword(\"second\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_second_keyword2459); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 568:3: -> SECOND[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(SECOND, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "second_keyword"


    public static class sqrt_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "sqrt_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:571:1: sqrt_keyword :{...}? =>id= IDENTIFIER -> SQRT[$id] ;
    public final OrderByParser.sqrt_keyword_return sqrt_keyword() throws RecognitionException {
        OrderByParser.sqrt_keyword_return retval = new OrderByParser.sqrt_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:572:2: ({...}? =>id= IDENTIFIER -> SQRT[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:572:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("sqrt")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "sqrt_keyword", "(validateSoftKeyword(\"sqrt\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_sqrt_keyword2483); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 573:3: -> SQRT[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(SQRT, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "sqrt_keyword"


    public static class substring_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "substring_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:576:1: substring_keyword :{...}? =>id= IDENTIFIER -> SUBSTRING[$id] ;
    public final OrderByParser.substring_keyword_return substring_keyword() throws RecognitionException {
        OrderByParser.substring_keyword_return retval = new OrderByParser.substring_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:577:2: ({...}? =>id= IDENTIFIER -> SUBSTRING[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:577:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("substring")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "substring_keyword", "(validateSoftKeyword(\"substring\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_substring_keyword2507); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 578:3: -> SUBSTRING[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(SUBSTRING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "substring_keyword"


    public static class timezone_hour_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timezone_hour_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:581:1: timezone_hour_keyword :{...}? =>id= IDENTIFIER -> TIMEZONE_HOUR[$id] ;
    public final OrderByParser.timezone_hour_keyword_return timezone_hour_keyword() throws RecognitionException {
        OrderByParser.timezone_hour_keyword_return retval = new OrderByParser.timezone_hour_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:582:2: ({...}? =>id= IDENTIFIER -> TIMEZONE_HOUR[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:582:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("timezone_hour")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "timezone_hour_keyword", "(validateSoftKeyword(\"timezone_hour\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_timezone_hour_keyword2531); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 583:3: -> TIMEZONE_HOUR[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(TIMEZONE_HOUR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timezone_hour_keyword"


    public static class timezone_minute_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timezone_minute_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:586:1: timezone_minute_keyword :{...}? =>id= IDENTIFIER -> TIMEZONE_MINUTE[$id] ;
    public final OrderByParser.timezone_minute_keyword_return timezone_minute_keyword() throws RecognitionException {
        OrderByParser.timezone_minute_keyword_return retval = new OrderByParser.timezone_minute_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:587:2: ({...}? =>id= IDENTIFIER -> TIMEZONE_MINUTE[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:587:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("timezone_minute")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "timezone_minute_keyword", "(validateSoftKeyword(\"timezone_minute\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_timezone_minute_keyword2555); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 588:3: -> TIMEZONE_MINUTE[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(TIMEZONE_MINUTE, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timezone_minute_keyword"


    public static class trailing_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trailing_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:591:1: trailing_keyword :{...}? =>id= IDENTIFIER -> TRAILING[$id] ;
    public final OrderByParser.trailing_keyword_return trailing_keyword() throws RecognitionException {
        OrderByParser.trailing_keyword_return retval = new OrderByParser.trailing_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:592:2: ({...}? =>id= IDENTIFIER -> TRAILING[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:592:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("trailing")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "trailing_keyword", "(validateSoftKeyword(\"trailing\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_trailing_keyword2579); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 593:3: -> TRAILING[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(TRAILING, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trailing_keyword"


    public static class trim_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "trim_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:596:1: trim_keyword :{...}? =>id= IDENTIFIER -> TRIM[$id] ;
    public final OrderByParser.trim_keyword_return trim_keyword() throws RecognitionException {
        OrderByParser.trim_keyword_return retval = new OrderByParser.trim_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:597:2: ({...}? =>id= IDENTIFIER -> TRIM[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:597:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("trim")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "trim_keyword", "(validateSoftKeyword(\"trim\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_trim_keyword2603); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 598:3: -> TRIM[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(TRIM, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "trim_keyword"


    public static class upper_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upper_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:601:1: upper_keyword :{...}? =>id= IDENTIFIER -> UPPER[$id] ;
    public final OrderByParser.upper_keyword_return upper_keyword() throws RecognitionException {
        OrderByParser.upper_keyword_return retval = new OrderByParser.upper_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:602:2: ({...}? =>id= IDENTIFIER -> UPPER[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:602:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("upper")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "upper_keyword", "(validateSoftKeyword(\"upper\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_upper_keyword2627); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 603:3: -> UPPER[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(UPPER, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upper_keyword"


    public static class year_keyword_return extends ParserRuleReturnScope {
        CommonTree tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "year_keyword"
    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:606:1: year_keyword :{...}? =>id= IDENTIFIER -> YEAR[$id] ;
    public final OrderByParser.year_keyword_return year_keyword() throws RecognitionException {
        OrderByParser.year_keyword_return retval = new OrderByParser.year_keyword_return();
        retval.start = input.LT(1);


        CommonTree root_0 = null;

        CommonToken id=null;

        CommonTree id_tree=null;
        RewriteRuleTokenStream stream_IDENTIFIER=new RewriteRuleTokenStream(adaptor,"token IDENTIFIER");

        try {
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:607:2: ({...}? =>id= IDENTIFIER -> YEAR[$id] )
            // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:607:4: {...}? =>id= IDENTIFIER
            {
            if ( !(((validateSoftKeyword("year")))) ) {
                if (state.backtracking>0) {state.failed=true; return retval;}
                throw new FailedPredicateException(input, "year_keyword", "(validateSoftKeyword(\"year\"))");
            }

            id=(CommonToken)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_year_keyword2651); if (state.failed) return retval; 
            if ( state.backtracking==0 ) stream_IDENTIFIER.add(id);


            // AST REWRITE
            // elements: 
            // token labels: 
            // rule labels: retval
            // token list labels: 
            // rule list labels: 
            // wildcard labels: 
            if ( state.backtracking==0 ) {

            retval.tree = root_0;
            RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.tree:null);

            root_0 = (CommonTree)adaptor.nil();
            // 608:3: -> YEAR[$id]
            {
                adaptor.addChild(root_0, 
                (CommonTree)adaptor.create(YEAR, id)
                );

            }


            retval.tree = root_0;
            }

            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {

            retval.tree = (CommonTree)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (CommonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "year_keyword"

    // $ANTLR start synpred1_OrderByParser
    public final void synpred1_OrderByParser_fragment() throws RecognitionException {
        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:176:7: ( IDENTIFIER ( DOT IDENTIFIER )* LEFT_PAREN )
        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:176:9: IDENTIFIER ( DOT IDENTIFIER )* LEFT_PAREN
        {
        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred1_OrderByParser260); if (state.failed) return ;

        // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:176:20: ( DOT IDENTIFIER )*
        loop24:
        do {
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0==DOT) ) {
                alt24=1;
            }


            switch (alt24) {
        	case 1 :
        	    // org/hibernate/hql/ast/origin/ordering/OrderByParser.g:176:22: DOT IDENTIFIER
        	    {
        	    match(input,DOT,FOLLOW_DOT_in_synpred1_OrderByParser264); if (state.failed) return ;

        	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred1_OrderByParser266); if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop24;
            }
        } while (true);


        match(input,LEFT_PAREN,FOLLOW_LEFT_PAREN_in_synpred1_OrderByParser271); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred1_OrderByParser

    // Delegated rules

    public final boolean synpred1_OrderByParser() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_OrderByParser_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


 

    public static final BitSet FOLLOW_sortSpecification_in_orderByFragment83 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_COMMA_in_orderByFragment87 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_sortSpecification_in_orderByFragment89 = new BitSet(new long[]{0x0000000020000002L});
    public static final BitSet FOLLOW_sortKey_in_sortSpecification131 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_collationSpecification_in_sortSpecification133 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_orderingSpecification_in_sortSpecification136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_sortKey182 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_QUOTED_IDENTIFIER_in_expression210 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_standardFunction_in_expression237 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_expression245 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_generalFunction_in_expression277 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_identDotIdentStructure_in_expression290 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_identDotIdentStructure521 = new BitSet(new long[]{0x0000020000000002L});
    public static final BitSet FOLLOW_DOT_in_identDotIdentStructure525 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L,0x0000000000200000L});
    public static final BitSet FOLLOW_identifier_in_identDotIdentStructure528 = new BitSet(new long[]{0x0000020000000002L});
    public static final BitSet FOLLOW_castFunction_in_standardFunction545 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concatFunction_in_standardFunction550 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_substringFunction_in_standardFunction555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimFunction_in_standardFunction560 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upperFunction_in_standardFunction565 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lowerFunction_in_standardFunction570 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lengthFunction_in_standardFunction575 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateFunction_in_standardFunction580 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_absFunction_in_standardFunction585 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sqrtFunction_in_standardFunction590 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_modFunction_in_standardFunction595 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentDateFunction_in_standardFunction600 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimeFunction_in_standardFunction605 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_currentTimestampFunction_in_standardFunction610 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_extractFunction_in_standardFunction615 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_positionFunction_in_standardFunction620 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_charLengthFunction_in_standardFunction625 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_octetLengthFunction_in_standardFunction630 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bitLengthFunction_in_standardFunction635 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cast_keyword_in_castFunction646 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_castFunction648 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_castFunction650 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_as_keyword_in_castFunction652 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_dataType_in_castFunction654 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_castFunction656 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_dataType686 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_concat_keyword_in_concatFunction697 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_concatFunction699 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_concatFunction701 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_COMMA_in_concatFunction705 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_concatFunction707 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_concatFunction712 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_substring_keyword_in_substringFunction739 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_substringFunction741 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_substringFunction743 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_COMMA_in_substringFunction745 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_substringFunction747 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_COMMA_in_substringFunction751 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_substringFunction753 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_substringFunction757 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trim_keyword_in_trimFunction789 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_trimFunction791 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_trimOperands_in_trimFunction793 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_trimFunction795 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimSpecification_in_trimOperands837 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_keyword_in_trimOperands839 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_trimOperands841 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trimSpecification_in_trimOperands863 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_trimOperands865 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_keyword_in_trimOperands867 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_trimOperands869 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_from_keyword_in_trimOperands888 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_trimOperands890 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_expression_in_trimOperands913 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_keyword_in_trimOperands917 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_trimOperands919 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_leading_keyword_in_trimSpecification967 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_trailing_keyword_in_trimSpecification972 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_both_keyword_in_trimSpecification977 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upper_keyword_in_upperFunction988 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_upperFunction990 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_upperFunction992 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_upperFunction994 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_lower_keyword_in_lowerFunction1020 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_lowerFunction1022 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_lowerFunction1024 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_lowerFunction1026 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_length_keyword_in_lengthFunction1052 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_lengthFunction1054 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_lengthFunction1056 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_lengthFunction1058 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locate_keyword_in_locateFunction1084 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_locateFunction1086 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_locateFunction1088 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_COMMA_in_locateFunction1090 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_locateFunction1092 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_COMMA_in_locateFunction1096 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_locateFunction1098 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_locateFunction1103 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_abs_keyword_in_absFunction1130 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_absFunction1132 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_absFunction1134 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_absFunction1136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_sqrt_keyword_in_sqrtFunction1162 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_sqrtFunction1164 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_sqrtFunction1166 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_sqrtFunction1168 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_mod_keyword_in_modFunction1194 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_modFunction1196 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_modFunction1198 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_COMMA_in_modFunction1200 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_modFunction1202 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_modFunction1204 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_current_date_keyword_in_currentDateFunction1231 = new BitSet(new long[]{0x0000000000000002L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_currentDateFunction1235 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_currentDateFunction1238 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_current_time_keyword_in_currentTimeFunction1253 = new BitSet(new long[]{0x0000000000000002L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_currentTimeFunction1257 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_currentTimeFunction1260 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_current_timestamp_keyword_in_currentTimestampFunction1275 = new BitSet(new long[]{0x0000000000000002L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_currentTimestampFunction1279 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_currentTimestampFunction1282 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_extract_keyword_in_extractFunction1297 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_extractFunction1299 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_extractField_in_extractFunction1301 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_from_keyword_in_extractFunction1303 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_extractFunction1305 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_extractFunction1307 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_datetimeField_in_extractField1335 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timeZoneField_in_extractField1340 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_nonSecondDatetimeField_in_datetimeField1351 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_second_keyword_in_datetimeField1356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_year_keyword_in_nonSecondDatetimeField1367 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_month_keyword_in_nonSecondDatetimeField1372 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_day_keyword_in_nonSecondDatetimeField1377 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_hour_keyword_in_nonSecondDatetimeField1382 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_minute_keyword_in_nonSecondDatetimeField1387 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timezone_hour_keyword_in_timeZoneField1398 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_timezone_minute_keyword_in_timeZoneField1403 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_position_keyword_in_positionFunction1414 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_positionFunction1416 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_positionFunction1418 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_in_keyword_in_positionFunction1420 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_positionFunction1422 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_positionFunction1424 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_character_length_keyword_in_charLengthFunction1451 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_charLengthFunction1453 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_charLengthFunction1455 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_charLengthFunction1457 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_octet_length_keyword_in_octetLengthFunction1483 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_octetLengthFunction1485 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_octetLengthFunction1487 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_octetLengthFunction1489 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_bit_length_keyword_in_bitLengthFunction1515 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_bitLengthFunction1517 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_expression_in_bitLengthFunction1519 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_bitLengthFunction1521 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_generalFunctionName_in_generalFunction1551 = new BitSet(new long[]{0x0000000000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_generalFunction1553 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_functionArgument_in_generalFunction1555 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_COMMA_in_generalFunction1559 = new BitSet(new long[]{0x4000004000200000L,0x8000000000040A00L,0x0000008000200000L});
    public static final BitSet FOLLOW_functionArgument_in_generalFunction1561 = new BitSet(new long[]{0x0000000020000000L,0x0000000000000000L,0x0000000000800000L});
    public static final BitSet FOLLOW_RIGHT_PAREN_in_generalFunction1566 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_generalFunctionName1605 = new BitSet(new long[]{0x0000020000000000L});
    public static final BitSet FOLLOW_DOT_in_generalFunctionName1609 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_generalFunctionName1611 = new BitSet(new long[]{0x0000020000000002L});
    public static final BitSet FOLLOW_expression_in_functionArgument1629 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_numeric_literal_in_literal1643 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HEX_LITERAL_in_literal1648 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_OCTAL_LITERAL_in_literal1653 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CHARACTER_LITERAL_in_literal1658 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_LITERAL_in_literal1663 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_collateKeyword_in_collationSpecification1701 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_collationName_in_collationSpecification1703 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_collateKeyword1739 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_collationName1771 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ascending_keyword_in_orderingSpecification1791 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_descending_keyword_in_orderingSpecification1812 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_abs_keyword1850 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_as_keyword1874 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_ascending_keyword1899 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_bit_length_keyword1915 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_both_keyword1939 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_cast_keyword1963 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_character_length_keyword1987 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_concat_keyword2011 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_current_date_keyword2035 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_current_time_keyword2059 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_current_timestamp_keyword2083 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_day_keyword2107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_descending_keyword2132 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_extract_keyword2148 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_from_keyword2172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_hour_keyword2196 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_in_keyword2220 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_leading_keyword2243 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_length_keyword2267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_locate_keyword2291 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_lower_keyword2315 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_minute_keyword2339 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_mod_keyword2363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_month_keyword2387 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_octet_length_keyword2411 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_position_keyword2435 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_second_keyword2459 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_sqrt_keyword2483 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_substring_keyword2507 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_timezone_hour_keyword2531 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_timezone_minute_keyword2555 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_trailing_keyword2579 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_trim_keyword2603 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_upper_keyword2627 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_year_keyword2651 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_synpred1_OrderByParser260 = new BitSet(new long[]{0x0000020000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_DOT_in_synpred1_OrderByParser264 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
    public static final BitSet FOLLOW_IDENTIFIER_in_synpred1_OrderByParser266 = new BitSet(new long[]{0x0000020000000000L,0x0000000200000000L});
    public static final BitSet FOLLOW_LEFT_PAREN_in_synpred1_OrderByParser271 = new BitSet(new long[]{0x0000000000000002L});

}