// $ANTLR 3.4 org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g 2014-05-20 21:31:11

/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008-2012, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 * Portions of SQL grammar parsing copyright (C) 2003 by Lubos Vnuk.  All rights
 * reserved.  These portions are distributed under license by Red Hat Inc. and
 * are covered by the above LGPL notice.  If you redistribute this material,
 * with or without modification, you must preserve this copyright notice in its
 * entirety.
 */
package org.hibernate.hql.ast.origin.hql.parse;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class HQLLexer extends Lexer {
    public static final int EOF=-1;
    public static final int ABS=4;
    public static final int ALIAS_NAME=5;
    public static final int ALIAS_REF=6;
    public static final int ALL=7;
    public static final int AMPERSAND=8;
    public static final int AND=9;
    public static final int ANY=10;
    public static final int ARROW=11;
    public static final int AS=12;
    public static final int ASTERISK=13;
    public static final int AVG=14;
    public static final int BETWEEN=15;
    public static final int BETWEEN_LIST=16;
    public static final int BIT_LENGTH=17;
    public static final int BOTH=18;
    public static final int CAST=19;
    public static final int CHARACTER_LENGTH=20;
    public static final int CHARACTER_LITERAL=21;
    public static final int CLASS=22;
    public static final int COALESCE=23;
    public static final int COLLATE=24;
    public static final int COLLECTION_EXPRESSION=25;
    public static final int COLON=26;
    public static final int COLUMN=27;
    public static final int COLUMN_LIST=28;
    public static final int COMMA=29;
    public static final int CONCAT=30;
    public static final int CONST_STRING_VALUE=31;
    public static final int COUNT=32;
    public static final int CROSS=33;
    public static final int CURRENT_DATE=34;
    public static final int CURRENT_TIME=35;
    public static final int CURRENT_TIMESTAMP=36;
    public static final int DAY=37;
    public static final int DECIMAL_LITERAL=38;
    public static final int DELETE=39;
    public static final int DISTINCT=40;
    public static final int DOT=41;
    public static final int DOT_CLASS=42;
    public static final int DOUBLE_PIPE=43;
    public static final int DYNAMIC_INSTANTIATION=44;
    public static final int DYNAMIC_INSTANTIATION_ARG=45;
    public static final int ELEMENTS=46;
    public static final int ELSE=47;
    public static final int END=48;
    public static final int ENTITY_NAME=49;
    public static final int ENTITY_PERSISTER_REF=50;
    public static final int EOL=51;
    public static final int EQUALS=52;
    public static final int ESCAPE=53;
    public static final int ESCAPE_SEQUENCE=54;
    public static final int EXCEPT=55;
    public static final int EXISTS=56;
    public static final int EXPONENT=57;
    public static final int EXTRACT=58;
    public static final int FALSE=59;
    public static final int FETCH=60;
    public static final int FILTER=61;
    public static final int FLOATING_POINT_LITERAL=62;
    public static final int FLOAT_TYPE_SUFFIX=63;
    public static final int FROM=64;
    public static final int FULL=65;
    public static final int FUNCTION=66;
    public static final int GREATER=67;
    public static final int GREATER_EQUAL=68;
    public static final int GROUPING_VALUE=69;
    public static final int GROUP_BY=70;
    public static final int HAVING=71;
    public static final int HEX_DIGIT=72;
    public static final int HEX_LITERAL=73;
    public static final int HOUR=74;
    public static final int IDENTIFIER=75;
    public static final int IN=76;
    public static final int INDEX=77;
    public static final int INDICES=78;
    public static final int INNER=79;
    public static final int INSERT=80;
    public static final int INSERTABILITY_SPEC=81;
    public static final int INTEGER_LITERAL=82;
    public static final int INTEGER_TYPE_SUFFIX=83;
    public static final int INTERSECT=84;
    public static final int INTO=85;
    public static final int IN_LIST=86;
    public static final int IS=87;
    public static final int IS_EMPTY=88;
    public static final int IS_NOT_EMPTY=89;
    public static final int IS_NOT_NULL=90;
    public static final int IS_NULL=91;
    public static final int JAVA_CONSTANT=92;
    public static final int JOIN=93;
    public static final int JPA_PARAM=94;
    public static final int LEADING=95;
    public static final int LEFT=96;
    public static final int LEFT_PAREN=97;
    public static final int LEFT_SQUARE=98;
    public static final int LENGTH=99;
    public static final int LESS=100;
    public static final int LESS_EQUAL=101;
    public static final int LIKE=102;
    public static final int LOCATE=103;
    public static final int LOWER=104;
    public static final int MAX=105;
    public static final int MAXELEMENT=106;
    public static final int MAXINDEX=107;
    public static final int MEMBER_OF=108;
    public static final int MIN=109;
    public static final int MINELEMENT=110;
    public static final int MININDEX=111;
    public static final int MINUS=112;
    public static final int MINUTE=113;
    public static final int MOD=114;
    public static final int MONTH=115;
    public static final int NAMED_PARAM=116;
    public static final int NEW=117;
    public static final int NOT=118;
    public static final int NOT_BETWEEN=119;
    public static final int NOT_EQUAL=120;
    public static final int NOT_IN=121;
    public static final int NOT_LIKE=122;
    public static final int NOT_MEMBER_OF=123;
    public static final int NULL=124;
    public static final int NULLIF=125;
    public static final int OCTAL_ESCAPE=126;
    public static final int OCTAL_LITERAL=127;
    public static final int OCTET_LENGTH=128;
    public static final int ON=129;
    public static final int OR=130;
    public static final int ORDER_BY=131;
    public static final int ORDER_SPEC=132;
    public static final int OUTER=133;
    public static final int PARAM=134;
    public static final int PATH=135;
    public static final int PERCENT=136;
    public static final int PERSISTER_JOIN=137;
    public static final int PERSISTER_SPACE=138;
    public static final int PIPE=139;
    public static final int PLUS=140;
    public static final int POSITION=141;
    public static final int PROPERTIES=142;
    public static final int PROPERTY_JOIN=143;
    public static final int PROPERTY_REFERENCE=144;
    public static final int PROP_FETCH=145;
    public static final int QUALIFIED_JOIN=146;
    public static final int QUERY=147;
    public static final int QUERY_SPEC=148;
    public static final int QUOTED_IDENTIFIER=149;
    public static final int RIGHT=150;
    public static final int RIGHT_PAREN=151;
    public static final int RIGHT_SQUARE=152;
    public static final int SEARCHED_CASE=153;
    public static final int SECOND=154;
    public static final int SELECT=155;
    public static final int SELECT_FROM=156;
    public static final int SELECT_ITEM=157;
    public static final int SELECT_LIST=158;
    public static final int SEMICOLON=159;
    public static final int SET=160;
    public static final int SIMPLE_CASE=161;
    public static final int SIZE=162;
    public static final int SOLIDUS=163;
    public static final int SOME=164;
    public static final int SORT_SPEC=165;
    public static final int SQRT=166;
    public static final int STRING_LITERAL=167;
    public static final int SUBSTRING=168;
    public static final int SUB_QUERY=169;
    public static final int SUM=170;
    public static final int TABLE=171;
    public static final int THEN=172;
    public static final int TIMEZONE_HOUR=173;
    public static final int TIMEZONE_MINUTE=174;
    public static final int TRAILING=175;
    public static final int TRIM=176;
    public static final int TRUE=177;
    public static final int UNARY_MINUS=178;
    public static final int UNARY_PLUS=179;
    public static final int UNICODE_ESCAPE=180;
    public static final int UNION=181;
    public static final int UPDATE=182;
    public static final int UPPER=183;
    public static final int VECTOR_EXPR=184;
    public static final int VERSIONED=185;
    public static final int VERSIONED_VALUE=186;
    public static final int WHEN=187;
    public static final int WHERE=188;
    public static final int WITH=189;
    public static final int WS=190;
    public static final int YEAR=191;

    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public HQLLexer() {} 
    public HQLLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public HQLLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g"; }

    // $ANTLR start "WS"
    public final void mWS() throws RecognitionException {
        try {
            int _type = WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:189:4: ( ( ' ' | '\\t' | '\\f' | EOL )+ )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:189:6: ( ' ' | '\\t' | '\\f' | EOL )+
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:189:6: ( ' ' | '\\t' | '\\f' | EOL )+
            int cnt1=0;
            loop1:
            do {
                int alt1=5;
                switch ( input.LA(1) ) {
                case ' ':
                    {
                    alt1=1;
                    }
                    break;
                case '\t':
                    {
                    alt1=2;
                    }
                    break;
                case '\f':
                    {
                    alt1=3;
                    }
                    break;
                case '\n':
                case '\r':
                    {
                    alt1=4;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:189:8: ' '
            	    {
            	    match(' '); if (state.failed) return ;

            	    }
            	    break;
            	case 2 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:190:4: '\\t'
            	    {
            	    match('\t'); if (state.failed) return ;

            	    }
            	    break;
            	case 3 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:191:4: '\\f'
            	    {
            	    match('\f'); if (state.failed) return ;

            	    }
            	    break;
            	case 4 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:192:4: EOL
            	    {
            	    mEOL(); if (state.failed) return ;


            	    }
            	    break;

            	default :
            	    if ( cnt1 >= 1 ) break loop1;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(1, input);
                        throw eee;
                }
                cnt1++;
            } while (true);


            if ( state.backtracking==0 ) { _channel=HIDDEN; }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "WS"

    // $ANTLR start "EOL"
    public final void mEOL() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:198:5: ( ( ( '\\r\\n' )=> '\\r\\n' | '\\r' | '\\n' ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:199:2: ( ( '\\r\\n' )=> '\\r\\n' | '\\r' | '\\n' )
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:199:2: ( ( '\\r\\n' )=> '\\r\\n' | '\\r' | '\\n' )
            int alt2=3;
            int LA2_0 = input.LA(1);

            if ( (LA2_0=='\r') ) {
                int LA2_1 = input.LA(2);

                if ( (LA2_1=='\n') && (synpred1_HQLLexer())) {
                    alt2=1;
                }
                else {
                    alt2=2;
                }
            }
            else if ( (LA2_0=='\n') ) {
                alt2=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;

            }
            switch (alt2) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:199:4: ( '\\r\\n' )=> '\\r\\n'
                    {
                    match("\r\n"); if (state.failed) return ;



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:200:5: '\\r'
                    {
                    match('\r'); if (state.failed) return ;

                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:201:5: '\\n'
                    {
                    match('\n'); if (state.failed) return ;

                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "EOL"

    // $ANTLR start "HEX_LITERAL"
    public final void mHEX_LITERAL() throws RecognitionException {
        try {
            int _type = HEX_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:205:13: ( '0' ( 'x' | 'X' ) ( HEX_DIGIT )+ ( INTEGER_TYPE_SUFFIX )? )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:205:15: '0' ( 'x' | 'X' ) ( HEX_DIGIT )+ ( INTEGER_TYPE_SUFFIX )?
            {
            match('0'); if (state.failed) return ;

            if ( input.LA(1)=='X'||input.LA(1)=='x' ) {
                input.consume();
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:205:29: ( HEX_DIGIT )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                int LA3_0 = input.LA(1);

                if ( ((LA3_0 >= '0' && LA3_0 <= '9')||(LA3_0 >= 'A' && LA3_0 <= 'F')||(LA3_0 >= 'a' && LA3_0 <= 'f')) ) {
                    alt3=1;
                }


                switch (alt3) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
            	        input.consume();
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:205:40: ( INTEGER_TYPE_SUFFIX )?
            int alt4=2;
            int LA4_0 = input.LA(1);

            if ( (LA4_0=='L'||LA4_0=='l') ) {
                alt4=1;
            }
            switch (alt4) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    {
                    if ( input.LA(1)=='L'||input.LA(1)=='l' ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "HEX_LITERAL"

    // $ANTLR start "INTEGER_LITERAL"
    public final void mINTEGER_LITERAL() throws RecognitionException {
        try {
            int _type = INTEGER_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:207:17: ( ( '0' | '1' .. '9' ( '0' .. '9' )* ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:207:19: ( '0' | '1' .. '9' ( '0' .. '9' )* )
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:207:19: ( '0' | '1' .. '9' ( '0' .. '9' )* )
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0=='0') ) {
                alt6=1;
            }
            else if ( ((LA6_0 >= '1' && LA6_0 <= '9')) ) {
                alt6=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }
            switch (alt6) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:207:20: '0'
                    {
                    match('0'); if (state.failed) return ;

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:207:26: '1' .. '9' ( '0' .. '9' )*
                    {
                    matchRange('1','9'); if (state.failed) return ;

                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:207:35: ( '0' .. '9' )*
                    loop5:
                    do {
                        int alt5=2;
                        int LA5_0 = input.LA(1);

                        if ( ((LA5_0 >= '0' && LA5_0 <= '9')) ) {
                            alt5=1;
                        }


                        switch (alt5) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop5;
                        }
                    } while (true);


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "INTEGER_LITERAL"

    // $ANTLR start "DECIMAL_LITERAL"
    public final void mDECIMAL_LITERAL() throws RecognitionException {
        try {
            int _type = DECIMAL_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:209:17: ( ( '0' | '1' .. '9' ( '0' .. '9' )* ) INTEGER_TYPE_SUFFIX )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:209:19: ( '0' | '1' .. '9' ( '0' .. '9' )* ) INTEGER_TYPE_SUFFIX
            {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:209:19: ( '0' | '1' .. '9' ( '0' .. '9' )* )
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0=='0') ) {
                alt8=1;
            }
            else if ( ((LA8_0 >= '1' && LA8_0 <= '9')) ) {
                alt8=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 8, 0, input);

                throw nvae;

            }
            switch (alt8) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:209:20: '0'
                    {
                    match('0'); if (state.failed) return ;

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:209:26: '1' .. '9' ( '0' .. '9' )*
                    {
                    matchRange('1','9'); if (state.failed) return ;

                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:209:35: ( '0' .. '9' )*
                    loop7:
                    do {
                        int alt7=2;
                        int LA7_0 = input.LA(1);

                        if ( ((LA7_0 >= '0' && LA7_0 <= '9')) ) {
                            alt7=1;
                        }


                        switch (alt7) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop7;
                        }
                    } while (true);


                    }
                    break;

            }


            mINTEGER_TYPE_SUFFIX(); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DECIMAL_LITERAL"

    // $ANTLR start "OCTAL_LITERAL"
    public final void mOCTAL_LITERAL() throws RecognitionException {
        try {
            int _type = OCTAL_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:211:15: ( '0' ( '0' .. '7' )+ ( INTEGER_TYPE_SUFFIX )? )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:211:17: '0' ( '0' .. '7' )+ ( INTEGER_TYPE_SUFFIX )?
            {
            match('0'); if (state.failed) return ;

            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:211:21: ( '0' .. '7' )+
            int cnt9=0;
            loop9:
            do {
                int alt9=2;
                int LA9_0 = input.LA(1);

                if ( ((LA9_0 >= '0' && LA9_0 <= '7')) ) {
                    alt9=1;
                }


                switch (alt9) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
            	        input.consume();
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt9 >= 1 ) break loop9;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(9, input);
                        throw eee;
                }
                cnt9++;
            } while (true);


            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:211:33: ( INTEGER_TYPE_SUFFIX )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0=='L'||LA10_0=='l') ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    {
                    if ( input.LA(1)=='L'||input.LA(1)=='l' ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "OCTAL_LITERAL"

    // $ANTLR start "HEX_DIGIT"
    public final void mHEX_DIGIT() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:214:11: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            {
            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                input.consume();
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "HEX_DIGIT"

    // $ANTLR start "INTEGER_TYPE_SUFFIX"
    public final void mINTEGER_TYPE_SUFFIX() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:217:21: ( ( 'l' | 'L' ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            {
            if ( input.LA(1)=='L'||input.LA(1)=='l' ) {
                input.consume();
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "INTEGER_TYPE_SUFFIX"

    // $ANTLR start "FLOATING_POINT_LITERAL"
    public final void mFLOATING_POINT_LITERAL() throws RecognitionException {
        try {
            int _type = FLOATING_POINT_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:2: ( ( '0' .. '9' )+ '.' ( '0' .. '9' )* ( EXPONENT )? ( FLOAT_TYPE_SUFFIX )? | '.' ( '0' .. '9' )+ ( EXPONENT )? ( FLOAT_TYPE_SUFFIX )? | ( '0' .. '9' )+ EXPONENT ( FLOAT_TYPE_SUFFIX )? | ( '0' .. '9' )+ FLOAT_TYPE_SUFFIX )
            int alt21=4;
            alt21 = dfa21.predict(input);
            switch (alt21) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:4: ( '0' .. '9' )+ '.' ( '0' .. '9' )* ( EXPONENT )? ( FLOAT_TYPE_SUFFIX )?
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:4: ( '0' .. '9' )+
                    int cnt11=0;
                    loop11:
                    do {
                        int alt11=2;
                        int LA11_0 = input.LA(1);

                        if ( ((LA11_0 >= '0' && LA11_0 <= '9')) ) {
                            alt11=1;
                        }


                        switch (alt11) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt11 >= 1 ) break loop11;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(11, input);
                                throw eee;
                        }
                        cnt11++;
                    } while (true);


                    match('.'); if (state.failed) return ;

                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:20: ( '0' .. '9' )*
                    loop12:
                    do {
                        int alt12=2;
                        int LA12_0 = input.LA(1);

                        if ( ((LA12_0 >= '0' && LA12_0 <= '9')) ) {
                            alt12=1;
                        }


                        switch (alt12) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop12;
                        }
                    } while (true);


                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:32: ( EXPONENT )?
                    int alt13=2;
                    int LA13_0 = input.LA(1);

                    if ( (LA13_0=='E'||LA13_0=='e') ) {
                        alt13=1;
                    }
                    switch (alt13) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:32: EXPONENT
                            {
                            mEXPONENT(); if (state.failed) return ;


                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:220:42: ( FLOAT_TYPE_SUFFIX )?
                    int alt14=2;
                    int LA14_0 = input.LA(1);

                    if ( (LA14_0=='D'||LA14_0=='F'||LA14_0=='d'||LA14_0=='f') ) {
                        alt14=1;
                    }
                    switch (alt14) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                            {
                            if ( input.LA(1)=='D'||input.LA(1)=='F'||input.LA(1)=='d'||input.LA(1)=='f' ) {
                                input.consume();
                                state.failed=false;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return ;}
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:221:4: '.' ( '0' .. '9' )+ ( EXPONENT )? ( FLOAT_TYPE_SUFFIX )?
                    {
                    match('.'); if (state.failed) return ;

                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:221:8: ( '0' .. '9' )+
                    int cnt15=0;
                    loop15:
                    do {
                        int alt15=2;
                        int LA15_0 = input.LA(1);

                        if ( ((LA15_0 >= '0' && LA15_0 <= '9')) ) {
                            alt15=1;
                        }


                        switch (alt15) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt15 >= 1 ) break loop15;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(15, input);
                                throw eee;
                        }
                        cnt15++;
                    } while (true);


                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:221:20: ( EXPONENT )?
                    int alt16=2;
                    int LA16_0 = input.LA(1);

                    if ( (LA16_0=='E'||LA16_0=='e') ) {
                        alt16=1;
                    }
                    switch (alt16) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:221:20: EXPONENT
                            {
                            mEXPONENT(); if (state.failed) return ;


                            }
                            break;

                    }


                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:221:30: ( FLOAT_TYPE_SUFFIX )?
                    int alt17=2;
                    int LA17_0 = input.LA(1);

                    if ( (LA17_0=='D'||LA17_0=='F'||LA17_0=='d'||LA17_0=='f') ) {
                        alt17=1;
                    }
                    switch (alt17) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                            {
                            if ( input.LA(1)=='D'||input.LA(1)=='F'||input.LA(1)=='d'||input.LA(1)=='f' ) {
                                input.consume();
                                state.failed=false;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return ;}
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:222:4: ( '0' .. '9' )+ EXPONENT ( FLOAT_TYPE_SUFFIX )?
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:222:4: ( '0' .. '9' )+
                    int cnt18=0;
                    loop18:
                    do {
                        int alt18=2;
                        int LA18_0 = input.LA(1);

                        if ( ((LA18_0 >= '0' && LA18_0 <= '9')) ) {
                            alt18=1;
                        }


                        switch (alt18) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt18 >= 1 ) break loop18;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(18, input);
                                throw eee;
                        }
                        cnt18++;
                    } while (true);


                    mEXPONENT(); if (state.failed) return ;


                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:222:25: ( FLOAT_TYPE_SUFFIX )?
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0=='D'||LA19_0=='F'||LA19_0=='d'||LA19_0=='f') ) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                            {
                            if ( input.LA(1)=='D'||input.LA(1)=='F'||input.LA(1)=='d'||input.LA(1)=='f' ) {
                                input.consume();
                                state.failed=false;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return ;}
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:223:4: ( '0' .. '9' )+ FLOAT_TYPE_SUFFIX
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:223:4: ( '0' .. '9' )+
                    int cnt20=0;
                    loop20:
                    do {
                        int alt20=2;
                        int LA20_0 = input.LA(1);

                        if ( ((LA20_0 >= '0' && LA20_0 <= '9')) ) {
                            alt20=1;
                        }


                        switch (alt20) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    if ( cnt20 >= 1 ) break loop20;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(20, input);
                                throw eee;
                        }
                        cnt20++;
                    } while (true);


                    mFLOAT_TYPE_SUFFIX(); if (state.failed) return ;


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FLOATING_POINT_LITERAL"

    // $ANTLR start "EXPONENT"
    public final void mEXPONENT() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:227:10: ( ( 'e' | 'E' ) ( '+' | '-' )? ( '0' .. '9' )+ )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:227:12: ( 'e' | 'E' ) ( '+' | '-' )? ( '0' .. '9' )+
            {
            if ( input.LA(1)=='E'||input.LA(1)=='e' ) {
                input.consume();
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:227:22: ( '+' | '-' )?
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0=='+'||LA22_0=='-') ) {
                alt22=1;
            }
            switch (alt22) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
                    {
                    if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:227:33: ( '0' .. '9' )+
            int cnt23=0;
            loop23:
            do {
                int alt23=2;
                int LA23_0 = input.LA(1);

                if ( ((LA23_0 >= '0' && LA23_0 <= '9')) ) {
                    alt23=1;
                }


                switch (alt23) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
            	        input.consume();
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt23 >= 1 ) break loop23;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(23, input);
                        throw eee;
                }
                cnt23++;
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "EXPONENT"

    // $ANTLR start "FLOAT_TYPE_SUFFIX"
    public final void mFLOAT_TYPE_SUFFIX() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:230:19: ( ( 'f' | 'F' | 'd' | 'D' ) )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            {
            if ( input.LA(1)=='D'||input.LA(1)=='F'||input.LA(1)=='d'||input.LA(1)=='f' ) {
                input.consume();
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FLOAT_TYPE_SUFFIX"

    // $ANTLR start "CHARACTER_LITERAL"
    public final void mCHARACTER_LITERAL() throws RecognitionException {
        try {
            int _type = CHARACTER_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:233:2: ( '\\'' ( ESCAPE_SEQUENCE |~ ( '\\'' | '\\\\' ) ) '\\'' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:233:4: '\\'' ( ESCAPE_SEQUENCE |~ ( '\\'' | '\\\\' ) ) '\\''
            {
            match('\''); if (state.failed) return ;

            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:233:9: ( ESCAPE_SEQUENCE |~ ( '\\'' | '\\\\' ) )
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( (LA24_0=='\\') ) {
                alt24=1;
            }
            else if ( ((LA24_0 >= '\u0000' && LA24_0 <= '&')||(LA24_0 >= '(' && LA24_0 <= '[')||(LA24_0 >= ']' && LA24_0 <= '\uFFFF')) ) {
                alt24=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;

            }
            switch (alt24) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:233:11: ESCAPE_SEQUENCE
                    {
                    mESCAPE_SEQUENCE(); if (state.failed) return ;


                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:233:29: ~ ( '\\'' | '\\\\' )
                    {
                    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            match('\''); if (state.failed) return ;

            if ( state.backtracking==0 ) {setText(getText().substring(1, getText().length()-1));}

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CHARACTER_LITERAL"

    // $ANTLR start "STRING_LITERAL"
    public final void mSTRING_LITERAL() throws RecognitionException {
        try {
            int _type = STRING_LITERAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:237:2: ( '\"' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\"' ) )* '\"' | ( '\\'' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\\'' ) )* '\\'' )+ )
            int alt28=2;
            int LA28_0 = input.LA(1);

            if ( (LA28_0=='\"') ) {
                alt28=1;
            }
            else if ( (LA28_0=='\'') ) {
                alt28=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 28, 0, input);

                throw nvae;

            }
            switch (alt28) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:237:4: '\"' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\"' ) )* '\"'
                    {
                    match('\"'); if (state.failed) return ;

                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:237:8: ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\"' ) )*
                    loop25:
                    do {
                        int alt25=3;
                        int LA25_0 = input.LA(1);

                        if ( (LA25_0=='\\') ) {
                            alt25=1;
                        }
                        else if ( ((LA25_0 >= '\u0000' && LA25_0 <= '!')||(LA25_0 >= '#' && LA25_0 <= '[')||(LA25_0 >= ']' && LA25_0 <= '\uFFFF')) ) {
                            alt25=2;
                        }


                        switch (alt25) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:237:10: ESCAPE_SEQUENCE
                    	    {
                    	    mESCAPE_SEQUENCE(); if (state.failed) return ;


                    	    }
                    	    break;
                    	case 2 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:237:28: ~ ( '\\\\' | '\"' )
                    	    {
                    	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
                    	        input.consume();
                    	        state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop25;
                        }
                    } while (true);


                    match('\"'); if (state.failed) return ;

                    if ( state.backtracking==0 ) {setText(getText().substring(1, getText().length()-1));}

                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:238:4: ( '\\'' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\\'' ) )* '\\'' )+
                    {
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:238:4: ( '\\'' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\\'' ) )* '\\'' )+
                    int cnt27=0;
                    loop27:
                    do {
                        int alt27=2;
                        int LA27_0 = input.LA(1);

                        if ( (LA27_0=='\'') ) {
                            alt27=1;
                        }


                        switch (alt27) {
                    	case 1 :
                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:238:5: '\\'' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\\'' ) )* '\\''
                    	    {
                    	    match('\''); if (state.failed) return ;

                    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:238:10: ( ESCAPE_SEQUENCE |~ ( '\\\\' | '\\'' ) )*
                    	    loop26:
                    	    do {
                    	        int alt26=3;
                    	        int LA26_0 = input.LA(1);

                    	        if ( (LA26_0=='\\') ) {
                    	            alt26=1;
                    	        }
                    	        else if ( ((LA26_0 >= '\u0000' && LA26_0 <= '&')||(LA26_0 >= '(' && LA26_0 <= '[')||(LA26_0 >= ']' && LA26_0 <= '\uFFFF')) ) {
                    	            alt26=2;
                    	        }


                    	        switch (alt26) {
                    	    	case 1 :
                    	    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:238:12: ESCAPE_SEQUENCE
                    	    	    {
                    	    	    mESCAPE_SEQUENCE(); if (state.failed) return ;


                    	    	    }
                    	    	    break;
                    	    	case 2 :
                    	    	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:238:30: ~ ( '\\\\' | '\\'' )
                    	    	    {
                    	    	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
                    	    	        input.consume();
                    	    	        state.failed=false;
                    	    	    }
                    	    	    else {
                    	    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	    	        recover(mse);
                    	    	        throw mse;
                    	    	    }


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop26;
                    	        }
                    	    } while (true);


                    	    match('\''); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt27 >= 1 ) break loop27;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(27, input);
                                throw eee;
                        }
                        cnt27++;
                    } while (true);


                    if ( state.backtracking==0 ) {setText(getText().substring(1, getText().length()-1));}

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING_LITERAL"

    // $ANTLR start "ESCAPE_SEQUENCE"
    public final void mESCAPE_SEQUENCE() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:243:2: ( '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' ) | UNICODE_ESCAPE | OCTAL_ESCAPE )
            int alt29=3;
            int LA29_0 = input.LA(1);

            if ( (LA29_0=='\\') ) {
                switch ( input.LA(2) ) {
                case '\"':
                case '\'':
                case '\\':
                case 'b':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                    {
                    alt29=1;
                    }
                    break;
                case 'u':
                    {
                    alt29=2;
                    }
                    break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt29=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 29, 1, input);

                    throw nvae;

                }

            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 29, 0, input);

                throw nvae;

            }
            switch (alt29) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:243:4: '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' )
                    {
                    match('\\'); if (state.failed) return ;

                    if ( input.LA(1)=='\"'||input.LA(1)=='\''||input.LA(1)=='\\'||input.LA(1)=='b'||input.LA(1)=='f'||input.LA(1)=='n'||input.LA(1)=='r'||input.LA(1)=='t' ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:244:4: UNICODE_ESCAPE
                    {
                    mUNICODE_ESCAPE(); if (state.failed) return ;


                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:245:4: OCTAL_ESCAPE
                    {
                    mOCTAL_ESCAPE(); if (state.failed) return ;


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ESCAPE_SEQUENCE"

    // $ANTLR start "OCTAL_ESCAPE"
    public final void mOCTAL_ESCAPE() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:250:2: ( '\\\\' ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | '\\\\' ( '0' .. '7' ) ( '0' .. '7' ) | '\\\\' ( '0' .. '7' ) )
            int alt30=3;
            int LA30_0 = input.LA(1);

            if ( (LA30_0=='\\') ) {
                int LA30_1 = input.LA(2);

                if ( ((LA30_1 >= '0' && LA30_1 <= '3')) ) {
                    int LA30_2 = input.LA(3);

                    if ( ((LA30_2 >= '0' && LA30_2 <= '7')) ) {
                        int LA30_4 = input.LA(4);

                        if ( ((LA30_4 >= '0' && LA30_4 <= '7')) ) {
                            alt30=1;
                        }
                        else {
                            alt30=2;
                        }
                    }
                    else {
                        alt30=3;
                    }
                }
                else if ( ((LA30_1 >= '4' && LA30_1 <= '7')) ) {
                    int LA30_3 = input.LA(3);

                    if ( ((LA30_3 >= '0' && LA30_3 <= '7')) ) {
                        alt30=2;
                    }
                    else {
                        alt30=3;
                    }
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 30, 1, input);

                    throw nvae;

                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;

            }
            switch (alt30) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:250:4: '\\\\' ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    match('\\'); if (state.failed) return ;

                    if ( (input.LA(1) >= '0' && input.LA(1) <= '3') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:251:4: '\\\\' ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    match('\\'); if (state.failed) return ;

                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:252:4: '\\\\' ( '0' .. '7' )
                    {
                    match('\\'); if (state.failed) return ;

                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "OCTAL_ESCAPE"

    // $ANTLR start "UNICODE_ESCAPE"
    public final void mUNICODE_ESCAPE() throws RecognitionException {
        try {
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:257:2: ( '\\\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:257:4: '\\\\' 'u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
            {
            match('\\'); if (state.failed) return ;

            match('u'); if (state.failed) return ;

            mHEX_DIGIT(); if (state.failed) return ;


            mHEX_DIGIT(); if (state.failed) return ;


            mHEX_DIGIT(); if (state.failed) return ;


            mHEX_DIGIT(); if (state.failed) return ;


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "UNICODE_ESCAPE"

    // $ANTLR start "TRUE"
    public final void mTRUE() throws RecognitionException {
        try {
            int _type = TRUE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:261:2: ( 'true' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:261:4: 'true'
            {
            match("true"); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "TRUE"

    // $ANTLR start "FALSE"
    public final void mFALSE() throws RecognitionException {
        try {
            int _type = FALSE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:265:2: ( 'false' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:265:4: 'false'
            {
            match("false"); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FALSE"

    // $ANTLR start "NULL"
    public final void mNULL() throws RecognitionException {
        try {
            int _type = NULL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:269:2: ( 'null' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:269:4: 'null'
            {
            match("null"); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NULL"

    // $ANTLR start "EQUALS"
    public final void mEQUALS() throws RecognitionException {
        try {
            int _type = EQUALS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:273:2: ( '=' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:273:4: '='
            {
            match('='); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "EQUALS"

    // $ANTLR start "SEMICOLON"
    public final void mSEMICOLON() throws RecognitionException {
        try {
            int _type = SEMICOLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:277:2: ( ';' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:277:4: ';'
            {
            match(';'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SEMICOLON"

    // $ANTLR start "COLON"
    public final void mCOLON() throws RecognitionException {
        try {
            int _type = COLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:281:2: ( ':' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:281:4: ':'
            {
            match(':'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COLON"

    // $ANTLR start "NOT_EQUAL"
    public final void mNOT_EQUAL() throws RecognitionException {
        try {
            int _type = NOT_EQUAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:285:2: ( '!=' | '^=' | '<>' )
            int alt31=3;
            switch ( input.LA(1) ) {
            case '!':
                {
                alt31=1;
                }
                break;
            case '^':
                {
                alt31=2;
                }
                break;
            case '<':
                {
                alt31=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 31, 0, input);

                throw nvae;

            }

            switch (alt31) {
                case 1 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:285:4: '!='
                    {
                    match("!="); if (state.failed) return ;



                    }
                    break;
                case 2 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:286:4: '^='
                    {
                    match("^="); if (state.failed) return ;



                    }
                    break;
                case 3 :
                    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:287:4: '<>'
                    {
                    match("<>"); if (state.failed) return ;



                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "NOT_EQUAL"

    // $ANTLR start "PIPE"
    public final void mPIPE() throws RecognitionException {
        try {
            int _type = PIPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:291:2: ( '|' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:291:4: '|'
            {
            match('|'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PIPE"

    // $ANTLR start "DOUBLE_PIPE"
    public final void mDOUBLE_PIPE() throws RecognitionException {
        try {
            int _type = DOUBLE_PIPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:295:2: ( '||' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:295:4: '||'
            {
            match("||"); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOUBLE_PIPE"

    // $ANTLR start "PARAM"
    public final void mPARAM() throws RecognitionException {
        try {
            int _type = PARAM;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:298:7: ( '?' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:298:9: '?'
            {
            match('?'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PARAM"

    // $ANTLR start "GREATER"
    public final void mGREATER() throws RecognitionException {
        try {
            int _type = GREATER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:302:2: ( '>' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:302:4: '>'
            {
            match('>'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "GREATER"

    // $ANTLR start "GREATER_EQUAL"
    public final void mGREATER_EQUAL() throws RecognitionException {
        try {
            int _type = GREATER_EQUAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:306:2: ( '>=' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:306:4: '>='
            {
            match(">="); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "GREATER_EQUAL"

    // $ANTLR start "LESS"
    public final void mLESS() throws RecognitionException {
        try {
            int _type = LESS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:310:2: ( '<' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:310:4: '<'
            {
            match('<'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LESS"

    // $ANTLR start "LESS_EQUAL"
    public final void mLESS_EQUAL() throws RecognitionException {
        try {
            int _type = LESS_EQUAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:314:2: ( '<=' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:314:4: '<='
            {
            match("<="); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LESS_EQUAL"

    // $ANTLR start "ARROW"
    public final void mARROW() throws RecognitionException {
        try {
            int _type = ARROW;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:318:2: ( '->' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:318:4: '->'
            {
            match("->"); if (state.failed) return ;



            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ARROW"

    // $ANTLR start "IDENTIFIER"
    public final void mIDENTIFIER() throws RecognitionException {
        try {
            int _type = IDENTIFIER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:322:2: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '$' | '\\u0080' .. '\\ufffe' ) ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '$' | '0' .. '9' | '\\u0080' .. '\\ufffe' )* )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:322:4: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '$' | '\\u0080' .. '\\ufffe' ) ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '$' | '0' .. '9' | '\\u0080' .. '\\ufffe' )*
            {
            if ( input.LA(1)=='$'||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\uFFFE') ) {
                input.consume();
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:322:50: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | '$' | '0' .. '9' | '\\u0080' .. '\\ufffe' )*
            loop32:
            do {
                int alt32=2;
                int LA32_0 = input.LA(1);

                if ( (LA32_0=='$'||(LA32_0 >= '0' && LA32_0 <= '9')||(LA32_0 >= 'A' && LA32_0 <= 'Z')||LA32_0=='_'||(LA32_0 >= 'a' && LA32_0 <= 'z')||(LA32_0 >= '\u0080' && LA32_0 <= '\uFFFE')) ) {
                    alt32=1;
                }


                switch (alt32) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:
            	    {
            	    if ( input.LA(1)=='$'||(input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\uFFFE') ) {
            	        input.consume();
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop32;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IDENTIFIER"

    // $ANTLR start "QUOTED_IDENTIFIER"
    public final void mQUOTED_IDENTIFIER() throws RecognitionException {
        try {
            int _type = QUOTED_IDENTIFIER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:326:2: ( '`' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '`' ) )* '`' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:326:4: '`' ( ESCAPE_SEQUENCE |~ ( '\\\\' | '`' ) )* '`'
            {
            match('`'); if (state.failed) return ;

            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:326:8: ( ESCAPE_SEQUENCE |~ ( '\\\\' | '`' ) )*
            loop33:
            do {
                int alt33=3;
                int LA33_0 = input.LA(1);

                if ( (LA33_0=='\\') ) {
                    alt33=1;
                }
                else if ( ((LA33_0 >= '\u0000' && LA33_0 <= '[')||(LA33_0 >= ']' && LA33_0 <= '_')||(LA33_0 >= 'a' && LA33_0 <= '\uFFFF')) ) {
                    alt33=2;
                }


                switch (alt33) {
            	case 1 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:326:10: ESCAPE_SEQUENCE
            	    {
            	    mESCAPE_SEQUENCE(); if (state.failed) return ;


            	    }
            	    break;
            	case 2 :
            	    // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:326:28: ~ ( '\\\\' | '`' )
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '_')||(input.LA(1) >= 'a' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop33;
                }
            } while (true);


            match('`'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "QUOTED_IDENTIFIER"

    // $ANTLR start "LEFT_PAREN"
    public final void mLEFT_PAREN() throws RecognitionException {
        try {
            int _type = LEFT_PAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:330:2: ( '(' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:330:4: '('
            {
            match('('); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LEFT_PAREN"

    // $ANTLR start "RIGHT_PAREN"
    public final void mRIGHT_PAREN() throws RecognitionException {
        try {
            int _type = RIGHT_PAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:334:2: ( ')' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:334:4: ')'
            {
            match(')'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "RIGHT_PAREN"

    // $ANTLR start "LEFT_SQUARE"
    public final void mLEFT_SQUARE() throws RecognitionException {
        try {
            int _type = LEFT_SQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:338:2: ( '[' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:338:4: '['
            {
            match('['); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LEFT_SQUARE"

    // $ANTLR start "RIGHT_SQUARE"
    public final void mRIGHT_SQUARE() throws RecognitionException {
        try {
            int _type = RIGHT_SQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:342:2: ( ']' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:342:4: ']'
            {
            match(']'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "RIGHT_SQUARE"

    // $ANTLR start "COMMA"
    public final void mCOMMA() throws RecognitionException {
        try {
            int _type = COMMA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:345:7: ( ',' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:345:9: ','
            {
            match(','); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COMMA"

    // $ANTLR start "DOT"
    public final void mDOT() throws RecognitionException {
        try {
            int _type = DOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:348:5: ( '.' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:348:7: '.'
            {
            match('.'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DOT"

    // $ANTLR start "PLUS"
    public final void mPLUS() throws RecognitionException {
        try {
            int _type = PLUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:351:6: ( '+' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:351:8: '+'
            {
            match('+'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PLUS"

    // $ANTLR start "MINUS"
    public final void mMINUS() throws RecognitionException {
        try {
            int _type = MINUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:354:7: ( '-' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:354:9: '-'
            {
            match('-'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "MINUS"

    // $ANTLR start "ASTERISK"
    public final void mASTERISK() throws RecognitionException {
        try {
            int _type = ASTERISK;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:358:2: ( '*' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:358:4: '*'
            {
            match('*'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "ASTERISK"

    // $ANTLR start "SOLIDUS"
    public final void mSOLIDUS() throws RecognitionException {
        try {
            int _type = SOLIDUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:361:9: ( '/' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:361:11: '/'
            {
            match('/'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "SOLIDUS"

    // $ANTLR start "PERCENT"
    public final void mPERCENT() throws RecognitionException {
        try {
            int _type = PERCENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:364:9: ( '%' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:364:11: '%'
            {
            match('%'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "PERCENT"

    // $ANTLR start "AMPERSAND"
    public final void mAMPERSAND() throws RecognitionException {
        try {
            int _type = AMPERSAND;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:368:2: ( '&' )
            // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:368:4: '&'
            {
            match('&'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "AMPERSAND"

    public void mTokens() throws RecognitionException {
        // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:8: ( WS | HEX_LITERAL | INTEGER_LITERAL | DECIMAL_LITERAL | OCTAL_LITERAL | FLOATING_POINT_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | TRUE | FALSE | NULL | EQUALS | SEMICOLON | COLON | NOT_EQUAL | PIPE | DOUBLE_PIPE | PARAM | GREATER | GREATER_EQUAL | LESS | LESS_EQUAL | ARROW | IDENTIFIER | QUOTED_IDENTIFIER | LEFT_PAREN | RIGHT_PAREN | LEFT_SQUARE | RIGHT_SQUARE | COMMA | DOT | PLUS | MINUS | ASTERISK | SOLIDUS | PERCENT | AMPERSAND )
        int alt34=37;
        alt34 = dfa34.predict(input);
        switch (alt34) {
            case 1 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:10: WS
                {
                mWS(); if (state.failed) return ;


                }
                break;
            case 2 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:13: HEX_LITERAL
                {
                mHEX_LITERAL(); if (state.failed) return ;


                }
                break;
            case 3 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:25: INTEGER_LITERAL
                {
                mINTEGER_LITERAL(); if (state.failed) return ;


                }
                break;
            case 4 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:41: DECIMAL_LITERAL
                {
                mDECIMAL_LITERAL(); if (state.failed) return ;


                }
                break;
            case 5 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:57: OCTAL_LITERAL
                {
                mOCTAL_LITERAL(); if (state.failed) return ;


                }
                break;
            case 6 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:71: FLOATING_POINT_LITERAL
                {
                mFLOATING_POINT_LITERAL(); if (state.failed) return ;


                }
                break;
            case 7 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:94: CHARACTER_LITERAL
                {
                mCHARACTER_LITERAL(); if (state.failed) return ;


                }
                break;
            case 8 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:112: STRING_LITERAL
                {
                mSTRING_LITERAL(); if (state.failed) return ;


                }
                break;
            case 9 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:127: TRUE
                {
                mTRUE(); if (state.failed) return ;


                }
                break;
            case 10 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:132: FALSE
                {
                mFALSE(); if (state.failed) return ;


                }
                break;
            case 11 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:138: NULL
                {
                mNULL(); if (state.failed) return ;


                }
                break;
            case 12 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:143: EQUALS
                {
                mEQUALS(); if (state.failed) return ;


                }
                break;
            case 13 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:150: SEMICOLON
                {
                mSEMICOLON(); if (state.failed) return ;


                }
                break;
            case 14 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:160: COLON
                {
                mCOLON(); if (state.failed) return ;


                }
                break;
            case 15 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:166: NOT_EQUAL
                {
                mNOT_EQUAL(); if (state.failed) return ;


                }
                break;
            case 16 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:176: PIPE
                {
                mPIPE(); if (state.failed) return ;


                }
                break;
            case 17 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:181: DOUBLE_PIPE
                {
                mDOUBLE_PIPE(); if (state.failed) return ;


                }
                break;
            case 18 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:193: PARAM
                {
                mPARAM(); if (state.failed) return ;


                }
                break;
            case 19 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:199: GREATER
                {
                mGREATER(); if (state.failed) return ;


                }
                break;
            case 20 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:207: GREATER_EQUAL
                {
                mGREATER_EQUAL(); if (state.failed) return ;


                }
                break;
            case 21 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:221: LESS
                {
                mLESS(); if (state.failed) return ;


                }
                break;
            case 22 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:226: LESS_EQUAL
                {
                mLESS_EQUAL(); if (state.failed) return ;


                }
                break;
            case 23 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:237: ARROW
                {
                mARROW(); if (state.failed) return ;


                }
                break;
            case 24 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:243: IDENTIFIER
                {
                mIDENTIFIER(); if (state.failed) return ;


                }
                break;
            case 25 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:254: QUOTED_IDENTIFIER
                {
                mQUOTED_IDENTIFIER(); if (state.failed) return ;


                }
                break;
            case 26 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:272: LEFT_PAREN
                {
                mLEFT_PAREN(); if (state.failed) return ;


                }
                break;
            case 27 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:283: RIGHT_PAREN
                {
                mRIGHT_PAREN(); if (state.failed) return ;


                }
                break;
            case 28 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:295: LEFT_SQUARE
                {
                mLEFT_SQUARE(); if (state.failed) return ;


                }
                break;
            case 29 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:307: RIGHT_SQUARE
                {
                mRIGHT_SQUARE(); if (state.failed) return ;


                }
                break;
            case 30 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:320: COMMA
                {
                mCOMMA(); if (state.failed) return ;


                }
                break;
            case 31 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:326: DOT
                {
                mDOT(); if (state.failed) return ;


                }
                break;
            case 32 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:330: PLUS
                {
                mPLUS(); if (state.failed) return ;


                }
                break;
            case 33 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:335: MINUS
                {
                mMINUS(); if (state.failed) return ;


                }
                break;
            case 34 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:341: ASTERISK
                {
                mASTERISK(); if (state.failed) return ;


                }
                break;
            case 35 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:350: SOLIDUS
                {
                mSOLIDUS(); if (state.failed) return ;


                }
                break;
            case 36 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:358: PERCENT
                {
                mPERCENT(); if (state.failed) return ;


                }
                break;
            case 37 :
                // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:1:366: AMPERSAND
                {
                mAMPERSAND(); if (state.failed) return ;


                }
                break;

        }

    }

    // $ANTLR start synpred1_HQLLexer
    public final void synpred1_HQLLexer_fragment() throws RecognitionException {
        // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:199:4: ( '\\r\\n' )
        // org/hibernate/hql/ast/origin/hql/parse/HQLLexer.g:199:6: '\\r\\n'
        {
        match("\r\n"); if (state.failed) return ;



        }

    }
    // $ANTLR end synpred1_HQLLexer

    public final boolean synpred1_HQLLexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_HQLLexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA21 dfa21 = new DFA21(this);
    protected DFA34 dfa34 = new DFA34(this);
    static final String DFA21_eotS =
        "\6\uffff";
    static final String DFA21_eofS =
        "\6\uffff";
    static final String DFA21_minS =
        "\2\56\4\uffff";
    static final String DFA21_maxS =
        "\1\71\1\146\4\uffff";
    static final String DFA21_acceptS =
        "\2\uffff\1\2\1\1\1\3\1\4";
    static final String DFA21_specialS =
        "\6\uffff}>";
    static final String[] DFA21_transitionS = {
            "\1\2\1\uffff\12\1",
            "\1\3\1\uffff\12\1\12\uffff\1\5\1\4\1\5\35\uffff\1\5\1\4\1\5",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA21_eot = DFA.unpackEncodedString(DFA21_eotS);
    static final short[] DFA21_eof = DFA.unpackEncodedString(DFA21_eofS);
    static final char[] DFA21_min = DFA.unpackEncodedStringToUnsignedChars(DFA21_minS);
    static final char[] DFA21_max = DFA.unpackEncodedStringToUnsignedChars(DFA21_maxS);
    static final short[] DFA21_accept = DFA.unpackEncodedString(DFA21_acceptS);
    static final short[] DFA21_special = DFA.unpackEncodedString(DFA21_specialS);
    static final short[][] DFA21_transition;

    static {
        int numStates = DFA21_transitionS.length;
        DFA21_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA21_transition[i] = DFA.unpackEncodedString(DFA21_transitionS[i]);
        }
    }

    class DFA21 extends DFA {

        public DFA21(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 21;
            this.eot = DFA21_eot;
            this.eof = DFA21_eof;
            this.min = DFA21_min;
            this.max = DFA21_max;
            this.accept = DFA21_accept;
            this.special = DFA21_special;
            this.transition = DFA21_transition;
        }
        public String getDescription() {
            return "219:1: FLOATING_POINT_LITERAL : ( ( '0' .. '9' )+ '.' ( '0' .. '9' )* ( EXPONENT )? ( FLOAT_TYPE_SUFFIX )? | '.' ( '0' .. '9' )+ ( EXPONENT )? ( FLOAT_TYPE_SUFFIX )? | ( '0' .. '9' )+ EXPONENT ( FLOAT_TYPE_SUFFIX )? | ( '0' .. '9' )+ FLOAT_TYPE_SUFFIX );";
        }
    }
    static final String DFA34_eotS =
        "\2\uffff\2\40\1\45\2\uffff\3\23\4\uffff\1\54\1\56\1\uffff\1\60\1"+
        "\62\17\uffff\1\63\1\uffff\1\40\3\uffff\3\23\15\uffff\1\77\3\23\4"+
        "\uffff\1\105\1\23\1\107\3\uffff\1\111\4\uffff";
    static final String DFA34_eofS =
        "\113\uffff";
    static final String DFA34_minS =
        "\1\11\1\uffff\2\56\1\60\1\0\1\uffff\1\162\1\141\1\165\4\uffff\1"+
        "\75\1\174\1\uffff\1\75\1\76\17\uffff\1\56\1\uffff\1\56\1\uffff\1"+
        "\42\1\0\1\165\2\154\11\uffff\1\0\1\60\2\0\1\47\1\145\1\163\1\154"+
        "\1\60\2\0\1\uffff\1\44\1\145\1\44\1\60\1\0\1\uffff\1\44\1\uffff"+
        "\1\60\1\uffff\1\0";
    static final String DFA34_maxS =
        "\1\ufffe\1\uffff\1\170\1\154\1\71\1\uffff\1\uffff\1\162\1\141\1"+
        "\165\4\uffff\1\76\1\174\1\uffff\1\75\1\76\17\uffff\1\146\1\uffff"+
        "\1\154\1\uffff\1\165\1\uffff\1\165\2\154\11\uffff\1\uffff\1\146"+
        "\2\uffff\1\47\1\145\1\163\1\154\1\146\2\uffff\1\uffff\1\ufffe\1"+
        "\145\1\ufffe\1\146\1\uffff\1\uffff\1\ufffe\1\uffff\1\146\1\uffff"+
        "\1\uffff";
    static final String DFA34_acceptS =
        "\1\uffff\1\1\4\uffff\1\10\3\uffff\1\14\1\15\1\16\1\17\2\uffff\1"+
        "\22\2\uffff\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\40\1\42\1\43\1"+
        "\44\1\45\1\2\1\3\1\4\1\uffff\1\6\1\uffff\1\37\5\uffff\1\26\1\25"+
        "\1\21\1\20\1\24\1\23\1\27\1\41\1\5\13\uffff\1\7\5\uffff\1\11\1\uffff"+
        "\1\13\1\uffff\1\12\1\uffff";
    static final String DFA34_specialS =
        "\5\uffff\1\5\41\uffff\1\4\14\uffff\1\10\1\uffff\1\2\1\3\5\uffff"+
        "\1\1\1\7\5\uffff\1\6\5\uffff\1\0}>";
    static final String[] DFA34_transitionS = {
            "\2\1\1\uffff\2\1\22\uffff\1\1\1\15\1\6\1\uffff\1\23\1\35\1\36"+
            "\1\5\1\25\1\26\1\33\1\32\1\31\1\22\1\4\1\34\1\2\11\3\1\14\1"+
            "\13\1\16\1\12\1\21\1\20\1\uffff\32\23\1\27\1\uffff\1\30\1\15"+
            "\1\23\1\24\5\23\1\10\7\23\1\11\5\23\1\7\6\23\1\uffff\1\17\3"+
            "\uffff\uff7f\23",
            "",
            "\1\43\1\uffff\10\42\2\43\12\uffff\3\43\5\uffff\1\41\13\uffff"+
            "\1\37\13\uffff\3\43\5\uffff\1\41\13\uffff\1\37",
            "\1\43\1\uffff\12\44\12\uffff\3\43\5\uffff\1\41\27\uffff\3\43"+
            "\5\uffff\1\41",
            "\12\43",
            "\47\47\1\6\64\47\1\46\uffa3\47",
            "",
            "\1\50",
            "\1\51",
            "\1\52",
            "",
            "",
            "",
            "",
            "\1\53\1\15",
            "\1\55",
            "",
            "\1\57",
            "\1\61",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\43\1\uffff\10\42\2\43\12\uffff\3\43\35\uffff\3\43",
            "",
            "\1\43\1\uffff\12\44\12\uffff\3\43\5\uffff\1\41\27\uffff\3\43"+
            "\5\uffff\1\41",
            "",
            "\1\64\4\uffff\1\64\10\uffff\4\66\4\67\44\uffff\1\64\5\uffff"+
            "\1\64\3\uffff\1\64\7\uffff\1\64\3\uffff\1\64\1\uffff\1\64\1"+
            "\65",
            "\47\6\1\70\uffd8\6",
            "\1\71",
            "\1\72",
            "\1\73",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\47\6\1\70\uffd8\6",
            "\12\74\7\uffff\6\74\32\uffff\6\74",
            "\47\6\1\70\10\6\10\75\uffc8\6",
            "\47\6\1\70\10\6\10\76\uffc8\6",
            "\1\6",
            "\1\100",
            "\1\101",
            "\1\102",
            "\12\103\7\uffff\6\103\32\uffff\6\103",
            "\47\6\1\70\10\6\10\104\uffc8\6",
            "\47\6\1\70\uffd8\6",
            "",
            "\1\23\13\uffff\12\23\7\uffff\32\23\4\uffff\1\23\1\uffff\32"+
            "\23\5\uffff\uff7f\23",
            "\1\106",
            "\1\23\13\uffff\12\23\7\uffff\32\23\4\uffff\1\23\1\uffff\32"+
            "\23\5\uffff\uff7f\23",
            "\12\110\7\uffff\6\110\32\uffff\6\110",
            "\47\6\1\70\uffd8\6",
            "",
            "\1\23\13\uffff\12\23\7\uffff\32\23\4\uffff\1\23\1\uffff\32"+
            "\23\5\uffff\uff7f\23",
            "",
            "\12\112\7\uffff\6\112\32\uffff\6\112",
            "",
            "\47\6\1\70\uffd8\6"
    };

    static final short[] DFA34_eot = DFA.unpackEncodedString(DFA34_eotS);
    static final short[] DFA34_eof = DFA.unpackEncodedString(DFA34_eofS);
    static final char[] DFA34_min = DFA.unpackEncodedStringToUnsignedChars(DFA34_minS);
    static final char[] DFA34_max = DFA.unpackEncodedStringToUnsignedChars(DFA34_maxS);
    static final short[] DFA34_accept = DFA.unpackEncodedString(DFA34_acceptS);
    static final short[] DFA34_special = DFA.unpackEncodedString(DFA34_specialS);
    static final short[][] DFA34_transition;

    static {
        int numStates = DFA34_transitionS.length;
        DFA34_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA34_transition[i] = DFA.unpackEncodedString(DFA34_transitionS[i]);
        }
    }

    class DFA34 extends DFA {

        public DFA34(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 34;
            this.eot = DFA34_eot;
            this.eof = DFA34_eof;
            this.min = DFA34_min;
            this.max = DFA34_max;
            this.accept = DFA34_accept;
            this.special = DFA34_special;
            this.transition = DFA34_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( WS | HEX_LITERAL | INTEGER_LITERAL | DECIMAL_LITERAL | OCTAL_LITERAL | FLOATING_POINT_LITERAL | CHARACTER_LITERAL | STRING_LITERAL | TRUE | FALSE | NULL | EQUALS | SEMICOLON | COLON | NOT_EQUAL | PIPE | DOUBLE_PIPE | PARAM | GREATER | GREATER_EQUAL | LESS | LESS_EQUAL | ARROW | IDENTIFIER | QUOTED_IDENTIFIER | LEFT_PAREN | RIGHT_PAREN | LEFT_SQUARE | RIGHT_SQUARE | COMMA | DOT | PLUS | MINUS | ASTERISK | SOLIDUS | PERCENT | AMPERSAND );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA34_74 = input.LA(1);

                        s = -1;
                        if ( (LA34_74=='\'') ) {s = 56;}

                        else if ( ((LA34_74 >= '\u0000' && LA34_74 <= '&')||(LA34_74 >= '(' && LA34_74 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA34_61 = input.LA(1);

                        s = -1;
                        if ( ((LA34_61 >= '0' && LA34_61 <= '7')) ) {s = 68;}

                        else if ( (LA34_61=='\'') ) {s = 56;}

                        else if ( ((LA34_61 >= '\u0000' && LA34_61 <= '&')||(LA34_61 >= '(' && LA34_61 <= '/')||(LA34_61 >= '8' && LA34_61 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA34_54 = input.LA(1);

                        s = -1;
                        if ( ((LA34_54 >= '0' && LA34_54 <= '7')) ) {s = 61;}

                        else if ( (LA34_54=='\'') ) {s = 56;}

                        else if ( ((LA34_54 >= '\u0000' && LA34_54 <= '&')||(LA34_54 >= '(' && LA34_54 <= '/')||(LA34_54 >= '8' && LA34_54 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA34_55 = input.LA(1);

                        s = -1;
                        if ( ((LA34_55 >= '0' && LA34_55 <= '7')) ) {s = 62;}

                        else if ( (LA34_55=='\'') ) {s = 56;}

                        else if ( ((LA34_55 >= '\u0000' && LA34_55 <= '&')||(LA34_55 >= '(' && LA34_55 <= '/')||(LA34_55 >= '8' && LA34_55 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA34_39 = input.LA(1);

                        s = -1;
                        if ( (LA34_39=='\'') ) {s = 56;}

                        else if ( ((LA34_39 >= '\u0000' && LA34_39 <= '&')||(LA34_39 >= '(' && LA34_39 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA34_5 = input.LA(1);

                        s = -1;
                        if ( (LA34_5=='\\') ) {s = 38;}

                        else if ( ((LA34_5 >= '\u0000' && LA34_5 <= '&')||(LA34_5 >= '(' && LA34_5 <= '[')||(LA34_5 >= ']' && LA34_5 <= '\uFFFF')) ) {s = 39;}

                        else if ( (LA34_5=='\'') ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA34_68 = input.LA(1);

                        s = -1;
                        if ( (LA34_68=='\'') ) {s = 56;}

                        else if ( ((LA34_68 >= '\u0000' && LA34_68 <= '&')||(LA34_68 >= '(' && LA34_68 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA34_62 = input.LA(1);

                        s = -1;
                        if ( (LA34_62=='\'') ) {s = 56;}

                        else if ( ((LA34_62 >= '\u0000' && LA34_62 <= '&')||(LA34_62 >= '(' && LA34_62 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA34_52 = input.LA(1);

                        s = -1;
                        if ( (LA34_52=='\'') ) {s = 56;}

                        else if ( ((LA34_52 >= '\u0000' && LA34_52 <= '&')||(LA34_52 >= '(' && LA34_52 <= '\uFFFF')) ) {s = 6;}

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 34, _s, input);
            error(nvae);
            throw nvae;
        }

    }
 

}