/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi.predicate;

import org.hibernate.hql.ast.spi.predicate.AbstractPredicate;
import org.hibernate.hql.ast.spi.predicate.ParentPredicate;
import org.hibernate.hql.ast.spi.predicate.Predicate;
import org.hibernate.hql.internal.logging.Log;
import org.hibernate.hql.internal.logging.LoggerFactory;

public abstract class RootPredicate<Q>
extends AbstractPredicate<Q>
implements ParentPredicate<Q> {
    private static final Log log = LoggerFactory.make();
    protected Predicate<Q> child;

    public RootPredicate() {
        super(Predicate.Type.ROOT);
    }

    @Override
    public void add(Predicate<Q> predicate) {
        if (this.child != null) {
            throw log.getNotMoreThanOnePredicateInRootOfWhereClauseAllowedException(predicate);
        }
        this.child = predicate;
    }

    public String toString() {
        return this.child == null ? "( * )" : this.child.toString();
    }
}

