/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tck.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.hibernate.tck.report.AuditParser;
import org.hibernate.tck.report.CoverageReport;
import org.hibernate.tck.report.SpecReference;

@SupportedAnnotationTypes(value={"org.hibernate.tck.annotations.SpecAssertion", "org.hibernate.tck.annotations.SpecAssertions"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CoverageProcessor
extends AbstractProcessor {
    private static final String OUTDIR_OPTION_FLAG = "outputDir";
    private static final String AUDITFILE_OPTION_KEY = "auditXml";
    private static final String DEFAULT_AUDIT_FILE_NAME = "tck-audit.xml";
    private final List<SpecReference> references = new ArrayList<SpecReference>();
    private AuditParser auditParser;
    private File baseDir;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.createOutputDir();
        InputStream in = this.getAuditFileInputStream();
        if (in == null) {
            return;
        }
        try {
            this.auditParser = new AuditParser(in);
            this.auditParser.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse audit file.", e);
        }
    }

    private InputStream getAuditFileInputStream() {
        FileInputStream in;
        try {
            in = new FileInputStream(this.getAuditFile());
        }
        catch (IOException ex) {
            System.err.println("Unable to open audit file - " + this.getAuditFile().getAbsolutePath());
            System.err.println("No report generated");
            return null;
        }
        return in;
    }

    private File getAuditFile() {
        String auditFileName = this.processingEnv.getOptions().get(AUDITFILE_OPTION_KEY);
        if (auditFileName == null || auditFileName.length() == 0) {
            auditFileName = this.getCurrentWorkingDirectory() + DEFAULT_AUDIT_FILE_NAME;
            System.out.println("No audit file specified. Trying default: " + auditFileName);
        } else {
            System.out.println("Reading spec assertions from audit file: " + auditFileName);
        }
        return new File(auditFileName);
    }

    private File getImagesDir() {
        return new File(this.getAuditFile().getParentFile(), "/images");
    }

    private void createOutputDir() {
        String baseDirName = this.processingEnv.getOptions().get(OUTDIR_OPTION_FLAG);
        if (baseDirName == null) {
            baseDirName = this.getCurrentWorkingDirectory() + "target";
            System.out.println("No output directory specified, using " + baseDirName + " instead.");
        } else {
            System.out.println("Outputting to " + baseDirName);
        }
        this.baseDir = new File(baseDirName);
        this.baseDir.mkdirs();
    }

    private String getCurrentWorkingDirectory() {
        return System.getProperty("user.dir") + System.getProperty("file.separator");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (this.auditParser == null) {
            return false;
        }
        for (TypeElement typeElement : annotations) {
            this.processAnnotatedMethods(roundEnvironment, typeElement);
        }
        if (roundEnvironment.processingOver()) {
            try {
                new CoverageReport(this.references, this.auditParser, this.getImagesDir()).generate(this.baseDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void processAnnotatedMethods(RoundEnvironment env, TypeElement annotation) {
        Set<? extends Element> elements = env.getElementsAnnotatedWith(annotation);
        for (Element element : elements) {
            this.processMethod(element);
        }
    }

    private void processMethod(Element element) {
        ExecutableElement methodElement = (ExecutableElement)element;
        String annotationType = null;
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(methodElement)) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
            annotationType = annotationMirror.getAnnotationType().toString();
            if (annotationType.equals(SpecAssertions.class.getName())) {
                List mirrors = (List)annotationMirror.getElementValues().values().iterator().next().getValue();
                for (AnnotationMirror mirror : mirrors) {
                    this.createSpecReference(methodElement, this.processingEnv.getElementUtils().getElementValuesWithDefaults(mirror));
                }
                continue;
            }
            if (!annotationType.equals(SpecAssertion.class.getName())) continue;
            this.createSpecReference(methodElement, annotationParameters);
        }
    }

    private void createSpecReference(ExecutableElement methodElement, Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParameters) {
        SpecReference ref = new SpecReference();
        PackageElement packageElement = this.getEnclosingPackageElement(methodElement);
        ref.setPackageName(packageElement.getQualifiedName().toString());
        ref.setClassName(methodElement.getEnclosingElement().getSimpleName().toString());
        ref.setMethodName(methodElement.getSimpleName().toString());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationParameters.entrySet()) {
            String elementKey = entry.getKey().toString();
            if (elementKey.equals("section()")) {
                ref.setSection((String)entry.getValue().getValue());
                continue;
            }
            if (!elementKey.equals("id()")) continue;
            ref.setAssertion((String)entry.getValue().getValue());
        }
        for (AnnotationMirror annotationMirror : this.processingEnv.getElementUtils().getAllAnnotationMirrors(methodElement)) {
            if (!annotationMirror.getAnnotationType().toString().equals("org.testng.annotations.Test")) continue;
            Map<? extends ExecutableElement, ? extends AnnotationValue> testAnnotationParameters = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : testAnnotationParameters.entrySet()) {
                String elementKey = entry.getKey().toString();
                if (!elementKey.equals("groups()")) continue;
                for (AnnotationValue annotationValue : (List)entry.getValue().getValue()) {
                    ref.getGroups().add((String)annotationValue.getValue());
                }
            }
        }
        this.references.add(ref);
    }

    private PackageElement getEnclosingPackageElement(ExecutableElement methodElement) {
        Element enclosingElement;
        Element classElement = methodElement.getEnclosingElement();
        for (enclosingElement = classElement.getEnclosingElement(); !(enclosingElement instanceof PackageElement) && enclosingElement != null; enclosingElement = enclosingElement.getEnclosingElement()) {
        }
        return (PackageElement)enclosingElement;
    }
}

