/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import org.apache.tools.ant.BuildException;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.api.export.Exporter;
import org.hibernate.tool.api.export.ExporterFactory;
import org.hibernate.tool.api.export.ExporterType;
import org.hibernate.tool.util.ReflectionUtil;

public class GenericExporterTask
extends ExporterTask {
    String templateName;
    String exporterClass;
    String filePattern;
    String forEach;

    public GenericExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setForEach(String forEach) {
        this.forEach = forEach;
    }

    public void setTemplate(String templateName) {
        this.templateName = templateName;
    }

    public void setExporterClass(String exporterClass) {
        this.exporterClass = exporterClass;
    }

    @Override
    protected Exporter createExporter() {
        if (this.exporterClass == null) {
            return ExporterFactory.createExporter((ExporterType)ExporterType.GENERIC);
        }
        try {
            return (Exporter)ReflectionUtil.classForName((String)this.exporterClass).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Could not find custom exporter class: " + this.exporterClass, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Could not create custom exporter class: " + this.exporterClass, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Could not access custom exporter class: " + this.exporterClass, (Throwable)e);
        }
    }

    @Override
    protected Exporter configureExporter(Exporter exp) {
        super.configureExporter(exp);
        if (this.templateName != null) {
            exp.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.TemplateName", this.templateName);
        }
        if (this.filePattern != null) {
            exp.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.FilePattern", this.filePattern);
        }
        if (this.forEach != null) {
            exp.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.ForEach", this.forEach);
        }
        return exp;
    }

    @Override
    public String getName() {
        StringBuffer buf = new StringBuffer("generic exporter");
        if (this.exporterClass != null) {
            buf.append("class: " + this.exporterClass);
        }
        if (this.templateName != null) {
            buf.append("template: " + this.templateName);
        }
        return buf.toString();
    }
}

