/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.tool.api.metadata.MetadataDescriptor;
import org.hibernate.tool.api.metadata.MetadataDescriptorFactory;
import org.hibernate.tool.api.reveng.RevengSettings;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.RevengStrategyFactory;
import org.hibernate.tool.util.ReflectionUtil;

public class JDBCConfigurationTask
extends ConfigurationTask {
    private boolean preferBasicCompositeIds = true;
    private String reverseEngineeringStrategyClass;
    private String packageName;
    private Path revengFiles;
    private boolean detectOneToOne = true;
    private boolean detectManyToMany = true;
    private boolean detectOptimisticLock = true;

    public JDBCConfigurationTask() {
        this.setDescription("JDBC Configuration (for reverse engineering)");
    }

    @Override
    protected MetadataDescriptor createMetadataDescriptor() {
        Properties properties = this.loadPropertiesFile();
        RevengStrategy res = this.createReverseEngineeringStrategy();
        properties.put("org.hibernate.tool.api.metadata.MetadataConstants.PreferBasicCompositeIds", (Object)this.preferBasicCompositeIds);
        return MetadataDescriptorFactory.createReverseEngineeringDescriptor((RevengStrategy)res, (Properties)properties);
    }

    private RevengStrategy createReverseEngineeringStrategy() {
        File[] revengFileList = null;
        if (this.revengFiles != null) {
            String[] fileNames = this.revengFiles.list();
            revengFileList = new File[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                revengFileList[i] = new File(fileNames[i]);
            }
        }
        RevengStrategy strategy = RevengStrategyFactory.createReverseEngineeringStrategy(null, revengFileList);
        if (this.reverseEngineeringStrategyClass != null) {
            strategy = this.loadreverseEngineeringStrategy(this.reverseEngineeringStrategyClass, strategy);
        }
        RevengSettings qqsettings = new RevengSettings(strategy).setDefaultPackageName(this.packageName).setDetectManyToMany(this.detectManyToMany).setDetectOneToOne(this.detectOneToOne).setDetectOptimisticLock(this.detectOptimisticLock);
        strategy.setSettings(qqsettings);
        return strategy;
    }

    public void setPackageName(String pkgName) {
        this.packageName = pkgName;
    }

    public void setReverseStrategy(String fqn) {
        this.reverseEngineeringStrategyClass = fqn;
    }

    public void setRevEngFile(Path p) {
        this.revengFiles = p;
    }

    public void setPreferBasicCompositeIds(boolean b) {
        this.preferBasicCompositeIds = b;
    }

    public void setDetectOneToOne(boolean b) {
        this.detectOneToOne = b;
    }

    public void setDetectManyToMany(boolean b) {
        this.detectManyToMany = b;
    }

    public void setDetectOptimisticLock(boolean b) {
        this.detectOptimisticLock = b;
    }

    private RevengStrategy loadreverseEngineeringStrategy(String className, RevengStrategy delegate) throws BuildException {
        try {
            Class clazz = ReflectionUtil.classForName((String)className);
            Constructor constructor = clazz.getConstructor(RevengStrategy.class);
            return (RevengStrategy)constructor.newInstance(delegate);
        }
        catch (NoSuchMethodException e) {
            try {
                this.getProject().log("Could not find public " + className + "(ReverseEngineeringStrategy delegate) constructor on ReverseEngineeringStrategy. Trying no-arg version.", 3);
                Class clazz = ReflectionUtil.classForName((String)className);
                RevengStrategy rev = (RevengStrategy)clazz.newInstance();
                this.getProject().log("Using non-delegating strategy, thus packagename and revengfile will be ignored.", 2);
                return rev;
            }
            catch (Exception eq) {
                throw new BuildException("Could not create or find " + className + " with default no-arg constructor", (Throwable)eq);
            }
        }
        catch (Exception e) {
            throw new BuildException("Could not create or find " + className + " with one argument delegate constructor", (Throwable)e);
        }
    }
}

