/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.tool.api.java.DefaultJavaPrettyPrinterStrategy;

public class JavaFormatterTask
extends Task {
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private boolean failOnError;
    private File configurationFile;

    public void addConfiguredFileSet(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    private Properties readConfig(File cfgfile) throws IOException {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(cfgfile));
            Properties settings = new Properties();
            settings.load(stream);
            Properties properties = settings;
            return properties;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void execute() throws BuildException {
        Properties settings = null;
        if (this.configurationFile != null) {
            try {
                settings = this.readConfig(this.configurationFile);
            }
            catch (IOException e) {
                throw new BuildException("Could not read configurationfile " + this.configurationFile, (Throwable)e);
            }
        }
        File[] files = this.getFiles();
        int failed = 0;
        if (files.length > 0) {
            DefaultJavaPrettyPrinterStrategy formatter = new DefaultJavaPrettyPrinterStrategy((Map)settings);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                try {
                    boolean ok = formatter.formatFile(file);
                    if (!ok) {
                        ++failed;
                        this.getProject().log((Task)this, "Formatting failed - skipping " + file, 1);
                        continue;
                    }
                    this.getProject().log((Task)this, "Formatted " + file, 3);
                    continue;
                }
                catch (RuntimeException ee) {
                    ++failed;
                    if (this.failOnError) {
                        throw new BuildException("Java formatting failed on " + file, (Throwable)ee);
                    }
                    this.getProject().log((Task)this, "Java formatting failed on " + file + ", " + ee.getLocalizedMessage(), 0);
                }
            }
        }
        this.getProject().log((Task)this, "Java formatting of " + files.length + " files completed. Skipped " + failed + " file(s).", 2);
    }

    private File[] getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (FileSet fs : this.fileSets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] dsFiles = ds.getIncludedFiles();
            for (int j = 0; j < dsFiles.length; ++j) {
                File f = new File(dsFiles[j]);
                if (!f.isFile()) {
                    f = new File(ds.getBasedir(), dsFiles[j]);
                }
                files.add(f);
            }
        }
        return files.toArray(new File[files.size()]);
    }
}

