/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.tool.internal.export.common.ConfigurationNavigator;
import org.hibernate.tool.internal.export.java.Cfg2JavaTool;
import org.hibernate.tool.internal.export.java.ComponentPOJOClass;
import org.hibernate.tool.internal.export.java.POJOClass;
import org.hibernate.type.Type;

public final class DocHelper {
    static final Comparator<POJOClass> POJOCLASS_COMPARATOR = new Comparator<POJOClass>(){

        @Override
        public int compare(POJOClass left, POJOClass right) {
            return left.getDeclarationName().compareTo(right.getDeclarationName());
        }
    };
    private static final Comparator<Property> PROPERTY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property left, Property right) {
            return left.getName().compareTo(right.getName());
        }
    };
    public static final String DEFAULT_NO_SCHEMA_NAME = "default";
    public static final String DEFAULT_NO_PACKAGE = "All Entities";
    private Map<String, List<Table>> tablesBySchema = new HashMap<String, List<Table>>();
    private Map<String, List<POJOClass>> classesByPackage = new HashMap<String, List<POJOClass>>();
    private List<POJOClass> classes = new ArrayList<POJOClass>();
    private Map<String, List<Value>> valuesByColumn = new HashMap<String, List<Value>>();
    private Map<Value, List<Property>> propsByValue = new HashMap<Value, List<Property>>();
    private List<Table> tables = new ArrayList<Table>();
    private Map<Table, String> tableSchemaNames = new HashMap<Table, String>();
    private Dialect dialect;
    private Metadata metadata;

    public DocHelper(Metadata metadata, Properties properties, Cfg2JavaTool cfg2JavaTool) {
        if (metadata == null) {
            throw new IllegalArgumentException("Hibernate Configuration cannot be null");
        }
        this.metadata = metadata;
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        builder.applySettings((Map)properties);
        StandardServiceRegistry serviceRegistry = builder.build();
        JdbcServices jdbcServices = (JdbcServices)serviceRegistry.getService(JdbcServices.class);
        this.dialect = jdbcServices.getDialect();
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        if (defaultSchema == null) {
            defaultSchema = DEFAULT_NO_SCHEMA_NAME;
        }
        for (Table table : metadata.collectTableMappings()) {
            String schema;
            if (!table.isPhysicalTable()) continue;
            this.tables.add(table);
            StringBuffer sb = new StringBuffer();
            String catalog = table.getCatalog();
            if (catalog == null) {
                catalog = defaultCatalog;
            }
            if (catalog != null) {
                sb.append(catalog + ".");
            }
            if ((schema = table.getSchema()) == null) {
                schema = defaultSchema;
            }
            sb.append(schema);
            String qualSchemaName = sb.toString();
            this.tableSchemaNames.put(table, qualSchemaName);
            List<Table> tableList = this.tablesBySchema.get(qualSchemaName);
            if (tableList == null) {
                tableList = new ArrayList<Table>();
                this.tablesBySchema.put(qualSchemaName, tableList);
            }
            tableList.add(table);
            Iterator columns = table.getColumnIterator();
            while (columns.hasNext()) {
                Column column = (Column)columns.next();
                String columnFQN = this.getQualifiedColumnName(table, column);
                List<Value> values = this.valuesByColumn.get(columnFQN);
                if (values == null) {
                    values = new ArrayList<Value>();
                    this.valuesByColumn.put(columnFQN, values);
                }
                values.add(column.getValue());
            }
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        for (PersistentClass clazz : metadata.getEntityBindings()) {
            POJOClass pojoClazz = cfg2JavaTool.getPOJOClass(clazz);
            ConfigurationNavigator.collectComponents(components, pojoClazz);
            this.processClass(pojoClazz);
            Iterator propertyIterator = clazz.getPropertyIterator();
            while (propertyIterator.hasNext()) {
                Property property = (Property)propertyIterator.next();
                Value value = property.getValue();
                List<Property> props = this.propsByValue.get(value);
                if (props == null) {
                    props = new ArrayList<Property>();
                    this.propsByValue.put(value, props);
                }
                props.add(property);
            }
        }
        for (Component component : components.values()) {
            ComponentPOJOClass element = new ComponentPOJOClass(component, cfg2JavaTool);
            this.processClass(element);
        }
    }

    private void processClass(POJOClass pojoClazz) {
        List<POJOClass> classList;
        this.classes.add(pojoClazz);
        String packageName = pojoClazz.getPackageName();
        if ("".equals(packageName)) {
            packageName = DEFAULT_NO_PACKAGE;
        }
        if ((classList = this.classesByPackage.get(packageName)) == null) {
            classList = new ArrayList<POJOClass>();
            this.classesByPackage.put(packageName, classList);
        }
        classList.add(pojoClazz);
    }

    public Map<String, List<Table>> getTablesBySchema() {
        return this.tablesBySchema;
    }

    public Map<String, List<POJOClass>> getClassesByPackage() {
        return this.classesByPackage;
    }

    public List<String> getSchemas() {
        ArrayList<String> schemas = new ArrayList<String>(this.tablesBySchema.keySet());
        Collections.sort(schemas);
        return schemas;
    }

    public List<String> getPackages() {
        ArrayList<String> packages = new ArrayList<String>(this.classesByPackage.keySet());
        Collections.sort(packages);
        return packages;
    }

    public List<Table> getTables(String schema) {
        List<Table> list = this.tablesBySchema.get(schema);
        return list;
    }

    public List<POJOClass> getClasses(String packageName) {
        List<POJOClass> clazzes = this.classesByPackage.get(packageName);
        ArrayList<POJOClass> orderedClasses = new ArrayList<POJOClass>(clazzes);
        Collections.sort(orderedClasses, POJOCLASS_COMPARATOR);
        return orderedClasses;
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<POJOClass> getClasses() {
        ArrayList<POJOClass> orderedClasses = new ArrayList<POJOClass>(this.classes);
        Collections.sort(orderedClasses, POJOCLASS_COMPARATOR);
        return orderedClasses;
    }

    public String getQualifiedSchemaName(Table table) {
        return this.tableSchemaNames.get(table);
    }

    public String getQualifiedTableName(Table table) {
        String qualifiedSchemaName = this.getQualifiedSchemaName(table);
        return qualifiedSchemaName + '.' + table.getName();
    }

    public String getPropertyType(Property p) {
        Value v = p.getValue();
        String propertyString = "N/D";
        try {
            Type t = v.getType();
            propertyString = t.getReturnedClass().getName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propertyString;
    }

    public String getQualifiedColumnName(Table table, Column column) {
        String qualifiedTableName = this.getQualifiedTableName(table);
        return qualifiedTableName + '.' + column.getName();
    }

    public String getSQLTypeName(Column column) {
        try {
            return column.getSqlType(this.dialect, (Mapping)this.metadata);
        }
        catch (HibernateException ex) {
            return "N/D";
        }
    }

    public int getLength(Column column) {
        return column.getLength() == null ? 255 : column.getLength().intValue();
    }

    public int getPrecision(Column column) {
        return column.getPrecision() == null ? 19 : column.getPrecision();
    }

    public int getScale(Column column) {
        return column.getScale() == null ? 2 : column.getScale();
    }

    public Iterator<Column> getPrimaryKeyColumnIterator(Table table) {
        return table.getPrimaryKey().getColumnIterator();
    }

    public List<Value> getValues(Table table, Column column) {
        String columnFQN = this.getQualifiedColumnName(table, column);
        List<Value> values = this.valuesByColumn.get(columnFQN);
        if (values != null) {
            return values;
        }
        return new ArrayList<Value>();
    }

    public List<Property> getProperties(Table table, Column column) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Value value : this.getValues(table, column)) {
            List<Property> props = this.propsByValue.get(value);
            if (props == null) continue;
            result.addAll(props);
        }
        return result;
    }

    public POJOClass getComponentPOJO(Property property) {
        if (property.getValue() instanceof Component) {
            Component comp = (Component)property.getValue();
            ComponentPOJOClass componentPOJOClass = new ComponentPOJOClass(comp, new Cfg2JavaTool());
            return componentPOJOClass;
        }
        return null;
    }

    public List<POJOClass> getInheritanceHierarchy(POJOClass pc) {
        if (pc.isSubclass()) {
            ArrayList<POJOClass> superClasses = new ArrayList<POJOClass>();
            for (POJOClass superClass = pc.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
                superClasses.add(superClass);
            }
            return superClasses;
        }
        return Collections.emptyList();
    }

    public List<Property> getOrderedProperties(POJOClass pojoClass) {
        List<Property> orderedProperties = this.getAllProperties(pojoClass);
        Collections.sort(orderedProperties, PROPERTY_COMPARATOR);
        return orderedProperties;
    }

    public List<Property> getSimpleProperties(POJOClass pojoClass) {
        List<Property> properties = this.getAllProperties(pojoClass);
        if (pojoClass.hasIdentifierProperty()) {
            properties.remove(pojoClass.getIdentifierProperty());
        }
        if (pojoClass.hasVersionProperty()) {
            properties.remove(pojoClass.getVersionProperty());
        }
        return properties;
    }

    public List<Property> getOrderedSimpleProperties(POJOClass pojoClass) {
        List<Property> orderedProperties = this.getSimpleProperties(pojoClass);
        Collections.sort(orderedProperties, PROPERTY_COMPARATOR);
        return orderedProperties;
    }

    private List<Property> getAllProperties(POJOClass pojoClass) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Iterator<Property> iterator = pojoClass.getAllPropertiesIterator();
        while (iterator.hasNext()) {
            properties.add(iterator.next());
        }
        return properties;
    }
}

