/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import java.util.Iterator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.tool.internal.export.lint.Detector;
import org.hibernate.tool.internal.export.lint.IssueCollector;

public abstract class RelationalModelDetector
extends Detector {
    @Override
    public void visit(IssueCollector collector) {
        for (Table table : this.getMetadata().collectTableMappings()) {
            this.visit(table, collector);
        }
    }

    protected abstract void visit(Table var1, Column var2, IssueCollector var3);

    protected void visitColumns(Table table, IssueCollector collector) {
        Iterator columnIter = table.getColumnIterator();
        while (columnIter.hasNext()) {
            Column col = (Column)columnIter.next();
            this.visit(table, col, collector);
        }
    }

    protected void visit(Table table, IssueCollector collector) {
        this.visitColumns(table, collector);
    }
}

