/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.dialect;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.tool.internal.reveng.dialect.JDBCMetaDataDialect;
import org.hibernate.tool.internal.reveng.dialect.ResultSetIterator;

public class MySQLMetaDataDialect
extends JDBCMetaDataDialect {
    @Override
    public Iterator<Map<String, Object>> getSuggestedPrimaryKeyStrategyName(String catalog, String schema, String table) {
        String sql = null;
        try {
            catalog = this.caseForSearch(catalog);
            schema = this.caseForSearch(schema);
            table = this.caseForSearch(table);
            this.log.debug((Object)("geSuggestedPrimaryKeyStrategyName(" + catalog + "." + schema + "." + table + ")"));
            sql = "show table status " + (catalog == null ? "" : " from " + catalog + " ") + (table == null ? "" : " like '" + table + "' ");
            PreparedStatement statement = this.getConnection().prepareStatement(sql);
            final String sc = schema;
            final String cat = catalog;
            return new ResultSetIterator(statement.executeQuery()){
                Map<String, Object> element;
                {
                    super(resultset);
                    this.element = new HashMap<String, Object>();
                }

                @Override
                protected Map<String, Object> convertRow(ResultSet tableRs) throws SQLException {
                    this.element.clear();
                    this.element.put("TABLE_NAME", tableRs.getString("NAME"));
                    this.element.put("TABLE_SCHEM", sc);
                    this.element.put("TABLE_CAT", cat);
                    String string = tableRs.getString("AUTO_INCREMENT");
                    if (string == null) {
                        this.element.put("HIBERNATE_STRATEGY", null);
                    } else {
                        this.element.put("HIBERNATE_STRATEGY", "identity");
                    }
                    return this.element;
                }

                @Override
                protected Throwable handleSQLException(SQLException e) {
                    throw new RuntimeException("Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", e);
                }
            };
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not get list of suggested identity strategies from database. Probably a JDBC driver problem. ", e);
        }
    }

    @Override
    public Iterator<Map<String, Object>> getTables(String xcatalog, String xschema, String xtable) {
        return super.getTables(xcatalog, xschema, xtable != null ? xtable : "%");
    }

    @Override
    public Iterator<Map<String, Object>> getColumns(String xcatalog, String xschema, String xtable, String xcolumn) {
        return super.getColumns(xcatalog, xschema, xtable != null ? xtable : "%", xcolumn != null ? xcolumn : "%");
    }
}

