/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hibernate.tool.ide.completion.EntityNameReference;

public class SubQuery
implements Comparable<SubQuery> {
    List<Integer> tokenIds = new ArrayList<Integer>();
    List<String> tokenText = new ArrayList<String>();
    int startOffset;
    int endOffset;
    int depth;

    @Override
    public int compareTo(SubQuery s) {
        return this.startOffset - s.startOffset;
    }

    public int getTokenCount() {
        return this.tokenIds.size();
    }

    public int getToken(int i) {
        return this.tokenIds.get(i);
    }

    public String getTokenText(int i) {
        return this.tokenText.get(i);
    }

    public List<EntityNameReference> getEntityNames() {
        boolean afterFrom = false;
        boolean afterJoin = false;
        StringBuffer tableNames = new StringBuffer();
        StringBuffer joins = new StringBuffer();
        int i = 0;
        boolean cont = true;
        int lastToken = -1;
        for (Integer typeInteger : this.tokenIds) {
            int type = typeInteger;
            if (!cont) break;
            if (!(afterFrom || type != 91 && type != 190 && type != 73)) {
                afterFrom = true;
            } else if (afterJoin) {
                switch (type) {
                    case 97: 
                    case 98: 
                    case 154: 
                    case 196: {
                        cont = false;
                        break;
                    }
                    case 104: 
                    case 110: 
                    case 115: 
                    case 155: 
                    case 164: {
                        joins.append(",");
                        break;
                    }
                    case 21: {
                        joins.append(",");
                        break;
                    }
                    case 22: {
                        joins.append(".");
                        break;
                    }
                    case 209: {
                        if (lastToken != 22) {
                            joins.append(" ");
                        }
                        joins.append(this.tokenText.get(i));
                    }
                }
            } else if (afterFrom) {
                switch (type) {
                    case 97: 
                    case 98: 
                    case 154: 
                    case 171: 
                    case 196: {
                        cont = false;
                        break;
                    }
                    case 21: {
                        tableNames.append(",");
                        break;
                    }
                    case 22: {
                        tableNames.append(".");
                        break;
                    }
                    case 209: {
                        if (lastToken != 22) {
                            tableNames.append(" ");
                        }
                        tableNames.append(this.tokenText.get(i));
                        break;
                    }
                    case 110: {
                        tableNames.append(",");
                        afterJoin = true;
                        break;
                    }
                }
            }
            ++i;
            lastToken = type;
        }
        ArrayList<EntityNameReference> tables = new ArrayList<EntityNameReference>();
        this.addEntityReferences(tables, tableNames);
        this.addEntityReferences(tables, joins);
        return tables;
    }

    private void addEntityReferences(List<EntityNameReference> tables, StringBuffer tableNames) {
        StringTokenizer tableTokenizer = new StringTokenizer(tableNames.toString(), ",");
        while (tableTokenizer.hasMoreTokens()) {
            String table = tableTokenizer.nextToken().trim();
            if (table.indexOf(32) == -1 && table.length() > 0) {
                tables.add(new EntityNameReference(table, table));
                continue;
            }
            StringTokenizer aliasTokenizer = new StringTokenizer(table, " ");
            if (aliasTokenizer.countTokens() < 2) continue;
            String type = aliasTokenizer.nextToken().trim();
            String alias = aliasTokenizer.nextToken().trim();
            if (type.length() <= 0 || alias.length() <= 0) continue;
            tables.add(new EntityNameReference(type, alias));
        }
    }
}

