/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.lint;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengDialectFactory;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.internal.export.lint.Issue;
import org.hibernate.tool.internal.export.lint.IssueCollector;
import org.hibernate.tool.internal.export.lint.RelationalModelDetector;
import org.hibernate.tool.internal.export.lint.SequenceCollector;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.reader.DatabaseReader;
import org.hibernate.tool.internal.reveng.strategy.DefaultStrategy;
import org.hibernate.tool.internal.reveng.strategy.TableSelectorStrategy;
import org.hibernate.tool.internal.util.JdbcToHibernateTypeHelper;
import org.hibernate.tool.internal.util.TableNameQualifier;

public class SchemaByMetaDataDetector
extends RelationalModelDetector {
    DatabaseReader reader;
    private SequenceCollector sequenceCollector;
    private TableSelectorStrategy tableSelector;
    private RevengDialect metadataDialect;
    private Dialect dialect;
    private Mapping mapping;
    private Properties properties;
    Table currentDbTable = null;

    @Override
    public String getName() {
        return "schema";
    }

    @Override
    public void initialize(Metadata metadata) {
        super.initialize(metadata);
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        StandardServiceRegistry serviceRegistry = builder.build();
        this.properties = Environment.getProperties();
        this.dialect = ((JdbcServices)serviceRegistry.getService(JdbcServices.class)).getDialect();
        this.tableSelector = new TableSelectorStrategy(new DefaultStrategy());
        this.metadataDialect = RevengDialectFactory.createMetaDataDialect(this.dialect, this.properties);
        this.reader = DatabaseReader.create(this.properties, this.tableSelector, this.metadataDialect, (ServiceRegistry)serviceRegistry);
        ConnectionProvider connectionProvider = (ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class);
        this.sequenceCollector = SequenceCollector.create(connectionProvider);
    }

    @Override
    public void visit(IssueCollector collector) {
        super.visit(collector);
        this.visitGenerators(collector);
    }

    public void visitGenerators(IssueCollector collector) {
        Iterator<IdentifierGenerator> iter = this.iterateGenerators();
        Set<String> sequences = Collections.EMPTY_SET;
        if (this.dialect.getSequenceSupport().supportsSequences()) {
            sequences = this.sequenceCollector.readSequences(this.dialect.getQuerySequencesString());
        }
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (this.isSequence(key, sequences) || this.isTable(key)) continue;
            collector.reportIssue(new Issue("MISSING_ID_GENERATOR", 100, "Missing sequence or table: " + key));
        }
    }

    private boolean isSequence(Object key, Set<?> sequences) {
        if (key instanceof String) {
            if (sequences.contains(key)) {
                return true;
            }
            String[] strings = StringHelper.split((String)".", (String)((String)key));
            if (strings.length == 3) {
                return sequences.contains(strings[2]);
            }
            if (strings.length == 2) {
                return sequences.contains(strings[1]);
            }
        }
        return false;
    }

    private boolean isTable(Object key) throws HibernateException {
        if (key instanceof String) {
            String[] strings = StringHelper.split((String)".", (String)((String)key));
            if (strings.length == 1) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(this.createSchemaSelection(null, null, strings[0]));
                Collection<Table> collection = this.readFromDatabase();
                return !collection.isEmpty();
            }
            if (strings.length == 3) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(this.createSchemaSelection(strings[0], strings[1], strings[2]));
                Collection<Table> collection = this.readFromDatabase();
                return !collection.isEmpty();
            }
            if (strings.length == 2) {
                this.tableSelector.clearSchemaSelections();
                this.tableSelector.addSchemaSelection(this.createSchemaSelection(null, strings[0], strings[1]));
                Collection<Table> collection = this.readFromDatabase();
                return !collection.isEmpty();
            }
        }
        return false;
    }

    @Override
    public void visit(Table table, IssueCollector pc) {
        if (table.isPhysicalTable()) {
            this.setSchemaSelection(table);
            Collection<Table> collection = this.readFromDatabase();
            if (collection.isEmpty()) {
                pc.reportIssue(new Issue("SCHEMA_TABLE_MISSING", 100, "Missing table " + TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName())));
                return;
            }
            if (collection.size() > 1) {
                pc.reportIssue(new Issue("SCHEMA_TABLE_MISSING", 50, "Found " + collection.size() + " tables for " + TableNameQualifier.qualify(table.getCatalog(), table.getSchema(), table.getName())));
                return;
            }
            this.currentDbTable = collection.iterator().next();
            this.visitColumns(table, pc);
        }
    }

    String table(Table t) {
        return TableNameQualifier.qualify(t.getCatalog(), t.getSchema(), t.getName());
    }

    @Override
    public void visit(Table table, Column col, IssueCollector pc) {
        if (this.currentDbTable == null) {
            return;
        }
        Column dbColumn = this.currentDbTable.getColumn(new Column(col.getName()));
        if (dbColumn == null) {
            pc.reportIssue(new Issue("SCHEMA_COLUMN_MISSING", 100, this.table(table) + " is missing column: " + col.getName()));
        } else {
            int modelTypeCode;
            int dbTypeCode = dbColumn.getSqlTypeCode();
            if (dbTypeCode != (modelTypeCode = col.getSqlTypeCode(this.mapping))) {
                pc.reportIssue(new Issue("SCHEMA_COLUMN_TYPE_MISMATCH", 50, this.table(table) + " has a wrong column type for " + col.getName() + ", expected: " + JdbcToHibernateTypeHelper.getJDBCTypeName(modelTypeCode) + " but was " + JdbcToHibernateTypeHelper.getJDBCTypeName(dbTypeCode) + " in db"));
            }
        }
    }

    private void setSchemaSelection(Table table) {
        this.tableSelector.clearSchemaSelections();
        this.tableSelector.addSchemaSelection(this.createSchemaSelection(table.getCatalog(), table.getSchema(), table.getName()));
    }

    private Iterator<IdentifierGenerator> iterateGenerators() throws MappingException {
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        for (PersistentClass pc : this.getMetadata().getEntityBindings()) {
            IdentifierGenerator ig;
            if (pc.isInherited() || !((ig = pc.getIdentifier().createIdentifierGenerator(this.getMetadata().getIdentifierGeneratorFactory(), this.dialect, defaultCatalog, defaultSchema, (RootClass)pc)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        for (org.hibernate.mapping.Collection collection : this.getMetadata().getCollectionBindings()) {
            IdentifierGenerator ig;
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getMetadata().getIdentifierGeneratorFactory(), this.dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    private Collection<Table> readFromDatabase() {
        RevengMetadataCollector revengMetadataCollector = new RevengMetadataCollector();
        this.reader.readDatabaseSchema(revengMetadataCollector);
        return revengMetadataCollector.getTables();
    }

    private RevengStrategy.SchemaSelection createSchemaSelection(final String matchCatalog, final String matchSchema, final String matchTable) {
        return new RevengStrategy.SchemaSelection(){

            @Override
            public String getMatchCatalog() {
                return matchCatalog;
            }

            @Override
            public String getMatchSchema() {
                return matchSchema;
            }

            @Override
            public String getMatchTable() {
                return matchTable;
            }
        };
    }
}

