/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.Iterator;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.tool.internal.reveng.binder.AbstractBinder;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.BinderUtils;
import org.hibernate.tool.internal.reveng.binder.EntityPropertyBinder;

class ManyToOneBinder
extends AbstractBinder {
    private final EntityPropertyBinder entityPropertyBinder;

    static ManyToOneBinder create(BinderContext binderContext) {
        return new ManyToOneBinder(binderContext);
    }

    private ManyToOneBinder(BinderContext binderContext) {
        super(binderContext);
        this.entityPropertyBinder = EntityPropertyBinder.create(binderContext);
    }

    Property bind(String propertyName, boolean mutable, Table table, ForeignKey fk, Set<Column> processedColumns) {
        ManyToOne value = new ManyToOne(this.getMetadataBuildingContext(), table);
        value.setReferencedEntityName(fk.getReferencedEntityName());
        this.addColumns(value, fk, processedColumns);
        value.setFetchMode(FetchMode.SELECT);
        return this.entityPropertyBinder.bind(propertyName, mutable, table, fk, (ToOne)value, false);
    }

    private void addColumns(ManyToOne value, ForeignKey fk, Set<Column> processedColumns) {
        Iterator columns = fk.getColumnIterator();
        while (columns.hasNext()) {
            Column fkcolumn = (Column)columns.next();
            BinderUtils.checkColumnForMultipleBinding(fkcolumn);
            value.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
    }
}

