/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.stat;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.hibernate.stat.CollectionStatistics;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.internal.CategorizedStatistics;

public class StatisticsCellRenderer
extends DefaultTreeCellRenderer {
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Statistics stats;
        JLabel treeCellRendererComponent = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        Object text = treeCellRendererComponent.getText();
        String tooltip = null;
        if (value instanceof Statistics) {
            stats = (Statistics)value;
            text = "Statistics " + this.formatter.format(new Date(stats.getStartTime()));
            tooltip = stats.toString();
        }
        if (value instanceof CategorizedStatistics) {
            stats = (CategorizedStatistics)value;
            text = stats.getCategoryName();
        }
        if (value instanceof EntityStatistics) {
            // empty if block
        }
        if (value instanceof CollectionStatistics) {
            // empty if block
        }
        if (value instanceof QueryStatistics) {
            // empty if block
        }
        treeCellRendererComponent.setText((String)text);
        treeCellRendererComponent.setToolTipText(tooltip);
        return treeCellRendererComponent;
    }
}

