/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.query;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.tool.internal.export.common.AbstractExporter;

public class QueryExporter
extends AbstractExporter {
    @Override
    public void doStart() {
        Session session = null;
        SessionFactory sessionFactory = null;
        Transaction transaction = null;
        try {
            sessionFactory = this.buildMetadata().buildSessionFactory();
            session = sessionFactory.openSession();
            transaction = session.beginTransaction();
            for (String query : this.getQueryList()) {
                List list = session.createQuery(query, null).getResultList();
                if (this.getFileName() == null) continue;
                PrintWriter pw = null;
                try {
                    File file = new File(this.getOutputDirectory(), this.getFileName());
                    this.getTemplateHelper().ensureExistence(file);
                    pw = new PrintWriter(new FileWriter(file, true));
                    this.getArtifactCollector().addFile(file, "query-output");
                    for (Object element : list) {
                        pw.println(element);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not write query output", e);
                }
                finally {
                    if (pw == null) continue;
                    pw.flush();
                    pw.close();
                }
            }
            transaction.commit();
        }
        catch (HibernateException he) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw new RuntimeException("Error occured while trying to execute query", he);
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (sessionFactory != null) {
                sessionFactory.close();
            }
        }
    }

    private String getFileName() {
        return (String)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.OutputFileName");
    }

    private List<?> getQueryList() {
        return (List)this.getProperties().get("org.hibernate.tool.api.export.ExporterConstants.QueryList");
    }

    public void setQueries(List<String> queryStrings) {
        this.getProperties().put("org.hibernate.tool.api.export.ExporterConstants.QueryList", queryStrings);
    }
}

