/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton;

import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.proton.ProtonDeliveryHandler;
import org.hornetq.core.protocol.proton.ProtonProtocolManager;
import org.hornetq.core.protocol.proton.ProtonRemotingConnection;
import org.hornetq.core.protocol.proton.ProtonSession;
import org.hornetq.core.protocol.proton.exceptions.HornetQAMQPException;

public class TransactionHandler
implements ProtonDeliveryHandler {
    private final ProtonRemotingConnection connection;
    private final Coordinator coordinator;
    private final ProtonProtocolManager protonProtocolManager;
    private final ProtonSession protonSession;

    public TransactionHandler(ProtonRemotingConnection connection, Coordinator coordinator, ProtonProtocolManager protonProtocolManager, ProtonSession protonSession) {
        this.connection = connection;
        this.coordinator = coordinator;
        this.protonProtocolManager = protonProtocolManager;
        this.protonSession = protonSession;
    }

    @Override
    public void onMessage(Delivery delivery) throws HornetQAMQPException {
        Receiver receiver = null;
        try {
            receiver = (Receiver)delivery.getLink();
            if (!delivery.isReadable()) {
                return;
            }
            HornetQBuffer buffer = this.connection.createTransportBuffer(1024);
            this.protonProtocolManager.handleTransaction(receiver, buffer, delivery, this.protonSession);
            buffer.byteBuf().release();
        }
        catch (Exception e) {
            e.printStackTrace();
            Rejected rejected = new Rejected();
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.valueOf((String)"failed"));
            condition.setDescription(e.getMessage());
            rejected.setError(condition);
            delivery.disposition((DeliveryState)rejected);
        }
    }

    @Override
    public void checkState() {
    }

    @Override
    public void close() throws HornetQAMQPException {
    }
}

