/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hornetq.core.logging.Logger;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.deployment.KernelDeployment;

public class HornetQBootstrapServer
extends BasicBootstrap {
    private static Logger log = Logger.getLogger(HornetQBootstrapServer.class);
    protected BeanXMLDeployer deployer;
    protected List<KernelDeployment> deployments = new CopyOnWriteArrayList<KernelDeployment>();
    protected String[] args;
    private Properties properties;

    public static void main(String[] args) throws Exception {
        log.info((Object)"Starting HornetQ Server");
        HornetQBootstrapServer bootstrap = new HornetQBootstrapServer(args);
        bootstrap.run();
        bootstrap.addShutdownHook();
    }

    public void addShutdownHook() {
        String dirName = System.getProperty("hornetq.config.dir", ".");
        final File file = new File(dirName + "/STOP_ME");
        if (file.exists()) {
            file.delete();
        }
        final Timer timer = new Timer("HornetQ Server Shutdown Timer", true);
        timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (file.exists()) {
                    try {
                        log.info((Object)"Stopping HornetQ Server");
                        HornetQBootstrapServer.this.shutDown();
                        timer.cancel();
                    }
                    finally {
                        Runtime.getRuntime().exit(0);
                    }
                }
            }
        }, 500L, 500L);
    }

    public void run() {
        try {
            super.run();
        }
        catch (RuntimeException e) {
            log.error((Object)"Failed to start server", (Throwable)e);
            throw e;
        }
    }

    public HornetQBootstrapServer(String ... args) throws Exception {
        this.args = args;
    }

    public HornetQBootstrapServer(KernelConfig kernelConfig, String ... args) throws Exception {
        super(kernelConfig);
        this.args = args;
    }

    public void bootstrap() throws Throwable {
        super.bootstrap();
        this.deployer = new BeanXMLDeployer(this.getKernel());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        for (String arg : this.args) {
            this.deploy(arg);
        }
        this.deployer.validate();
    }

    public void undeploy(KernelDeployment deployment) throws Throwable {
        log.debug((Object)("Undeploying " + deployment.getName()));
        this.deployments.remove(deployment);
        try {
            this.deployer.undeploy(deployment);
            log.debug((Object)("Undeployed " + deployment.getName()));
        }
        catch (Throwable t) {
            log.warn((Object)("Error during undeployment: " + deployment.getName()), t);
        }
    }

    public KernelDeployment deploy(String arg) throws Throwable {
        File file;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(arg);
        if (url == null) {
            url = cl.getResource("META-INF/" + arg);
        }
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getClassLoader().getResource(arg);
        }
        if (url == null && (file = new File(arg)).exists()) {
            url = file.toURI().toURL();
        }
        if (url == null) {
            throw new RuntimeException("Unable to find resource:" + arg);
        }
        return this.deploy(url);
    }

    public KernelDeployment deploy(String name, String xml) throws Throwable {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintStream printOut = new PrintStream(byteOut);
        printOut.print(xml);
        printOut.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(byteOut.toByteArray());
        KernelDeployment deployment = this.deployer.deploy(name, (InputStream)is);
        this.deployments.add(deployment);
        return deployment;
    }

    protected KernelDeployment deploy(URL url) throws Throwable {
        log.debug((Object)("Deploying " + url));
        KernelDeployment deployment = this.deployer.deploy(url);
        this.deployments.add(deployment);
        log.debug((Object)("Deployed " + url));
        return deployment;
    }

    public void shutDown() {
        ListIterator<KernelDeployment> iterator = this.deployments.listIterator(this.deployments.size());
        while (iterator.hasPrevious()) {
            KernelDeployment deployment = iterator.previous();
            try {
                this.undeploy(deployment);
            }
            catch (Throwable t) {
                log.warn((Object)("Unable to undeploy: " + deployment.getName()), t);
            }
        }
    }

    protected Properties getConfigProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        public void run() {
            HornetQBootstrapServer.this.shutDown();
        }
    }
}

