/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.integration.jboss.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.core.server.HornetQComponent;
import org.hornetq.integration.jboss.security.AS4SecurityActions;
import org.hornetq.integration.jboss.security.SecurityActions;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;

public class JBossASSecurityManager
implements HornetQSecurityManager,
HornetQComponent {
    private static final Logger log = Logger.getLogger(JBossASSecurityManager.class);
    private final boolean trace = log.isTraceEnabled();
    private RealmMapping realmMapping;
    private AuthenticationManager authenticationManager;
    private String securityDomainName = "java:/jaas/hornetq";
    private boolean started;
    private boolean isAs5 = true;
    private boolean allowClientLogin = false;
    private boolean authoriseOnClientLogin = false;

    public boolean validateUser(String user, String password) {
        SimplePrincipal principal = new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        Subject subject = new Subject();
        return this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject);
    }

    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        if (this.allowClientLogin && SecurityContextAssociation.isClient()) {
            return this.authoriseOnClientLogin ? this.useClientAuthentication(roles, checkType) : true;
        }
        return this.useConnectionAuthentication(user, password, roles, checkType);
    }

    private boolean useConnectionAuthentication(String user, String password, Set<Role> roles, CheckType checkType) {
        Subject subject;
        boolean authenticated;
        SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        if (authenticated = this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject = new Subject())) {
            this.pushSecurityContext(principal, passwordChars, subject);
            Set<Principal> rolePrincipals = this.getRolePrincipals(checkType, roles);
            authenticated = this.realmMapping.doesUserHaveRole((Principal)principal, rolePrincipals);
            if (this.trace) {
                log.trace((Object)("user " + user + (authenticated ? " is " : " is NOT ") + "authorized"));
            }
            this.popSecurityContext();
        }
        return authenticated;
    }

    private boolean useClientAuthentication(Set<Role> roles, CheckType checkType) {
        Subject subject;
        char[] passwordChars;
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        Principal principal = sc.getUtil().getUserPrincipal();
        boolean authenticated = this.authenticationManager.isValid(principal, (Object)(passwordChars = (char[])sc.getUtil().getCredential()), subject = sc.getSubjectInfo().getAuthenticatedSubject());
        if (authenticated) {
            Set<Principal> rolePrincipals = this.getRolePrincipals(checkType, roles);
            authenticated = this.realmMapping.doesUserHaveRole(principal, rolePrincipals);
            if (this.trace) {
                log.trace((Object)("user " + principal.getName() + (authenticated ? " is " : " is NOT ") + "authorized"));
            }
        }
        return authenticated;
    }

    private void popSecurityContext() {
        if (this.isAs5) {
            SecurityActions.popSubjectContext();
        } else {
            AS4SecurityActions.popSubjectContext();
        }
    }

    private void pushSecurityContext(SimplePrincipal principal, char[] passwordChars, Subject subject) {
        if (this.isAs5) {
            SecurityActions.pushSubjectContext((Principal)principal, passwordChars, subject, this.securityDomainName);
        } else {
            AS4SecurityActions.pushSubjectContext((Principal)principal, passwordChars, subject);
        }
    }

    public void addRole(String user, String role) {
    }

    public void addUser(String user, String password) {
    }

    public void removeRole(String user, String role) {
    }

    public void removeUser(String user) {
    }

    public void setDefaultUser(String username) {
    }

    private Set<Principal> getRolePrincipals(CheckType checkType, Set<Role> roles) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            principals.add((Principal)new SimplePrincipal(role.getName()));
        }
        return principals;
    }

    public void setRealmMapping(RealmMapping realmMapping) {
        this.realmMapping = realmMapping;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        InitialContext ic = new InitialContext();
        this.authenticationManager = (AuthenticationManager)ic.lookup(this.securityDomainName);
        this.realmMapping = (RealmMapping)this.authenticationManager;
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void setSecurityDomainName(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }

    public void setAs5(boolean as5) {
        this.isAs5 = as5;
    }

    public void setAllowClientLogin(boolean allowClientLogin) {
        this.allowClientLogin = allowClientLogin;
    }

    public void setAuthoriseOnClientLogin(boolean authoriseOnClientLogin) {
        this.authoriseOnClientLogin = authoriseOnClientLogin;
    }
}

